//  ltk-config --compile test.cxx
// g++ -o test test.cxx l1.o @_buildFltk
// g++ -o test test.cxx l1.o @_staticFltk
// g++ -no-pie test.cxx -o test `fltk-config --cxxflags` `fltk-config --ldflags`  
// g++ -no-pie test.cxx -o test.o `fltk-config --cxxflags` `fltk-config --ldflags
// g++ -no-pie test.cxx -o test `fltk-config --cxxflags` `fltk-config --ldflags` -Xlinker -Bstatic
// ld -Bstatic -o test test.o 
// /usr/share/doc/fltk1.3-doc/HTML
// /usr/share/doc/fltk1.3-doc/examples
// ld -o V0.01 V0.01 test.o languageONE.lib
//
// /usr/include/FL/Enumerations.H (constants)
//

#include <iostream>
#include <cmath>
#include <iomanip>
using namespace std; 

#include <FL/Fl.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Output.H>
#include <FL/Fl_Multiline_Output.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Radio_Round_Button.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Menu_Window.H>
#include <FL/Fl_Tabs.H>
#include <FL/Fl_Spinner.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Select_Browser.H>
#include <FL/Fl_Repeat_Button.H>

//==========================================================
//	FUNCTIONS
//==========================================================
	#include "V3.04/include/fV3.04.pro"

//==========================================================
//	WINDOWS
//==========================================================
	#include "V3.04/include/fV3.04.ptr"
	#include "V3.04/include/fV3.04.win"

//==========================================================
//	START - languageONE stuff
//==========================================================
#include "V3.04/include/l1.cpy"

//==========================================================
//	GLOBAL VARIABLES
//==========================================================
//	using lower case for the C++ reflection of the
//	languageONE variables (makes debugging easier)

	long 		*a01_no;
 	char 		*a01_name;

	char		*b01_acctno;
	char		*b01_description;
	char		*b01_flag1;
	long		*b01_flag2;
	long 		*b01_flag3;
	long 		*b01_flag4;
	char		*b01_balid;		
	char		*b01_cntlacctno;
	long		*b01_depreciation;
	long		*b01_unitprice;

	long		windowNo;
 
	long 		i, j;
	string 		str;

	long 		previousA01_No;
	long		win1_A01_No;
	long		win2_B01_No;


	string flag1[]	= 	{"A ","X ","T ","C ","AB","CA","PA",
						 "BA","PL","DA","AS","TO","TC"};
	string balID[]	=	{"DR","CR"};


//==========================================================
//	EVENT HANDLER
//==========================================================
int eventHandler(int e, Fl_Window *w) 
{
	if ( e == FL_KEYDOWN ) 
	{

 		int k = Fl::event_key(); 

		if (k==65307) { e=NULL; } 				// Swallow Escape

		if (k==65474) 							// F5
		{ 	
			if (windowNo==2) 
			{
				message_text->label("This option is not defined \n at present");
				windowNo +=1;	
				message->show();
			}
		}
	}

	return Fl::handle_(e, w);

}

//==========================================================
//	Mainline
//==========================================================
int main(int argc, char **argv) {

	Fl::event_dispatch(eventHandler);

//	------------------
//	Initialize
//	------------------
 	Fl::scheme("base");
	Fl::background(225,225,225);
	FL_NORMAL_SIZE = 11; 

	l1_HouseKeeping();
	
//	------------------
//	Window 0 - Message
//	------------------
	window0();

//	--------
//	WINDOW 1
//	--------
	window1(); 

	previousA01_No = *a01_no;
	win1_company->value(*a01_no);
	str=""; for (i=0; i<30; i++) {str = str + a01_name[i];}			
	win1_companyDesc->label(str.c_str());

	windowNo += 1;
	win1->show();
	return Fl::run();

}
//==========================================================
//	languageONE initialisation
//	builds languageONE control blocks
//	calls languageONE to initialise
//==========================================================
void l1_HouseKeeping()
{

	l1_Call(c_Initial,0);

	a01_no				= (long *)l1_Params[2];
	a01_name			= (char *)l1_Params[3];

	b01_acctno			= (char *)l1_Params[4];
	b01_description 	= (char *)l1_Params[5];
	b01_flag1			= (char *)l1_Params[6];
	b01_flag2			= (long *)l1_Params[7];
	b01_flag3			= (long *)l1_Params[8];
	b01_flag4			= (long *)l1_Params[9];
	b01_balid			= (char *)l1_Params[10];	
	b01_cntlacctno		= (char *)l1_Params[11];
	b01_depreciation	= (long *)l1_Params[12];
	b01_unitprice		= (long *)l1_Params[13];

}

//==========================================================
//	ALL WINDOWS
//==========================================================
void windowExit_callback(Fl_Widget *w, void *data)
{
	windowNo -=1;
	w->hide();	
}

//==========================================================
//	WINDOW 0
//==========================================================
void warning_message(Fl_Widget *w, void *data)
{
	message_text->label("This menu option is not defined \n at present");
	windowNo +=1;	
	message->show();
}

//==========================================================
//	WINDOW 1
//==========================================================
//----------------------------------------------------------
//	button2 callback
//----------------------------------------------------------
void win1_but2_callback(Fl_Widget *w, void *data) 
{

	win1_but2->clear();

//	---------------
//	Setup Window 2
//	---------------
	window2(); 
	for (i=0; i < 13; i++) {win2_flag1->add(flag1[i].c_str());}
	for (i=0; i < 2;  i++) {win2_balid->add(balID[i].c_str());}
	win2_coa_key();

//	---------------------
//	Grab the transactions
//	---------------------
	win2_coa_transactions();		

//	---------------
//	Open the window
//	---------------
	windowNo += 1;

	win2_chart->hide();
	win2_tabs->hide();
	win2_menuBar->activate();
	win2->show();

}

//----------------------------------------------------------
//	spinner1 callback
//----------------------------------------------------------
void win1_spinner1_callback(Fl_Widget *w, void *data) 
{

//--------------------------------------------------------
//	Call languageONE
//--------------------------------------------------------
	win1_A01_No = win1_company->value();
	if (win1_A01_No > previousA01_No) {i = +1;}
	if (win1_A01_No < previousA01_No) {i = -1;}

	l1_Call(c_A01_Read,i);
	if (l1_Params[0]==0) 
		{previousA01_No = *a01_no;}

//--------------------------------------------------------
//	Grab the return values & display them
//--------------------------------------------------------
	win1_company->value(*a01_no);
	str="";	for (i=0; i<30; i++) {str = str + a01_name[i];}
	win1_companyDesc->label(str.c_str());
	win1->redraw();
}

//==========================================================
//	WINDOW 2
//==========================================================

//**********************************************************
//	MENU OPTIONS
//**********************************************************

//----------------------------------------------------------
//	MENU option  - Show the Chart of Account screen
//----------------------------------------------------------
void win2_showChart(Fl_Widget *w, void *data)
{
	win2_B01_No = 1;
	win2_get_acctNo(false);

	win2_menuBar->deactivate();
	win2_tabs->hide();
	win2_chart->show();
	win2->redraw();
}
//----------------------------------------------------------
//	MENU option - Show the GeneralJournal screen
//----------------------------------------------------------
void win2_showTrans(Fl_Widget *w, void *data)
{
	win2_menuBar->deactivate();
	win2_chart->hide();
	win2_tabs->show();
}

//**********************************************************
//	PROGRAM FUNCTIONS
//**********************************************************

//----------------------------------------------------------
//	Chart of Account Key
//----------------------------------------------------------
void win2_coa_key()
{
	win2_key->activate();
	win2_browser->activate();
	win2_details->deactivate();
}

//----------------------------------------------------------
//	Chart of Account Details
//----------------------------------------------------------
void win2_coa_details()
{
	win2_details->activate();
	win2_browser->deactivate();
	win2_key->deactivate();
}

//----------------------------------------------------------
//	get the transactions
//----------------------------------------------------------
void win2_coa_transactions() 
{

	long x=2, y=0; 
	string str1, str2;

	static int widths[] = { 65, 300 };
	win2_browser->column_widths(widths);
	win2_browser->column_char('\t');

	i=0;
	while (1==1) 
	{
		i++;

		l1_Call(c_B01_Read,i);
		if (l1_Params[0]!=0){ break; }

		str1="";for (j=0; j<5;  j++) {str1 = str1 + b01_acctno[j];}
		str2="";for (j=0; j<30; j++) {str2 = str2 + b01_description[j];}

		y = remainder(i, x);
		if (y==0)	{str = "@B52" + str1 + "\t@B52" + str2;}
		else		{str = str1 + "\t"       + str2;}
		win2_browser->insert(i,str.c_str());

	}
}

//----------------------------------------------------------
//	call languageONE to get account
//----------------------------------------------------------
void win2_get_acctNo(bool _details)
{

//	----------------------------------------
//	LanguageONE call to get the account data
//	---------------------------------------- 
	l1_Call(c_B01_Read,win2_B01_No);
	if (l1_Params[0]!=0) 
	{
		win2_B01_No -= 1;
		return;
	}
	
//	----------------------------------------
//	Account Number and Description
//	---------------------------------------- 
	str="";for (i=0; i<5; i++) {str = str + b01_acctno[i];}
		win2_acctNo->value(str.c_str()); 

	str="";for (i=0; i<30; i++) {str = str + b01_description[i];}	
		win2_acctNoDesc->value(str.c_str());


//	----------------------------------------
//	Details
//	---------------------------------------- 
	if (_details)
	{
		win2_description->value(str.c_str());

		str="";for (i=0; i<2; i++) {str = str + b01_flag1[i];}
		for (i=0; i<13; i++) { if (str==flag1[i]) {break;}}
		win2_flag1->value(i);

		win2_flag2->value(*b01_flag2);
		win2_flag3->value(*b01_flag3);
		win2_flag4->value(*b01_flag4);
		
		str="";for (i=0; i<2; i++) {str = str + b01_balid[i];}
		for (i=0; i<2; i++) { if (str==balID[i]) {break;}}
			win2_balid->value(i);

		str="";for (i=0; i<5; i++) {str = str + b01_cntlacctno[i];}
			win2_cntlacctno->value(str.c_str());

		win2_depreciation->value(to_string(*b01_depreciation).c_str());

		win2_unitprice->value(l1_GetRational(b01_unitprice).c_str());
		
		}

	win2->redraw();

}

//**********************************************************
//	CALLBACKS
//**********************************************************
//----------------------------------------------------------
//	call languageONE to put account
//----------------------------------------------------------
void win2_details_okay_callback(Fl_Widget *w, void *data)
{	 

//	----------------------------------------
//	Details
//	---------------------------------------- 
	str = win2_description->value(); str = str.substr(0,30);
 	strcpy(b01_description, str.c_str());

	i = win2_flag1->value(); str = flag1[i];
	strcpy(b01_flag1, str.c_str());
 
	*b01_flag2 = win2_flag2->value();
	*b01_flag3 = win2_flag3->value();
	*b01_flag4 = win2_flag4->value();

	i = win2_balid->value(); str = balID[i];
	strcpy(b01_balid, str.c_str());

	str = win2_cntlacctno->value(); str = str.substr(0,5);
 	strcpy(b01_cntlacctno, str.c_str());

//	-----------------------------------------------------------------
//	This will not need validating because 'stoi' will return only the 
//	interger portion
//	-----------------------------------------------------------------
	str = win2_depreciation->value();
	*b01_depreciation = stoi(str);

//	-----------------------------------------------------------------
//	Need to drop any more than (n) decimal places 
//	-----------------------------------------------------------------
	str = win2_unitprice->value();
	i = str.find('.');
    if (i != -1)
	{
		i += 4;
		str = str.substr(0,i+1);
	}
	*b01_unitprice = l1_PutRational(b01_unitprice,str);

//	----------------------------------------
//	languageONE call to write the data
//	---------------------------------------- 
	l1_Call(c_B01_Write,win2_B01_No);


//	----------------------------------------
//	reload trans & setup for key
//	---------------------------------------- 
	win2_coa_transactions();
	win2_key->activate();
	win2_browser->activate();
	win2_details->deactivate();

}

//----------------------------------------------------------
//	Callbacks - account up button pressed
//----------------------------------------------------------
void win2_acctNoUp_callback(Fl_Widget *w, void *data)
{
	win2_B01_No += 1;
	win2_get_acctNo(false);
}

//----------------------------------------------------------
//	Callbacks - account down button pressed
//----------------------------------------------------------
void win2_acctNoDown_callback(Fl_Widget *w, void *data)
{
	if (win2_B01_No>1)
	{
		win2_B01_No -= 1;
		win2_get_acctNo(false);
	}
}

//----------------------------------------------------------
//	Callbacks - coa details cancel button pressed
//----------------------------------------------------------
void win2_key_cancel_callback(Fl_Widget *w, void *data)
{ 
	win2_chart->hide();
	win2_tabs->hide();
	win2_menuBar->activate();
	win2->show();

}

//----------------------------------------------------------
//	Callbacks - coa details cancel button pressed
//----------------------------------------------------------
inline void win2_details_cancel_callback(Fl_Widget *w, void *data)
	{ win2_coa_key(); }


//----------------------------------------------------------
//	Callbacks - coa browser selection 
//----------------------------------------------------------
void win2_browser_callback(Fl_Widget *w, void *data)
{
	win2_B01_No = win2_browser->value();	

	win2_get_acctNo(true);
	win2_coa_details();

}
//----------------------------------------------------------
//	Callbacks - General Journal details cancel button pressed
//----------------------------------------------------------
void win2_trans_cancel_callback(Fl_Widget *w, void *data)
{ 
	win2_chart->hide();
	win2_tabs->hide();
	win2_menuBar->activate();
	win2->show();

}

//----------------------------------------------------------
//	Callbacks - Exit selected from menu
//----------------------------------------------------------
void win2_menu_Exit(Fl_Widget *w, void *data)
	{ windowExit_callback(win2,(void *)NULL); }


