//----------------------------------------------------------
//	languageONE routines/Constants
//----------------------------------------------------------
	extern "C" int l1_Process();

	const long c_Initial 	= 0;
	const long c_A01_Read	= 1;
	const long c_B01_Read	= 2;
	const long c_B01_Write	= 3;

//----------------------------------------------------------
//	languageONE data structures
//----------------------------------------------------------
//	Not sure if I will need these so here at the moment just
//	in case

	struct l1_Number 
	{
		long Scale;
		char Indicator;
		long Length;
		long Number;
		char Picture[26];
	} __attribute__((packed)); 

	struct l1_Word 
	{
		long Filler1;
		char Indicator;
		long Length;
		char Alpha[128];
	} __attribute__((packed)); 

//----------------------------------------------------------
//	Parameters and Parameter Address to pass to languageONE
//----------------------------------------------------------
	long *l1_Params[15] = {};
	long *l1_Params_Addr;

//----------------------------------------------------------
//	Call languageONE
//----------------------------------------------------------
void l1_Call (long const _function,long const _data) 
{
	l1_Params[0] = (long *)_function;						// Function passed by value
	l1_Params[1] = (long *)_data;							// Data passed by value

	auto l1_Params_Addr = std::addressof(l1_Params);		// Get Array address (it keeps moving)
//	----------------------------------------
//	asm ("mov %rax,l1_Params_Addr");						// Array address into RAX
//	----------------------------------------
//	As luck would have it std::addressof(l1_Params)
//	returns the address in the RAX register and so we
//	can do without it
//
//	Apparantly Inline assembler is not supported in VC++
//	so for conformity it is commented out here
//	It is nice to keep it for documentations sake
//	---------------------------------------

	asm("push %rbp");
	asm("push %rdi");
		
		l1_Process();											// Make the Call
	
	asm("pop %rdi");
	asm("pop %rbp");
	

}

//----------------------------------------------------------
//	Convert languageONE number to string
//----------------------------------------------------------
string l1_GetRational (long *l1_num)
{
	char *tmp = (char *)l1_num;								// Get an address that will move in Bytes
	tmp -=17;												// move back 17 bytes
	long *Scale = (long *)tmp; 								// and we have the Scale address								

	double x = *l1_num;										// x is the passed value
	double y = *Scale; 										// y is the Scale
	double z = x / y;										// and divide to get a rational number

	int i;													// Count the no of decimal places
	for (i=1;i<18;i++)						
	{
		y = y / 10;
		if (y==1) {break;}
	}
	
	string str = to_string(z);								// convert it to a string
	str = str.substr(0,str.length()-(6 - i));				// defaults to 6 places so shorten the string

	return(str);

}
//----------------------------------------------------------
//	Convert C++ string to languageONE number 
//----------------------------------------------------------
long l1_PutRational (long *l1_num, string str)
{
	char *tmp = (char *)l1_num;								// Get an address that will move in Bytes
	tmp -=17;												// move back 17 bytes
	long *Scale = (long *)tmp; 								// and we have the Scale address								

	double x = stof(str);									// x is the passed value
	double y = *Scale; 										// y is the Scale
	double z = x * y;										// and multiply to get a languageONE number

	return(z);

}