#include <string>
#include <iostream>
#include <cmath>
#include <iomanip>
#include <time.h> 
 
using namespace std; 

#include <FL/Fl.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Output.H>
#include <FL/Fl_Multiline_Output.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Radio_Round_Button.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Menu_Window.H>
#include <FL/Fl_Tabs.H>
#include <FL/Fl_Spinner.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Select_Browser.H>
#include <FL/Fl_Hold_Browser.H>
#include <FL/Fl_Repeat_Button.H>
#include <FL/Fl_Value_Input.H>
#include <FL/Fl_Text_Display.H>
#include <FL/Fl_Choice.H>

//==========================================================
//	C++ languageONE Interface
//==========================================================
		#include "V3.06/include/interface.ext"

//==========================================================
//	Constants
//==========================================================
		const long long c_Initial					= 0;
		const long long c_A01							= 1;
		const long long c_B01							= 2;
		const long long c_B02							= 3;
		const long long c_B03							= 4;
		const long long c_B99							= 99;
			const long long c_B99_GetDate		= 1;
			const long long c_B99_ValidDate	= 2;

		const long long c_Read							= 1;
		const long long c_Write						= 2;
		const	long long c_Start						= 3;
		const long long c_PreviousNext			= 4;
		const long long c_Delete						= 5;
		const long long c_Commit						= 6;

		const long long c_Enquire					= 11;

		void L1_INTERFACE();

//==========================================================
//	GLOBAL VARIABLES
//==========================================================

		long long		i,j,k,x,y;
		long long		windowNo, fromWindowNo;
		long long		searchNo;

		long long		spinner_acctno, spinner_recno, enq_acctno;
		
		long long		a01_recNo; 
		long long		a01_system_recno;

		long long		b01_recNo; bool b01_AllAccts;
		long long		b02_recNo;
		long long		b99_recNo, b99_startAcctNo;
		
		long long 	direction;

		string	ccyy="",mm="",dd="",hrs="",min="",sec="";	


		string 	str, str1, str2, str3, str4;

		string flag1[]	= {"A ","X ","T ","C ","AB","CA","PA",
						 					 "BA","PL","DA","AS","TO","TC"};
		string balID[]	=	{"DR","CR"};

		char w_RunningBalance[10];

		#include "V3.06/include/msg.win"
		#include "V3.06/include/acctselect.win"

		#include "V3.06/include/sys.win"
		#include "V3.06/include/coa.win"
		#include "V3.06/include/gj.win"
		#include "V3.06/include/enq.win"
		
		#include "V3.06/include/menu1.win"
		#include "V3.06/include/menu2.win"
		
	
//==========================================================
//	START - languageONE stuff
//==========================================================
		#include "V3.06/include/l1.cpy"

//==========================================================
//+--EVENT HANDLER -> Keyboard Capture
//==========================================================
int eventHandler(int e, Fl_Window *w) 
{

	if ( e == FL_KEYDOWN ) 
	{

 		int k = Fl::event_key(); 


		if (k==65307) { e=NULL; } 				// Swallow Escape

		if ((k==65474)||(k==65507)) 			// F5, Ctrl on chromebook		
		{ 	
			if (w==win3_sys) 
				{
					a01_recNo=0;
					if (WIN3_GET_SYS(true)) {selectWin3_sys_details();}
				}

			if (w==win4_coa) 
				{
					b01_recNo=0;
					if (WIN4_GET_ACCT(true)) {selectWin4_coa_details();}
				}

			if (w==win5_gj) 
				{
					b02_recNo=0;
					if (WIN5_GET_TRANS(false)) {selectWin5_gj_details();}
				}

			if (w==win6_enq) 
				{
					if (WIN6_GET_KEY()) 
						{		
							L1_CALL(c_B03,c_Enquire,0,enq_acctno,0);
							WIN6_ENQ_ACCOUNTS(); 	
						}
				}

		}
	}

	return Fl::handle_(e, w);

}

//==========================================================
//+--MAINLINE
//==========================================================
int main(int argc, char **argv)
{
		Fl::event_dispatch(eventHandler);

//	------------------
//	Initialize
//	------------------
 		Fl::scheme("base");
		Fl::background(225,225,225);
		FL_NORMAL_SIZE = 11; 

		L1_INTERFACE(); 
		window0();
		window1(); 
		window2(); 
		window3();
		window4(); 
		window5();
		window6();
		window99();
		
//	---------
//	and Do it
//	---------
		windowNo=1; win1->show();
		return Fl::run();

}
//==========================================================
//+--L1_INTERFACE
//	 calls languageONE to initialise
//==========================================================
void L1_INTERFACE()
{

		L1_CALL(0,c_Initial,0,0,0);

		if (RETURN_CODE!=0)
			{_message("Missing/Full file system \n contact supplier");}
		else
			{
				a01_recNo=A01_Record_NO;
				a01_system_recno=A01_Record_NO;
			}
	
}

//----------------------------------------------------------
//+--Common Function - ACCOUNT SPINNERS
//----------------------------------------------------------
void fACCT_SPINNER_CALLBACK(Fl_Widget* w, void* data)
{

//	----------------
//	Get the Field Id
//	----------------
		str=(char*)data; x=stoi(str); bool b_AllAccts;
		 
//	-----------------
//	Set the direction
//	-----------------
		if (x>0) {direction=+1;}
		else		 {direction=-1;}
			
//	------------------
//	Get the account no
//	------------------
		switch (x)
		{
			case  41:  
			case -41:
				spinner_acctno=win4_coa_key_acctno->value();
				b01_AllAccts=true;
				break;
			case  42:  
			case -42:
				spinner_acctno=win4_coa_details_cntlacctno->value();
				b01_AllAccts=true;
				break;
			case  51:  
			case -51:
				spinner_acctno=win5_gj_details_dracctno->value();
				b01_AllAccts=false;
				break;
			case  52:  
			case -52:
				spinner_acctno=win5_gj_details_cracctno->value();
				b01_AllAccts=false;
				break;
			case  53:  
			case -53:
				spinner_acctno=win5_gj_details_invacctno->value();
				b01_AllAccts=false;
				break;			
			case  61:  
			case -61:
				spinner_acctno=win6_enq_key_acctno->value();
				b01_AllAccts=false;
				break;			
		}
		
//	-----------------
//	Get the record no
//	-----------------
		spinner_recno=l1_findAcct(spinner_acctno);
				
//	-----------------------------
//	Find the Next/Previous record
//	-----------------------------
		if (spinner_acctno==0)
		{		L1_CALL(c_B01,c_Start,1,0,b01_AllAccts);	}
		else
		{		spinner_recno=l1_findAcct(spinner_acctno);
				if (spinner_recno==99999)
				{ return; }
				else
				{		L1_CALL(c_B01,c_PreviousNext,direction,0,b01_AllAccts);
						if (RETURN_CODE!=0){return;}
				}
		}
			
//	-------------------------
//	string up the description
//	-------------------------
		str="";for (i=0; i<30; i++) {str = str + B01_Description[i];}	

//	-------------------------------------
//	Display the account no and description
//	-------------------------------------
		switch (x)
		{
			case  41:  
			case -41:
				win4_coa_key_acctno->value(B01_AcctNo);	
				win4_coa_key_acctdesc->value(str.c_str());
				win4_coa->redraw();
				break;
			case  42:  
			case -42:
				win4_coa_details_cntlacctno->value(B01_AcctNo);	
				win4_coa_details_cntlacctdesc->value(str.c_str());
				win4_coa->redraw();
				break;
			case  51:  
			case -51:
				win5_gj_details_dracctno->value(B01_AcctNo);	
				win5_gj_details_dracctdesc->value(str.c_str());
				win5_gj->redraw();
				break;
			case  52:  
			case -52:
				win5_gj_details_cracctno->value(B01_AcctNo);	
				win5_gj_details_cracctdesc->value(str.c_str());
				win5_gj->redraw();
				break;
			case  53:  
			case -53:
				win5_gj_details_invacctno->value(B01_AcctNo);	
				win5_gj_details_invacctdesc->value(str.c_str());
				win5_gj->redraw();
				break;
			case  61:  
			case -61:
				win6_enq_key_acctno->value(B01_AcctNo);	
				win6_enq_key_acctdesc->value(str.c_str());
				win6_enq->redraw();
				break;
		}
		
}

//----------------------------------------------------------
//+--Common Function - REQUEST SEARCH
//----------------------------------------------------------
void fACCT_SEARCH_CALLBACK(Fl_Widget* w, void* data)
{

//	----------------
//	Get the Field Id
//	----------------
		str=(char*)data; x=stoi(str);

//	-------------------
//	Starting Account No
//	-------------------		
		switch (x)
		{
			case 42: 
				searchNo=1;
				b99_startAcctNo=win4_coa_details_cntlacctno->value(); 
				b01_AllAccts=true;
				break;
			case 51:
				searchNo=2;
				b99_startAcctNo=win5_gj_details_dracctno->value();
				b01_AllAccts=false;
				break;
			case 52:
				searchNo=3;
				b99_startAcctNo=win5_gj_details_cracctno->value();
				b01_AllAccts=false;
				break;
			case 53:
				searchNo=4;			
				b99_startAcctNo=win5_gj_details_invacctno->value();
				b01_AllAccts=false;
				break;
			case 61:
				searchNo=5;			
				b99_startAcctNo=win6_enq_key_acctno->value();
				b01_AllAccts=false;
				break;
		}
		
		WIN99_ALL_ACCOUNTS();

}

//==========================================================
//		+--
//		+--WINDOW 99 - ACCT SEARCH SELECTION
//==========================================================

//----------------------------------------------------------
//			+--window 99 - populate browser
//----------------------------------------------------------
void WIN99_ALL_ACCOUNTS() 
{

	x=2, y=0; 

	win99_acctselect_browser->clear();

	static int widths[] = { 65, 300 };
	win99_acctselect_browser->column_widths(widths);
	win99_acctselect_browser->column_char('\t');
	i=0;win99Depth=0;

	L1_CALL(c_B01,c_Start,0,0,b01_AllAccts);
	if (RETURN_CODE!=0){return;}

	i=0;
	while (1==1) 
	{

		L1_CALL(c_B01,c_PreviousNext,1,0,b01_AllAccts);	
		if (RETURN_CODE!=0) {break;}

		if (B01_AcctNo >= b99_startAcctNo)
		{			
		
			i++;

			if (win99Depth<375){win99Depth=win99Depth+15;}
		
			str1=to_string(B01_AcctNo).c_str();
			str2="";for (j=0; j<30; j++) {str2 = str2 + B01_Description[j];}

			y = remainder(i, x);
			if (y==0)	{str = "@B52@r " + str1 + "\t@B52" + str2;}
			else		{str = "@r " + str1 + "\t" + str2;}
			win99_acctselect_browser->insert(i,str.c_str(),(long long*)B01_Record_NO);
		}
	}
	
	switch (searchNo)
		{
			case 1: x=270; y=270; break;
			case 2: x=270; y=250; break;
			case 3: x=270; y=280; break;
			case 4: x=270; y=270; break;
			case 5: x=270; y=270; break;
				
		}				
	win99_acctselect->resize(x,y,365,win99Depth+75); 
	win99_grp->resize(5,50,355,win99Depth);
	
	win99_acctselect->redraw();
	windowNo=99; win99_acctselect->show(); 

}

//----------------------------------------------------------
//			+--window 99 - browser selection 
//----------------------------------------------------------
void fWin99_browser_callback(Fl_Widget* w, void* data)
{
	
		x=win99_acctselect_browser->value();if (x==0){return;}
		
		b99_recNo=(long long)win99_acctselect_browser->data(x);
		
		L1_CALL(c_B01,c_Read,b99_recNo,0,b01_AllAccts);

		str="";for (i=0; i<30; i++) {str = str + B01_Description[i];}	
		
		switch (searchNo)
		{
			case 1:
				win4_coa_details_cntlacctno->value(B01_AcctNo);
				win4_coa_details_cntlacctdesc->value(str.c_str());
				win4_coa->redraw();
				windowNo=4;
				break;
				
			case 2:
				win5_gj_details_dracctno->value(B01_AcctNo);
				win5_gj_details_dracctdesc->value(str.c_str());
				windowNo=5;
				win5_gj->redraw();
				break;
				
			case 3: 
				win5_gj_details_cracctno->value(B01_AcctNo);
				win5_gj_details_cracctdesc->value(str.c_str());
				windowNo=5;
				win5_gj->redraw();
				break;
				
			case 4: 
				win5_gj_details_invacctno->value(B01_AcctNo);
				win5_gj_details_invacctdesc->value(str.c_str());
				windowNo=5;
				win5_gj->redraw();
				break;		

			case 5: 
				win6_enq_key_acctno->value(B01_AcctNo);
				win6_enq_key_acctdesc->value(str.c_str());
				windowNo=6;
				win6_enq->redraw();
				break;		
				
		}				
	
		win99_acctselect->hide(); 
		
}

//==========================================================
//		+--
//		+--WINDOW 1 - SYSTEM MENU
//==========================================================
 
//----------------------------------------------------------
//			+--window 1 fWIN1_SPINNER1_CALLBACK
//----------------------------------------------------------
void fWIN1_SPINNER1_CALLBACK(Fl_Widget* w, void* data) 
{	

//	----------------
//	Get the Field Id
//	----------------
		string z=(char*)data; int y=stoi(z);
		 
//	-----------------
//	Set the direction
//	-----------------
		if (y>0) {direction=+1;}
		else		 {direction=-1;}
				
//	-----------------------------
//	Find the Next/Previous record
//	-----------------------------
		L1_CALL(c_A01,c_PreviousNext,direction,0,0);
		a01_system_recno = A01_Record_NO;

//	-------------------------
//	string up the description
//	-------------------------
		str="";for (i=0; i<30; i++) {str = str + A01_Description[i];}	

	//---------------------------------------
	//Grab the return values & display them
	//---------------------------------------
		win1_company_no->value(A01_Parameter);			
		win1_company_desc->value(str.c_str());
		win1->redraw();
		
}
		
//----------------------------------------------------------
//			+--window 1 button 1 callback -> System Parameters
//----------------------------------------------------------
void fWin1_but1_callback(Fl_Widget* w, void* data) 
{	

		win1_but1->clear();

	//-----------------------
	//Grab the transactions
	//-----------------------
		WIN3_SYS_TRANSACTIONS();		

	//---------------
	//Open the window
	//---------------
		win3_sys_key->activate();
		win3_sys_details->deactivate();
		win3_sys_list->activate();
		windowNo=3; win3_sys->show();

}

//----------------------------------------------------------
//			+--window 1 button 2 callback - General Ledger Menu
//----------------------------------------------------------
void fWin1_but2_callback(Fl_Widget* w, void* data) 
{	
	
		L1_CALL(c_A01,c_Read,a01_system_recno,0,0);
		
		win1_but2->clear();
		windowNo=2; win2->show();
				
}
//==========================================================
//		+--
//		+--WINDOW 2 -  GENERAL LEDGER MENU
//==========================================================

//----------------------------------------------------------
//			+--window 2 button 1 callback -> ChartOfAccount
//----------------------------------------------------------
void fWin2_but1_callback(Fl_Widget* w, void* data) 
{	

		win2_but1->clear();

	//-----------------------
	//Grab the transactions
	//-----------------------
		WIN4_COA_ACCOUNTS();		

	//---------------
	//Open the window
	//---------------
		win4_coa_key->activate();
		win4_coa_details->deactivate();
		win4_coa_list->activate();
		
		windowNo=4; win4_coa->show();
		
}
//----------------------------------------------------------
//			+--window 2 button 2 callback -> General Journal
//----------------------------------------------------------
void fWin2_but2_callback(Fl_Widget* w, void* data) 
{	

		win2_but2->clear();

	//-----------------------
	//Grab the transactions
	//-----------------------
		WIN5_GJ_TRANS();		

	//-----------------------
	//Grab todays date
	//-----------------------
		L1_CALL(c_B99,c_B99_GetDate,0,0,0);
		str="";for (j=0; j<4; j++) {str = str + B02_TranDate[j]; win5_gj_key_ccyy->value(str.c_str());}
		str="";for (j=5; j<7; j++) {str = str + B02_TranDate[j]; win5_gj_key_mm->value(str.c_str());}
		str="";for (j=8; j<10;j++) {str = str + B02_TranDate[j]; win5_gj_key_dd->value(str.c_str());}

	//---------------
	//Open the window
	//---------------
		win5_gj_key->activate();
			win5_gj_key_time->deactivate();

		win5_gj_details->deactivate();
		win5_gj_list->activate();
		
		win5_gj->resize(60,120,625,595); 
		win5_gj->redraw();
		
		fromWindowNo=2;
		windowNo=5; win5_gj->show();

}

//----------------------------------------------------------
//			+--window 2 button 3 callback -> Account Enquiry
//----------------------------------------------------------
void fWin2_but3_callback(Fl_Widget* w, void* data) 
{	

		win2_but3->clear();
		win6_enq_key_acctno->value(0);
		win6_enq_browser->clear();

	//-----------------------
	//Grab todays date
	//-----------------------
		win6_enq_key_start_dd->value("01");
		win6_enq_key_start_mm->value("07");
		win6_enq_key_start_ccyy->value("2022");
		win6_enq_key_end_dd->value("30");
		win6_enq_key_end_mm->value("06");
		win6_enq_key_end_ccyy->value("2023");


	//---------------
	//Open the window
	//---------------
		win6_enq_key->activate();
		win6_enq_list->activate();
		windowNo=6; win6_enq->show();

}

//==========================================================
//		+--//		
//		+--WINDOW 3 - SYSTEM PARAMETERS
//==========================================================

//----------------------------------------------------------
//			+--window 3 - populate browser
//----------------------------------------------------------
void WIN3_SYS_TRANSACTIONS() 
{

	x=2, y=0; 

	win3_sys_browser->clear();

	static int widths[] = { 85, 65, 200 };
	win3_sys_browser->column_widths(widths);
	win3_sys_browser->column_char('\t');

	A01_Record_NO = 0;
	i=0;
	while (1==1) 
	{
		i++;

		A01_Record_NO +=1; L1_CALL(c_A01,c_Read,A01_Record_NO,0,0);
		if (RETURN_CODE!=0) {break;}

		str1=to_string(A01_ParameterNo).c_str();
		str2=to_string(A01_Parameter).c_str();
		str3="";for (j=0; j<30; j++) {str3 = str3 + A01_Description[j];}

		y = remainder(i, x);
		if (y==0)	{str = "@B52@r " + str1 + "\t@B52@r" + str2 + "\t@B52" + str3;}
		else		{str = "@r " + str1 + "\t@r" + str2 + "\t" + str3;}
		win3_sys_browser->insert(i,str.c_str(),(long long*)A01_Record_NO);
//		win3_sys_browser->data(i,(long long*)A01_Record_NO);
		
	}
	
	L1_CALL(c_A01,c_Read,1,0,0);
	win3_sys_key_parameterno->value(A01_ParameterNo);
	win3_sys_key_parameter->value(A01_Parameter);

	win3_sys->redraw();

}

//----------------------------------------------------------
//			+--window 3 - browser selection
//----------------------------------------------------------
void fWin3_browser_callback(Fl_Widget* w, void* data)
{

		x=win3_sys_browser->value();if (x==0){return;}	
		
		a01_recNo=(long long)win3_sys_browser->data(x);
	
		if (WIN3_GET_SYS(true)) 
		{
			selectWin3_sys_details();
		}

}

//----------------------------------------------------------
//			+--window 3 - WIN3_GET_SYS
//----------------------------------------------------------
long long WIN3_GET_SYS(bool _details)
{

	//----------------------------------------
	// F5 PRESSED -> Valid Key ?
	//---------------------------------------- 
	if (a01_recNo == 0)
	{
		if (win3_sys_key_parameterno->value()<1 || win3_sys_key_parameterno->value()>3)
		{
			_message("ParameterNo must be 1,2 or 3 \n Press any key to exit");
			return(false);
		}
		if (win3_sys_key_parameter->value()<1 || win3_sys_key_parameter->value()>99)
		{
			_message("Parameter must be between 1 and 99 \n Press any key to exit");
			return(false);
		}
	// EXISTING OR NEW
		for (a01_recNo=1;a01_recNo<100;a01_recNo++)
			{ 
 				L1_CALL(c_A01,c_Read,a01_recNo,0,0);
				if (RETURN_CODE!=0)
		//	NEW
				{	
					a01_recNo=99999; 
					win3_init_parms();
					return(true); 
				}
				else
		//	EXISTING
				{
					if (A01_ParameterNo==win3_sys_key_parameterno->value() 
					&&  A01_Parameter==win3_sys_key_parameter->value())
					{			
						a01_recNo=A01_Record_NO;
						break;
					}
				}
			}
	}
	else
	{
	//----------------------------------------
	// SELECTED FROM BROWSER OR EXISTING (F5)
	//---------------------------------------- 
		L1_CALL(c_A01,c_Read,a01_recNo,0,0); 
		win3_sys_key_parameterno->value(A01_ParameterNo); 
		win3_sys_key_parameter->value(A01_Parameter);
	}

	if (!_details) {return(true);}

 	//-------
	//Details
	//------- 
	str="";for (i=0; i<30; i++) {str = str + A01_Description[i];}	
	win3_sys_details_description->value(str.c_str());
	
	str="";for (i=0; i<8; i++) {str = str + A01_MenuName[i];}
	win3_sys_details_menuname->value(str.c_str());

	str="";for (i=0; i<12; i++) {str = str + A01_LastReference[i];}
	win3_sys_details_lastreference->value(str.c_str());

	win3_sys_details_gstacct->value(A01_GSTAccount);
	win3_sys_details_startyear->value(A01_StartYear);
	
	str="";for (i=0; i<9; i++) {str = str + w_A01_UnitPrice[i];}	
	win3_sys_details_unitprice->value(str.c_str());

	win3_sys_details_company01->value(A01_Company01);
	win3_sys_details_company02->value(A01_Company02);
	win3_sys_details_company03->value(A01_Company03);
	win3_sys_details_company04->value(A01_Company04);
	win3_sys_details_company05->value(A01_Company05);
	win3_sys_details_company06->value(A01_Company06);
	win3_sys_details_company07->value(A01_Company07);
	win3_sys_details_company08->value(A01_Company08);
	win3_sys_details_company09->value(A01_Company09);
	win3_sys_details_company10->value(A01_Company10);
	win3_sys_details_company11->value(A01_Company11);
	win3_sys_details_company12->value(A01_Company12);

	win3_sys->redraw();
	return(true);

}

//----------------------------------------------------------
//			+--window 3 - fWIN3_DETAILS_DELETE_CALLBACK
//----------------------------------------------------------
void fWIN3_DETAILS_DELETE_CALLBACK(Fl_Widget* w, void* data)
{
		L1_CALL(c_A01,c_Delete,a01_recNo,0,0);

		if (RETURN_CODE==0)
		{
			WIN3_SYS_TRANSACTIONS();
			selectWin3_sys_key(NULL,NULL);
		}
		else
		{
			switch (RETURN_CODE)
			{
				case 31:_message("Company belong longs to consolidated group \n cannot be deleted"); break;
			}
		}

}

//----------------------------------------------------------
//			+--window 3 - fWIN3_DETAILS_OKAY_CALLBACK 
//----------------------------------------------------------
void fWIN3_DETAILS_OKAY_CALLBACK(Fl_Widget* w, void* data)
{	 

	//----------------------------------------
	//Valid Data ?
	//---------------------------------------- 

	//DESCRIPTION
		str = win3_sys_details_description->value();
		if (isWhitespace(str))
			 {_message("Please enter a description"); return; }
		l1_strcpy(str,A01_Description,30);

	//MENUNAME
		str = win3_sys_details_menuname->value();
		if (A01_ParameterNo==1 && isWhitespace(str))
			 {_message("Please enter a Menu Name"); return; }
		l1_strcpy(str,A01_MenuName,8);

	//LAST REFERENCE
		str = win3_sys_details_lastreference->value();	
		if (A01_ParameterNo==2 && isWhitespace(str))
			 {_message("Please enter a Last Reference"); return; }
		l1_strcpy(str,A01_LastReference,12);

	//GSTACCOUNT - can be zero
		A01_GSTAccount = win3_sys_details_gstacct->value();

	//START YEAR
		if (A01_ParameterNo==2 && win3_sys_details_startyear->value()==0)
			 {_message("Please enter a Start Year"); return; }
		A01_StartYear = win3_sys_details_startyear->value();

	//UNITPRICE - can be zero
		str = win3_sys_details_unitprice->value();
		for (i=0; i<9; i++){w_A01_UnitPrice[i]=' ';} 
		l1_strcpy(str,w_A01_UnitPrice,str.length());

	//COMPANIES - Validated by languageONE
		A01_Company01=win3_sys_details_company01->value();
		A01_Company02=win3_sys_details_company02->value();
		A01_Company03=win3_sys_details_company03->value();
		A01_Company04=win3_sys_details_company04->value();
		A01_Company05=win3_sys_details_company05->value();
		A01_Company06=win3_sys_details_company06->value();
		A01_Company07=win3_sys_details_company07->value();
		A01_Company08=win3_sys_details_company08->value();
		A01_Company09=win3_sys_details_company09->value();
		A01_Company10=win3_sys_details_company10->value();
		A01_Company11=win3_sys_details_company11->value();
		A01_Company12=win3_sys_details_company12->value();

	//----------------------------------------
	//Proceed ?
	//---------------------------------------- 
		L1_CALL(c_A01,c_Write,a01_recNo,0,0);
		if (RETURN_CODE==0)
		{
			WIN3_SYS_TRANSACTIONS();
			selectWin3_sys_key(NULL,NULL);
		}
		else
		{
			switch (RETURN_CODE)
			{
				case 32:_message("Invalid GST Account"); break;
				case 33:_message("Invalid Company in Consolidated Group"); break;
			}
		}

}

//==========================================================
//		+--
//		+--WINDOW 4 - CHART OF ACCOUNT
//==========================================================

//----------------------------------------------------------
//			+--window 4 - populate browser
//----------------------------------------------------------
void WIN4_COA_ACCOUNTS() 
{

	b01_AllAccts=true;
	
	x=2, y=0; 

	win4_coa_browser->clear();

	static int widths[] = { 65, 300 };
	win4_coa_browser->column_widths(widths);
	win4_coa_browser->column_char('\t');

	L1_CALL(c_B01,c_Start,0,0,b01_AllAccts);
	if (RETURN_CODE!=0){return;}
	
	i=0;
	while (1==1) 
	{
		i++;

		L1_CALL(c_B01,c_PreviousNext,1,0,b01_AllAccts);
		if (RETURN_CODE!=0) {break;}

		str1=to_string(B01_AcctNo).c_str();
		str2="";for (j=0; j<30; j++) {str2 = str2 + B01_Description[j];}

		y = remainder(i, x);
		if (y==0)	{str = "@B52@r " + str1 + "\t@B52" + str2;}
		else		{str = "@r " + str1 + "\t" + str2;}
		win4_coa_browser->insert(i,str.c_str(),(long long*)B01_Record_NO);
//		win4_coa_browser->data(i,(long long*)B01_Record_NO);

	}

		x=(long long)win4_coa_browser->data(1);
	
		L1_CALL(c_B01,c_Start,1,0,b01_AllAccts);
		win4_coa_key_acctno->value(B01_AcctNo);
		win4_coa_key_acctdesc->value(B01_Description);

		win4_coa->redraw();

}

//----------------------------------------------------------
//			+--window 4 - browser selection 
//----------------------------------------------------------
void fWin4_browser_callback(Fl_Widget* w, void* data)
{

			x=win4_coa_browser->value();if (x==0){return;}	
			
			b01_recNo=(long long)win4_coa_browser->data(x);

			WIN4_GET_ACCT(true);
			selectWin4_coa_details();
			
}


//----------------------------------------------------------
//			+--Window 4 - WIN4_GET_ACCT
//----------------------------------------------------------
long long WIN4_GET_ACCT(bool _details)
{

	//----------------------------------------
	// F5 PRESSED -> Valid Key ?
	//---------------------------------------- 
	if (b01_recNo == 0)
	{
		if (win4_coa_key_acctno->value()>59998) 
		{
			_message("Account No must be less than 59999 \n Press any key to exit");
			return(false);
		}
		if (win4_coa_key_acctno->value()<1)
		{
			_message("Please enter an Account No \n Press any key to exit");
			return(false);
		}

	// EXISTING OR NEW
		b01_recNo=l1_findAcct(win4_coa_key_acctno->value());
		if (b01_recNo==99999)
		{
			win4_init_accts();
			return(true);
		}
		else
		{
			win4_coa_key_acctno->value(B01_AcctNo);
			str="";for (i=0; i<30; i++) {str = str + B01_Description[i];}	
			win4_coa_key_acctdesc->value(str.c_str());						
		}
	}
	else
	//----------------------------------------
	// SELECTED FROM BROWSER
	//----------------------------------------
	{ 
		L1_CALL(c_B01,c_Read,b01_recNo,0,b01_AllAccts); 
		win4_coa_key_acctno->value(B01_AcctNo); 
	}	

	b01_recNo=B01_Record_NO;

	//-------
	//Details
	//------- 
	if (!_details) {return(true);}
		
	str="";for (i=0; i<30; i++) {str = str + B01_Description[i];}	
	win4_coa_details_description->value(str.c_str());
		
	str="";for (i=0; i<2; i++) {str = str + B01_Flag1[i];}
	for (i=0; i<13; i++) { if (str==flag1[i]) {break;}}
	win4_coa_details_flag1->value(i);

	win4_coa_details_flag2->value(B01_Flag2);
	win4_coa_details_flag3->value(B01_Flag3);
	win4_coa_details_flag4->value(B01_Flag4);
		
	str="";for (i=0; i<2; i++) {str = str + B01_BalanceIndicator[i];}
	for (i=0; i<2; i++) { if (str==balID[i]) {break;}}
	win4_coa_details_balid->value(i);

	win4_coa_details_cntlacctno->value(B01_CntlAcctNo);			
	win4_coa_details_depreciation->value(to_string(B01_Depreciation).c_str());

	str="";for (i=0; i<9; i++) {str = str + w_B01_UnitPrice[i];}	
	win4_coa_details_unitprice->value(str.c_str());

	win4_coa->redraw();
	return(true);
	
}

//----------------------------------------------------------
//			+--window 4 - fWIN4_DETAILS_DELETE_CALLBACK
//----------------------------------------------------------
void fWIN4_DETAILS_DELETE_CALLBACK(Fl_Widget *w, void *data)
{

		L1_CALL(c_B01,c_Read,b01_recNo,0,b01_AllAccts);
		L1_CALL(c_B01,c_Delete,b01_recNo,0,b01_AllAccts);

		if (RETURN_CODE==0)
		{
			WIN4_COA_ACCOUNTS();
			selectWin4_coa_key(NULL,NULL);
		}
		else
		{
			switch (RETURN_CODE)
			{
				case 41: _message("Cannot delete a controlling account with children"); break;
			}
		}

}

//----------------------------------------------------------
//			+--window 4 - fWIN4_DETAILS_OKAY_CALLBACK 
//----------------------------------------------------------
void fWIN4_DETAILS_OKAY_CALLBACK(Fl_Widget* w, void* data)
{	 

	if (b01_recNo!=99999)	
		{L1_CALL(c_B01,c_Read,b01_recNo,0,b01_AllAccts);}

	//-------
	//Details
	//------- 

	//DESCRIPTION
		str = win4_coa_details_description->value();
		if (isWhitespace(str))
			 {_message("Please enter a description"); return; }
		l1_strcpy(str,B01_Description,30);

	//FLAG1
		i = win4_coa_details_flag1->value(); str = flag1[i];
		l1_strcpy(str,B01_Flag1,2);

	//FLAG2,3,4
		B01_Flag2=win4_coa_details_flag2->value();
		B01_Flag3=win4_coa_details_flag3->value();
		B01_Flag4=win4_coa_details_flag4->value();

	//BALANCE INDICATOR
	i = win4_coa_details_balid->value(); str = balID[i];
		l1_strcpy(str,B01_BalanceIndicator,2);

	//CONTROL ACCOUNT
		B01_CntlAcctNo=win4_coa_details_cntlacctno->value();
		if (B01_CntlAcctNo==B01_AcctNo)
			 {_message("Control account cannot refer to itself"); return; }
			
	//-----------------------------------------------------------------
	//This will not need validating because 'stoi' will return only the 
	//interger portion
	//-----------------------------------------------------------------
		str = win4_coa_details_depreciation->value();
		if (!isWhitespace(str))
			{ B01_Depreciation = stoi(str);}

	//UNITPRICE - can be zero
	//-----------------------------------------------------------------
	//Need to drop any more than (n) decimal places 
	//-----------------------------------------------------------------
		str = win4_coa_details_unitprice->value();
		for (i=0; i<9; i++){w_B01_UnitPrice[i]=' ';} 
		l1_strcpy(str,w_B01_UnitPrice,str.length());

	//----------------------------------------
	//Proceed ?
	//---------------------------------------- 
		L1_CALL(c_B01,c_Write,b01_recNo,0,b01_AllAccts);
		if (RETURN_CODE==0)
		{
			WIN4_COA_ACCOUNTS();
			selectWin4_coa_key(NULL,NULL);
		}
		else
		{
			switch (RETURN_CODE)
			{
				case 42: _message("Sub Accounts still atached to this Control Account"); break;
				case 43: _message("Invalid Control Account"); break;
			}
		}

}


//==========================================================
//		+--
//		+--WINDOW 5 - GENERAL JOURNAL
//==========================================================

//----------------------------------------------------------
//			+--window 5 - populate browser
//----------------------------------------------------------
void WIN5_GJ_TRANS() 
{

	b01_AllAccts=false;

	x=2, y=0; 

	win5_gj_browser->clear();

	static int widths[] = { 85, 300 };
	win5_gj_browser->column_widths(widths);
	win5_gj_browser->column_char('\t');

	L1_CALL(c_B02,c_Start,0,0,0);
	if (RETURN_CODE!=0){return;}

	i=0;
	while (1==1) 
	{
		i++;

		L1_CALL(c_B02,c_PreviousNext,1,0,0);
		if (RETURN_CODE!=0) {break;}

		str1="";for (j=0; j<10; j++) {str1 = str1 + B02_TranDate[j];}
		str2="";for (j=0; j<30; j++) {str2 = str2 + B02_Description[j];}

		y = remainder(i, x);
		if (y==0)	{str = "@B52@r " + str1 + "\t@B52" + str2;}
		else		{str = "@r " + str1 + "\t" + str2;}
		win5_gj_browser->insert(i,str.c_str(),(long long*)B02_Record_NO);
//		win5_gj_browser->data(i,(long long*)B02_Record_NO);
		
	}

	L1_CALL(c_B02,c_Start,1,0,0);
	
	win5_gj_key_ccyy->value(str1.substr(0,4).c_str());
	win5_gj_key_mm->value(str1.substr(5,2).c_str());
	win5_gj_key_dd->value(str1.substr(8,2).c_str());

	str3="";for (j=0; j<8; j++) {str3 = str3 + B02_TranTime[j];}
	win5_gj_key_time->value(str3.c_str());
	
	win5_gj->redraw();

}

//----------------------------------------------------------
//			+--window 5 - browser selection 
//----------------------------------------------------------
void fWin5_browser_callback(Fl_Widget* w, void* data)
{

		x=win5_gj_browser->value();if (x==0){return;}	
		
		b02_recNo=(long long)win5_gj_browser->data(x);
	
		WIN5_GET_TRANS(true);
		selectWin5_gj_details();
		
}

//----------------------------------------------------------
//			+--Window 5 - WIN5_GET_TRANS
//----------------------------------------------------------
long long WIN5_GET_TRANS(bool _details)
{
		time_t rawtime;
		struct tm * timeinfo;
  
	//------------------------------------------
	// F5 PRESSED -> Valid Key ?
	//	Always a new record for the transactions
	//------------------------------------------ 
	if (b02_recNo == 0)
	{
	//DATE
		dd=win5_gj_key_dd->value(); if (dd.length()==1){dd='0'+dd;}
		mm=win5_gj_key_mm->value(); if (mm.length()==1){mm='0'+mm;}
		ccyy=win5_gj_key_ccyy->value();
		str=ccyy+'/'+mm+'/'+dd;
		l1_strcpy(str,B02_TranDate,10);
		
		for (i=0; i<10; i++) {w_Date[i] = B02_TranDate[i];}		
		L1_CALL(c_B99,c_B99_ValidDate,0,0,0);
		if (RETURN_CODE!=0) 
		{
			_message("Invalid Date \n Press any key to exit");
			return(false);
		}	
		else
		{
		//TIME
			time (&rawtime);
			timeinfo = localtime (&rawtime);
			str=asctime(timeinfo);
			x=str.find(':'); x=x-2; str = str.substr(x, 8);
			l1_strcpy(str,B02_TranTime,8);

			b02_recNo=99999; 
			win5_init_trans();
			return(true); 
		}
	}
	else
	//----------------------------------------
	// SELECTED FROM BROWSER
	//---------------------------------------- 
	{
		L1_CALL(c_B02,c_Read,b02_recNo,0,0); 
	
		str="";for (j=0; j<10; j++) {str = str + B02_TranDate[j];}
			win5_gj_key_ccyy->value(str.substr(0,4).c_str());
			win5_gj_key_mm->value(str.substr(5,2).c_str());
			win5_gj_key_dd->value(str.substr(8,2).c_str());

			str="";for (j=0; j<8; j++) {str = str + B02_TranTime[j];}
				win5_gj_key_time->value(str.c_str());

		}

	b02_recNo=B02_Record_NO;

	if (!_details) {return(true);}

	//-------
	//Details
	//------- 
		win5_gj_details_dracctno->value(B02_DRAcctNo);
			x=l1_findAcct(B02_DRAcctNo);
			str="";for (i=0; i<30; i++) {str = str + B01_Description[i];}	
			win5_gj_details_dracctdesc->value(str.c_str());
						
		win5_gj_details_cracctno->value(B02_CRAcctNo);	
			x=l1_findAcct(B02_CRAcctNo);
			str="";for (i=0; i<30; i++) {str = str + B01_Description[i];}	
			win5_gj_details_cracctdesc->value(str.c_str());
		
		str="";for (i=0; i<30; i++) {str = str + B02_Description[i];}	
		win5_gj_details_description->value(str.c_str());

		str="";for (i=0; i<10; i++) {str = str + w_B02_Value[i];}	
		win5_gj_details_value->value(str.c_str());
		
		win5_gj_details_noofunits->value(B02_NoOfUnits);

		str="";for (i=0; i<10; i++) {str = str + B02_Reference[i];}	
		win5_gj_details_reference->value(str.c_str());

		win5_gj_details_invtrantype->value(B02_INVTranType);
		win5_gj_details_invacctno->value(B02_INVAcctNo);
			str="";for (i=0; i<30; i++) {str = str + B01_Description[i];}	
			win5_gj_details_invacctdesc->value(str.c_str());
				
		win5_gj_details_invparcelno->value(B02_INVParcelNo);
		win5_gj_details_invgrouping->value(B02_INVGrouping);

		str="";for (i=0; i<7; i++) {str = str + w_B02_FrankedAmt[i];}	
		win5_gj_details_frankedamt->value(str.c_str());

		str="";for (i=0; i<7; i++) {str = str + w_B02_ImputedCredit[i];}	
		win5_gj_details_imputedcredit->value(str.c_str());

		str="";for (i=0; i<9; i++) {str = str + w_B02_SUnitPrice[i];}	
		win5_gj_details_sunitprice->value(str.c_str());
		
		str="";for (i=0; i<10; i++) {str = str + B02_SReference[i];}	
		win5_gj_details_sreference->value(str.c_str());
		

	win5_gj->redraw();
	return(true);

}

//----------------------------------------------------------
//			+--window 5 - fWIN5_DETAILS_DELETE_CALLBACK
//----------------------------------------------------------
void fWIN5_DETAILS_DELETE_CALLBACK(Fl_Widget *w, void *data)
{

		L1_CALL(c_B02,c_Delete,b02_recNo,0,0);

		if (RETURN_CODE==0)
		{
			WIN5_GJ_TRANS();
			selectWin5_gj_key(NULL,NULL);
		}
		else
		{
			switch (RETURN_CODE)
			{
				case 0000: break;  // There no reason you cant delete a transaction
			}
		}
}

//----------------------------------------------------------
//			+--window 5 - fWIN5_DETAILS_OKAY_CALLBACK 
//----------------------------------------------------------
void fWIN5_DETAILS_OKAY_CALLBACK(Fl_Widget* w, void* data)
{	

	if (b02_recNo!=99999)	
		{L1_CALL(c_B02,c_Read,b02_recNo,0,0);}

	//-------
	//Details
	//------- 
		
	//DEBIT ACCOUNT
		B02_DRAcctNo = win5_gj_details_dracctno->value();
		if (B02_DRAcctNo==0)
			{
				_message("Please enter a Debit Account No");
				return;
			}

	//CREDIT ACCOUNT
		B02_CRAcctNo = win5_gj_details_cracctno->value();
		if (B02_CRAcctNo==0)
			{
				_message("Please enter a Credit Account No");
				return;
			}

	//DESCRIPTION
		str = win5_gj_details_description->value();
		if (isWhitespace(str))
			 {_message("Please enter a description"); return; }
		l1_strcpy(str,B02_Description,30);

	//VALUE
	//-----------------------------------------------------------------
	//Need to drop any more than (n) decimal places 
	//-----------------------------------------------------------------
		str = win5_gj_details_value->value();
		for (i=0; i<10; i++){w_B02_Value[i]=' ';} 
		l1_strcpy(str,w_B02_Value,str.length());
		
	//NOOFUNITS
		B02_NoOfUnits = win5_gj_details_noofunits->value();
		
	//REFERENCE
		str = win5_gj_details_reference->value();
		l1_strcpy(str,B02_Reference,10);

	//INVTRANTYPE
		B02_INVTranType = win5_gj_details_invtrantype->value();

	//INVACCTNO
		B02_INVAcctNo = win5_gj_details_invacctno->value();

	//INVPARCELNO
		B02_INVParcelNo = win5_gj_details_invparcelno->value();

	//INVGROUPING
		B02_INVGrouping = win5_gj_details_invgrouping->value();
		
	//FRANKEDAMOUNT
	//-----------------------------------------------------------------
	//Need to drop any more than (n) decimal places 
	//-----------------------------------------------------------------
		str = win5_gj_details_frankedamt->value();
		for (i=0; i<7; i++){w_B02_FrankedAmt[i]=' ';} 
		l1_strcpy(str,w_B02_FrankedAmt,str.length());
		
	//IMPUTEDCREDIT
	//-----------------------------------------------------------------
	//Need to drop any more than (n) decimal places 
	//-----------------------------------------------------------------
		str = win5_gj_details_imputedcredit->value();
		for (i=0; i<7; i++){w_B02_ImputedCredit[i]=' ';} 
		l1_strcpy(str,w_B02_ImputedCredit,str.length());

	//SUNITPRICE
	//-----------------------------------------------------------------
	//Need to drop any more than (n) decimal places 
	//-----------------------------------------------------------------
		str = win5_gj_details_sunitprice->value();
		for (i=0; i<9; i++){w_B02_SUnitPrice[i]=' ';} 
		l1_strcpy(str,w_B02_SUnitPrice,str.length());

	//SREFERENCE
		str = win5_gj_details_sreference->value();
		l1_strcpy(str,B02_SReference,10);

	//----------------------------------------
	//Proceed ?
	//---------------------------------------- 
		L1_CALL(c_B02,c_Write,b02_recNo,0,0);
		if (RETURN_CODE==0)
		{
			WIN5_GJ_TRANS();
			selectWin5_gj_key(NULL,NULL);
		}
		else
		{
			switch (RETURN_CODE)
			{
				case 52: _message("Invalid Debit Account"); break;
				case 53: _message("Invalid Credit Account"); break;
				case 54: _message("Invalid Investment Account"); break;
				case 55: _message("Value cannot be zero"); break;
			}
		}

}

//==========================================================
//		+--
//		+--WINDOW 6 - ACCOUNT ENQUIRY
//==========================================================

//----------------------------------------------------------
//			+--Window 6 - WIN6_GET_KEY
//----------------------------------------------------------
long long WIN6_GET_KEY()
{		

	//ACCOUNT NUMBER
		b01_recNo=l1_findAcct(win6_enq_key_acctno->value());
		if (b01_recNo==59999)
		{
			_message("Invalid Account Number \n Press any key to exit");
			return(false);
		}	
		enq_acctno=B01_AcctNo;
		
	//START DATE
		dd=win6_enq_key_start_dd->value(); if (dd.length()==1){dd='0'+dd;}
		mm=win6_enq_key_start_mm->value(); if (mm.length()==1){mm='0'+mm;}
		ccyy=win6_enq_key_start_ccyy->value();
		str=ccyy+'/'+mm+'/'+dd;
		l1_strcpy(str,w_StartDate,10);		

		for (i=0; i<10; i++) {w_Date[i] = w_StartDate[i];}		
		L1_CALL(c_B99,c_B99_ValidDate,0,0,0);
		if (RETURN_CODE!=0) 
		{
			_message("Invalid Start Date \n Press any key to exit");
			return(false);
		}	

	//END DATE
		dd=win6_enq_key_end_dd->value(); if (dd.length()==1){dd='0'+dd;}
		mm=win6_enq_key_end_mm->value(); if (mm.length()==1){mm='0'+mm;}
		ccyy=win6_enq_key_end_ccyy->value();
		str=ccyy+'/'+mm+'/'+dd;
		l1_strcpy(str,w_EndDate,10);		

		for (i=0; i<10; i++) {w_Date[i] = w_EndDate[i];}		
		L1_CALL(c_B99,c_B99_ValidDate,0,0,0);
		if (RETURN_CODE!=0) 
		{
			_message("Invalid End Date \n Press any key to exit");
			return(false);
		}	
		
	//DATES
		if (strcmp(w_EndDate,w_StartDate)<0)
		{
			_message("End Date cannot be less than Start Date \n Press any key to exit");
			return(false);
		}				
		
	return(true);
	
}

//----------------------------------------------------------
//			+--window 6 - populate browser
//----------------------------------------------------------
long long WIN6_ENQ_ACCOUNTS() 
{

	string sDate, sDetails, sDebit, sCredit, sBalance;
	string spaces10="";for (j=0; j<30; j++) {spaces10 = spaces10 + ' ';}	

	
	win6_enq_browser->clear();

	static int widths[] = { 80, 255, 80, 80, 15, 100 };
	win6_enq_browser->column_widths(widths);
	win6_enq_browser->column_char('\t');

	i=0;
	while (1==1) 
	{
		i++;

		L1_CALL(c_B03,c_Read,i,0,0);
		if (RETURN_CODE!=0) {break;}

	//DATE
		sDate="";for (j=0; j<10; j++) {sDate = sDate + B03_TranDate[j];}

	//DETAILS - Description	
		str1="";for (j=0; j<36; j++) {str1 = str1 + B03_Description[j];}	
		str2=str1.substr(0,15); 
		if (str2.compare("Opening Balance")==0)
			{ sDetails="Opening Balance";}
		else {sDetails=str1;}

	//VALUE	
		str1="";for (j=0; j<2; j++) {str1 = str1 + B01_BalanceIndicator[j];}
		
		str="";str=l1_addcommas(w_B03_Value);
		if (str1==balID[1])
		{	
			if (B03_DRAcctNo==B01_AcctNo)
			{	sDebit=str; sCredit=spaces10; } else	{	sCredit=str; sDebit=spaces10; }
		}
		else
		{
			if (B03_CRAcctNo==B01_AcctNo)
			{	sCredit=str; sDebit=spaces10; } else	{	sDebit=str; sCredit=spaces10; }
		}
	
			
	//RUNNING BALANCE	
		for (j=9; j>-1; j--) {w_RunningBalance[j]=' ';}
		
		str2=w_B03_RunningBalance[10];
		for (j=9; j>-1; j--) {w_RunningBalance[j]=w_B03_RunningBalance[j];}
	
		str3='-';str="";
		if (str2.compare(str3)==0)
			{	str=l1_addcommas(w_RunningBalance);
				sBalance='(' + str + ')'; }
		else
			{ str=l1_addcommas(w_RunningBalance);
				sBalance=' ' + str + ' '; }
	
		y = remainder(i, 2);
		if (y==0)	
		{	
			str = "@B52 " + sDate + "\t@B52 " + sDetails + "\t@B52@r " + sDebit + "\t@B52@r " + sCredit + "\t@B52 " + ' ' + "\t@B52@r " + sBalance;
		}
		else		
		{
			str =  ' ' + sDate + "\t " + sDetails + "\t@r " + sDebit + "\t@r " + sCredit + "\t " + ' ' + "\t@r " + sBalance;
		}
		win6_enq_browser->insert(i,str.c_str(),(long long*)B03_TranRecNo);
//		win6_enq_browser->data(i,(long long*)B03_TranRecNo);
		
	}

	win6_enq->redraw();

}

//----------------------------------------------------------
//			+--window 5 - browser selection 
//----------------------------------------------------------
void fWin6_browser_callback(Fl_Widget* w, void* data)
{

//	< 2 inn this instance cuz we cant change the opening balance
		x=win6_enq_browser->value();if (x<2){return;}
		
		b02_recNo=(long long)win6_enq_browser->data(x);	

		WIN5_GET_TRANS(true);
		selectWin5_gj_details();

		win5_gj->resize(80,160,625,595); 
		win5_gj->redraw();
		
		fromWindowNo=6;
		windowNo=5; win5_gj->show();

}


//==========================================================
//		+--
//		+--GENERAL 
//==========================================================

//----------------------------------------------------------
//			+--window 3 select key
//----------------------------------------------------------
void selectWin3_sys_key(Fl_Widget* w, void* data)
{
		win3_sys_key->activate();
		win3_sys_details->deactivate();
		win3_sys_browser->activate();

}

//----------------------------------------------------------
//			+--window 3 select details
//----------------------------------------------------------
void selectWin3_sys_details()
{
		win3_sys_key->deactivate();
		win3_sys_details->activate();
		win3_sys_browser->deactivate();

		switch (A01_ParameterNo)
		{
			case 1: 
				win3_sys_details_grp1->activate();
				win3_sys_details_grp2->deactivate();
				win3_sys_details_grp3->deactivate();
				win3_sys_details_tabs->value(win3_sys_details_grp1);
				break;
			case 2: 
				win3_sys_details_grp1->deactivate();
				win3_sys_details_grp2->activate();
				win3_sys_details_grp3->deactivate();
				win3_sys_details_tabs->value(win3_sys_details_grp2);
				break;
			case 3: 
				win3_sys_details_grp1->deactivate();
				win3_sys_details_grp2->deactivate();
				win3_sys_details_grp3->activate();
				win3_sys_details_tabs->value(win3_sys_details_grp3);
				break;
		}

		if (a01_recNo==99999)
		{ win3_sys_details_delete->deactivate(); }
		else
		{ win3_sys_details_delete->activate(); }

		win3_sys_details_description->position(0);

}

//----------------------------------------------------------
//			+--window 4 select key
//----------------------------------------------------------
void selectWin4_coa_key(Fl_Widget* w, void* data)
{
		win4_coa_key->activate();
		win4_coa_details->deactivate();
		win4_coa_browser->activate();

}

//----------------------------------------------------------
//			+--window 4 select details
//----------------------------------------------------------
void selectWin4_coa_details()
{
		win4_coa_key->deactivate();
		win4_coa_details->activate();
		win4_coa_browser->deactivate();

		if (b01_recNo==99999)
		{ win4_coa_details_delete->deactivate(); }
		else
		{ win4_coa_details_delete->activate(); }

		win4_coa_details_description->position(0);
	
}

//----------------------------------------------------------
//			+--window 5 select key
//----------------------------------------------------------
void selectWin5_gj_key(Fl_Widget* w, void* data)
{
		win5_gj_key->activate();
		win5_gj_details->deactivate();
		win5_gj_browser->activate();
}

//----------------------------------------------------------
//			+--window 5 select details
//----------------------------------------------------------
void selectWin5_gj_details()
{
		win5_gj_key->deactivate();
		win5_gj_details->activate();
				win5_gj_details_grp1->activate();
				win5_gj_details_tabs->value(win5_gj_details_grp1);

				win5_gj_details_grp2->activate();
				win5_gj_details_grp3->activate();

		win5_gj_browser->deactivate();

		if (b02_recNo==99999)
		{ win5_gj_details_delete->deactivate(); }
		else
		{ win5_gj_details_delete->activate(); }

}

//----------------------------------------------------------
//			+--window 3 - init parms
//----------------------------------------------------------
void win3_init_parms()
{

	//-----
	//	KEY
	//-----
		A01_ParameterNo=win3_sys_key_parameterno->value();
		A01_Parameter=win3_sys_key_parameter->value();

	//---------
	//	DETAILS
	//---------
		win3_sys_details_description->value("");
		win3_sys_details_menuname->value("");
		win3_sys_details_lastreference->value("");
		win3_sys_details_gstacct->value(0);
		win3_sys_details_startyear->value(0);
		win3_sys_details_unitprice->value(0);
		win3_sys_details_company01->value(0);
		win3_sys_details_company02->value(0);
		win3_sys_details_company03->value(0);
		win3_sys_details_company04->value(0);
		win3_sys_details_company05->value(0);
		win3_sys_details_company06->value(0);
		win3_sys_details_company07->value(0);
		win3_sys_details_company08->value(0);
		win3_sys_details_company09->value(0);
		win3_sys_details_company10->value(0);
		win3_sys_details_company11->value(0);
		win3_sys_details_company12->value(0);
		win3_sys->redraw();

}

//----------------------------------------------------------
//			+--window 4 - init accts
//----------------------------------------------------------
void win4_init_accts()
{

	//-----
	//	KEY
	//-----
		B01_AcctNo=win4_coa_key_acctno->value();

	//---------
	//	DETAILS
	//---------
		win4_coa_details_description->value("");
		win4_coa_details_flag1->value(1);
		win4_coa_details_flag2->value(1);
		win4_coa_details_flag3->value(1);
		win4_coa_details_flag4->value(1);
		win4_coa_details_balid->value(1);	
		win4_coa_details_cntlacctno->value(0);
		win4_coa_details_cntlacctdesc->value("");		
		win4_coa_details_depreciation->value(0);
		win4_coa_details_unitprice->value(0);
	
		win4_coa->redraw();

}

//----------------------------------------------------------
//			+--window 5 - init trans
//----------------------------------------------------------
void win5_init_trans()
{

	//-----
	//	KEY
	//-----
	//	Key is not setup here cuz F5 is always a new record
	//	it is done in win5_get_trans cuz the date is validated
	//	there
 
	//---------
	//	DETAILS
	//---------
		win5_gj_details_dracctno->value(0);
		win5_gj_details_dracctdesc->value("");
		win5_gj_details_cracctno->value(0);
		win5_gj_details_cracctdesc->value("");
		win5_gj_details_description->value("");
		win5_gj_details_value->value(0);
		win5_gj_details_noofunits->value(0);
		win5_gj_details_reference->value("");
		win5_gj_details_invtrantype->value(0);
		win5_gj_details_invacctno->value(0);
		win5_gj_details_invacctdesc->value("");
		win5_gj_details_invparcelno->value(0);
		win5_gj_details_invgrouping->value(0);
		win5_gj_details_frankedamt->value("");
		win5_gj_details_imputedcredit->value("");
		win5_gj_details_sunitprice->value("");
		win5_gj_details_reference->value("");

		
		win5_gj->redraw();

}

//==========================================================
//		+--WINDOW 0 - MESSAGES
//==========================================================

//----------------------------------------------------------
//			+--window 0 - display message
//----------------------------------------------------------
void _message(string _text)
{
		str = _text;
		message_text->label(str.c_str());
		message->show();
 
}

//----------------------------------------------------------
//			+--window 0 - message YES
//----------------------------------------------------------
void _message_yes_callback(Fl_Widget* w, void* data)
{ 
		if (windowNo==1)
		{
			L1_CALL (0,c_Commit,0,0,0);
			message->hide();
			win1->hide();
		}
		else
		{
			message->hide();
		} 

}

//----------------------------------------------------------
//			+--window 0 - message NO
//----------------------------------------------------------
void _message_no_callback(Fl_Widget* w, void* data)
{ 
		message->hide(); 
		if (windowNo==1) {win1->hide();}

}

//----------------------------------------------------------
//			+--window 0 - message cancel
//----------------------------------------------------------
void _message_cancel_callback(Fl_Widget* w, void* data)
{ 
		message->hide(); 

}

//----------------------------------------------------------
//		+--All windows - exit
//----------------------------------------------------------
void _windowExit_callback(Fl_Widget* w, void* data)
{

		switch (windowNo)
		{
			case 1:	 _message("Commit changes to database ?");
								break;

			case 2: 	win2->hide();
								windowNo=1;
								break;

			case 3: 	win3_sys->hide();	
								windowNo=1;
								break;

			case 4: 	win4_coa->hide();	
								windowNo=2;
								break;

			case 5: 	win5_gj->hide();
								windowNo=fromWindowNo;
								if (windowNo==6)
									{
										L1_CALL(c_B03,c_Enquire,0,enq_acctno,0);
									 	WIN6_ENQ_ACCOUNTS();
									 	break;
									}
								break;

			case 6: 	win6_enq->hide();	
								windowNo=2;
								break;
								
			case 99:	win99_acctselect->hide();
								switch (searchNo) {
									case 1: windowNo=4; break;
									case 2:
									case 3: 
									case 4: windowNo=5; break; 
									case 5: windowNo=6; break;		
								}				
								break;

		}
				
}

