//----------------------------------------------------------
//	languageONE routines/Constants
//----------------------------------------------------------
	extern "C" int L1_PROCESS();
	extern "C" long long l1_findAcct(long long acct);

//----------------------------------------------------------
//	languageONE data structures
//----------------------------------------------------------
//	Not sure if I will need these so here at the moment just
//	in case

	struct l1_Number 
	{
		long long CtrlBlk;
		long long Scale;
		char Indicator;
		long long Length;
		long long Number;
		char Picture[26];
	} __attribute__((packed)); 

	struct l1_Word 
	{
		long long Filler1;
		long long Filler2;
		char Indicator;
		long long Length;
		char Alpha[128];
	} __attribute__((packed)); 

//----------------------------------------------------------
//	Parameters and Parameter Address to pass to languageONE
//----------------------------------------------------------
//	long long* l1_Params[3] = {};
//	long long* l1_Params_Addr;

//----------------------------------------------------------
//	Call languageONE
//----------------------------------------------------------
void L1_CALL (long long _table,long long _request, long long _recNo, long long _acctno, long long _accts) 
{
//	l1_Params[0] = (long long*)_table;							// Table
//	l1_Params[1] = (long long*)_request;							// Request
//	l1_Params[2] = (long long*)_recNo;							// Record No

//	auto l1_Params_Addr = std::addressof(l1_Params);		// Get Array address (it keeps moving)
//	----------------------------------------
//	asm ("mov %rax,l1_Params_Addr");						// Array address into RAX
//	----------------------------------------
//	As luck would have it std::addressof(l1_Params)
//	returns the address in the RAX register and so we
//	can do without it
//
//	Apparantly Inline assembler is not supported in VC++
//	so for conformity it is commented out here
//	It is nice to keep it for documentations sake
//	---------------------------------------
	x_TableNo	= _table;
	x_Request	= _request;
	x_RecNo		= _recNo;
	x_AcctNo	= _acctno;
	x_Accts		= _accts;
	
	asm("push %rax");
	asm("push %rbx");
	asm("push %rcx");
	asm("push %rdx");	
	asm("push %rsi");
	asm("push %rdi");
	asm("push %rbp");
	asm("push %r8");
	asm("push %r9");
	asm("push %r10");
	asm("push %r11");
	asm("push %r12");
	asm("push %r13");
	asm("push %r14");
	asm("push %r15");
			
	L1_PROCESS();

	asm("pop %r15");
	asm("pop %r14");
	asm("pop %r13");
	asm("pop %r12");
	asm("pop %r11");
	asm("pop %r10");
	asm("pop %r9");
	asm("pop %r8");
	asm("pop %rbp");
	asm("pop %rdi");
	asm("pop %rsi");
	asm("pop %rdx");
	asm("pop %rcx");
	asm("pop %rbx");
	asm("pop %rax");
	

}

//----------------------------------------------------------
//	C++ helpers - Blank String
//----------------------------------------------------------
bool isWhitespace(string s)
{
    for(int i=0; i<s.length(); i++)
	{
        if(!std::isspace(s[i]))
            return false;
    }
    return true;
}

//----------------------------------------------------------
//	C++ helpers - String to languageONE Fixed Length
//----------------------------------------------------------
void l1_strcpy(string s,char *d, const long long _length)
{
    for(int i=0; i < _length; i++)
	{
		if (i < s.length())
			{ d[i] = s[i]; }
		else
			{ d[i] = ' ';  }
	}
}

//----------------------------------------------------------
//	C++ helpers - add commas
//----------------------------------------------------------
string l1_addcommas(char value[10])
{
	string spaces1,char1,result;
	spaces1=' ';char1="";result="";

//	---------------------
//	Remove leading zeroes
//	---------------------
	for (k=0; k<10; k++)
	{
		if (value[k]=='0') { value[k]=' '; }
		else { if (value[k]!='.') {break;}}
	}
		
//	---------------------
//	Add the commas
//	---------------------	
	char1=value[9];
	if (char1.compare(spaces1)!=0)
	{	for (j=9; j>-1; j--)
		{	char1=value[j];			
			if ( (j==3 || j==0) && (char1.compare(spaces1)!=0))
			{result=char1+","+result;}
			else
			{result=char1+result;}
		}
	}

	return(result);
	
}
