//==========================================================
//WINDOW 4 - CHART OF ACCOUNT
//==========================================================

//----------------------------------------------------------
//Window Addresse's
//----------------------------------------------------------
Fl_Double_Window*											win4_coa;

	Fl_Group*														win4_coa_key;
		Fl_Box*														win4_coa_key_decoration;
 			Fl_Value_Input*									win4_coa_key_acctno;
 			Fl_Button* 											win4_coa_key_spinner_up;
 			Fl_Button* 											win4_coa_key_spinner_down;
			Fl_Output*											win4_coa_key_acctdesc;
			Fl_Button*											win4_coa_key_exit;
	
	Fl_Group*														win4_coa_details;
		Fl_Box*														win4_coa_details_decoration;
			Fl_Input*												win4_coa_details_description;
			Fl_Choice*											win4_coa_details_flag1;
			Fl_Spinner*											win4_coa_details_flag2;
			Fl_Spinner*											win4_coa_details_flag3;
			Fl_Spinner*											win4_coa_details_flag4;	
			Fl_Choice*											win4_coa_details_balid;
			Fl_Value_Input*									win4_coa_details_cntlacctno;
			Fl_Button*											win4_coa_details_spinner_up;
			Fl_Button*											win4_coa_details_spinner_down;
			Fl_Button*											win4_coa_details_search;
			Fl_Output*											win4_coa_details_cntlacctdesc;
			Fl_Input*												win4_coa_details_depreciation;
			Fl_Input*												win4_coa_details_unitprice;
			Fl_Button*											win4_coa_details_cancel;
			Fl_Button*											win4_coa_details_delete;
			Fl_Button*											win4_coa_details_okay;

		Fl_Group*													win4_coa_list;
			Fl_Box*													win4_coa_head1;
			Fl_Box*													win4_coa_head2;
			Fl_Select_Browser*							win4_coa_browser;

	Fl_Box*															win4_coa_help;

//----------------------------------------------------------
//Callbacks
//----------------------------------------------------------
void selectWin4_coa_key										(Fl_Widget* w, void* data);
void fWIN4_DETAILS_DELETE_CALLBACK				(Fl_Widget* w, void* data);
void fWIN4_DETAILS_OKAY_CALLBACK					(Fl_Widget* w, void* data);
void fWin4_browser_callback								(Fl_Widget* w, void* data);

void selectWin4_coa_details();
void WIN4_COA_ACCOUNTS();
long long WIN4_GET_ACCT(bool _details);
void win4_init_accts();

//----------------------------------------------------------
//WINDOW Chart of Account
//----------------------------------------------------------
void window4(){

	x=0; y=0; 

	win4_coa = new Fl_Double_Window(60,120,625,580);

	//---------------------------------------------------
	//KEY
	//---------------------------------------------------
		win4_coa_key = new Fl_Group(x,y,625,70);

			win4_coa_key_decoration = new Fl_Box(x+25,y+15,575,40);
					win4_coa_key_decoration->box(FL_THIN_UP_BOX);

				x=125; y=25;

				win4_coa_key_acctno = new Fl_Value_Input(x,y,45,20,"Account No...");

				win4_coa_key_spinner_up = new Fl_Button(x+45,y,13,10,"@-38>");
						win4_coa_key_spinner_up->callback(fACCT_SPINNER_CALLBACK,(char*)"41");
				win4_coa_key_spinner_down = new Fl_Button(x+45,y+10,13,10,"@-38<");
						win4_coa_key_spinner_down->callback(fACCT_SPINNER_CALLBACK,(char*)"-41");

				win4_coa_key_acctdesc = new Fl_Output(x+60,y,300,20);
						win4_coa_key_acctdesc->deactivate();

				win4_coa_key_exit	= new Fl_Button(x+415,y,50,20,"Exit");
						win4_coa_key_exit->box(FL_THIN_UP_BOX);
						win4_coa_key_exit->callback(_windowExit_callback);

		win4_coa_key->end();

	//---------------------------------------------------
	//DETAILS
	//---------------------------------------------------

		x=0; y=55;

		win4_coa_details = new Fl_Group(x,y,575,180);

			win4_coa_details_decoration = new Fl_Box(x+25,y+15,575,175);
					win4_coa_details_decoration->box(FL_THIN_UP_BOX);

				win4_coa_details_description	= new Fl_Input(x+125,y+25,300,20,"Description..:");
				win4_coa_details_flag1 				= new Fl_Choice(x+125,y+50,45,20,"Flag1..:");
				win4_coa_details_flag2 				= new Fl_Spinner(x+220,y+50,35,20,"Flag2..:");
				win4_coa_details_flag2->range(1,4);		
				win4_coa_details_flag3 				= new Fl_Spinner(x+305,y+50,35,20,"Flag3..:");
						win4_coa_details_flag3->range(1,4);		
				win4_coa_details_flag4 				= new Fl_Spinner(x+390,y+50,35,20,"Flag4..:");	
						win4_coa_details_flag4->range(0,4);		
				win4_coa_details_balid 				= new Fl_Choice(x+125,y+75,45,20,"Debit/Credit..:");

				win4_coa_details_cntlacctno		= new Fl_Value_Input(x+125,y+100,45,20,"Cntrl Acct..:");
				win4_coa_details_spinner_up = new Fl_Button(x+170,y+100,13,10,"@-38>");
						win4_coa_details_spinner_up->callback(fACCT_SPINNER_CALLBACK,(char*)"42");
				win4_coa_details_spinner_down = new Fl_Button(x+170,y+110,13,10,"@-38<");
						win4_coa_details_spinner_down->callback(fACCT_SPINNER_CALLBACK,(char*)"-42");

				win4_coa_details_search = new Fl_Button(x+185,y+100,13,20,"?");
  					win4_coa_details_search->box(FL_THIN_UP_BOX);
  					win4_coa_details_search->color(FL_WHITE);
  					win4_coa_details_search->labelcolor(FL_BLUE);
  					win4_coa_details_search->callback(fACCT_SEARCH_CALLBACK,(char*)"42");
					
				win4_coa_details_cntlacctdesc = new Fl_Output(x+200,y+100,300,20);
						win4_coa_details_cntlacctdesc->deactivate();

				win4_coa_details_depreciation	= new Fl_Input(x+125,y+125,55,20,"Depreciation..:");
				win4_coa_details_unitprice		= new Fl_Input(x+125,y+150,100,20,"Unit Price..:");

				win4_coa_details_cancel	= new Fl_Button(x+415,y+150,50,20,"Cancel");
						win4_coa_details_cancel->box(FL_THIN_UP_BOX);
						win4_coa_details_cancel->callback(selectWin4_coa_key);
				win4_coa_details_delete	= new Fl_Button(x+475,y+150,50,20,"Delete");
						win4_coa_details_delete->box(FL_THIN_UP_BOX);
						win4_coa_details_delete->callback(fWIN4_DETAILS_DELETE_CALLBACK);
				win4_coa_details_okay		= new Fl_Button(x+535,y+150,50,20,"Okay");
						win4_coa_details_okay->box(FL_THIN_UP_BOX);
						win4_coa_details_okay->callback(fWIN4_DETAILS_OKAY_CALLBACK);

		win4_coa_details->end();

	//---------------------------------------------------
	//BROWSER
	//---------------------------------------------------

		x=0; y = 255; 

		win4_coa_list = new Fl_Group(x,y,625,325);

			win4_coa_head1 				= new Fl_Box(x+25,y,70,15,"Acct No");
					win4_coa_head1->box(FL_THIN_UP_BOX);
			win4_coa_head2 				= new Fl_Box(x+95,y,510,15,"Description");
					win4_coa_head2->box(FL_THIN_UP_BOX);
					win4_coa_head2->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));

			win4_coa_browser	= new Fl_Select_Browser(x+25,y+17,575,265);
					win4_coa_browser->type(FL_MULTI_BROWSER);
					win4_coa_browser->textcolor(FL_BLUE);
					win4_coa_browser->callback(fWin4_browser_callback);

		win4_coa_list->end();

	//---------------------------------------------------
	//HELP
	//---------------------------------------------------
		win4_coa_help					= new Fl_Box(x+25,y+290,575,25);
				win4_coa_help->box(FL_THIN_DOWN_BOX);
				win4_coa_help->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
				win4_coa_help->label("(F5) Accept; (F3) Print");

	win4_coa->end();

//------------
//Initial
//------------
	for (i=0; i<14;i++) {win4_coa_details_flag1->add(flag1[i].c_str());}
	for (i=0; i<2; i++) {win4_coa_details_balid->add(balID[i].c_str());}

	win4_coa->callback(_windowExit_callback);
	win4_coa->set_modal();

	selectWin4_coa_key(NULL,NULL);

}

//----------------------------------------------------------
//	window 4 - populate browser
//----------------------------------------------------------
void WIN4_COA_ACCOUNTS(){

	b01_AllAccts=true;

	x=2, y=0; 

	win4_coa_browser->clear();

	static int widths[] = { 65, 300 };
	win4_coa_browser->column_widths(widths);
	win4_coa_browser->column_char('\t');

	L1_CALL(c_B01,c_Start,0,0,b01_AllAccts);
	if (RETURN_CODE!=0){return;}

	i=0;
	while (1==1) 
	{
		i++;

		L1_CALL(c_B01,c_PreviousNext,1,0,b01_AllAccts);
		if (RETURN_CODE!=0) {break;}

		str1=to_string(B01_AcctNo).c_str();
		str2="";for (j=0; j<30; j++) {str2 = str2 + B01_Description[j];}

		y = remainder(i, x);
		if (y==0)	{str = "@B52@r " + str1 + "\t@B52 " + str2;}
		else		{str = "@r " + str1 + "\t " + str2;}
		win4_coa_browser->insert(i,str.c_str(),(long long*)B01_Record_NO);

	}

		x=(long long)win4_coa_browser->data(1);

		L1_CALL(c_B01,c_Start,1,0,b01_AllAccts);
		win4_coa_key_acctno->value(B01_AcctNo);
		win4_coa_key_acctdesc->value(B01_Description);

		win4_coa->redraw();

}

//----------------------------------------------------------
//	window 4 - browser selection 
//----------------------------------------------------------
void fWin4_browser_callback(Fl_Widget* w, void* data){

		x=win4_coa_browser->value();if (x==0){return;}

		b01_recNo=(long long)win4_coa_browser->data(x);

		WIN4_GET_ACCT(true);
		selectWin4_coa_details();

}

//----------------------------------------------------------
//	Window 4 - WIN4_GET_ACCT
//----------------------------------------------------------
long long WIN4_GET_ACCT(bool _details){

	//----------------------------------------
	// F5 PRESSED -> Valid Key ?
	//---------------------------------------- 
	if (b01_recNo == 0)
	{
		if (win4_coa_key_acctno->value()>59998)
		{
			fl_alert("Account No must be less than 59999");
			return(false);
		}
		if (win4_coa_key_acctno->value()<1)
		{
			fl_alert("Please enter an Account No");
			return(false);
		}

	// EXISTING OR NEW
		b01_recNo=l1_findAcct(win4_coa_key_acctno->value());
		if (b01_recNo==99999)
		{
			win4_init_accts();
			return(true);
		}
		else
		{
			win4_coa_key_acctno->value(B01_AcctNo);
			str="";for (i=0; i<30; i++) {str = str + B01_Description[i];}
			win4_coa_key_acctdesc->value(str.c_str());
		}
	}
	else
	//----------------------------------------
	// SELECTED FROM BROWSER
	//----------------------------------------
	{
		L1_CALL(c_B01,c_Read,b01_recNo,0,b01_AllAccts); 
		win4_coa_key_acctno->value(B01_AcctNo); 
	}

	b01_recNo=B01_Record_NO;

	//-------
	//Details
	//------- 
	if (!_details) {return(true);}

	str="";for (i=0; i<30; i++) {str = str + B01_Description[i];}
	win4_coa_details_description->value(str.c_str());

	str="";for (i=0; i<2; i++) {str = str + B01_Flag1[i];}
	for (i=0; i<13; i++) { if (str==flag1[i]) {break;}}
	win4_coa_details_flag1->value(i);

	win4_coa_details_flag2->value(B01_Flag2);
	win4_coa_details_flag3->value(B01_Flag3);
	win4_coa_details_flag4->value(B01_Flag4);

	str="";for (i=0; i<2; i++) {str = str + B01_BalanceIndicator[i];}
	for (i=0; i<2; i++) { if (str==balID[i]) {break;}}
	win4_coa_details_balid->value(i);

	win4_coa_details_cntlacctno->value(B01_CntlAcctNo);
	win4_coa_details_depreciation->value(to_string(B01_Depreciation).c_str());

	str="";for (i=0; i<9; i++) {str = str + w_B01_UnitPrice[i];}
	win4_coa_details_unitprice->value(str.c_str());

	win4_coa->redraw();
	return(true);

}

//----------------------------------------------------------
//	window 4 - fWIN4_DETAILS_DELETE_CALLBACK
//----------------------------------------------------------
void fWIN4_DETAILS_DELETE_CALLBACK(Fl_Widget *w, void *data){

		L1_CALL(c_B01,c_Read,b01_recNo,0,b01_AllAccts);
		L1_CALL(c_B01,c_Delete,b01_recNo,0,b01_AllAccts);

		if (RETURN_CODE==0)
		{
			WIN4_COA_ACCOUNTS();
			selectWin4_coa_key(NULL,NULL);
		}
		else
		{
			switch (RETURN_CODE)
			{
				case 41: fl_alert("Cannot delete a controlling account with children"); break;
			}
		}

}

//----------------------------------------------------------
//	window 4 - fWIN4_DETAILS_OKAY_CALLBACK 
//----------------------------------------------------------
void fWIN4_DETAILS_OKAY_CALLBACK(Fl_Widget* w, void* data){

	if (b01_recNo!=99999)	
		{L1_CALL(c_B01,c_Read,b01_recNo,0,b01_AllAccts);}

	//-------
	//Details
	//------- 

	//FLAG1
		i = win4_coa_details_flag1->value(); str1 = flag1[i];
		l1_strcpy(str1,B01_Flag1,2);

	//DESCRIPTION
		str2 = win4_coa_details_description->value();
		if ((str1.compare("X ")!=0) && (str1.compare("C ")!=0))
		{
			if (isWhitespace(str2))
			{
				fl_alert("Please enter a description"); return; 
			}
		}
		l1_strcpy(str2,B01_Description,30);


	//FLAG2,3,4
		B01_Flag2=win4_coa_details_flag2->value();
		B01_Flag3=win4_coa_details_flag3->value();
		B01_Flag4=win4_coa_details_flag4->value();

	//BALANCE INDICATOR
	i = win4_coa_details_balid->value(); str = balID[i];
		l1_strcpy(str,B01_BalanceIndicator,2);

	//CONTROL ACCOUNT
		B01_CntlAcctNo=win4_coa_details_cntlacctno->value();
		if (B01_CntlAcctNo==B01_AcctNo)
			 {fl_alert("Control account cannot refer to itself"); return; }

	//-----------------------------------------------------------------
	//This will not need validating because 'stoi' will return only the 
	//interger portion
	//-----------------------------------------------------------------
		str = win4_coa_details_depreciation->value();
		if (!isWhitespace(str))
			{ B01_Depreciation = stoi(str);}

	//UNITPRICE - can be zero
	//-----------------------------------------------------------------
	//Need to drop any more than (n) decimal places 
	//-----------------------------------------------------------------
		str = win4_coa_details_unitprice->value();
		for (i=0; i<9; i++){w_B01_UnitPrice[i]=' ';} 
		l1_strcpy(str,w_B01_UnitPrice,str.length());

	//----------------------------------------
	//Proceed ?
	//---------------------------------------- 
		L1_CALL(c_B01,c_Write,b01_recNo,0,b01_AllAccts);
		if (RETURN_CODE==0)
		{
			WIN4_COA_ACCOUNTS();
			selectWin4_coa_key(NULL,NULL);
		}
		else
		{
			switch (RETURN_CODE)
			{
				case 42: fl_alert("Sub Accounts still atached to this Control Account"); break;
				case 43: fl_alert("Invalid Control Account"); break;
			}
		}

}

//----------------------------------------------------------
//	window 4 select key
//----------------------------------------------------------
void selectWin4_coa_key(Fl_Widget* w, void* data){

	win4_coa_key->activate();
	win4_coa_details->deactivate();
	win4_coa_browser->activate();

}

//----------------------------------------------------------
//			+--window 4 select details
//----------------------------------------------------------
void selectWin4_coa_details(){

	win4_coa_key->deactivate();
	win4_coa_details->activate();
	win4_coa_browser->deactivate();

	if (b01_recNo==99999)
	{ win4_coa_details_delete->deactivate(); }
	else
	{ win4_coa_details_delete->activate(); }

	win4_coa_details_description->position(0);

}

//----------------------------------------------------------
//	window 4 - init accts
//----------------------------------------------------------
void win4_init_accts(){

//-----
//	KEY
//-----
	B01_AcctNo=win4_coa_key_acctno->value();

//---------
//	DETAILS
//---------
	win4_coa_details_description->value("");
	win4_coa_details_flag1->value(0);
	win4_coa_details_flag2->value(1);
	win4_coa_details_flag3->value(1);
	win4_coa_details_flag4->value(0);
	win4_coa_details_balid->value(0);	
	win4_coa_details_cntlacctno->value(0);
	win4_coa_details_cntlacctdesc->value("");
	win4_coa_details_depreciation->value(0);
	win4_coa_details_unitprice->value(0);

	win4_coa->redraw();

}

//==========================================================
//WINDOW 4 - PRINT
//==========================================================

//----------------------------------------------------------
//Window Addresse's
//----------------------------------------------------------
Fl_Double_Window* win4p_coa;
	Fl_Value_Input*									win4p_coa_StartAcctNo;
	Fl_Value_Input*									win4p_coa_EndAcctNo;
	Fl_Button*											win4p_coa_print;
	Fl_Button*											win4p_coa_exit;

//----------------------------------------------------------
//Callbacks
//----------------------------------------------------------
void WIN4_COA_PRINT_CALLBACK(Fl_Widget* w, void* data);

//----------------------------------------------------------
//WINDOW 4 Chart Of Account PRINT
//----------------------------------------------------------
void window4p(){

	x=80; y=140;

	win4p_coa = new Fl_Double_Window(x,y,300,80);

		x=135; y=15; 

			win4p_coa_StartAcctNo = new Fl_Value_Input(x,y,45,20,"Start Account No..:");
			win4p_coa_EndAcctNo 	= new Fl_Value_Input(x,y+25,45,20,"End Account No..:");	

			lButton(win4p_coa_print,x+100,y,"Print",WIN4_COA_PRINT_CALLBACK);
			lButton(win4p_coa_exit,x+100,y+25,"Exit",_windowExit_callback);

	lWindowEnd(win4p_coa,_windowExit_callback);

}

//----------------------------------------------------------
//			+--window 4 - PRINT
//----------------------------------------------------------
void WIN4_COA_PRINT_CALLBACK(Fl_Widget* w, void* data){

	n_StartAcctNo = win4p_coa_StartAcctNo->value();
	n_EndAcctNo = win4p_coa_EndAcctNo->value();

	if (n_StartAcctNo>n_EndAcctNo)
	{fl_alert("Starrt Acct cannot be larger than end account");}
	else
	{ L1_CALL(c_B01,c_Print,0,0,0);
		fromWindowNo=2; windowNo=4; win4p_coa->hide();
	}

}
