//==========================================================
//WINDOW 6 - ENQUIRY
//==========================================================

//----------------------------------------------------------
//Window Addresse's
//----------------------------------------------------------
Fl_Double_Window*											win6_enq;
	Fl_Group*														win6_enq_key;
		Fl_Box*														win6_enq_key_decoration;
			Fl_Value_Input*									win6_enq_key_acctno;
 			Fl_Button* 											win6_enq_key_spinner_up;
 			Fl_Button* 											win6_enq_key_spinner_down;
			Fl_Button*											win6_enq_key_search;
			Fl_Output*											win6_enq_key_acctdesc;
			Fl_Input*												win6_enq_key_start_dd;
 			Fl_Input*												win6_enq_key_start_mm;
 			Fl_Input*												win6_enq_key_start_ccyy;
			Fl_Input*												win6_enq_key_end_dd;
 			Fl_Input*												win6_enq_key_end_mm;
 			Fl_Input*												win6_enq_key_end_ccyy;
			Fl_Button*											win6_enq_key_exit;
	
	Fl_Group*														win6_enq_list;
		Fl_Box*														win6_enq_head1;
		Fl_Box*														win6_enq_head2;
		Fl_Box*														win6_enq_head3;
		Fl_Box*														win6_enq_head4;
		Fl_Box*														win6_enq_head5;
		Fl_Select_Browser*								win6_enq_browser;

	Fl_Box*															win6_enq_help;

//----------------------------------------------------------
//Callbacks
//----------------------------------------------------------
void fWin6_browser_callback(Fl_Widget* w, void* data);
long long WIN6_GET_KEY();
long long WIN6_ENQ_ACCOUNTS();

//----------------------------------------------------------
//WINDOW Account Enquiry
//----------------------------------------------------------
void window6(){

	x=0; y=0;

	win6_enq = new Fl_Double_Window(60,120,660,555);

	//---------------------------------------------------
	//KEY
	//---------------------------------------------------
		win6_enq_key = new Fl_Group(x,y,650,110);

			win6_enq_key_decoration = new Fl_Box(x+25,y+15,610,90);
					win6_enq_key_decoration->box(FL_THIN_UP_BOX);

				x=125; y=25;

				win6_enq_key_acctno = new Fl_Value_Input(x,y,45,20,"Account No...");

				win6_enq_key_spinner_up = new Fl_Button(x+45,y,13,10,"@-38>");
						win6_enq_key_spinner_up->callback(fACCT_SPINNER_CALLBACK,(char*)"61");
				win6_enq_key_spinner_down = new Fl_Button(x+45,y+10,13,10,"@-38<");
						win6_enq_key_spinner_down->callback(fACCT_SPINNER_CALLBACK,(char*)"-61");
				win6_enq_key_search = new Fl_Button(x+60,y,13,20,"?");
						win6_enq_key_search->box(FL_THIN_UP_BOX);
						win6_enq_key_search->color(FL_WHITE);
						win6_enq_key_search->labelcolor(FL_BLUE);
						win6_enq_key_search->callback(fACCT_SEARCH_CALLBACK,(char*)"61");
				win6_enq_key_acctdesc = new Fl_Output(x+75,y,300,20);
						win6_enq_key_acctdesc->deactivate();

				win6_enq_key_start_dd = new Fl_Input(x,y+25,25,20,"Start Date...");
 				win6_enq_key_start_mm = new Fl_Input(x+25,y+25,20,20);
 				win6_enq_key_start_ccyy = new Fl_Input(x+50,y+25,40,20);
 				
				win6_enq_key_end_dd = new Fl_Input(x,y+50,20,20,"End Date.....");
 				win6_enq_key_end_mm = new Fl_Input(x+25,y+50,20,20);
 				win6_enq_key_end_ccyy = new Fl_Input(x+50,y+50,40,20);
 				
				win6_enq_key_exit	= new Fl_Button(x+440,y+50,50,20,"Exit");
						win6_enq_key_exit->box(FL_THIN_UP_BOX);
						win6_enq_key_exit->callback(_windowExit_callback);

		win6_enq_key->end();


	//---------------------------------------------------
	//BROWSER
	//---------------------------------------------------
		x=0; y = 120;

		win6_enq_list = new Fl_Group(x,y,660,450);

			win6_enq_head1 				= new Fl_Box(x+25,y,85,15,"Date");
					win6_enq_head1->box(FL_THIN_UP_BOX);
			win6_enq_head2 				= new Fl_Box(x+110,y,250,15,"Description");
					win6_enq_head2->box(FL_THIN_UP_BOX);
					win6_enq_head2->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
			win6_enq_head3 				= new Fl_Box(x+360,y,80,15,"Debit");
					win6_enq_head3->box(FL_THIN_UP_BOX);
					win6_enq_head3->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
			win6_enq_head4 				= new Fl_Box(x+440,y,80,15,"Credit");
					win6_enq_head4->box(FL_THIN_UP_BOX);
					win6_enq_head4->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
			win6_enq_head5 				= new Fl_Box(x+520,y,115,15,"Balance");
					win6_enq_head5->box(FL_THIN_UP_BOX);
					win6_enq_head5->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
				
			win6_enq_browser	= new Fl_Select_Browser(x+25,y+17,610,375);
					win6_enq_browser->type(FL_MULTI_BROWSER);
					win6_enq_browser->textcolor(FL_BLUE);
					win6_enq_browser->callback(fWin6_browser_callback);

		win6_enq_list->end();

	//---------------------------------------------------
	//HELP
	//---------------------------------------------------
		win6_enq_help					= new Fl_Box(x+25,y+400,610,25);
			win6_enq_help->box(FL_THIN_DOWN_BOX);
			win6_enq_help->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
			win6_enq_help->label("(F5) Accept");

	win6_enq->end();

//------------
//Initial
//------------
	win6_enq->callback(_windowExit_callback);
	win6_enq->set_modal();

}

//----------------------------------------------------------
//	Window 6 - WIN6_GET_KEY
//----------------------------------------------------------
long long WIN6_GET_KEY(){

	enq_acctno=win6_enq_key_acctno->value();

//START DATE
	dd=win6_enq_key_start_dd->value(); if (dd.length()==1){dd='0'+dd;}
	mm=win6_enq_key_start_mm->value(); if (mm.length()==1){mm='0'+mm;}
	ccyy=win6_enq_key_start_ccyy->value();
	str=ccyy+'/'+mm+'/'+dd;
	l1_strcpy(str,w_StartDate,10);

	for (i=0; i<10; i++) {w_Date[i] = w_StartDate[i];}
	L1_CALL(c_B99,c_B99_ValidDate,0,0,0);
	if (RETURN_CODE!=0) 
	{
		fl_alert("Invalid Start Date");
		return(false);
	}

//END DATE
	dd=win6_enq_key_end_dd->value(); if (dd.length()==1){dd='0'+dd;}
	mm=win6_enq_key_end_mm->value(); if (mm.length()==1){mm='0'+mm;}
	ccyy=win6_enq_key_end_ccyy->value();
	str=ccyy+'/'+mm+'/'+dd;
	l1_strcpy(str,w_EndDate,10);

	for (i=0; i<10; i++) {w_Date[i] = w_EndDate[i];}
	L1_CALL(c_B99,c_B99_ValidDate,0,0,0);
	if (RETURN_CODE!=0) 
	{
		fl_alert("Invalid End Date");
		return(false);
	}

//DATES
	if (strcmp(w_EndDate,w_StartDate)<0)
	{
		fl_alert("End Date cannot be less than Start Date");
		return(false);
	}

	return(true);

}

//----------------------------------------------------------
//	window 6 - populate browser
//----------------------------------------------------------
long long WIN6_ENQ_ACCOUNTS(){

	string sDate, sDetails, sDebit, sCredit, sBalance;
	string spaces10="";for (j=0; j<30; j++) {spaces10 = spaces10 + ' ';}

	win6_enq_browser->clear();

	static int widths[] = { 80, 255, 80, 80, 15, 100 };
	win6_enq_browser->column_widths(widths);
	win6_enq_browser->column_char('\t');

	i=0;
	while (1==1) 
	{
		i++;

		L1_CALL(c_B03,c_Read,i,0,0);
		if (RETURN_CODE!=0) {break;}

	//DATE
		sDate="";for (j=0; j<10; j++) {sDate = sDate + B03_TranDate[j];}

	//DETAILS - Description		
		str1=to_string(B03_Company).c_str();
		if (str1.length()==1){str1='0'+str1;}
		str1=str1+" ";
			for (j=0; j<36; j++) {str1 = str1 + B03_Description[j];}

		str2=str1.substr(3,15); 
		if (str2.compare("Opening Balance")==0)
			{ sDetails="Opening Balance";}
		else {sDetails=str1;}

	//VALUE
		str1="";for (j=0; j<2; j++) {str1 = str1 + B01_BalanceIndicator[j];}

		str="";str=l1_addcommas(w_B03_Value);
		if (str=="       .00"){str=spaces10;}

		if (str1==balID[1])
		{	
			if (B03_DRAcctNo==B01_AcctNo)
			{	sDebit=str; sCredit=spaces10; } else	{	sCredit=str; sDebit=spaces10; }
		}
		else
		{
			if (B03_CRAcctNo==B01_AcctNo)
			{	sCredit=str; sDebit=spaces10; } else	{	sDebit=str; sCredit=spaces10; }
		}

	//RUNNING BALANCE	
		for (j=9; j>-1; j--) {w_RunningBalance[j]=' ';}

		str2=w_B03_RunningBalance[10];
		for (j=9; j>-1; j--) {w_RunningBalance[j]=w_B03_RunningBalance[j];}

		str3='-';str="";
		if (str2.compare(str3)==0)
			{	str=l1_addcommas(w_RunningBalance);
				sBalance='(' + str + ')'; }
		else
			{ str=l1_addcommas(w_RunningBalance);
				sBalance=' ' + str + ' '; }

		y = remainder(i, 2);
		if (y==0)	
		{	
			str = "@B52 " + sDate + "\t@B52 " + sDetails + "\t@B52@r " + sDebit + "\t@B52@r " + sCredit + "\t@B52 " + ' ' + "\t@B52@r " + sBalance;
		}
		else
		{
			str =  ' ' + sDate + "\t " + sDetails + "\t@r " + sDebit + "\t@r " + sCredit + "\t " + ' ' + "\t@r " + sBalance;
		}
		win6_enq_browser->insert(i,str.c_str(),(long long*)B03_TranRecNo);
		
	}

	win6_enq->redraw();
	return(i);

}

//----------------------------------------------------------
//			+--window 6 - browser selection 
//----------------------------------------------------------
void fWin6_browser_callback(Fl_Widget* w, void* data){

//	< 2 in this instance cuz we cant change the opening balance
		x=win6_enq_browser->value();if (x<2){return;}

		b02_recNo=(long long)win6_enq_browser->data(x);	

		WIN5_GET_TRANS(true);
		selectWin5_gj_details();

		win5_gj->resize(80,160,625,595); 
		win5_gj->redraw();

		fromWindowNo=6; windowNo=5; win5_gj->show();

}



//	---------------------------------------------------
//	PRINT WINDOW
//	---------------------------------------------------
void WIN6_ENQ_PRINT_CALLBACK(Fl_Widget* w, void* data);

Fl_Double_Window* win6p_enq;
	Fl_Value_Input*									win6p_enq_StartAcctNo;
	Fl_Value_Input*									win6p_enq_EndAcctNo;
	Fl_Input*												win6p_enq_start_dd;
	Fl_Input*												win6p_enq_start_mm;
	Fl_Input*												win6p_enq_start_ccyy;
	Fl_Input*												win6p_enq_end_dd;
	Fl_Input*												win6p_enq_end_mm;
	Fl_Input*												win6p_enq_end_ccyy;

	Fl_Choice*											win6p_enq_trans;
	Fl_Choice*											win6p_enq_zero;
	Fl_Choice*											win6p_enq_newpage;
	
	Fl_Button*											win6p_enq_print;
	Fl_Button*											win6p_enq_exit;		

void window6p()
{
	x=80; y=140; win6p_enq = new Fl_Double_Window(x,y,500,150); 
		
			x=125; y=15; 

			win6p_enq_StartAcctNo = new Fl_Value_Input(x,y,45,20,"Start Account No..:");
			win6p_enq_EndAcctNo = new Fl_Value_Input(x+175,y,45,20,"End Account No..:");
					
			win6p_enq_start_dd = new Fl_Input(x,y+25,20,20,"Start Date..:");
			win6p_enq_start_mm = new Fl_Input(x+25,y+25,20,20,"");
			win6p_enq_start_ccyy = new Fl_Input(x+50,y+25,40,20,"");		
			
			win6p_enq_end_dd = new Fl_Input(x+175,y+25,20,20,"End Date..:");
			win6p_enq_end_mm = new Fl_Input(x+200,y+25,20,20,"");
			win6p_enq_end_ccyy = new Fl_Input(x+225,y+25,40,20,"");			
			
			win6p_enq_trans		= new Fl_Choice(x+125,y+50,35,20,"Print Transactions..:");
			win6p_enq_zero		= new Fl_Choice(x+125,y+75,35,20,"Print Accounts with zero balance..:");
			win6p_enq_newpage		= new Fl_Choice(x+125,y+100,35,20,"New page for each account..:");

			lButton(win6p_enq_print,x+300,y,"Print",WIN6_ENQ_PRINT_CALLBACK);
			lButton(win6p_enq_exit,x+300,y+25,"Exit",_windowExit_callback);
	
		lWindowEnd(win6p_enq,_windowExit_callback);
		
		win6p_enq_trans->add("N"); win6p_enq_trans->add("Y");
		win6p_enq_zero->add("N"); win6p_enq_zero->add("Y");
		win6p_enq_newpage->add("N"); win6p_enq_newpage->add("Y");
			
}

//----------------------------------------------------------
//			+--window 6 - PRINT
//----------------------------------------------------------
void WIN6_ENQ_PRINT_CALLBACK(Fl_Widget* w, void* data){

	n_StartAcctNo = win6p_enq_StartAcctNo->value();
	n_EndAcctNo = win6p_enq_EndAcctNo->value();	

//START DATE
	dd=win6p_enq_start_dd->value(); if (dd.length()==1){dd='0'+dd;}
	mm=win6p_enq_start_mm->value(); if (mm.length()==1){mm='0'+mm;}
	ccyy=win6p_enq_start_ccyy->value();
	str=ccyy+'/'+mm+'/'+dd;
	l1_strcpy(str,w_StartDate,10);

//END DATE
	dd=win6p_enq_end_dd->value(); if (dd.length()==1){dd='0'+dd;}
	mm=win6p_enq_end_mm->value(); if (mm.length()==1){mm='0'+mm;}
	ccyy=win6p_enq_end_ccyy->value();
	str=ccyy+'/'+mm+'/'+dd;
	l1_strcpy(str,w_EndDate,10);

	i = win6p_enq_trans->value();
	if (i==0) {	w_PrintTrans[0]='N'; } else {	w_PrintTrans[0]='Y'; }

	i = win6p_enq_zero->value();
	if (i==0) {	w_PrintZero[0]='N'; } else {	w_PrintZero[0]='Y'; }

	i = win6p_enq_newpage->value();
	if (i==0) {	w_PrintNewPage[0]='N'; } else {	w_PrintNewPage[0]='Y'; }

	if (n_StartAcctNo>n_EndAcctNo)
	{ 
		fl_alert("Start Acct cannot be larger than end account");
	}
	else
	{
		if (strcmp(w_StartDate,w_EndDate) > 0)
		{ 
			fl_alert("Start date cannot be greater than end date");
		}
		else
		{ L1_CALL(c_B03,c_Print,0,0,0);
			fromWindowNo=2; windowNo=6; win6p_enq->hide();
		}
	}	

}
