//==========================================================
//WINDOW 5 - GENERAL JOURNAL
//==========================================================

//----------------------------------------------------------
//Window Addresse's
//----------------------------------------------------------
Fl_Double_Window*											win5_gj;

	Fl_Group*														win5_gj_key;
		Fl_Box*														win5_gj_key_decoration;
 			Fl_Input*												win5_gj_key_dd;
 			Fl_Input*												win5_gj_key_mm;
 			Fl_Input*												win5_gj_key_ccyy;
			Fl_Output*											win5_gj_key_time;
			Fl_Button*											win5_gj_key_exit;
	
	Fl_Group*														win5_gj_details;
		Fl_Box*														win5_gj_details_decoration;
			Fl_Tabs*												win5_gj_details_tabs;
				Fl_Group*											win5_gj_details_grp1;
 					Fl_Value_Input*							win5_gj_details_dracctno;
 					Fl_Button* 									win5_gj_details_drspinner_up;
 					Fl_Button* 									win5_gj_details_drspinner_down;
					Fl_Button*									win5_gj_details_drsearch;
					Fl_Output*									win5_gj_details_dracctdesc;
 					Fl_Value_Input*							win5_gj_details_cracctno;
 					Fl_Button* 									win5_gj_details_crspinner_up;
 					Fl_Button* 									win5_gj_details_crspinner_down;
					Fl_Button*									win5_gj_details_crsearch;
					Fl_Output*									win5_gj_details_cracctdesc;
					Fl_Input*										win5_gj_details_description;
					Fl_Input*										win5_gj_details_value;
					Fl_Value_Input*							win5_gj_details_noofunits;
					Fl_Input*										win5_gj_details_reference;

				Fl_Group*											win5_gj_details_grp2;
        	Fl_Value_Input*							win5_gj_details_invtrantype;
 					Fl_Value_Input*							win5_gj_details_invacctno;
 					Fl_Button* 									win5_gj_details_invspinner_up;
 					Fl_Button* 									win5_gj_details_invspinner_down;
					Fl_Button*									win5_gj_details_invsearch;
					Fl_Output*									win5_gj_details_invacctdesc;
        	Fl_Value_Input*							win5_gj_details_invparcelno;
        	Fl_Value_Input*							win5_gj_details_invgrouping;

				Fl_Group*											win5_gj_details_grp3;
        	Fl_Input*										win5_gj_details_frankedamt;
        	Fl_Input*										win5_gj_details_imputedcredit;
        	Fl_Input*										win5_gj_details_sunitprice;
        	Fl_Input*										win5_gj_details_sreference;

			Fl_Button*											win5_gj_details_cancel;
			Fl_Button*											win5_gj_details_delete;
			Fl_Button*											win5_gj_details_okay;

		Fl_Group*													win5_gj_list;
			Fl_Box*													win5_gj_head1;
			Fl_Box*													win5_gj_head2;
			Fl_Select_Browser*							win5_gj_browser;

	Fl_Box*															win5_gj_help;

///----------------------------------------------------------
//Callbacks
//----------------------------------------------------------
void selectWin5_gj_key									(Fl_Widget* w, void* data);

void fWIN5_DETAILS_DELETE_CALLBACK			(Fl_Widget* w, void* data);
void fWIN5_DETAILS_OKAY_CALLBACK				(Fl_Widget* w, void* data);
void fWin5_browser_callback							(Fl_Widget* w, void* data);
void fWIN5_SEARCH2_CALLBACK							(Fl_Widget* w, void* data);
void fWIN5_SEARCH3_CALLBACK							(Fl_Widget* w, void* data);
void fWIN5_SEARCH4_CALLBACK							(Fl_Widget* w, void* data);

void selectWin5_gj_details();
void WIN5_GJ_TRANS();
long long WIN5_GET_TRANS(bool _details);
void win5_init_trans();

//----------------------------------------------------------
//WINDOW General Journal
//----------------------------------------------------------
void window5(){

	x=0; y=0;

	win5_gj = new Fl_Double_Window(60,120,625,595);

	//---------------------------------------------------
	//KEY
	//---------------------------------------------------
		win5_gj_key = new Fl_Group(x,y,625,70);

			win5_gj_key_decoration = new Fl_Box(x+25,y+15,575,40);
					win5_gj_key_decoration->box(FL_THIN_UP_BOX);

			x=125; y=25;

				win5_gj_key_dd = new Fl_Input(x,y,20,20,"Date...");
 				win5_gj_key_mm = new Fl_Input(x+25,y,20,20);
 				win5_gj_key_ccyy = new Fl_Input(x+50,y,40,20);

				win5_gj_key_time = new Fl_Output(x+100,y,60,20);
						win5_gj_key_time->deactivate();
 
				win5_gj_key_exit	= new Fl_Button(x+415,y,50,20,"Exit");
						win5_gj_key_exit->box(FL_THIN_UP_BOX);
						win5_gj_key_exit->callback(_windowExit_callback);

		win5_gj_key->end();

	//---------------------------------------------------
	//DETAILS
	//---------------------------------------------------

		x=0; y=55; 

		win5_gj_details = new Fl_Group(x,y,575,250);

			win5_gj_details_decoration = new Fl_Box(x+25,y+15,575,235);
					win5_gj_details_decoration->box(FL_THIN_UP_BOX);

				win5_gj_details_tabs = new Fl_Tabs(x+35,y+30,550,205);

					win5_gj_details_grp1 = new Fl_Group(x+40,y+55,400,200,"Transaction");

						x=120;

 						win5_gj_details_dracctno = new Fl_Value_Input(x,y+75,45,20,"Debit Acct.:");
 						win5_gj_details_drspinner_up = new Fl_Button(x+45,y+75,13,10,"@-38>");
								win5_gj_details_drspinner_up->callback(fACCT_SPINNER_CALLBACK,(char*)"51");
						win5_gj_details_drspinner_down = new Fl_Button(x+45,y+85,13,10,"@-38<");
								win5_gj_details_drspinner_down->callback(fACCT_SPINNER_CALLBACK,(char*)"-51");												
						win5_gj_details_drsearch = new Fl_Button(x+60,y+75,13,20,"?");
 								win5_gj_details_drsearch->box(FL_THIN_UP_BOX);
 								win5_gj_details_drsearch->color(FL_WHITE);
 								win5_gj_details_drsearch->labelcolor(FL_BLUE);
 								win5_gj_details_drsearch->callback(fACCT_SEARCH_CALLBACK,(char*)"51");									
						win5_gj_details_dracctdesc = new Fl_Output(x+75,y+75,300,20);
								win5_gj_details_dracctdesc->deactivate();

	 					win5_gj_details_cracctno = new Fl_Value_Input(x,y+100,45,20,"Credit Acct.:"); 					
 						win5_gj_details_crspinner_up = new Fl_Button(x+45,y+100,13,10,"@-38>");
								win5_gj_details_crspinner_up->callback(fACCT_SPINNER_CALLBACK,(char*)"52");
						win5_gj_details_crspinner_down = new Fl_Button(x+45,y+110,13,10,"@-38<");
								win5_gj_details_crspinner_down->callback(fACCT_SPINNER_CALLBACK,(char*)"-52");						
						win5_gj_details_crsearch = new Fl_Button(x+60,y+100,13,20,"?");
								win5_gj_details_crsearch->box(FL_THIN_UP_BOX);
								win5_gj_details_crsearch->color(FL_WHITE);
								win5_gj_details_crsearch->labelcolor(FL_BLUE);
								win5_gj_details_crsearch->callback(fACCT_SEARCH_CALLBACK,(char*)"52");						
						win5_gj_details_cracctdesc = new Fl_Output(x+75,y+100,300,20);
								win5_gj_details_cracctdesc->deactivate();

						win5_gj_details_description = new Fl_Input(x,y+125,300,20,"Description.:");
						win5_gj_details_value = new Fl_Input(x,y+150,75,20,"Value.:");
						win5_gj_details_noofunits = new Fl_Value_Input(x,y+175,60,20,"No Of Units.:");
						win5_gj_details_reference = new Fl_Input(x,y+200,80,20,"Reference.:");

					win5_gj_details_grp1->end();

					win5_gj_details_grp2 = new Fl_Group(x,y+55,100,200,"Investment");

						win5_gj_details_invtrantype = new Fl_Value_Input(x,y+75,40,20,"Tran Type.:");
 						win5_gj_details_invacctno = new Fl_Value_Input(x,y+100,45,20,"Account No.:"); 					
 						win5_gj_details_invspinner_up = new Fl_Button(x+45,y+100,13,10,"@-38>");
								win5_gj_details_invspinner_up->callback(fACCT_SPINNER_CALLBACK,(char*)"53");
						win5_gj_details_invspinner_down = new Fl_Button(x+45,y+110,13,10,"@-38<");
								win5_gj_details_invspinner_down->callback(fACCT_SPINNER_CALLBACK,(char*)"-53");		

						win5_gj_details_invsearch = new Fl_Button(x+60,y+100,13,20,"?");
								win5_gj_details_invsearch->box(FL_THIN_UP_BOX);
								win5_gj_details_invsearch->color(FL_WHITE);
								win5_gj_details_invsearch->labelcolor(FL_BLUE);
								win5_gj_details_invsearch->callback(fACCT_SEARCH_CALLBACK,(char*)"53");

						win5_gj_details_invacctdesc = new Fl_Output(x+75,y+100,300,20);
								win5_gj_details_invacctdesc->deactivate();

						win5_gj_details_invparcelno = new Fl_Value_Input(x,y+125,40,20,"Parcel No.:");
						win5_gj_details_invgrouping = new Fl_Value_Input(x,y+150,40,20,"Group.:");

					win5_gj_details_grp2->end();

					win5_gj_details_grp3 = new Fl_Group(x,y+55,100,200,"Dividend");

						win5_gj_details_frankedamt = new Fl_Input(x+20,y+75,60,20,"Franked Amt.:");
						win5_gj_details_imputedcredit = new Fl_Input(x+20,y+100,60,20,"Imputed Credit.:");
						win5_gj_details_sunitprice = new Fl_Input(x+20,y+125,60,20,"Unit Price.:");
						win5_gj_details_sreference = new Fl_Input(x+20,y+150,80,20,"Reference.:");

				win5_gj_details_grp3->end();

			win5_gj_details_tabs->end();

			x=0;

			win5_gj_details_cancel	= new Fl_Button(x+400,y+200,50,20,"Cancel");
					win5_gj_details_cancel->box(FL_THIN_UP_BOX);
					win5_gj_details_cancel->callback(selectWin5_gj_key);
			win5_gj_details_delete	= new Fl_Button(x+460,y+200,50,20,"Delete");
					win5_gj_details_delete->box(FL_THIN_UP_BOX);
					win5_gj_details_delete->callback(fWIN5_DETAILS_DELETE_CALLBACK);
			win5_gj_details_okay		= new Fl_Button(x+520,y+200,50,20,"Okay");
					win5_gj_details_okay->box(FL_THIN_UP_BOX);
					win5_gj_details_okay->callback(fWIN5_DETAILS_OKAY_CALLBACK);

		win5_gj_details->end();

	//---------------------------------------------------
	//BROWSER
	//---------------------------------------------------

		x=0; y = 310; 

		win5_gj_list = new Fl_Group(x,y,625,250);

			win5_gj_head1 				= new Fl_Box(x+25,y,100,15,"Date");
					win5_gj_head1->box(FL_THIN_UP_BOX);
			win5_gj_head2 				= new Fl_Box(x+115,y,490,15,"Description");
					win5_gj_head2->box(FL_THIN_UP_BOX);
					win5_gj_head2->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));

			win5_gj_browser	= new Fl_Select_Browser(x+25,y+17,575,225);
					win5_gj_browser->type(FL_MULTI_BROWSER);
					win5_gj_browser->textcolor(FL_BLUE);
					win5_gj_browser->callback(fWin5_browser_callback);

		win5_gj_list->end();

	//---------------------------------------------------
	//HELP
	//---------------------------------------------------

		win5_gj_help					= new Fl_Box(x+25,y+250,575,25);
				win5_gj_help->box(FL_THIN_DOWN_BOX);
				win5_gj_help->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
				win5_gj_help->label("(F5) Accept; (F3) Print");

	win5_gj->end();

//------------
//Initial
//------------
	win5_gj->callback(_windowExit_callback);
	win5_gj->set_modal();

	selectWin5_gj_key(NULL,NULL);

}

//----------------------------------------------------------
//	window 5 - populate browser
//----------------------------------------------------------
void WIN5_GJ_TRANS(){

	b01_AllAccts=false;

	x=2, y=0; 

	win5_gj_browser->clear();

	static int widths[] = { 85, 300 };
	win5_gj_browser->column_widths(widths);
	win5_gj_browser->column_char('\t');

	L1_CALL(c_B02,c_Start,0,0,0);
	if (RETURN_CODE!=0){return;}

	i=0;
	while (1==1) 
	{
		i++;

		L1_CALL(c_B02,c_PreviousNext,1,0,0);
		if (RETURN_CODE!=0) {break;}

		str1="";for (j=0; j<10; j++) {str1 = str1 + B02_TranDate[j];}
		str2="";for (j=0; j<30; j++) {str2 = str2 + B02_Description[j];}

		y = remainder(i, x);
		if (y==0)	{str = "@B52@r " + str1 + "\t@B52 " + str2;}
		else		{str = "@r " + str1 + "\t " + str2;}
		win5_gj_browser->insert(i,str.c_str(),(long long*)B02_Record_NO);
	}

	L1_CALL(c_B02,c_Start,1,0,0);

	win5_gj_key_ccyy->value(str1.substr(0,4).c_str());
	win5_gj_key_mm->value(str1.substr(5,2).c_str());
	win5_gj_key_dd->value(str1.substr(8,2).c_str());

	str3="";for (j=0; j<8; j++) {str3 = str3 + B02_TranTime[j];}
	win5_gj_key_time->value(str3.c_str());

	win5_gj->redraw();

}

//----------------------------------------------------------
//	window 5 - browser selection 
//----------------------------------------------------------
void fWin5_browser_callback(Fl_Widget* w, void* data){

	x=win5_gj_browser->value();if (x==0){return;}	

	b02_recNo=(long long)win5_gj_browser->data(x);

	WIN5_GET_TRANS(true);
	selectWin5_gj_details();

}

//----------------------------------------------------------
//	Window 5 - WIN5_GET_TRANS
//----------------------------------------------------------
long long WIN5_GET_TRANS(bool _details){

	time_t rawtime;
	struct tm * timeinfo;

	//------------------------------------------
	// F5 PRESSED -> Valid Key ?
	//	Always a new record for the transactions
	//------------------------------------------ 
	if (b02_recNo == 0)	{

	//DATE
		dd=win5_gj_key_dd->value(); if (dd.length()==1){dd='0'+dd;}
		mm=win5_gj_key_mm->value(); if (mm.length()==1){mm='0'+mm;}
		ccyy=win5_gj_key_ccyy->value();
		str=ccyy+'/'+mm+'/'+dd;
		l1_strcpy(str,B02_TranDate,10);

		for (i=0; i<10; i++) {w_Date[i] = B02_TranDate[i];}
		L1_CALL(c_B99,c_B99_ValidDate,0,0,0);
		if (RETURN_CODE!=0) 
		{
			fl_alert("Invalid Date");
			return(false);
		}
		else
		{
	//TIME
			time (&rawtime);
			timeinfo = localtime (&rawtime);
			str=asctime(timeinfo);
			x=str.find(':'); x=x-2; str = str.substr(x, 8);
			l1_strcpy(str,B02_TranTime,8);

			b02_recNo=99999; 
			win5_init_trans();
			return(true); 
		}
	}
	else
	//----------------------------------------
	// SELECTED FROM BROWSER
	//---------------------------------------- 
	{
		L1_CALL(c_B02,c_Read,b02_recNo,0,0); 

		str="";for (j=0; j<10; j++) {str = str + B02_TranDate[j];}
			win5_gj_key_ccyy->value(str.substr(0,4).c_str());
			win5_gj_key_mm->value(str.substr(5,2).c_str());
			win5_gj_key_dd->value(str.substr(8,2).c_str());

			str="";for (j=0; j<8; j++) {str = str + B02_TranTime[j];}
				win5_gj_key_time->value(str.c_str());

	}

	b02_recNo=B02_Record_NO;

	if (!_details) {return(true);}

	//-------
	//Details
	//------- 
		win5_gj_details_dracctno->value(B02_DRAcctNo);
			x=l1_findAcct(B02_DRAcctNo);
			str="";for (i=0; i<30; i++) {str = str + B01_Description[i];}
			win5_gj_details_dracctdesc->value(str.c_str());
						
		win5_gj_details_cracctno->value(B02_CRAcctNo);
			x=l1_findAcct(B02_CRAcctNo);
			str="";for (i=0; i<30; i++) {str = str + B01_Description[i];}
			win5_gj_details_cracctdesc->value(str.c_str());

		str="";for (i=0; i<30; i++) {str = str + B02_Description[i];}
		win5_gj_details_description->value(str.c_str());

		str="";for (i=0; i<10; i++) {str = str + w_B02_Value[i];}
		win5_gj_details_value->value(str.c_str());
		
		win5_gj_details_noofunits->value(B02_NoOfUnits);

		str="";for (i=0; i<10; i++) {str = str + B02_Reference[i];}
		win5_gj_details_reference->value(str.c_str());

		win5_gj_details_invtrantype->value(B02_INVTranType);
		win5_gj_details_invacctno->value(B02_INVAcctNo);
			str="";for (i=0; i<30; i++) {str = str + B01_Description[i];}
			win5_gj_details_invacctdesc->value(str.c_str());
				
		win5_gj_details_invparcelno->value(B02_INVParcelNo);
		win5_gj_details_invgrouping->value(B02_INVGrouping);

		str="";for (i=0; i<7; i++) {str = str + w_B02_FrankedAmt[i];}	
		win5_gj_details_frankedamt->value(str.c_str());

		str="";for (i=0; i<7; i++) {str = str + w_B02_ImputedCredit[i];}
		win5_gj_details_imputedcredit->value(str.c_str());

		str="";for (i=0; i<9; i++) {str = str + w_B02_SUnitPrice[i];}
		win5_gj_details_sunitprice->value(str.c_str());

		str="";for (i=0; i<10; i++) {str = str + B02_SReference[i];}
		win5_gj_details_sreference->value(str.c_str());
		

	win5_gj->redraw();
	return(true);

}

//----------------------------------------------------------
//	window 5 - fWIN5_DETAILS_DELETE_CALLBACK
//----------------------------------------------------------
void fWIN5_DETAILS_DELETE_CALLBACK(Fl_Widget *w, void *data){

	L1_CALL(c_B02,c_Delete,b02_recNo,0,0);

	if (RETURN_CODE==0)
	{
		WIN5_GJ_TRANS();
		selectWin5_gj_key(NULL,NULL);
	}
	else
	{
		switch (RETURN_CODE)
			{
				case 0000: break;  // There no reason you cant delete a transaction
			}
		}
}

//----------------------------------------------------------
//	window 5 - fWIN5_DETAILS_OKAY_CALLBACK 
//----------------------------------------------------------
void fWIN5_DETAILS_OKAY_CALLBACK(Fl_Widget* w, void* data){	

	if (b02_recNo!=99999)
		{L1_CALL(c_B02,c_Read,b02_recNo,0,0);}

	//-------
	//Details
	//------- 

	//DEBIT ACCOUNT
		B02_DRAcctNo = win5_gj_details_dracctno->value();
		if (B02_DRAcctNo==0)
			{
				fl_alert("Please enter a Debit Account No");
				return;
			}

	//CREDIT ACCOUNT
		B02_CRAcctNo = win5_gj_details_cracctno->value();
		if (B02_CRAcctNo==0)
			{
				fl_alert("Please enter a Credit Account No");
				return;
			}

	//DESCRIPTION
		str = win5_gj_details_description->value();
		if (isWhitespace(str))
			 {fl_alert("Please enter a description"); return; }
		l1_strcpy(str,B02_Description,30);

	//VALUE
	//-----------------------------------------------------------------
	//Need to drop any more than (n) decimal places 
	//-----------------------------------------------------------------
		str = win5_gj_details_value->value();
		for (i=0; i<10; i++){w_B02_Value[i]=' ';}
		l1_strcpy(str,w_B02_Value,str.length());

	//NOOFUNITS
		B02_NoOfUnits = win5_gj_details_noofunits->value();

	//REFERENCE
		str = win5_gj_details_reference->value();
		l1_strcpy(str,B02_Reference,10);

	//INVTRANTYPE
		B02_INVTranType = win5_gj_details_invtrantype->value();

	//INVACCTNO
		B02_INVAcctNo = win5_gj_details_invacctno->value();

	//INVPARCELNO
		B02_INVParcelNo = win5_gj_details_invparcelno->value();

	//INVGROUPING
		B02_INVGrouping = win5_gj_details_invgrouping->value();

	//FRANKEDAMOUNT
	//-----------------------------------------------------------------
	//Need to drop any more than (n) decimal places 
	//-----------------------------------------------------------------
		str = win5_gj_details_frankedamt->value();
		for (i=0; i<7; i++){w_B02_FrankedAmt[i]=' ';}
		l1_strcpy(str,w_B02_FrankedAmt,str.length());
		
	//IMPUTEDCREDIT
	//-----------------------------------------------------------------
	//Need to drop any more than (n) decimal places 
	//-----------------------------------------------------------------
		str = win5_gj_details_imputedcredit->value();
		for (i=0; i<7; i++){w_B02_ImputedCredit[i]=' ';}
		l1_strcpy(str,w_B02_ImputedCredit,str.length());

	//SUNITPRICE
	//-----------------------------------------------------------------
	//Need to drop any more than (n) decimal places 
	//-----------------------------------------------------------------
		str = win5_gj_details_sunitprice->value();
		for (i=0; i<9; i++){w_B02_SUnitPrice[i]=' ';}
		l1_strcpy(str,w_B02_SUnitPrice,str.length());

	//SREFERENCE
		str = win5_gj_details_sreference->value();
		l1_strcpy(str,B02_SReference,10);

	//----------------------------------------
	//Proceed ?
	//---------------------------------------- 
		L1_CALL(c_B02,c_Write,b02_recNo,0,0);
		if (RETURN_CODE==0)
		{
			WIN5_GJ_TRANS();
			selectWin5_gj_key(NULL,NULL);
		}
		else
		{
			switch (RETURN_CODE)
			{
				case 52: fl_alert("Invalid Debit Account"); break;
				case 53: fl_alert("Invalid Credit Account"); break;
				case 54: fl_alert("Invalid Investment Account"); break;
				case 55: fl_alert("Value cannot be zero"); break;
			}
		}

}

//----------------------------------------------------------
//	window 5 select key
//----------------------------------------------------------
void selectWin5_gj_key(Fl_Widget* w, void* data){

	win5_gj_key->activate();
	win5_gj_details->deactivate();
	win5_gj_browser->activate();

}

//----------------------------------------------------------
//	window 5 select details
//----------------------------------------------------------
void selectWin5_gj_details(){

	win5_gj_key->deactivate();
	win5_gj_details->activate();
	win5_gj_details_grp1->activate();
		win5_gj_details_tabs->value(win5_gj_details_grp1);
	win5_gj_details_grp2->activate();
	win5_gj_details_grp3->activate();

	win5_gj_browser->deactivate();

	if (b02_recNo==99999)
	{ win5_gj_details_delete->deactivate(); }
	else
	{ win5_gj_details_delete->activate(); }

}

//----------------------------------------------------------
//	window 5 - init trans
//----------------------------------------------------------
void win5_init_trans(){

//-----
//	KEY
//-----
//	Key is not setup here cuz F5 is always a new record
//	it is done in win5_get_trans cuz the date is validated
//	there

//---------
//	DETAILS
//---------
	win5_gj_details_dracctno->value(0);
	win5_gj_details_dracctdesc->value("");
	win5_gj_details_cracctno->value(0);
	win5_gj_details_cracctdesc->value("");
	win5_gj_details_description->value("");
	win5_gj_details_value->value(0);
	win5_gj_details_noofunits->value(0);
	win5_gj_details_reference->value("");
	win5_gj_details_invtrantype->value(0);
	win5_gj_details_invacctno->value(0);
	win5_gj_details_invacctdesc->value("");
	win5_gj_details_invparcelno->value(0);
	win5_gj_details_invgrouping->value(0);
	win5_gj_details_frankedamt->value("");
	win5_gj_details_imputedcredit->value("");
	win5_gj_details_sunitprice->value("");
	win5_gj_details_reference->value("");

	win5_gj->redraw();

}

//==========================================================
//WINDOW 5 - PRINT
//==========================================================

//----------------------------------------------------------
//Window Addresse's
//----------------------------------------------------------
Fl_Double_Window* win5p_gj;
	Fl_Input*												win5p_gj_start_dd;
	Fl_Input*												win5p_gj_start_mm;
	Fl_Input*												win5p_gj_start_ccyy;
	Fl_Input*												win5p_gj_end_dd;
	Fl_Input*												win5p_gj_end_mm;
	Fl_Input*												win5p_gj_end_ccyy;
	Fl_Input*												win5p_gj_reference;
	Fl_Choice*											win5p_gj_details;
	Fl_Button*											win5p_gj_print;
	Fl_Button*											win5p_gj_exit;		

//----------------------------------------------------------
//Callbacks
//----------------------------------------------------------
void WIN5_GJ_PRINT_CALLBACK(Fl_Widget* w, void* data);

//----------------------------------------------------------
//WINDOW 5 General Journal PRINT
//----------------------------------------------------------
void window5p(){

	x=80; y=140; 

	win5p_gj = new Fl_Double_Window(x,y,350,140);

		x=100; y=15; 

		win5p_gj_start_dd = new Fl_Input(x,y,20,20,"Start Date..:");
		win5p_gj_start_mm = new Fl_Input(x+25,y,20,20,"");
		win5p_gj_start_ccyy = new Fl_Input(x+50,y,40,20,"");

		win5p_gj_end_dd = new Fl_Input(x,y+25,20,20,"End Date..:");
		win5p_gj_end_mm = new Fl_Input(x+25,y+25,20,20,"");
		win5p_gj_end_ccyy = new Fl_Input(x+50,y+25,40,20,"");

		win5p_gj_reference = new Fl_Input(x,y+50,80,20,"Reference..");

		win5p_gj_details		= new Fl_Choice(x,y+75,35,20,"Print Details..:");

		lButton(win5p_gj_print,x+150,y,"Print",WIN5_GJ_PRINT_CALLBACK);
		lButton(win5p_gj_exit,x+150,y+25,"Exit",_windowExit_callback);

	lWindowEnd(win5p_gj,_windowExit_callback);

//------------
//Initial
//------------
	win5p_gj_details->add("Y");
	win5p_gj_details->add("N");

}

//----------------------------------------------------------
//	window 5 - PRINT
//----------------------------------------------------------
void WIN5_GJ_PRINT_CALLBACK(Fl_Widget* w, void* data){

	//START DATE
	dd=win5p_gj_start_dd->value(); if (dd.length()==1){dd='0'+dd;}
	mm=win5p_gj_start_mm->value(); if (mm.length()==1){mm='0'+mm;}
	ccyy=win5p_gj_start_ccyy->value();
	str=ccyy+'/'+mm+'/'+dd;
	l1_strcpy(str,w_StartDate,10);

	//END DATE
	dd=win5p_gj_end_dd->value(); if (dd.length()==1){dd='0'+dd;}
	mm=win5p_gj_end_mm->value(); if (mm.length()==1){mm='0'+mm;}
	ccyy=win5p_gj_end_ccyy->value();
	str=ccyy+'/'+mm+'/'+dd;
	l1_strcpy(str,w_EndDate,10);		

	str = win5p_gj_reference->value();
	l1_strcpy(str,w_Reference,10);

	i = win5p_gj_details->value();
	if (i==0)
	{	w_PrintDetails[0]='Y'; }
	else
	{	w_PrintDetails[0]='N'; }

	if (strcmp(w_StartDate,w_EndDate) > 0)
	{fl_alert("Invalid selection criteria");}
	else
	{ L1_CALL(c_B02,c_Print,0,0,0);
		fromWindowNo=2; windowNo=5; win5p_gj->hide();
	}

}
