//----------------------------------------------------------
//	MACROS to assist in screen definition
//----------------------------------------------------------
	#define lWindowEnd(name,cb)											\
		name->end();																	\
		name->callback(cb);														\
		name->set_modal();
		
	#define lButton(name,x,y,literal,cb)						\
		name = new Fl_Button(x,y,50,20,literal);			\
		name->box(FL_THIN_UP_BOX);										\
		name->callback(cb);

//----------------------------------------------------------
//	languageONE routines/Constants
//----------------------------------------------------------
	extern "C" int L1_PROCESS();
	extern "C" long long l1_findAcct(long long acct);
	extern "C" long long l1_findCompany(long long i);

//----------------------------------------------------------
//	languageONE data structures
//----------------------------------------------------------
//	Not sure if I will need these so here at the moment just
//	in case

#pragma pack(1)
	struct l1_Number 
	{
		long Scale;
		char Indicator;
		long Length;
		long Number;
		char Picture[26];
	}; 

#pragma pack(1)
	struct l1_Word 
	{
		long Filler1;
		char Indicator;
		long Length;
		char Alpha[128];
	}; 

//----------------------------------------------------------
//	Parameters and Parameter Address to pass to languageONE
//----------------------------------------------------------
//	long long* l1_Params[3] = {};
//	long long* l1_Params_Addr;

//----------------------------------------------------------
//	Call languageONE
//----------------------------------------------------------
void L1_CALL (long long _table,long long _request, long long _recNo, long long _acctno, long long _accts) 
{
//	l1_Params[0] = (long long*)_table;							// Table
//	l1_Params[1] = (long long*)_request;							// Request
//	l1_Params[2] = (long long*)_recNo;							// Record No

//	auto l1_Params_Addr = std::addressof(l1_Params);		// Get Array address (it keeps moving)
//	----------------------------------------
//	asm ("mov %rax,l1_Params_Addr");						// Array address into RAX
//	----------------------------------------
//	As luck would have it std::addressof(l1_Params)
//	returns the address in the RAX register and so we
//	can do without it
//
//	Apparantly Inline assembler is not supported in VC++
//	so for conformity it is commented out here
//	It is nice to keep it for documentations sake
//	---------------------------------------
	x_TableNo	= _table;
	x_Request	= _request;
	x_RecNo		= _recNo;
	x_AcctNo	= _acctno;
	x_Accts		= _accts;
	
	L1_PROCESS();											// Make the 
	
}

//----------------------------------------------------------
//	C++ helpers - Blank String
//----------------------------------------------------------
bool isWhitespace(string s)
{
    for(int i=0; i<s.length(); i++)
	{
        if(!std::isspace(s[i]))
            return false;
    }
    return true;
}

//----------------------------------------------------------
//	C++ helpers - String to languageONE Fixed Length
//----------------------------------------------------------
void l1_strcpy(string s,char *d, const long long _length)
{
    for(int i=0; i < _length; i++)
	{
		if (i < s.length())
			{ d[i] = s[i]; }
		else
			{ d[i] = ' ';  }
	}
}

//----------------------------------------------------------
//	C++ helpers - add commas
//----------------------------------------------------------
string l1_addcommas(char value[10])
{
	string spaces1,char1,result;
	spaces1=' ';char1="";result="";

//	---------------------
//	Remove leading zeroes
//	---------------------
	for (k=0; k<10; k++)
	{
		if (value[k]=='0') { value[k]=' '; }
		else { if (value[k]!='.') {break;}}
	}
		
//	---------------------
//	Add the commas
//	---------------------	
	char1=value[9];
	if (char1.compare(spaces1)!=0)
	{	for (j=9; j>-1; j--)
		{	char1=value[j];			
			if ( (j==3 || j==0) && (char1.compare(spaces1)!=0))
			{result=char1+","+result;}
			else
			{result=char1+result;}
		}
	}

	return(result);
	
}
