//==========================================================
//WINDOW 3 - SYSTEM PARAMETERS
//==========================================================

//----------------------------------------------------------
//Window Addresse's
//----------------------------------------------------------
Fl_Double_Window*									win3_sys;
	Fl_Group*												win3_sys_key;
		Fl_Box*												win3_sys_key_decoration;
			Fl_Value_Input*							win3_sys_key_parameterno;
			Fl_Value_Input*							win3_sys_key_parameter;
			Fl_Button*									win3_sys_key_exit;

	Fl_Group*												win3_sys_details;
		Fl_Box*												win3_sys_details_decoration;
			Fl_Input*										win3_sys_details_description;
			Fl_Tabs*										win3_sys_details_tabs;
				Fl_Group*									win3_sys_details_grp1;
					Fl_Input*								win3_sys_details_menuname;
				Fl_Group*									win3_sys_details_grp2;
					Fl_Input*								win3_sys_details_lastreference;
					Fl_Value_Input*					win3_sys_details_gstacct;
					Fl_Value_Input*					win3_sys_details_startyear;
					Fl_Input*								win3_sys_details_unitprice;
				Fl_Group*									win3_sys_details_grp3;
					Fl_Value_Input*					win3_sys_details_company01;
					Fl_Value_Input*					win3_sys_details_company02;
					Fl_Value_Input*					win3_sys_details_company03;
					Fl_Value_Input*					win3_sys_details_company04;
					Fl_Value_Input*					win3_sys_details_company05;
					Fl_Value_Input*					win3_sys_details_company06;
					Fl_Value_Input*					win3_sys_details_company07;
					Fl_Value_Input*					win3_sys_details_company08;
					Fl_Value_Input*					win3_sys_details_company09;
					Fl_Value_Input*					win3_sys_details_company10;
					Fl_Value_Input*					win3_sys_details_company11;
					Fl_Value_Input*					win3_sys_details_company12;
			Fl_Button*									win3_sys_details_delete;
			Fl_Button*									win3_sys_details_cancel;
			Fl_Button*									win3_sys_details_okay;

	Fl_Group*												win3_sys_list;
		Fl_Box*												win3_sys_head1;
		Fl_Box*												win3_sys_head2;
		Fl_Box*												win3_sys_head3;
		Fl_Select_Browser*						win3_sys_browser;

	Fl_Box*													win3_sys_help;

//----------------------------------------------------------
//Callbacks
//----------------------------------------------------------
void selectWin3_sys_key								(Fl_Widget* w, void* data);
void fWIN3_DETAILS_DELETE_CALLBACK		(Fl_Widget* w, void* data);
void fWIN3_DETAILS_OKAY_CALLBACK			(Fl_Widget* w, void* data);
void fWin3_browser_callback						(Fl_Widget* w, void* data);

void selectWin3_sys_details();
void WIN3_SYS_TRANSACTIONS();
long long WIN3_GET_SYS(bool _details);
void win3_init_parms();

//----------------------------------------------------------
//WINDOW - System Parameters
//----------------------------------------------------------
void window3(){

	win3_sys = new Fl_Double_Window(40,80,625,580);

		x=0; y=0; 

	//---------------------------------------------------
	//KEY
	//---------------------------------------------------
		win3_sys_key = new Fl_Group(x,y,625,90);

			x=25; y=10; 

			win3_sys_key_decoration = new Fl_Box(x,y,575,70);
					win3_sys_key_decoration->box(FL_THIN_UP_BOX);

 				win3_sys_key_parameterno = new Fl_Value_Input(x+105,y+10,25,20,"Parameter No...:");
 				win3_sys_key_parameter = new Fl_Value_Input(x+105,y+35,25,20,"Parameter ...:");

				win3_sys_key_exit	= new Fl_Button(x+510,y+40,50,20,"Exit");
						win3_sys_key_exit->box(FL_THIN_UP_BOX);
						win3_sys_key_exit->callback(_windowExit_callback);

		win3_sys_key->end();

	//---------------------------------------------------
	//DETAILS
	//---------------------------------------------------
		y=90; 

		win3_sys_details = new Fl_Group(x,y,625,190);

			x=25; 

			win3_sys_details_decoration = new Fl_Box(x,y,575,190);
					win3_sys_details_decoration->box(FL_UP_BOX);

				win3_sys_details_description = new Fl_Input(x+105,y+10,300,20,"Description..:");

				win3_sys_details_tabs = new Fl_Tabs(x+10,y+40,555,140);

					win3_sys_details_grp1 = new Fl_Group(x+25,y+65,525,175,"Menu");
							win3_sys_details_menuname = new Fl_Input(x+100,y+85,80,20,"Menu Name..:");
					win3_sys_details_grp1->end();

					win3_sys_details_grp2 = new Fl_Group(x+25,y+65,525,175,"General Ledger");
							win3_sys_details_lastreference	= new Fl_Input(x+120,y+75,80,20,"Last Reference..:");
							win3_sys_details_gstacct				= new Fl_Value_Input(x+120,y+100,50,20,"GST Account..:");
							win3_sys_details_startyear			= new Fl_Value_Input(x+120,y+125,40,20,"Start Year..:");
							win3_sys_details_unitprice			= new Fl_Input(x+120,y+150,80,20,"Unit Price..:");
					win3_sys_details_grp2->end();

					win3_sys_details_grp3 = new Fl_Group(x+25,y+65,525,175,"Companies");
							win3_sys_details_company01			= new Fl_Value_Input(x+100,y+85,20,20,"Companies..:");
							win3_sys_details_company02			= new Fl_Value_Input(x+125,y+85,20,20);
							win3_sys_details_company03			= new Fl_Value_Input(x+150,y+85,20,20);
							win3_sys_details_company04			= new Fl_Value_Input(x+175,y+85,20,20);
							win3_sys_details_company05			= new Fl_Value_Input(x+200,y+85,20,20);
							win3_sys_details_company06			= new Fl_Value_Input(x+225,y+85,20,20);
							win3_sys_details_company07			= new Fl_Value_Input(x+250,y+85,20,20);
							win3_sys_details_company08			= new Fl_Value_Input(x+275,y+85,20,20);
							win3_sys_details_company09			= new Fl_Value_Input(x+300,y+85,20,20);
							win3_sys_details_company10			= new Fl_Value_Input(x+325,y+85,20,20);
							win3_sys_details_company11			= new Fl_Value_Input(x+350,y+85,20,20);
							win3_sys_details_company12			= new Fl_Value_Input(x+375,y+85,20,20);
						win3_sys_details_grp3->end();

				win3_sys_details_tabs->end();

				win3_sys_details_cancel	= new Fl_Button(x+390,y+150,50,20,"Cancel");
						win3_sys_details_cancel->box(FL_THIN_UP_BOX);
				win3_sys_details_cancel->callback(selectWin3_sys_key);
				win3_sys_details_delete	= new Fl_Button(x+445,y+150,50,20,"Delete");
						win3_sys_details_delete->box(FL_THIN_UP_BOX);
						win3_sys_details_delete->callback(fWIN3_DETAILS_DELETE_CALLBACK);
				win3_sys_details_okay		= new Fl_Button(x+500,y+150,50,20,"Okay");
						win3_sys_details_okay->box(FL_THIN_UP_BOX);
						win3_sys_details_okay->callback(fWIN3_DETAILS_OKAY_CALLBACK);

		win3_sys_details->end();

	//---------------------------------------------------
	//BROWSER
	//---------------------------------------------------
		y = 280;

		win3_sys_list = new Fl_Group(x,y,625,300);

			win3_sys_head1 = new Fl_Box(x,y+10,85,15,"Parameter No");
					win3_sys_head1->box(FL_THIN_UP_BOX);
			win3_sys_head2 = new Fl_Box(x+85,y+10,70,15,"Parameter");
					win3_sys_head2->box(FL_THIN_UP_BOX);
			win3_sys_head3 = new Fl_Box(x+155,y+10,425,15,"Description");
					win3_sys_head3->box(FL_THIN_UP_BOX);
					win3_sys_head3->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));

			win3_sys_browser = new Fl_Select_Browser(x,y+25,575,230);
					win3_sys_browser->type(FL_MULTI_BROWSER);
					win3_sys_browser->textcolor(FL_BLUE);
					win3_sys_browser->callback(fWin3_browser_callback);

		win3_sys_list->end();

	//---------------------------------------------------
	//HELP
	//---------------------------------------------------
		win3_sys_help = new Fl_Box(x,y+265,575,25);
				win3_sys_help->box(FL_THIN_DOWN_BOX);
				win3_sys_help->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
				win3_sys_help->label("(F5) Accept; (F3) Print");

	win3_sys->end();

//------------
//Initial
//------------
	win3_sys->callback(_windowExit_callback);
	win3_sys->set_modal();
	selectWin3_sys_key(NULL,NULL);

}

//----------------------------------------------------------
//			+--window 3 - populate browser
//----------------------------------------------------------
void WIN3_SYS_TRANSACTIONS(){

	x=2, y=0; 

	win3_sys_browser->clear();

	static int widths[] = { 85, 65, 200 };
	win3_sys_browser->column_widths(widths);
	win3_sys_browser->column_char('\t');

	A01_Record_NO = 0;
	i=0;
	while (1==1) 
	{
		i++;

		A01_Record_NO +=1; L1_CALL(c_A01,c_Read,A01_Record_NO,0,0);
		if (RETURN_CODE!=0) {break;}

		str1=to_string(A01_ParameterNo).c_str();
		str2=to_string(A01_Parameter).c_str();
		str3="";for (j=0; j<30; j++) {str3 = str3 + A01_Description[j];}

		y = remainder(i, x);
		if (y==0)	{str = "@B52@r " + str1 + "\t@B52@r" + str2 + "\t@B52 " + str3;}
		else		{str = "@r " + str1 + "\t@r" + str2 + "\t " + str3;}
		win3_sys_browser->insert(i,str.c_str(),(long long*)A01_Record_NO);

	}

	L1_CALL(c_A01,c_Read,1,0,0);
//	win3_sys_key_parameterno->value(A01_ParameterNo);
//	win3_sys_key_parameter->value(A01_Parameter);
	win3_sys_key_parameterno->value(2);
	win3_sys_key_parameter->value(1);

	win3_sys->redraw();

}

//----------------------------------------------------------
//	window 3 - browser selection
//----------------------------------------------------------
void fWin3_browser_callback(Fl_Widget* w, void* data){

	x=win3_sys_browser->value();if (x==0){return;}

	a01_recNo=(long long)win3_sys_browser->data(x);

	if (WIN3_GET_SYS(true)) 
	{
		selectWin3_sys_details();
	}

}

//----------------------------------------------------------
//	window 3 - WIN3_GET_SYS
//----------------------------------------------------------
long long WIN3_GET_SYS(bool _details){

	//----------------------------------------
	// F5 PRESSED -> Valid Key ?
	//---------------------------------------- 
	if (a01_recNo == 0)
	{
		if (win3_sys_key_parameterno->value()<1 || win3_sys_key_parameterno->value()>3)
		{
			fl_alert("ParameterNo must be 1,2 or 3");
			return(false);
		}
		if (win3_sys_key_parameter->value()<1 || win3_sys_key_parameter->value()>99)
		{
			fl_alert("Parameter must be between 1 and 99");
			return(false);
		}
	// EXISTING OR NEW
		for (a01_recNo=1;a01_recNo<100;a01_recNo++)
			{ 
				L1_CALL(c_A01,c_Read,a01_recNo,0,0);
				if (RETURN_CODE!=0)
		//	NEW
				{	
					a01_recNo=99999; 
					win3_init_parms();
					return(true); 
				}
				else
		//	EXISTING
				{
					if (A01_ParameterNo==win3_sys_key_parameterno->value()
					&&  A01_Parameter==win3_sys_key_parameter->value())
					{			
						a01_recNo=A01_Record_NO;
						break;
					}
				}
			}
	}
	else
	{
	//----------------------------------------
	// SELECTED FROM BROWSER OR EXISTING (F5)
	//---------------------------------------- 
		L1_CALL(c_A01,c_Read,a01_recNo,0,0);
		win3_sys_key_parameterno->value(A01_ParameterNo);
		win3_sys_key_parameter->value(A01_Parameter);
	}

	if (!_details) {return(true);}

	//-------
	//Details
	//------- 
	str="";for (i=0; i<30; i++) {str = str + A01_Description[i];}
	win3_sys_details_description->value(str.c_str());
	
	str="";for (i=0; i<8; i++) {str = str + A01_MenuName[i];}
	win3_sys_details_menuname->value(str.c_str());

	str="";for (i=0; i<10; i++) {str = str + A01_LastReference[i];}
	win3_sys_details_lastreference->value(str.c_str());

	win3_sys_details_gstacct->value(A01_GSTAccount);
	win3_sys_details_startyear->value(A01_StartYear);

	str="";for (i=0; i<9; i++) {str = str + w_A01_UnitPrice[i];}
	win3_sys_details_unitprice->value(str.c_str());

	win3_sys_details_company01->value(A01_Company01);
	win3_sys_details_company02->value(A01_Company02);
	win3_sys_details_company03->value(A01_Company03);
	win3_sys_details_company04->value(A01_Company04);
	win3_sys_details_company05->value(A01_Company05);
	win3_sys_details_company06->value(A01_Company06);
	win3_sys_details_company07->value(A01_Company07);
	win3_sys_details_company08->value(A01_Company08);
	win3_sys_details_company09->value(A01_Company09);
	win3_sys_details_company10->value(A01_Company10);
	win3_sys_details_company11->value(A01_Company11);
	win3_sys_details_company12->value(A01_Company12);

	win3_sys->redraw();
	return(true);

}

//----------------------------------------------------------
//	window 3 - fWIN3_DETAILS_DELETE_CALLBACK
//----------------------------------------------------------
void fWIN3_DETAILS_DELETE_CALLBACK(Fl_Widget* w, void* data){

		L1_CALL(c_A01,c_Delete,a01_recNo,0,0);

		if (RETURN_CODE==0)
		{
			WIN3_SYS_TRANSACTIONS();
			selectWin3_sys_key(NULL,NULL);
		}
		else
		{
			switch (RETURN_CODE)
			{
				case 31:fl_alert("Company belong longs to consolidated group \n cannot be deleted"); break;
			}
		}

}

//----------------------------------------------------------
//	window 3 - fWIN3_DETAILS_OKAY_CALLBACK 
//----------------------------------------------------------
void fWIN3_DETAILS_OKAY_CALLBACK(Fl_Widget* w, void* data){

	//----------------------------------------
	//Valid Data ?
	//---------------------------------------- 

	//DESCRIPTION
		str = win3_sys_details_description->value();
		if (isWhitespace(str))
			 {fl_alert("Please enter a description"); return; }
		l1_strcpy(str,A01_Description,30);

	//MENUNAME
		str = win3_sys_details_menuname->value();
		if (A01_ParameterNo==1 && isWhitespace(str))
			 {fl_alert("Please enter a Menu Name"); return; }
		l1_strcpy(str,A01_MenuName,8);

	//LAST REFERENCE
		str = win3_sys_details_lastreference->value();	
		if (A01_ParameterNo==2 && isWhitespace(str))
			 {fl_alert("Please enter a Last Reference"); return; }
		l1_strcpy(str,A01_LastReference,12);

	//GSTACCOUNT - can be zero
	//******* NOTE Roger -> should be validated if not zero
		A01_GSTAccount = win3_sys_details_gstacct->value();

	//START YEAR
		if (A01_ParameterNo==2 && win3_sys_details_startyear->value()==0)
			 {fl_alert("Please enter a Start Year"); return; }
		A01_StartYear = win3_sys_details_startyear->value();

	//UNITPRICE - can be zero
		str = win3_sys_details_unitprice->value();
		for (i=0; i<9; i++){w_A01_UnitPrice[i]=' ';} 
		l1_strcpy(str,w_A01_UnitPrice,str.length());

	//COMPANIES - Validated by languageONE
		A01_Company01=win3_sys_details_company01->value();
		A01_Company02=win3_sys_details_company02->value();
		A01_Company03=win3_sys_details_company03->value();
		A01_Company04=win3_sys_details_company04->value();
		A01_Company05=win3_sys_details_company05->value();
		A01_Company06=win3_sys_details_company06->value();
		A01_Company07=win3_sys_details_company07->value();
		A01_Company08=win3_sys_details_company08->value();
		A01_Company09=win3_sys_details_company09->value();
		A01_Company10=win3_sys_details_company10->value();
		A01_Company11=win3_sys_details_company11->value();
		A01_Company12=win3_sys_details_company12->value();

	//----------------------------------------
	//Proceed ?
	//---------------------------------------- 
		L1_CALL(c_A01,c_Write,a01_recNo,0,0);
		if (RETURN_CODE==0)
		{
			WIN3_SYS_TRANSACTIONS();
			selectWin3_sys_key(NULL,NULL);
		}
		else
		{
			switch (RETURN_CODE)
			{
				case 32:fl_alert("Invalid GST Account"); break;
				case 33:fl_alert("Invalid Company in Consolidated Group"); break;
			}
		}

}

//----------------------------------------------------------
//	window 3 select key
//----------------------------------------------------------
void selectWin3_sys_key(Fl_Widget* w, void* data){

	win3_sys_key->activate();
	win3_sys_details->deactivate();
	win3_sys_browser->activate();

}

//----------------------------------------------------------
//	window 3 select details
//----------------------------------------------------------
void selectWin3_sys_details()
{
		win3_sys_key->deactivate();
		win3_sys_details->activate();
		win3_sys_browser->deactivate();

		switch (A01_ParameterNo)
		{
			case 1: 
				win3_sys_details_grp1->activate();
				win3_sys_details_grp2->deactivate();
				win3_sys_details_grp3->deactivate();
				win3_sys_details_tabs->value(win3_sys_details_grp1);
				break;
			case 2: 
				win3_sys_details_grp1->deactivate();
				win3_sys_details_grp2->activate();
				win3_sys_details_grp3->deactivate();
				win3_sys_details_tabs->value(win3_sys_details_grp2);
				break;
			case 3: 
				win3_sys_details_grp1->deactivate();
				win3_sys_details_grp2->deactivate();
				win3_sys_details_grp3->activate();
				win3_sys_details_tabs->value(win3_sys_details_grp3);
				break;
		}

		if (a01_recNo==99999)
		{ win3_sys_details_delete->deactivate(); }
		else
		{ win3_sys_details_delete->activate(); }

		win3_sys_details_description->position(0);

}

//----------------------------------------------------------
//	-window 3 - init parms
//----------------------------------------------------------
void win3_init_parms(){

//-----
//	KEY
//-----
	A01_ParameterNo=win3_sys_key_parameterno->value();
	A01_Parameter=win3_sys_key_parameter->value();

//---------
//	DETAILS
//---------
	win3_sys_details_description->value("");
	win3_sys_details_menuname->value("");
	win3_sys_details_lastreference->value("");
	win3_sys_details_gstacct->value(0);
	win3_sys_details_startyear->value(0);
	win3_sys_details_unitprice->value(0);
	win3_sys_details_company01->value(0);
	win3_sys_details_company02->value(0);
	win3_sys_details_company03->value(0);
	win3_sys_details_company04->value(0);
	win3_sys_details_company05->value(0);
	win3_sys_details_company06->value(0);
	win3_sys_details_company07->value(0);
	win3_sys_details_company08->value(0);
	win3_sys_details_company09->value(0);
	win3_sys_details_company10->value(0);
	win3_sys_details_company11->value(0);
	win3_sys_details_company12->value(0);
	win3_sys->redraw();

}

//==========================================================
//WINDOW 3 - PRINT
//==========================================================

//----------------------------------------------------------
//Window Addresse's
//----------------------------------------------------------
Fl_Double_Window*									win3p_sys;
	Fl_Value_Input*									win3p_sys_StartParameterNo;
	Fl_Value_Input*									win3p_sys_EndParameterNo;
	Fl_Value_Input*									win3p_sys_StartParameter;
	Fl_Value_Input*									win3p_sys_EndParameter;
	Fl_Button*											win3p_sys_print;
	Fl_Button*											win3p_sys_exit;

//----------------------------------------------------------
//Callbacks
//----------------------------------------------------------
void WIN3_SYS_PRINT_CALLBACK(Fl_Widget* w, void* data);

//----------------------------------------------------------
//WINDOW 3 System Parameters PRINT
//----------------------------------------------------------
void window3p(){

	x=60; y=100;

		win3p_sys = new Fl_Double_Window(x,y,400,80);

		x=135; y=15; 

			win3p_sys_StartParameterNo 	= new Fl_Value_Input(x,y,20,20,"Start Parameter No..:");
			win3p_sys_EndParameterNo 		= new Fl_Value_Input(x+155,y,20,20,"End Parameter No..:");
			win3p_sys_StartParameter 		= new Fl_Value_Input(x,y+25,20,20,"Start Parameter..:");
			win3p_sys_EndParameter 			= new Fl_Value_Input(x+155,y+25,20,20,"End Parameter..:");

			lButton(win3p_sys_print,x+200,y,"Print",WIN3_SYS_PRINT_CALLBACK);
			lButton(win3p_sys_exit,x+200,y+25,"Exit",_windowExit_callback);

	lWindowEnd(win3p_sys,_windowExit_callback);

}

//----------------------------------------------------------
//	window 3 - PRINT
//----------------------------------------------------------
void WIN3_SYS_PRINT_CALLBACK(Fl_Widget* w, void* data){

	n_StartParmNo = win3p_sys_StartParameterNo->value();
	n_EndParmNo = win3p_sys_EndParameterNo->value();

	n_StartParm = win3p_sys_StartParameter->value();
	n_EndParm = win3p_sys_EndParameter->value();

	if (n_StartParmNo>n_EndParmNo || n_StartParm>n_EndParm)
	{fl_alert("Invalid selection criteria");}
	else
	{ L1_CALL(c_A01,c_Print,0,0,0);
		fromWindowNo=1; windowNo=3; win3p_sys->hide();
	}

}
