%assign debug 0
%include 'include/BEGIN.PROGRAM'
;
;	Refer to VERSION.HISTORY for...well...version history
 
;	BEGIN.SYNONYMS **************************************
;		include/LPACK1.SYN                                                                                                                                                                                                                                    
;	END.SYNONYMS ****************************************
 
;=======================================================================
;		PROGRAM DATA
;=======================================================================
 
;-----------------------------------------------------------------------
;		DICTIONARY
;-----------------------------------------------------------------------
%include 'include/BEGIN.DICTIONARY'
 
;(BEGIN):Temporary Words by languageONE
;(END..):Temporary Words by languageONE
 
	@INSERTWORD w_finYear,								04,' '
	@INSERTWORD w_prtLine,								80,' '
	@INSERTWORD w_Underlines,						80,' '
	@INSERTWORD w_Command,								80,' '
	@INSERTWORD x_NewPage,								01,0x0C
 
%include 'include/END.DICTIONARY'
 
;-----------------------------------------------------------------------
;		MATRIX
;-----------------------------------------------------------------------
%include 'include/BEGIN.MATRIX'
 
;(BEGIN):Temporary Integers by languageONE
	@insertnumber i0001,0                                        
;(END..):Temporary Integers by languageONE
 
;(BEGIN):Temporary FixedPoint numbers by languageONE
;(END..):Temporary FixedPoint numbers by languageONE
 
;	--------------------------------
;	Fields used calling this program
;	--------------------------------
	@INSERTNUMBER x_TableNo,							00
	@INSERTNUMBER x_Request,							00
	@INSERTNUMBER x_RecNo,								00
	@INSERTNUMBER x_AcctNo,							00,'99999'
	@INSERTNUMBER x_Accts,								00
;	---------------------------------
 
	@INSERTNUMBER n_CompanyNo,						00,'99'
 
	@INSERTNUMBER I,											00,'9999999'
	@INSERTNUMBER J,											00,'9999999'
	@INSERTNUMBER K,											00,'9999999'
 
	@INSERTNUMBER n_finYear,							00,'9999'
 
	@INSERTNUMBER A01_StartRecNo,				00
	@INSERTNUMBER B01_StartRecNo,				00
	@INSERTNUMBER B02_StartRecNo,				00
 
	@INSERTNUMBER n_CpyIdx,							00
	@INSERTNUMBER n_StartRecNo,					00
 
	global w_A01_UnitPrice
	@INSERTWORD	w_A01_UnitPrice,				09,' '
	global w_B01_UnitPrice
	@INSERTWORD	w_B01_UnitPrice,				09,' '
	global w_B02_Value
	@INSERTWORD	w_B02_Value,						10,' '
	global w_B02_FrankedAmt
	@INSERTWORD	w_B02_FrankedAmt,				07,' '
	global w_B02_ImputedCredit
	@INSERTWORD	w_B02_ImputedCredit,		07,' '
	global w_B02_SUnitPrice
	@INSERTWORD	w_B02_SUnitPrice,				09,' '
 
	@INSERTWORD	w_B03_Value,						10,' '
	@INSERTWORD	w_B03_RunningBalance,		11,' '
 
	@INSERTNUMBER n_AcctNo,							00
	@INSERTNUMBER n_CntlAcctNo,					00
	global w_Date
	@INSERTWORD	 w_Date,					10,' '
 
	@INSERTWORD	 w_StartDate,						10,' '
	@INSERTWORD	 w_EndDate,							10,' '
	@INSERTNUMBER n_RunningBalance,			0000,'######9.99'
	@INSERTNUMBER b_Start,								c_TRUE
 
	@INSERTNUMBER n_LineCtr,							00,'9999'
	@INSERTNUMBER n_PageNo,							00,'9999'
 
;	--------------
;	Printing - A01
;	--------------
	global n_StartParmNo
	@INSERTNUMBER n_StartParmNo,	00,'99'
	global n_StartParm
	@INSERTNUMBER n_StartParm,		00,'99'
	global n_EndParmNo
	@INSERTNUMBER n_EndParmNo,		00,'99'
	global n_EndParm
	@INSERTNUMBER n_EndParm,			00,'99'
 
;	--------------
;	Printing - B01
;	--------------
	global n_StartAcctNo
	@INSERTNUMBER n_StartAcctNo,	00,'99999'
	global n_EndAcctNo
	@INSERTNUMBER n_EndAcctNo,		00,'99999'
 
;	--------------
;	Printing - B02
;	--------------
	@INSERTWORD w_Reference,							10,' '
	@INSERTWORD w_PrintDetails,					01,'Y'
 
;	--------------
;	Printing - B03
;	--------------
	@INSERTWORD w_PrintTrans,						01,'Y'
	@INSERTWORD w_PrintZero,							01,'Y'
	@INSERTWORD w_PrintNewPage,					01,'Y'
	@INSERTNUMBER n_TotalDebits,					0000,'######9.99'
	@INSERTNUMBER n_TotalCredits,				0000,'######9.99'
 
;	--------------
;	Printing - B04
;	--------------
	@INSERTWORD	w_Sub,									01,' '
	@INSERTWORD	w_Closing,							10,' '
 
	@INSERTNUMBER n_ReportNo,						00
	@INSERTWORD	 w_ReportName,					30,' '
	@INSERTNUMBER n_Idx,									00
 
	@INSERTNUMBER n_PAAcctNo,						00,'99999'
	@INSERTNUMBER n_PLAcctNo,						00,'99999'
	@INSERTNUMBER n_ASAcctNo,						00,'99999'
	@INSERTNUMBER n_TOAcctNo,						00,'99999'
	@INSERTNUMBER n_TCAcctNo,						00,'99999'
 
	@INSERTNUMBER n_PreviousAcctNo,			00,'99999'
	@INSERTWORD	 w_saveFlag1,						02,' '
	@INSERTWORD	 w_PreviousDescription,	64,' '
	@INSERTNUMBER n_PreviousCtrlAcctNo,	00,'99999'
	@INSERTWORD	 w_PreviousFlag1,				02,' '
	@INSERTNUMBER n_PreviousFlag2,				00,'9'
	@INSERTNUMBER n_PreviousFlag3,				00,'9'
	@INSERTNUMBER n_PreviousFlag4,				00,'9'
	@INSERTWORD	 w_PreviousIndicator,		02,' '
 
	@INSERTNUMBER n_AcctBalance,					0000,'9999999.99'
	@INSERTNUMBER n_AcctBalanceRounded,	00,'######9'
	@INSERTNUMBER n_CtrlAcctBalance,			0000,'9999999.99'
	@INSERTNUMBER n_NoOfUnits,						00,'99999'
 
	@INSERTNUMBER n_Value,								00,'######9'
	@INSERTNUMBER n_ValueLocation,				00,'99'
 
	@INSERTARRAY  n_Totals,4
 
%include 'include/END.MATRIX'
 
;-----------------------------------------------------------------------
;		@files
;-----------------------------------------------------------------------
%include 'include/BEGIN.FILES'
 
;	----------
;	Parameters
;	----------
	@INSERTFILE c_CSV,A01_FILE,{'./A01_9999.CSV',0h}
	@INSERTFILE c_CSV,A01_BACKUP,{'./A01_9999.CSV.backup',0h}
 
	%define c_A01_RecordLength 94
	%define c_A01_MaxRecords 99
 
	global A01_Record_NO
	@BEGIN_Record c_A01_RecordLength,A01_Record
		global A01_ParameterNo
		@INSERTNUMBER	{A101,A01_ParameterNo},		00,'99'
		global A01_Parameter
		@INSERTNUMBER	{A102,A01_Parameter},			00,'99'
		global A01_Description
		@INSERTWORD		{A103,A01_Description},		30,' '
		global A01_MenuName
		@INSERTWORD		{A104,A01_MenuName},			08,' '
		global A01_LastReference
		@INSERTWORD		{A105,A01_LastReference},	10,' '
		global A01_GSTAccount
		@INSERTNUMBER	{A106,A01_GSTAccount},		00,'99999'
		global A01_StartYear
		@INSERTNUMBER	{A107,A01_StartYear},			00,'9999'
		global A01_UnitPrice
		@INSERTNUMBER	{A108,A01_UnitPrice},			000000,'9999.9999'
		global A01_Company01
		@INSERTNUMBER	{A109,A01_Company01},			00,'99'
		global A01_Company02
		@INSERTNUMBER	{A110,A01_Company02},			00,'99'
		global A01_Company03
		@INSERTNUMBER	{A111,A01_Company03},			00,'99'
		global A01_Company04
		@INSERTNUMBER	{A112,A01_Company04},			00,'99'
		global A01_Company05
		@INSERTNUMBER	{A113,A01_Company05},			00,'99'
		global A01_Company06
		@INSERTNUMBER	{A114,A01_Company06},			00,'99'
		global A01_Company07
		@INSERTNUMBER	{A115,A01_Company07},			00,'99'
		global A01_Company08
		@INSERTNUMBER	{A116,A01_Company08},			00,'99'
		global A01_Company09
		@INSERTNUMBER	{A117,A01_Company09},			00,'99'
		global A01_Company10
		@INSERTNUMBER	{A118,A01_Company10},			00,'99'
		global A01_Company11
		@INSERTNUMBER	{A119,A01_Company11},			00,'99'
		global A01_Company12
		@INSERTNUMBER	{A120,A01_Company12},			00,'99'
	@END_Record A01_Record
 
;	----------
;	Accounts
;	----------
 
	@INSERTFILE c_CSV,B01_FILE,{'./B01_9999.CSV',0h}
	@INSERTFILE c_CSV,B01_BACKUP,{'./B01_9999.CSV.backup',0h}
 
	%define c_B01_RecordLength 61
	%define c_B01_MaxRecords 1024
 
	global B01_Record_NO
	@BEGIN_record c_B01_RecordLength,B01_Record
		global B01_Company
		@INSERTNUMBER	{B101,B01_Company},						00,'99'
		global B01_AcctNo
		@INSERTNUMBER	{B102,B01_AcctNo},						00,'99999'
		global B01_Description
		@INSERTWORD		{B103,B01_Description},  			30,' '
		global B01_Flag1
		@INSERTWORD 		{B104,B01_Flag1},							02,' '
		global B01_Flag2
		@INSERTNUMBER	{B105,B01_Flag2},							01,'9'
		global B01_Flag3
		@INSERTNUMBER	{B106,B01_Flag3},							01,'9'
		global B01_Flag4
		@INSERTNUMBER	{B107,B01_Flag4},							01,'9'
		global B01_BalanceIndicator
		@INSERTWORD		{B108,B01_BalanceIndicator},	02,' '
		global B01_CntlAcctNo
		@INSERTNUMBER	{B109,B01_CntlAcctNo},				00,'99999'
		global B01_Depreciation
		@INSERTNUMBER	{B110,B01_Depreciation},			00,'999'
		global B01_UnitPrice
		@INSERTNUMBER	{B111,B01_UnitPrice},					000000,'9999.9999'
	@END_Record B01_Record
 
	%define c_B01_AltIdx_RecordLength 12
 
	@BEGIN_record c_B01_AltIdx_RecordLength,B01_AltIdx_Record
		@INSERTNUMBER	 B01_AltIdx_AcctNo,				00,'99999'
		@INSERTNUMBER	 B01_AltIdx_Company,			00,'99'
		@INSERTNUMBER	 B01_AltIdx_RecNo,				00,'99999'
	@END_Record B01_AltIdx_Record
 
;	------------
;	Transactions
;	------------
 
	@INSERTFILE c_CSV,B02_FILE,{'./B02_9999.CSV',0h}
	@INSERTFILE c_CSV,B02_BACKUP,{'./B02_9999.CSV.backup',0h}
 
	%define c_B02_RecordLength 152
	%define c_B02_MaxRecords 4096
 
	global B02_Record_NO
	@BEGIN_record c_B02_RecordLength,B02_Record
		global B02_Company
		@INSERTNUMBER	{B201,B02_Company},				00,'99'
		global B02_TranDate
		@INSERTWORD		{B202,B02_TranDate},			10,' '
		global B02_TranTime
		@INSERTWORD		{B203,B02_TranTime},			08,' '
		global B02_DRAcctNo
		@INSERTNUMBER	{B204,B02_DRAcctNo},			00,'99999'
		global B02_CRAcctNo
		@INSERTNUMBER	{B205,B02_CRAcctNo},			00,'99999'
		global B02_DRCtrlAcctNo
		@INSERTNUMBER	{B206,B02_DRCtrlAcctNo},	00,'99999'
		global B02_CRCtrlAcctNo
		@INSERTNUMBER	{B207,B02_CRCtrlAcctNo},	00,'99999'
		global B02_Description
		@INSERTWORD		{B208,B02_Description},		30,' '
		global B02_Value
		@INSERTNUMBER	{B209,B02_Value},					0000,'######9.99'
		global B02_NoOfUnits
		@INSERTNUMBER	{B210,B02_NoOfUnits},			00,'999999'
		global B02_Reference
		@INSERTWORD		{B211,B02_Reference},			10,' '
		global B02_INVTranType
		@INSERTNUMBER	{B212,B02_INVTranType},		00,'999'
		global B02_INVAcctNo
		@INSERTNUMBER	{B213,B02_INVAcctNo},			00,'99999'
		global B02_INVParcelNo
		@INSERTNUMBER	{B214,B02_INVParcelNo},		00,'999'
		global B02_INVGrouping
		@INSERTNUMBER	{B215,B02_INVGrouping},		00,'999'
		global B02_FrankedAmt
		@INSERTNUMBER	{B216,B02_FrankedAmt},		0000,'9999.99'
		global B02_ImputedCredit
		@INSERTNUMBER	{B217,B02_ImputedCredit},	0000,'9999.99'
		global B02_SUnitPrice
		@INSERTNUMBER	{B218,B02_SUnitPrice},		000000,'9999.9999'
		global B02_SReference
		@INSERTWORD		{B219,B02_SReference},		10,' '
	@END_Record B02_Record
 
;	----------
;	Enquiry
;	----------
	global B03_TranRecNo
	global B03_TranDate
	global B03_Company
	global B03_DRAcctNo
	global B03_CRAcctNo
	global B03_Description
	global B03_Value
	global B03_RunningBalance
 
	%define c_B03_RecordLength 86
	%define c_B03_MaxRecords 1024
 
	@BEGIN_record c_B03_RecordLength,B03_Record
		@INSERTNUMBER	{B301,B03_TranRecNo},			00,'99999'
		@INSERTWORD		{B302,B03_TranDate},			10,' '
		@INSERTNUMBER	{B303,B03_Company},				00,'99'
		@INSERTNUMBER	{B304,B03_DRAcctNo},			00,'99999'
		@INSERTNUMBER	{B305,B03_CRAcctNo},			00,'99999'
		@INSERTWORD		{B306,B03_Description},			36,' '
 		@INSERTNUMBER	{B307,B03_Value},				0000,'######9.99'
 		@INSERTNUMBER	{B308,B03_RunningBalance},		0000,'######9.99-'
		@INSERTWORD		{B309,B03_BalanceIndicator},	02,' '
 	@END_Record B03_Record
 
	@INSERTFILE c_LF,A01_PRINT,{'./A01_FILE.PRT',0h}
	@INSERTFILE c_LF,B01_PRINT,{'./B01_FILE.PRT',0h}
	@INSERTFILE c_LF,B02_PRINT,{'./B02_FILE.PRT',0h}
	@INSERTFILE c_LF,B03_PRINT,{'./B03_FILE.PRT',0h}
	@INSERTFILE c_LF,B04_PRINT,{'./B04_FILE.PRT',0h}
 
%include 'include/END.FILES'
 
;-----------------------------------------------------------------------
;		@tables
;-----------------------------------------------------------------------
%include 'include/BEGIN.TABLES'
 
	@BEGIN_raw
		@INSERTTABLE A01_Table,c_A01_RecordLength*c_A01_MaxRecords
		@INSERTTABLE B01_Table,c_B01_RecordLength*c_B01_MaxRecords
		@INSERTTABLE B01_AltIdx_Table,c_B01_AltIdx_RecordLength*c_B01_MaxRecords
 
		@INSERTTABLE B02_Table,c_B02_RecordLength*c_B02_MaxRecords
		@INSERTTABLE B03_Table,c_B03_RecordLength*c_B03_MaxRecords
	@END_raw
 
	@INSERTARRAY n_Companies,12
 
%include 'include/END.TABLES'
 
 
 
;=======================================================================
;		PROGRAM INSTRUCTIONS
;		Mainline
;
;		The program is linked using the "_l1" as the global entry point
;		It must then Bind any Xtables to reserve the memory else C++
;		will screw around and move stuff
;		Then it calls "_start" the C++ entry point which does some
;		initialisation before calling "main"
;
;=======================================================================
	%define c_Interface				-1
	%define c_Initial				0
	%define c_A01					1
	%define c_B01					2
	%define c_B02					3
	%define c_B03					4
	%define c_B04					5
	%define c_B99					99
		%define c_B99_GetDate		1
		%define c_B99_ValidDate 	2
 
	%define c_Read					1
	%define c_Write					2
	%define c_Start					3
	%define c_PreviousNext			4
	%define c_Delete				5
	%define c_Commit				6
	%define c_Print					7
 
	%define c_Enquire				11
 
 
 
;(BEGIN):Macros created by languageONE
 
%macro m001 0
	@INTEGERS_CALC i0001,=,n_PreviousFlag2,*,2                                                                                 
	@INTEGERS_CALC I,=,i0001,-,1                                                                                               
%endmacro
 
%macro m002 0
	@INTEGERS_CALC i0001,=,n_PreviousFlag2,*,2                                                                                 
	@INTEGERS_CALC I,=,i0001,-,1                                                                                               
%endmacro
 
%macro m003 0
	@INTEGERS_CALC i0001,=,n_PreviousFlag3,*,10                                                                                
	@INTEGERS_CALC n_ValueLocation,=,i0001,+,32                                                                                
%endmacro
 
%macro m004 0
	@INTEGERS_CALC i0001,=,n_PreviousFlag3,*,10                                                                                
	@INTEGERS_CALC n_ValueLocation,=,i0001,+,32                                                                                
%endmacro
 
%macro m005 0
	@INTEGERS_CALC i0001,=,n_PreviousFlag4,*,10                                                                                
	@INTEGERS_CALC I,=,i0001,+,32,-,1                                                                                          
%endmacro
 
%macro m006 0
	@INTEGERS_CALC i0001,=,n_PreviousFlag2,*,2                                                                                 
	@INTEGERS_CALC J,=,i0001,-,1                                                                                               
%endmacro
;(END)..:Macros created by languageONE
 
%include 'include/BEGIN.INSTRUCTIONS'
%include 'include/END.INSTRUCTIONS'
%include 'include/END.PROGRAM'
 
;=======================================================================
;		PROGRAM PROCEDURES
;=======================================================================
;***********************************************************************
;	EXTERNAL:This function only used by the Pascal front end
;***********************************************************************
global l1_findParameters
@BEGIN_SUB l1_findParameters
 
;	This is a SUBROUTINE that acts as a FUNCTION for Pascal
;	(LINUX) The 1st six parameter are passed in RDI, RSI, RDX, RCX, R8, and R9
;	(WINDOWS) The 1st four parameters are passed in RCX, RDX, R8, R9
;	Each Functon needs to grab the parameter(s) for itself and then save all
;	the registers
 
;	This is singularly called by menu1.pas to validate entry into
;	the Accounting System.
;	It cannot use the A01_PROCESS routines as thay are built to honour the
;	current company (as you would after passing menu1)
 
	@BEGIN_assembler
		mov qword[n_StartParmNo],rdi
		mov qword[n_StartParm],rSi
		$pushAll rbx,rcx,rdx,rsi,rdi,rbp,r8,r9,r10,r11,r12,r13,r14,r15
	@END_assembler
 
	@Repeat_for A01_Record_NO, 1, A01_Table_UBOUND
		@TABLES_rget A01_Table,A01_Record_NO 
		@IF A01_ParameterNo,>,n_StartParmNo
			@BEGIN_assembler
				mov rax,0
				jmp l1_findParameters_exit
			@END_assembler
		@ELSE
			@_IF 	A01_ParameterNo,=,n_StartParmNo
			@_AND	A01_Parameter,	=,n_StartParm
			@_END
				@BEGIN_assembler
					mov rax,qword[A01_Record_NO]
					jmp l1_findParameters_exit
				@END_assembler
			@END_If
		@END_If
	@END_Repeat
 
	@BEGIN_assembler
		mov rax,0
	l1_findParameters_exit:
		$popAll r15,r14,r13,r12,r11,r10,r9,r8,rbp,rdi,rsi,rdx,rcx,rbx
 
@END_SUB l1_findParameters
 
;***********************************************************************
;	EXTERNAL:This function only used by the Pascal front end
;***********************************************************************
global l1_findCompany
@BEGIN_SUB l1_findCompany
 
;	This is a SUBROUTINE that acts as a FUNCTION for Pascal
;	(LINUX) The 1st six parameter are passed in RDI, RSI, RDX, RCX, R8, and R9
;	(WINDOWS) The 1st four parameters are passed in RCX, RDX, R8, R9
;	Each Functon needs to grab the parameter(s) for itself (in this case just
;	one parameter) and then save all the registers
;	The most common access should be a singe entry point with the calling
;	Pascal program saving and restoring registers
 
;	This is singularly called by menu1.pas to validate entry into
;	the Accounting System
 
	@BEGIN_assembler
		mov qword[n_CompanyNo],rdi
		$pushAll rbx,rcx,rdx,rsi,rdi,rbp,r8,r9,r10,r11,r12,r13,r14,r15
	@END_assembler
	@INTEGERS_CALC x_Request,=,c_Start
	@INTEGERS_CALC x_RecNo,	=,0
	@INTEGERS_CALC x_Accts,	=,c_TRUE
	@CALL A01_Process
 
	@INTEGERS_CALC x_Request,=,c_PreviousNext
	@INTEGERS_CALC x_RecNo,	=,1
	@Repeat_while 1,=,1
		@CALL A01_Process
		@IF ERROR_CODE, =,10
			@BEGIN_assembler
				mov rax,0
				jmp l1_findCompany_exit
			@END_assembler
		@ELSE
			@IF A01_Parameter,>,n_CompanyNo
				@BEGIN_assembler
					mov rax,0
					jmp l1_findCompany_exit
				@END_assembler
			@ELSE
				@IF A01_Parameter,=,n_CompanyNo
					@BEGIN_assembler
						mov rax,qword[n_CompanyNo]
						jmp l1_findCompany_exit
					@END_assembler
				@END_if
			@END_if
		@END_if
	@END_repeat
 
	@BEGIN_assembler
	l1_findCompany_exit:
		$popAll r15,r14,r13,r12,r11,r10,r9,r8,rbp,rdi,rsi,rdx,rcx,rbx
 
@END_SUB l1_findCompany
 
;***********************************************************************
;	EXTERNAL:This function only used by the Pascal front end
;***********************************************************************
global l1_findAcct
@BEGIN_SUB l1_findAcct
 
;	This is a SUBROUTINE that acts as a FUNCTION for Pascal
;	(LINUX) The 1st six parameter are passed in RDI, RSI, RDX, RCX, R8, and R9
;	(WINDOWS) The 1st four parameters are passed in RCX, RDX, R8, R9
;	Each Functon needs to grab the parameter(s) for itself (in this case just
;	one parameter) and then save all the registers
;	The most common access should be a singe entry point with the calling
;	Pascal program saving and restoring registers
 
;	This is called by chart1.pas & Journal1.pas and honours the Company that
;	it belongs to
 
	@BEGIN_assembler
		mov qword[x_AcctNo],rdi
		$pushAll rbx,rcx,rdx,rsi,rdi,rbp,r8,r9,r10,r11,r12,r13,r14,r15
	@END_assembler
 
	@INTEGERS_CALC x_Request,=,c_Start
	@INTEGERS_CALC x_RecNo,	=,0
	@INTEGERS_CALC x_Accts,	=,c_FALSE
	@CALL B01_Process
 
	@INTEGERS_CALC x_Request,=,c_PreviousNext
	@INTEGERS_CALC x_RecNo,	=,1
	@Repeat_while 1,=,1
		@CALL B01_Process
		@IF ERROR_CODE, =,10
			@INTEGERS_CALC RETURN_CODE,=,10
			@BEGIN_assembler
				mov rax,qword[B01_AcctNo]
				jmp l1_findAcct_exit
			@END_assembler
		@ELSE
			@IF B01_AcctNo,>,x_AcctNo
				@BEGIN_assembler
					mov rax,0
					jmp l1_findAcct_exit
				@END_assembler
			@ELSE
				@IF B01_AcctNo,=,x_AcctNo
					@BEGIN_assembler
						mov rax,qword[B01_Record_NO]
						jmp l1_findAcct_exit
					@END_assembler
				@END_if
			@END_if
		@END_if
	@END_repeat
 
	@BEGIN_assembler
	l1_findAcct_exit:
		$popAll r15,r14,r13,r12,r11,r10,r9,r8,rbp,rdi,rsi,rdx,rcx,rbx
	@END_assembler
 
@END_SUB l1_findAcct
 
;-----------------------------------------------------------------------
;	INTERNAL:Only Value Accounts
;-----------------------------------------------------------------------
@BEGIN_SUB f_ValueAcct
 
;	Changed from the VBA version here because you shuld be allowed to
;	post to a Control Account
 
	@IF x_Accts,=,c_TRUE
		@INTEGERS_CALC RETURN_CODE,=,c_TRUE
	@ELSE
		@IF  B01_Flag1,_IN,{"CA","PA","PL","A","AB","AS","DA","TO","TC"}
			@IF B01_CntlAcctNo,!=,99999
				@INTEGERS_CALC RETURN_CODE,=,c_TRUE
			@END_If
		@END_If
	@END_If
 
@END_SUB f_ValueAcct
 
;-----------------------------------------------------------------------
;	INTERNAL:Function to see  if Account exists
;-----------------------------------------------------------------------
@BEGIN_FUNCTION f_AcctExists
	@USING {n1_Acct,'99999'}
 
	@Repeat_for B01_Record_NO,B01_StartRecNo,B01_Table_UBOUND
		@TABLES_rget  B01_Table,B01_Record_NO 
 
		@IF B01_Company,>,A01_Parameter
			@INTEGERS_CALC RETURN_CODE,=,c_FALSE
			@EXIT_function f_AcctExists
		@ELSE
			@IF B01_AcctNo,>,n1_Acct
				@INTEGERS_CALC RETURN_CODE,=,c_FALSE
				@EXIT_function f_AcctExists
 
			@ELSE
				@IF B01_AcctNo,=,n1_Acct
					@INTEGERS_CALC RETURN_CODE,=,c_TRUE
					@EXIT_function f_AcctExists
				@END_if
			@END_If
		@END_If
	@END_repeat
 
@END_FUNCTION f_AcctExists
 
;-----------------------------------------------------------------------
;	INTERNAL:Function to see  if Control Account has any children
;-----------------------------------------------------------------------
@BEGIN_FUNCTION f_CntlAcctChildren
	@USING {n2_Acct,'99999'}
 
	@Repeat_for B01_Record_NO,B01_StartRecNo,B01_Table_UBOUND
		@TABLES_rget  B01_Table,B01_Record_NO 
 
		@IF B01_Company,>,A01_Parameter
			@INTEGERS_CALC RETURN_CODE,=,c_FALSE
			@EXIT_function f_CntlAcctChildren
		@ELSE
			@IF B01_CntlAcctNo,=,n2_Acct
				@INTEGERS_CALC RETURN_CODE,=,c_TRUE
				@EXIT_function f_CntlAcctChildren
			@END_If
		@END_If
	@END_repeat
 
@END_FUNCTION f_CntlAcctChildren
 
 
;=======================================================================
;		Initialisation
;=======================================================================
@BEGIN_SUB l1_loadTables
 
;	----------
;	Initialise
;	----------
	@INTEGERS_CALC ERROR_CODE,			=,0
 
	@INTEGERS_CALC n_finYear,				=,x_RecNo
	@words_pad n_finYear,w_finYear 
 
	@words_copy w_finYear,{A01_FILE,7,4} 
	@words_copy w_finYear,{B01_FILE,7,4} 
	@words_copy w_finYear,{B02_FILE,7,4} 
 
	@words_copy w_finYear,{A01_BACKUP,7,4} 
	@words_copy w_finYear,{B01_BACKUP,7,4} 
	@words_copy w_finYear,{B02_BACKUP,7,4} 
 
	@words_copy w_finYear,{A01_PRINT,7,4} 
	@words_copy w_finYear,{B01_PRINT,7,4} 
	@words_copy w_finYear,{B02_PRINT,7,4} 
	@words_copy w_finYear,{B03_PRINT,7,4} 
	@words_copy w_finYear,{B04_PRINT,7,4} 
 
;	------------------
;	Backup file system
;	------------------
	@FILES_Open  A01_FILE,$read
		@IF A01_FILE_STATUS,!=,0
			@DISPLAY "A01_FILE.CSV open failed"
			@TERMINATE 1
		@END_if
	@FILES_Open  A01_BACKUP,$write+$beginning
	@FILES_Copy  A01_FILE,A01_BACKUP
	@FILES_Close A01_FILE
	@FILES_Close A01_BACKUP
 
	@FILES_Open  B01_FILE,$read
		@IF B01_FILE_STATUS,!=,0
			@DISPLAY "B01_FILE.CSV open failed"
			@TERMINATE 1
		@END_if
	@FILES_Open  B01_BACKUP,$write+$beginning
	@FILES_Copy  B01_FILE,B01_BACKUP
	@FILES_Close B01_FILE
	@FILES_Close B01_BACKUP
 
	@FILES_Open  B02_FILE,$read
		@IF B02_FILE_STATUS,!=,0
			@DISPLAY "B02_FILE.CSV open failed"
			@TERMINATE 1
		@END_if
	@FILES_Open  B02_BACKUP,$write+$beginning
	@FILES_Copy  B02_FILE,B02_BACKUP
	@FILES_Close B02_FILE
	@FILES_Close B02_BACKUP
 
;	--------------
;	Load A01_Table
;	--------------
	@TABLES_Bind A01_Table,A01_Record,c_A01_MaxRecords
	@FILES_Open A01_FILE,$read
	@Repeat_for A01_Record_NO,1,c_A01_MaxRecords
		@FILES $read,A01_FILE, \
			A101,A102,A103,A104,A105,A106,A107,A108,A109,A110, \
			A111,A112,A113,A114,A115,A116,A117,A118,A119,A120
 
		@IF 	A01_FILE_STATUS,=,0
			@TABLES_rput A01_Table,A01_Record_NO 
		@ELSE
			@EXIT_Repeat
		@END_If
	@END_Repeat
	@FILES_Close A01_FILE
	@INTEGERS_CALC A01_Table_UBOUND,=,A01_Record_NO,-,1
 
;	---------------------
;	Return 1st A01 Record
;	---------------------
	@Repeat_for A01_Record_NO,1,c_A01_MaxRecords
		@TABLES_rget A01_Table,A01_Record_NO 
		@IF A01_ParameterNo,=,2
			@INTEGERS_CALC A01_StartRecNo,=,A01_Record_NO
			@EXIT_repeat
		@END_If
	@END_repeat
 
;	--------------
;	Load B01_Table
;	--------------
	@TABLES_Bind B01_Table,B01_Record,c_B01_MaxRecords
	@TABLES_Bind B01_AltIdx_Table,B01_AltIdx_Record,c_B01_MaxRecords
 
	@FILES_Open B01_FILE,$read
	@Repeat_for B01_Record_NO,1,c_B01_MaxRecords
		@FILES $read,B01_FILE, \
			B101,B102,B103,B104,B105,B106,B107,B108,B109,B110,B111
 
		@IF 	B01_FILE_STATUS,=,0
			@TABLES_rput B01_Table,B01_Record_NO 
		@ELSE
			@EXIT_Repeat
		@END_If
	@END_Repeat
	@FILES_Close B01_FILE
	@INTEGERS_CALC B01_Table_UBOUND,=,B01_Record_NO,-,1
 
;	--------------
;	Load B02_Table
;	--------------
	@TABLES_Bind B02_Table,B02_Record,c_B02_MaxRecords
	@FILES_Open B02_FILE,$read
	@Repeat_for B02_Record_NO,1,c_B02_MaxRecords
		@FILES $read,B02_FILE, \
			B201,B202,B203,B204,B205,B206,B207,B208,B209,B210, \
			B211,B212,B213,B214,B215,B216,B217,B218,B219
 
		@IF 	B02_FILE_STATUS,=,0
			@TABLES_rput B02_Table,B02_Record_NO 
		@ELSE
			@EXIT_Repeat
		@END_If
	@END_Repeat
	@FILES_Close B02_FILE
	@INTEGERS_CALC B02_Table_UBOUND,=,B02_Record_NO,-,1
 
;	--------------
;	Bind B03_Table
;	--------------
	@TABLES_Bind B03_Table,B03_Record,c_B03_MaxRecords
 
;	--------------
;	For Printing
;	--------------
	@Repeat_for I,1,80
		@words_copy "-",{w_Underlines,I,1} 
	@END_repeat
 
@END_SUB l1_loadTables
 
;=======================================================================
;		Processes
;=======================================================================
	 global L1_PROCESS
@BEGIN_SUB L1_PROCESS
 
	@BEGIN_assembler
		$pushAll rax,rbx,rcx,rdx,rsi,rdi,rbp,r8,r9,r10,r11,r12,r13,r14,r15
	@END_assembler
 
;	---------------------
;	Get Request
;	---------------------
	@BEGIN_assembler
		movq qword[x_TableNo],xmm0
		movq qword[x_Request],xmm1
		movq qword[x_RecNo],xmm2
		movq qword[x_AcctNo],xmm3
		movq qword[x_Accts],xmm4
	@END_assembler
 
;	---------------------
;	Call required section
;	---------------------
	@IF x_Request,=,c_Initial
		@CALL l1_loadTables
	@ELSE
		@IF x_Request,=,c_Commit
			@CALL Z_1_Finalise
		@ELSE
 
			@BEGIN_TEST x_TableNo
 
				@WHEN =,c_A01
					@CALL A01_Process
				@WEND
 
				@WHEN =,c_B01
					@CALL B01_Process
				@WEND
 
				@WHEN =,c_B02
					@CALL B02_Process
				@WEND
 
				@WHEN =,c_B03
					@CALL B03_Process
				@WEND
 
				@WHEN =,c_B04
					@CALL B04_Process
				@WEND
 
				@WHEN =,c_B99
					@CALL B99_Process
				@WEND
 
			@END_TEST
		@END_If
	@END_If
 
	@INTEGERS_CALC RETURN_CODE,=,ERROR_CODE
 
	@BEGIN_assembler
		$popAll r15,r14,r13,r12,r11,r10,r9,r8,rbp,rdi,rsi,rdx,rcx,rbx,rax
	@END_assembler
 
@END_SUB L1_PROCESS
 
;-----------------------------------------------------------------------
;	Company processing
;-----------------------------------------------------------------------
@BEGIN_SUB A01_Process
 
;	----------
;	Initialise
;	----------
	@INTEGERS_CALC ERROR_CODE,=,0
 
;	-----
;	Start
;	-----
;	0 is return the record No of the 1st record - 1
;	1 is return the record No of our 1st LOGICAL record
;		the 1st record of type ParameterNo = 2
 
	@IF  x_Request,=,c_Start
		@IF x_RecNo,=,A01_StartRecNo
			@INTEGERS_CALC A01_Record_NO,=,0
		@ELSE
			@INTEGERS_CALC A01_Record_NO,=,A01_StartRecNo,-,1
		@END_If
		@EXIT_sub A01_Process
	@END_If
 
;	----
;	Read
;	----
	@IF  x_Request,=,c_Read
		@INTEGERS_CALC A01_Record_NO,=,x_RecNo
		@IF A01_Record_NO,>,A01_Table_UBOUND
			@INTEGERS_CALC ERROR_CODE,=,10
			@EXIT_sub A01_Process
		@ELSE
			@TABLES_rget A01_Table,A01_Record_NO 
			@INTEGERS_CALC ERROR_CODE,=,A01_Table_STATUS
			@words_pad A01_UnitPrice,w_A01_UnitPrice 
			@EXIT_sub A01_Process
		@END_If
	@END_If
 
;	-------------
;	Previous/Next
;	-------------
	@IF  x_Request,=,c_PreviousNext
		@Repeat_while  1,=,1,
			@INTEGERS_CALC A01_Record_NO,=,A01_Record_NO,+,x_RecNo
			@TABLES_rget A01_Table,A01_Record_NO 
 
			@_IF A01_Table_STATUS,!=,0
			@_OR A01_ParameterNo,<,2
			@_END
				@INTEGERS_CALC A01_Record_NO,=,A01_Record_NO,-,x_RecNo
				@TABLES_rget A01_Table,A01_Record_NO 
				@INTEGERS_CALC ERROR_CODE,=,10
				@EXIT_sub A01_Process
			@ELSE
				@INTEGERS_CALC ERROR_CODE,=,A01_Table_STATUS
				@EXIT_sub A01_Process
			@END_If
		@END_repeat
		@EXIT_sub A01_Process
	@END_If
 
;	------
;	Delete
;	------
	@IF  x_Request,=,c_Delete
		@IF f_A01_Valid_Record
			@INTEGERS_CALC A01_ParameterNo,=,99
			@INTEGERS_CALC A01_Parameter,=,99
			@TABLES_rput A01_Table,x_RecNo 
			@TABLES_Sort A01_Table,1,4
			@NUMBERS_CALC  A01_Table_UBOUND,=,A01_Table_UBOUND,-,1
		@END_If
		@EXIT_sub A01_Process
	@END_If
 
;	-----
;	Write
;	-----
	@IF  x_Request,=,c_Write
 
		@NUMBERS_CALC  A01_UnitPrice,=,w_A01_UnitPrice
 
		@TABLES_rput A01_Table,c_A01_MaxRecords 
 
		@IF f_A01_Valid_Record
			@TABLES_rget A01_Table,c_A01_MaxRecords 
			@IF x_RecNo,=,0
				@NUMBERS_CALC  A01_Table_UBOUND,=,A01_Table_UBOUND,+,1
				@IF A01_Table_UBOUND,<,c_A01_MaxRecords
					@TABLES_rput A01_Table,A01_Table_UBOUND 
					@TABLES_Sort A01_Table,1,4
				@ELSE
					@Display_Line "A01_Table size has been exceeded"
					@TERMINATE 1
				@END_If
			@ELSE
				@INTEGERS_CALC A01_Record_NO,=,x_RecNo
				@TABLES_rput A01_Table,A01_Record_NO 
			@END_If
		@ELSE
			@TABLES_rget A01_Table,c_A01_MaxRecords 
		@END_If
	@END_If
 
;	-----
;	Print
;	-----
	@IF  x_Request,=,c_Print
		@CALL A01_Process_Print
	@END_If
 
@END_SUB A01_Process
 
;-----------------------------------------------------------------------
;	Validate A01 record
;-----------------------------------------------------------------------
@BEGIN_FUNCTION f_A01_Valid_Record
 
;	------
;	DELETE
;	------
;	If the Account belongs to a Consolidated group [Parameter No=3]
	@IF  x_Request,=,c_Delete
		@IF A01_ParameterNo,=,2
			@Repeat_for I,1,A01_Table_UBOUND
				@TABLES_rget A01_Table,I 
				@IF A01_ParameterNo,=,3
					@CALL A99_LoadCompany_Array
					@TABLES_rget A01_Table,x_RecNo 
					@Repeat_for J,n_CpyIdx,12
						@ARRAYS_IF  n_Companies,{J},!=,0
							@ARRAYS_IF n_Companies,{J},=,A01_Parameter
						 		@INTEGERS_CALC RETURN_CODE,=,c_FALSE
						 		@INTEGERS_CALC ERROR_CODE,=,31
						 		@EXIT_function f_A01_Valid_Record
						 	@END_If
						 @END_If
					@END_repeat
				@END_If
			@END_repeat
			@INTEGERS_CALC RETURN_CODE,=,c_TRUE
			@EXIT_function f_A01_Valid_Record
		@END_If
	@END_If
 
;	--------------
;	GST Account No
;	--------------
	@IF A01_ParameterNo,=,2
 
		@_IF  A01_GSTAccount,>,0
		@_AND A01_GSTAccount,<,59999
		@_END
			@INTEGERS_CALC ERROR_CODE,=,32
			@Repeat_for B01_Record_NO,1,c_B01_MaxRecords
				@TABLES_rget B01_Table,B01_Record_NO 
				@IF A01_GSTAccount,=,B01_AcctNo
					@IF B01_CntlAcctNo,!=,99999
						@INTEGERS_CALC ERROR_CODE,=,0
						@EXIT_repeat
					@ELSE
						@EXIT_repeat
					@END_If
				@END_If
			@END_repeat
			@IF ERROR_CODE,=,32
			 	@INTEGERS_CALC RETURN_CODE,=,c_FALSE
				@EXIT_function f_A01_Valid_Record
			@ELSE
				@INTEGERS_CALC RETURN_CODE,=,c_TRUE
				@EXIT_function f_A01_Valid_Record
			@END_If
		@END_If
	 	@INTEGERS_CALC RETURN_CODE,=,c_TRUE
		@EXIT_function f_A01_Valid_Record
	@END_If
 
;	---------
;	Companies
;	---------
;	The Comapny entered in a Consolidated Group does not exist
	@IF A01_ParameterNo,=,3
 
		@CALL A99_LoadCompany_Array
 
		@INTEGERS_CALC n_StartRecNo,=,A01_StartRecNo
		@Repeat_for n_CpyIdx,n_CpyIdx,12
			@Repeat_for A01_Record_NO,n_StartRecNo,c_A01_MaxRecords
				@TABLES_rget A01_Table,A01_Record_NO 
 
				@IF A01_ParameterNo,=,3
			 		@INTEGERS_CALC RETURN_CODE,=,c_FALSE
			 		@INTEGERS_CALC ERROR_CODE,=,33
			 		@EXIT_function f_A01_Valid_Record
			 	@END_If
 
			 	@ARRAYS_IF  n_Companies,{n_CpyIdx},<,A01_Parameter
			 		@INTEGERS_CALC RETURN_CODE,=,c_FALSE
			 		@INTEGERS_CALC ERROR_CODE,=,33
			 		@EXIT_function f_A01_Valid_Record
			 	@END_If
 
			 	@ARRAYS_IF  n_Companies,{n_CpyIdx},=,A01_Parameter
					@INTEGERS_CALC n_StartRecNo,=,A01_Record_NO,+,1
					@EXIT_repeat
				@END_If
 
			@END_repeat
		@END_repeat
 
	 	@INTEGERS_CALC RETURN_CODE,=,c_TRUE
		@EXIT_function f_A01_Valid_Record
 
	@END_If
 
 	@INTEGERS_CALC RETURN_CODE,=,c_TRUE
 
@END_FUNCTION f_A01_Valid_Record
 
 
;-----------------------------------------------------------------------
;	System Parameters Print
;-----------------------------------------------------------------------
@BEGIN_SUB A01_Process_Print
 
	@INTEGERS_CALC n_LineCtr,		=,99
	@INTEGERS_CALC n_PageNo,		=,0
 
	@FILES_Open A01_PRINT,$write+$beginning
 
	@Repeat_for A01_Record_NO,1,c_A01_MaxRecords
 
		@TABLES_rget A01_Table,A01_Record_NO 
		@IF A01_Table_STATUS,=,0
 
			@_IF	 A01_ParameterNo,>=,n_StartParmNo
			@_AND A01_ParameterNo,<=,n_EndParmNo
			@_AND A01_Parameter,	>=,n_StartParm
			@_AND A01_Parameter,	<=,n_EndParm
			@_END
 
				@NUMBERS_CALC  n_LineCtr,=,n_LineCtr,+,1
 
				@CALL A01_Process_Print_Headings
				@CALL A01_Process_Print_Details
			@END_If
		@ELSE
			@EXIT_repeat
		@END_If
 
	@END_Repeat
 
	@FILES_Close A01_PRINT
 
@END_SUB A01_Process_Print
 
;-----------------------------------------------------------------------
;	System Parameters Headings
;-----------------------------------------------------------------------
@BEGIN_SUB A01_Process_Print_Headings
 
	@IF n_LineCtr,<,55
		@EXIT_Sub A01_Process_Print_Headings
	@END_If
 
	@FILES $write,A01_PRINT,x_NewPage
 
	@NUMBERS_CALC  n_PageNo,=,n_PageNo,+,1
 
	@FILES $write,A01_PRINT,w_Underlines
 
	@words_pad {w_Spaces,1,80},w_prtLine 
	@words_pad "A0100001",w_prtLine 
	@words_copy "SYSTEM PARAMETRS",{w_prtLine,11} 
	@words_copy "PAGE",{w_prtLine,72} 
	@words_copy n_PageNo,{w_prtLine,77} 
	@FILES $write,A01_PRINT,w_prtLine
 
	@FILES $write,A01_PRINT,w_Underlines
 
	@words_pad {w_Spaces,1,80},w_prtLine 
	@words_pad "ParamNo",w_prtLine 
	@words_copy "Param",{w_prtLine,09} 
	@words_copy "Description",{w_prtLine,15} 
	@FILES $write,A01_PRINT,w_prtLine
 
	@words_pad {w_Spaces,1,80},w_prtLine 
	@words_pad "-------",w_prtLine 
	@words_copy "------",{w_prtLine,09} 
	@words_copy "-----------",{w_prtLine,15} 
	@FILES $write,A01_PRINT,w_prtLine
 
	@INTEGERS_CALC n_LineCtr,=,6
 
@END_SUB A01_Process_Print_Headings
 
;-----------------------------------------------------------------------
;	System Parameters Details
;-----------------------------------------------------------------------
@BEGIN_SUB A01_Process_Print_Details
 
	@IF A01_ParameterNo,>,1
		@words_pad {w_Spaces,1,80},w_prtLine 
		@FILES $write,A01_PRINT,w_prtLine
	@END_If
 
	@words_pad {w_Spaces,1,80},w_prtLine 
	@words_copy A01_ParameterNo,{w_prtLine,06} 
	@words_copy A01_Parameter,{w_prtLine,12} 
	@words_copy A01_Description,{w_prtLine,15} 
	@FILES $write,A01_PRINT,w_prtLine
 
	@words_pad {w_Spaces,1,80},w_prtLine 
 
	@BEGIN_test A01_ParameterNo
		@WHEN =,1
			@words_copy "MenuName=",{w_prtLine,15} 
			@words_copy A01_MenuName,{w_prtLine,24} 
			@FILES $write,A01_PRINT,w_prtLine
		@WEND
		@WHEN =,2
			@words_copy "Ref=",{w_prtLine,15} 
			@words_copy A01_LastReference,{w_prtLine,19} 
			@words_copy "GST Acct=",{w_prtLine,30} 
			@words_copy A01_GSTAccount,{w_prtLine,39} 
			@words_copy "StartYear=",{w_prtLine,45} 
			@words_copy A01_StartYear,{w_prtLine,55} 
			@words_copy "UnitPrice=",{w_prtLine,60} 
			@words_copy A01_UnitPrice,{w_prtLine,70} 
			@FILES $write,A01_PRINT,w_prtLine
		@WEND
		@WHEN =,3
			@words_copy "Companies=",{w_prtLine,15} 
			@words_copy A01_Company01,{w_prtLine,25} 
			@words_copy A01_Company02,{w_prtLine,28} 
			@words_copy A01_Company03,{w_prtLine,31} 
			@words_copy A01_Company04,{w_prtLine,34} 
			@words_copy A01_Company05,{w_prtLine,37} 
			@words_copy A01_Company06,{w_prtLine,40} 
			@words_copy A01_Company07,{w_prtLine,43} 
			@words_copy A01_Company08,{w_prtLine,46} 
			@words_copy A01_Company09,{w_prtLine,49} 
			@words_copy A01_Company10,{w_prtLine,52} 
			@FILES $write,A01_PRINT,w_prtLine
		@WEND
	@END_test
 
@END_SUB A01_Process_Print_Details
 
;-----------------------------------------------------------------------
;	Chart of Account
;-----------------------------------------------------------------------
@BEGIN_SUB B01_Process
 
;	These IO Routines are mainly called by the LAZARUS front-end and will
;	make working thru the multi-company Chart Of Account invisible to
;	that fornt-end
 
;	----------
;	Initialise
;	----------
	@INTEGERS_CALC ERROR_CODE,=,0
 
;	-----
;	Start
;	-----
;	0 is return the record No of the 1st LOGICAL record - 1
;	1 is return the record No of our 1st LOGICAL record
;		Logical records are those belonging to the selected COMPANY
 
	@IF  x_Request,=,c_Start
		@Repeat_for B01_Record_NO,1,c_B01_MaxRecords
			@TABLES_rget B01_Table,B01_Record_NO 
			@INTEGERS_CALC ERROR_CODE,=,B01_Table_STATUS
			@IF B01_Company,=,A01_Parameter
				@CALL f_ValueAcct
				@IF RETURN_CODE,=,c_TRUE
					@INTEGERS_CALC B01_StartRecNo,=,B01_Record_NO
					@IF x_RecNo,=,0
						@INTEGERS_CALC B01_Record_NO,=,B01_StartRecNo,-,1
					@END_If
					@EXIT_sub B01_Process
				@END_If
			@END_If
		@END_repeat
		@INTEGERS_CALC ERROR_CODE,=,10
		@EXIT_sub B01_Process
	@END_If
 
;	----
;	Read
;	----
	@IF  x_Request,=,c_Read
		@INTEGERS_CALC B01_Record_NO,=,x_RecNo
		@IF B01_Record_NO,>,B01_Table_UBOUND
			@INTEGERS_CALC ERROR_CODE,=,10
			@EXIT_sub B01_Process
		@ELSE
			@TABLES_rget B01_Table,B01_Record_NO 
			@INTEGERS_CALC ERROR_CODE,=,B01_Table_STATUS
			@words_pad B01_UnitPrice,w_B01_UnitPrice 
			@EXIT_sub B01_Process
		@END_If
	@END_If
 
;	-------------
;	Previous/Next
;	-------------
;	Logical records are those belonging to the selected COMPANY
 
	@IF  x_Request,=,c_PreviousNext
		@Repeat_while  1,=,1,
			@INTEGERS_CALC B01_Record_NO,=,B01_Record_NO,+,x_RecNo
			@TABLES_rget B01_Table,B01_Record_NO 
 
			@_IF B01_Table_STATUS,!=,0
			@_OR B01_Company,!=,A01_Parameter
			@_END
				@INTEGERS_CALC B01_Record_NO,=,B01_Record_NO,-,x_RecNo
				@TABLES_rget B01_Table,B01_Record_NO 
				@INTEGERS_CALC ERROR_CODE,=,10
				@EXIT_sub B01_Process
			@ELSE
				@CALL f_ValueAcct
				@IF RETURN_CODE,=,c_TRUE
					@INTEGERS_CALC ERROR_CODE,=,B01_Table_STATUS
					@EXIT_sub B01_Process
				@END_If
			@END_If
		@END_repeat
		@EXIT_sub B01_Process
	@END_If
 
;	------
;	Delete
;	------
	@IF  x_Request,=,c_Delete
		@IF f_B01_Valid_Record
			@INTEGERS_CALC B01_Company,=,99
			@INTEGERS_CALC B01_AcctNo,=,99999
			@TABLES_rput B01_Table,x_RecNo 
			@TABLES_Sort B01_Table,1,7
			@NUMBERS_CALC  B01_Table_UBOUND,=,B01_Table_UBOUND,-,1
		@END_If
		@EXIT_sub B01_Process
	@END_If
 
;	-----
;	Write
;	-----
	@IF  x_Request,=,c_Write
 
		@INTEGERS_CALC B01_Company,	=,A01_Parameter
		@NUMBERS_CALC  B01_UnitPrice,=,w_B01_UnitPrice
 
		@TABLES_rput B01_Table,c_B01_MaxRecords 
 
		@IF f_B01_Valid_Record
			@TABLES_rget B01_Table,c_B01_MaxRecords 
 
			@IF x_RecNo,=,0
				@NUMBERS_CALC  B01_Table_UBOUND,=,B01_Table_UBOUND,+,1
				@IF B01_Table_UBOUND,<,c_B01_MaxRecords
					@TABLES_rput B01_Table,B01_Table_UBOUND 
					@TABLES_Sort B01_Table,1,7
				@ELSE
					@Display_Line "B01_Table size has been exceeded"
					@TERMINATE 1
				@END_If
			@ELSE
				@INTEGERS_CALC B01_Record_NO,=,x_RecNo
				@TABLES_rput B01_Table,B01_Record_NO 
			@END_If
 
		@ELSE
			@TABLES_rget B01_Table,c_B01_MaxRecords 
		@END_If
	@END_If
 
;	-----
;	Print
;	-----
	@IF  x_Request,=,c_Print
		@CALL B01_Process_Print
	@END_If
 
@END_SUB B01_Process
 
 
;-----------------------------------------------------------------------
;	Validate B01 record
;-----------------------------------------------------------------------
@BEGIN_FUNCTION f_B01_Valid_Record
 
	@INTEGERS_CALC n_AcctNo,		=,B01_AcctNo
	@INTEGERS_CALC n_CntlAcctNo,	=,B01_CntlAcctNo
 
;	------
;	DELETE
;	------
;	Child Accounts still exist
	@IF  x_Request,=,c_Delete
		@IF B01_CntlAcctNo,=,99999
			@IF {f_CntlAcctChildren,n_AcctNo}
				@INTEGERS_CALC RETURN_CODE,=,c_FALSE
				@INTEGERS_CALC ERROR_CODE,=,41
				@EXIT_function f_B01_Valid_Record
			@ELSE
				@INTEGERS_CALC RETURN_CODE,=,c_TRUE
				@EXIT_function f_B01_Valid_Record
			@END_If
		@END_If
		@INTEGERS_CALC RETURN_CODE,=,c_TRUE
		@EXIT_function f_B01_Valid_Record
	@END_If
 
;	---------------
;	CONTROL ACCOUNT
;	---------------
;	Child Accounts still exist (Control Account can be changed from 99999 to 0)
	@IF  n_CntlAcctNo,=,0
		@IF {f_CntlAcctChildren,n_AcctNo}
			@INTEGERS_CALC RETURN_CODE,=,c_FALSE
			@INTEGERS_CALC ERROR_CODE,=,42
			@EXIT_function f_B01_Valid_Record
		@ELSE
			@INTEGERS_CALC RETURN_CODE,=,c_TRUE
			@EXIT_function f_B01_Valid_Record
		@END_If
		@EXIT_function f_B01_Valid_Record
	@END_If
 
;	-----------------------
;	INVALID CONTROL ACCOUNT
;	-----------------------
;	Control Account does not exist
	@_IF  n_CntlAcctNo,>,0
	@_AND n_CntlAcctNo,<,59999
	@_END
		@IF {f_AcctExists,n_CntlAcctNo}
			@IF B01_CntlAcctNo,=,99999
				@INTEGERS_CALC RETURN_CODE,=,c_TRUE
				@EXIT_function f_B01_Valid_Record
			@ELSE
				@INTEGERS_CALC RETURN_CODE,=,c_FALSE
				@INTEGERS_CALC ERROR_CODE,=,43
				@EXIT_function f_B01_Valid_Record
			@END_If
		@ELSE
			@INTEGERS_CALC RETURN_CODE,=,c_FALSE
			@INTEGERS_CALC ERROR_CODE,=,43
			@EXIT_function f_B01_Valid_Record
		@END_If
 
		@EXIT_function f_B01_Valid_Record
	@END_If
 
	@INTEGERS_CALC RETURN_CODE,=,c_TRUE
 
@END_FUNCTION f_B01_Valid_Record
 
;-----------------------------------------------------------------------
;	Chart of Accounts Print
;-----------------------------------------------------------------------
@BEGIN_SUB B01_Process_Print
 
;	Because the Chart of Accounts can be run for multi-companies the
;	the tables are accessed directly. More so because a mult-company
;	report is in Account/Company order, an Alternate key is built and
;	used to acces the Chart of Account
 
	@INTEGERS_CALC n_LineCtr,		=,99
	@INTEGERS_CALC n_PageNo,		=,0
	@FILES_Open B01_PRINT,$write+$beginning
 
;	--------------------
;	Load Alt Index Table
;	--------------------
	@CALL A99_LoadCompany_Array
	@CALL B99_AltIndex
 
;	----------------------------------------
;	Loop thru the Alt Index - AcctNo/Company
;	----------------------------------------
	@Repeat_for I,1,B01_AltIdx_Table_UBOUND
 
		@TABLES_rget B01_AltIdx_Table,I 
		@TABLES_rget B01_Table,B01_AltIdx_RecNo 
 
		@CALL B01_Process_Print_Headings
		@CALL B01_Process_Print_Details
 
    @END_Repeat
 
	@FILES_Close B01_PRINT
 
@END_SUB B01_Process_Print
 
;-----------------------------------------------------------------------
;	Chart of Accounts Headings
;-----------------------------------------------------------------------
@BEGIN_SUB B01_Process_Print_Headings
 
	@IF n_LineCtr,<,55
		@EXIT_Sub B01_Process_Print_Headings
	@END_If
 
	@FILES $write,B01_PRINT,x_NewPage
 
	@NUMBERS_CALC  n_PageNo,=,n_PageNo,+,1
 
	@FILES $write,B01_PRINT,w_Underlines
 
	@words_pad {w_Spaces,1,80},w_prtLine 
	@words_pad "B0100001",w_prtLine 
	@words_copy "CHART OF ACCOUNTS",{w_prtLine,11} 
	@words_copy A01_Description,{w_prtLine,30} 
	@words_copy "PAGE",{w_prtLine,72} 
	@words_copy n_PageNo,{w_prtLine,77} 
	@FILES $write,B01_PRINT,w_prtLine
 
	@FILES $write,B01_PRINT,w_Underlines
 
	@words_pad {w_Spaces,1,80},w_prtLine 
	@words_copy "Co",{w_prtLine,01} 
	@words_copy "AcctNo",{w_prtLine,04} 
	@words_copy "Description",{w_prtLine,11} 
	@words_copy "F1",{w_prtLine,40} 
	@words_copy "F2",{w_prtLine,43} 
	@words_copy "F3",{w_prtLine,46} 
	@words_copy "F4",{w_prtLine,49} 
	@words_copy "IN",{w_prtLine,52} 
	@words_copy "CtrlAcct",{w_prtLine,56} 
	@words_copy "Deprec",{w_prtLine,65} 
	@words_copy "UnitPrice",{w_prtLine,72} 
	@FILES $write,B01_PRINT,w_prtLine
 
	@words_pad {w_Spaces,1,80},w_prtLine 
	@words_copy "--",{w_prtLine,01} 
	@words_copy "------",{w_prtLine,04} 
	@words_copy "-----------",{w_prtLine,11} 
	@words_copy "--",{w_prtLine,40} 
	@words_copy "--",{w_prtLine,43} 
	@words_copy "--",{w_prtLine,46} 
	@words_copy "--",{w_prtLine,49} 
	@words_copy "--",{w_prtLine,52} 
	@words_copy "--------",{w_prtLine,56} 
	@words_copy "------",{w_prtLine,65} 
	@words_copy "---------",{w_prtLine,72} 
	@FILES $write,B01_PRINT,w_prtLine
 
	@INTEGERS_CALC n_LineCtr,=,6
 
@END_SUB B01_Process_Print_Headings
 
;-----------------------------------------------------------------------
;	Chart of Accounts Details
;-----------------------------------------------------------------------
@BEGIN_SUB B01_Process_Print_Details
 
	@words_pad {w_Spaces,1,80},w_prtLine 
	@words_copy B01_Company,{w_prtLine,01} 
	@words_copy B01_AcctNo,{w_prtLine,05} 
	@words_copy B01_Description,{w_prtLine,11} 
	@words_copy B01_Flag1,{w_prtLine,40} 
	@words_copy B01_Flag2,{w_prtLine,44} 
	@words_copy B01_Flag3,{w_prtLine,47} 
	@words_copy B01_Flag4,{w_prtLine,50} 
	@words_copy B01_BalanceIndicator,{w_prtLine,52} 
	@words_copy B01_CntlAcctNo,{w_prtLine,59} 
	@words_copy B01_Depreciation,{w_prtLine,68} 
	@words_copy B01_UnitPrice,{w_prtLine,72} 
 
	@FILES $write,B01_PRINT,w_prtLine
	@NUMBERS_CALC  n_LineCtr,=,n_LineCtr,+,1
 
@END_SUB B01_Process_Print_Details
 
;-----------------------------------------------------------------------
;	General Journal
;-----------------------------------------------------------------------
@BEGIN_SUB B02_Process
 
;	These IO Routines are mainly called by the LAZARUS front-end and will
;	make working thru the multi-company Transaction invisible to
;	that fornt-end
 
;	----------
;	Initialise
;	----------
	@INTEGERS_CALC ERROR_CODE,=,0
 
;	-----
;	Start
;	-----
;	0 is return the record No of the 1st LOGICAL record - 1
;	1 is return the record No of our 1st LOGICAL record
;		Logical records are those belonging to the selected COMPANY
 
	@IF  x_Request,=,c_Start
		@Repeat_for B02_Record_NO,1,c_B02_MaxRecords
			@TABLES_rget B02_Table,B02_Record_NO 
			@INTEGERS_CALC ERROR_CODE,=,B02_Table_STATUS
			@IF B02_Company,=,A01_Parameter
				@INTEGERS_CALC B02_StartRecNo,=,B02_Record_NO
				@IF x_RecNo,=,0
					@INTEGERS_CALC B02_Record_NO,=,B02_StartRecNo,-,1
				@END_If
				@EXIT_sub B02_Process
			@END_If
		@END_repeat
		@INTEGERS_CALC ERROR_CODE,=,10
		@EXIT_sub B02_Process
	@END_If
 
;	-----
;	Read
;	----
	@IF  x_Request,=,c_Read
		@INTEGERS_CALC B02_Record_NO,=,x_RecNo
		@IF B02_Record_NO,>,B02_Table_UBOUND
			@INTEGERS_CALC ERROR_CODE,=,10
			@EXIT_sub B02_Process
		@ELSE
			@TABLES_rget B02_Table,B02_Record_NO 
			@INTEGERS_CALC ERROR_CODE,=,B02_Table_STATUS
			@words_pad B02_Value,w_B02_Value 
			@words_pad B02_FrankedAmt,w_B02_FrankedAmt 
			@words_pad B02_ImputedCredit,w_B02_ImputedCredit 
			@words_pad B02_SUnitPrice,w_B02_SUnitPrice 
			@EXIT_sub B02_Process
		@END_If
	@END_If
 
;	-------------
;	Previous/Next
;	-------------
;	Logical records are those belonging to the selected COMPANY
 
	@IF  x_Request,=,c_PreviousNext
 
		@Repeat_while  1,=,1,
			@INTEGERS_CALC B02_Record_NO,=,B02_Record_NO,+,x_RecNo
			@TABLES_rget B02_Table,B02_Record_NO 
 
			@_IF B02_Table_STATUS,!=,0
			@_OR B02_Company,!=,A01_Parameter
			@_END
				@INTEGERS_CALC B02_Record_NO,=,B02_Record_NO,-,x_RecNo
				@TABLES_rget B02_Table,B02_Record_NO 
				@INTEGERS_CALC ERROR_CODE,=,10
				@EXIT_sub B02_Process
			@ELSE
				@INTEGERS_CALC ERROR_CODE,=,B02_Table_STATUS
				@EXIT_sub B02_Process
			@END_If
		@END_repeat
		@EXIT_sub B02_Process
	@END_If
 
;	------
;	Delete
;	------
	@IF  x_Request,=,c_Delete
		@IF f_B02_Valid_Record
			@INTEGERS_CALC B02_Company,	=,99
			@words_pad "9999/99/99",B02_TranDate 
			@words_pad "99:99:99",B02_TranTime 
			@TABLES_rput B02_Table,x_RecNo 
			@TABLES_Sort B02_Table,1,20
			@NUMBERS_CALC  B02_Table_UBOUND,=,B02_Table_UBOUND,-,1
		@END_If
		@EXIT_sub B02_Process
	@END_If
 
;	-----
;	Write
;	-----
	@IF  x_Request,=,c_Write
 
		@INTEGERS_CALC B02_Company,		=,A01_Parameter
		@NUMBERS_CALC  B02_Value,		=,w_B02_Value
		@NUMBERS_CALC  B02_FrankedAmt,	=,w_B02_FrankedAmt
		@NUMBERS_CALC  B02_ImputedCredit,=,w_B02_ImputedCredit
		@NUMBERS_CALC  B02_SUnitPrice,	=,w_B02_SUnitPrice
 
		@TABLES_rput B02_Table,c_B02_MaxRecords 
 
		@IF f_B02_Valid_Record
			@TABLES_rget B02_Table,c_B02_MaxRecords 
 
			@CALL B02_Process_CntlAccts
 
			@IF x_RecNo,=,0
				@NUMBERS_CALC  B02_Table_UBOUND,=,B02_Table_UBOUND,+,1
				@IF B02_Table_UBOUND,<,c_B02_MaxRecords
					@TABLES_rput B02_Table,B02_Table_UBOUND 
					@TABLES_Sort B02_Table,1,20
				@ELSE
					@Display_Line "B02_Table size has been exceeded"
					@TERMINATE 1
				@END_If
			@ELSE
				@INTEGERS_CALC B02_Record_NO,=,x_RecNo
				@TABLES_rput B02_Table,B02_Record_NO 
			@END_If
		@ELSE
			@TABLES_rget B02_Table,c_B02_MaxRecords 
		@END_If
	@END_If
 
;	-----
;	Print
;	-----
	@IF  x_Request,=,c_Print
		@CALL B02_Process_Print
	@END_If
 
@END_SUB B02_Process
 
;-----------------------------------------------------------------------
;	Validate B02 record
;-----------------------------------------------------------------------
@BEGIN_FUNCTION f_B02_Valid_Record
 
;	-------------
;	DEBIT ACCOUNT
;	-------------
	@IF {f_AcctExists,B02_DRAcctNo}
	@ELSE
		@INTEGERS_CALC RETURN_CODE,=,c_FALSE
		@INTEGERS_CALC ERROR_CODE,=,52
		@EXIT_function f_B02_Valid_Record
	@END_If
 
;	--------------
;	CREDIT ACCOUNT
;	--------------
	@IF {f_AcctExists,B02_CRAcctNo}
	@ELSE
		@INTEGERS_CALC RETURN_CODE,=,c_FALSE
		@INTEGERS_CALC ERROR_CODE,=,53
		@EXIT_function f_B02_Valid_Record
	@END_If
 
;	-----------
;	INV ACCOUNT
;	-----------
	@IF B02_INVAcctNo,>,0
		@IF {f_AcctExists,B02_INVAcctNo}
		@ELSE
			@INTEGERS_CALC RETURN_CODE,=,c_FALSE
			@INTEGERS_CALC ERROR_CODE,=,54
			@EXIT_function f_B02_Valid_Record
		@END_If
	@END_If
 
;	-----
;	Value
;	-----
	@IF B02_Value,=,0
		@INTEGERS_CALC RETURN_CODE,=,c_FALSE
		@INTEGERS_CALC ERROR_CODE,=,55
		@EXIT_function f_B02_Valid_Record
	@END_If
 
	@INTEGERS_CALC RETURN_CODE,=,c_TRUE
 
@END_FUNCTION f_B02_Valid_Record
 
;-----------------------------------------------------------------------
;	Check for Control Accounts
;-----------------------------------------------------------------------
@BEGIN_SUB B02_Process_CntlAccts
 
	@Repeat_for B01_Record_NO,B01_StartRecNo,B01_Table_UBOUND
		@TABLES_rget  B01_Table,B01_Record_NO 
 
		@IF B01_Company,>,A01_Parameter
			@EXIT_sub B02_Process_CntlAccts
		@ELSE
 
			@IF B02_DRAcctNo,=,B01_AcctNo
				@INTEGERS_CALC B02_DRCtrlAcctNo,=,B01_CntlAcctNo
			@END_If
			@IF B02_CRAcctNo,=,B01_AcctNo
				@INTEGERS_CALC B02_CRCtrlAcctNo,=,B01_CntlAcctNo
			@END_If
 
		@END_If
 
	@END_repeat
 
@END_SUB B02_Process_CntlAccts
 
;-----------------------------------------------------------------------
;	General Journal Print
;-----------------------------------------------------------------------
@BEGIN_SUB B02_Process_Print
 
;	Because the Transaction Listing can not run Consolidated, we can
;	use the LAZARUS IO routines from here. They will return records
;	for the appropriate company
 
;	--------------------
;	Gets the 1st records
;	--------------------
	@INTEGERS_CALC x_Request,=,c_Start
	@INTEGERS_CALC x_RecNo,	=,1
	@CALL B01_Process
	@INTEGERS_CALC x_Request,=,c_PreviousNext
 
	@INTEGERS_CALC n_LineCtr,		=,99
	@INTEGERS_CALC n_PageNo,		=,0
 
	@FILES_Open B02_PRINT,$write+$beginning
 
	@INTEGERS_CALC ERROR_CODE,=,0
	@Repeat_while ERROR_CODE,=,0
 
		@IF B02_TranDate,>,w_EndDate
			@EXIT_repeat
 
		@ELSE
 
			@IF B02_TranDate,!<,w_StartDate
 
				@IF  w_Reference,!=,{w_Spaces,10}
					@IF B02_Reference,=,w_Reference
						@NUMBERS_CALC  n_LineCtr,=,n_LineCtr,+,1
						@CALL B02_Process_Print_Headings
						@CALL B02_Process_Print_Details
					@END_If
				@ELSE
					@NUMBERS_CALC  n_LineCtr,=,n_LineCtr,+,1
					@CALL B02_Process_Print_Headings
					@CALL B02_Process_Print_Details
				@END_If
			@END_If
 
			@CALL B02_Process
 
		@END_If
 
	@END_Repeat
 
	@FILES_Close B01_PRINT
 
@END_SUB B02_Process_Print
 
;-----------------------------------------------------------------------
;	General Journal Headings
;-----------------------------------------------------------------------
@BEGIN_SUB B02_Process_Print_Headings
 
    @IF n_LineCtr,<,55
       @EXIT_Sub B02_Process_Print_Headings
    @END_If
    @FILES $write,B02_PRINT,x_NewPage
 
    @NUMBERS_CALC  n_PageNo,=,n_PageNo,+,1
 
	@FILES $write,B02_PRINT,w_Underlines
 
    @words_pad {w_Spaces,1,80},w_prtLine 
	@words_pad "B0200001",w_prtLine 
	@words_copy "GENERAL JOURNAL",{w_prtLine,11} 
	@words_copy A01_Description,{w_prtLine,30} 
	@words_copy "PAGE",{w_prtLine,72} 
	@words_copy n_PageNo,{w_prtLine,77} 
	@FILES $write,B02_PRINT,w_prtLine
 
	@FILES $write,B02_PRINT,w_Underlines
 
    @words_pad {w_Spaces,1,80},w_prtLine 
	@words_copy "Date",{w_prtLine,04} 
    @words_copy "Description",{w_prtLine,12} 
    @words_copy "No Of Units",{w_prtLine,50} 
    @words_copy "Value",{w_prtLine,70} 
	@FILES $write,B02_PRINT,w_prtLine
 
    @words_pad {w_Spaces,1,80},w_prtLine 
	@words_copy "----",{w_prtLine,04} 
    @words_copy "-----------",{w_prtLine,12} 
    @words_copy "-----------",{w_prtLine,50} 
    @words_copy "-----",{w_prtLine,70} 
	@FILES $write,B02_PRINT,w_prtLine
 
    @INTEGERS_CALC n_LineCtr,=,6
 
@END_SUB B02_Process_Print_Headings
 
;-----------------------------------------------------------------------
;	General Journal Details
;-----------------------------------------------------------------------
@BEGIN_SUB B02_Process_Print_Details
 
     @words_pad {w_Spaces,1,80},w_prtLine 
	@words_copy B02_TranDate,{w_prtLine,01} 
    @words_copy B02_Description,{w_prtLine,12} 
    @IF B02_NoOfUnits,>,0
    	@words_copy B02_NoOfUnits,{w_prtLine,55} 
    @ELSE
    	@words_copy {w_Spaces,6},{w_prtLine,55} 
    @END_If
    @words_copy B02_Value,{w_prtLine,65} 
	@FILES $write,B02_PRINT,w_prtLine
 
	@IF {f_AcctExists,B02_DRAcctNo}
     	@words_pad {w_Spaces,1,80},w_prtLine 
     	@words_copy "Debit=",{w_prtLine,12} 
     	@words_copy B02_DRAcctNo,{w_prtLine,18} 
     	@words_copy B01_Description,{w_prtLine,24} 
     	@FILES $write,B02_PRINT,w_prtLine
		@NUMBERS_CALC  n_LineCtr,=,n_LineCtr,+,1
	@END_If
 
	@IF {f_AcctExists,B02_CRAcctNo}
     	@words_pad {w_Spaces,1,80},w_prtLine 
     	@words_copy "Credit=",{w_prtLine,12} 
     	@words_copy B02_CRAcctNo,{w_prtLine,19} 
     	@words_copy B01_Description,{w_prtLine,25} 
     	@FILES $write,B02_PRINT,w_prtLine
		@NUMBERS_CALC  n_LineCtr,=,n_LineCtr,+,1
	@END_If
 
	@IF w_PrintDetails,=,"N"
		@EXIT_sub B02_Process_Print_Details
	@END_If
 
   	@words_pad {w_Spaces,1,80},w_prtLine 
   	@words_copy "Reference=",{w_prtLine,12} 
   	@words_copy B02_Reference,{w_prtLine,22} 
   	@FILES $write,B02_PRINT,w_prtLine
	@NUMBERS_CALC  n_LineCtr,=,n_LineCtr,+,1
 
   	@words_pad {w_Spaces,1,80},w_prtLine 
   	@words_copy "Tran Type=",{w_prtLine,12} 
   	@words_copy B02_INVTranType,{w_prtLine,22} 
   	@words_copy "Acct=",{w_prtLine,26} 
   	@words_copy B02_INVAcctNo,{w_prtLine,31} 
   	@words_copy "Parcel=",{w_prtLine,37} 
   	@words_copy B02_INVParcelNo,{w_prtLine,44} 
   	@words_copy "Grouping=",{w_prtLine,48} 
   	@words_copy B02_INVGrouping,{w_prtLine,57} 
   	@FILES $write,B02_PRINT,w_prtLine
	@NUMBERS_CALC  n_LineCtr,=,n_LineCtr,+,1
 
   	@words_pad {w_Spaces,1,80},w_prtLine 
   	@words_copy "Franked Amt=",{w_prtLine,12} 
   	@words_copy B02_FrankedAmt,{w_prtLine,24} 
   	@words_copy "ImputedCredit=",{w_prtLine,32} 
   	@words_copy B02_ImputedCredit,{w_prtLine,46} 
   	@words_copy "UnitPrice=",{w_prtLine,54} 
   	@words_copy B02_SUnitPrice,{w_prtLine,64} 
   	@FILES $write,B02_PRINT,w_prtLine
	@NUMBERS_CALC  n_LineCtr,=,n_LineCtr,+,1
 
   	@words_pad {w_Spaces,1,80},w_prtLine 
   	@words_copy "Reference=",{w_prtLine,12} 
   	@words_copy B02_SReference,{w_prtLine,22} 
   	@FILES $write,B02_PRINT,w_prtLine
	@NUMBERS_CALC  n_LineCtr,=,n_LineCtr,+,1
 
   	@words_pad {w_Spaces,1,80},w_prtLine 
   	@FILES $write,B02_PRINT,w_prtLine
	@NUMBERS_CALC  n_LineCtr,=,n_LineCtr,+,1
 
@END_SUB B02_Process_Print_Details
 
;-----------------------------------------------------------------------
;	Account Enquiry
;-----------------------------------------------------------------------
@BEGIN_SUB B03_Process
 
;	---------------------
;	Enquire - build table
;	---------------------
;	The front-end accepts the parameters and an enquiry table is
;	first built here.
 
	@IF  x_Request,=,c_Enquire
		@CALL B03_1_BuildTable
	@END_If
 
;	-------------------------------
;	Enquire - read thru built table
;	-------------------------------
;	The front-end then fills a browser (OBJECT!!!) by normal calls
;	here by looping thru the record no
 
	@IF  x_Request,=,c_Read
		@INTEGERS_CALC B03_Record_NO, =,x_RecNo
		@IF B03_Record_NO,>,B03_Table_UBOUND
			@INTEGERS_CALC ERROR_CODE,=,10
			@EXIT_sub B03_Process
		@ELSE
			@TABLES_rget B03_Table,B03_Record_NO 
			@INTEGERS_CALC ERROR_CODE,=,B03_Table_STATUS
			@words_pad B03_Value,w_B03_Value 
			@words_pad B03_RunningBalance,w_B03_RunningBalance 
			@EXIT_sub B03_Process
		@END_If
	@END_If
 
;	-------
;	Print
;	-------
	@IF  x_Request,=,c_Print
		@CALL B03_Process_Print
	@END_If
 
@END_SUB B03_Process
 
;-----------------------------------------------------------------------
;	Build Table
;-----------------------------------------------------------------------
@BEGIN_SUB B03_1_BuildTable
 
;	Because this can also run for Consolidated companies, direct table
;	access is required
 
;	----------
;	Initialise
;	----------
	@INTEGERS_CALC ERROR_CODE,			=,0
	@INTEGERS_CALC B03_Table_UBOUND,	=,0
	@NUMBERS_CALC  n_RunningBalance,	=,0
	@words_pad {w_Spaces,1,10},w_B03_Value 
	@words_pad {w_Spaces,1,11},w_B03_RunningBalance 
	@INTEGERS_CALC b_Start,				=,c_TRUE
 
;	-----------------------
;	Load Company Array
;	-----------------------
	@CALL A99_LoadCompany_Array
 
;	---------------------------
;	Loop thru Transaction Table
;	---------------------------
	@Repeat_for B02_Record_NO,1,B02_Table_UBOUND
 
		@TABLES_rget B02_Table,B02_Record_NO 
 
		@Repeat_for J,n_CpyIdx,12
			@ARRAYS_IF  n_Companies,{J},=,B02_Company
 
				@IF B02_TranDate,<,w_StartDate
					@CALL B03_1_1_RunningBalance
				@ELSE
 
					@IF B02_TranDate,>,w_EndDate
						@EXIT_sub B03_1_BuildTable
					@ELSE
 
						@_IF B02_DRAcctNo,=,x_AcctNo
						@_OR B02_CRAcctNo,=,x_AcctNo
						@_END
 
							@IF b_Start,=,c_TRUE
								@INTEGERS_CALC b_Start,=,c_FALSE
								@CALL B03_1_2_OpeningBalance
							@END_If
 
							@INTEGERS_CALC B03_TranRecNo,	=,B02_Record_NO
							;words_pad B02_TranDate,B03_TranDate 
							MOV RSI,B02_TranDate  
							MOV RDI,B03_TranDate  
							mov rcx,000010 
							Call _MOVSTR                         
							@INTEGERS_CALC B03_Company,		=,B02_Company
							@INTEGERS_CALC B03_DRAcctNo,	=,B02_DRAcctNo
							@INTEGERS_CALC B03_CRAcctNo,	=,B02_CRAcctNo
							@words_pad B02_Company,B03_Description 
							@IF B03_DRAcctNo,=,B01_AcctNo
								@words_pad B02_CRAcctNo,B03_Description 
							@ELSE
								@words_pad B02_DRAcctNo,B03_Description 
							@END_If
							@words_copy B02_Description,{B03_Description,7} 
							@NUMBERS_CALC  B03_Value,		=,B02_Value
 
							@CALL B03_1_1_RunningBalance
 
							@NUMBERS_CALC  B03_Table_UBOUND,=,B03_Table_UBOUND,+,1
							@IF B03_Table_UBOUND,>,c_B03_MaxRecords
								@Display_Line "B03_Table size has been exceeded"
								@TERMINATE 1
							@END_If
							@TABLES_rput B03_Table,B03_Table_UBOUND 
 
						@END_If
					@END_If
 
				@END_If
 
			@END_If
 
		@END_Repeat
 
	@END_Repeat
 
@END_SUB B03_1_BuildTable
 
;-----------------------------------------------------------------------
;	Running Balance
;-----------------------------------------------------------------------
@BEGIN_SUB B03_1_1_RunningBalance
 
	@IF B01_BalanceIndicator,=,'DR'
		@IF B02_DRAcctNo,=,B01_AcctNo
			@NUMBERS_CALC  n_RunningBalance,=,n_RunningBalance,+,B02_Value
		@ELSE
			@NUMBERS_CALC  n_RunningBalance,=,n_RunningBalance,-,B02_Value
		@END_If
	@ELSE
		@IF B02_CRAcctNo,=,B01_AcctNo
			@NUMBERS_CALC  n_RunningBalance,=,n_RunningBalance,+,B02_Value
		@ELSE
			@NUMBERS_CALC  n_RunningBalance,=,n_RunningBalance,-,B02_Value
		@END_If
	@END_If
 
	@NUMBERS_CALC  B03_RunningBalance,		=,n_RunningBalance
	;words_pad B01_BalanceIndicator,B03_BalanceIndicator 
	MOV RSI,B01_BalanceIndicator  
	MOV RDI,B03_BalanceIndicator  
	mov rcx,000002 
	Call _MOVSTR                                         
 
@END_SUB B03_1_1_RunningBalance
 
;-----------------------------------------------------------------------
;	Opening Balance
;-----------------------------------------------------------------------
@BEGIN_SUB B03_1_2_OpeningBalance
 
	@IF B02_Description,=,"Opening Balance"
		@EXIT_sub B03_1_2_OpeningBalance
	@END_If
 
 
 	@INTEGERS_CALC B03_TranRecNo,	=,0
	;words_pad w_StartDate,B03_TranDate 
	MOV RSI,w_StartDate  
	MOV RDI,B03_TranDate  
	mov rcx,000010 
	Call _MOVSTR                        
	@NUMBERS_CALC  B03_Company,		=,{w_Spaces,1,2}
	@NUMBERS_CALC  B03_DRAcctNo,	=,{w_Spaces,1,10}
	@NUMBERS_CALC  B03_CRAcctNo,	=,{w_Spaces,1,10}
	@words_pad "Opening Balance",B03_Description 
	@NUMBERS_CALC  B03_Value,		=,0
	@NUMBERS_CALC  B03_RunningBalance,=,n_RunningBalance
 
	@INTEGERS_CALC B03_Table_UBOUND,=,1
	@TABLES_rput B03_Table,B03_Table_UBOUND 
 
@END_SUB B03_1_2_OpeningBalance
 
;-----------------------------------------------------------------------
;	Account Enquiry Print
;-----------------------------------------------------------------------
@BEGIN_SUB B03_Process_Print
 
;	Because the Transaction Listing can not run Consolidated, we can
;	use the LAZARUS IO routines from here. They will return records
;	for the appropriate company
 
;	The Account Enquiry Print will work in 2 ways.
;	1] When the PRINT TRANSACTIONS option is "N" it will provide a trial balance
;	2] When the PRINT TRANSACTIONS option is "Y" it will provide a normal enquiry
 
;	The trick with this routine is to piggy back on the enquiry in that it will
;	iterately build the B03_Table for each subsequent account and use that to
;	print from. If in Trial Balance mode it will only use the running balance
;	from B03_Table
 
;	--------------------------------
;	Gets the 1st records
;	--------------------------------
	@INTEGERS_CALC x_Request,		=,c_Start
	@INTEGERS_CALC x_RecNo,			=,1
	@CALL B01_Process
   	@INTEGERS_CALC x_Request,		=,c_PreviousNext
 
	@INTEGERS_CALC n_LineCtr,		=,99
	@INTEGERS_CALC n_PageNo,		=,0
 
    @NUMBERS_CALC  n_TotalDebits,	=,0
    @NUMBERS_CALC  n_TotalCredits,	=,0
 
	@INTEGERS_CALC ERROR_CODE,		=,0
 
	@FILES_Open B03_PRINT,$write+$beginning
 
;	----------------------
;	Loop thru all accounts
;	----------------------
    @Repeat_while ERROR_CODE,=,0
 
		@IF B01_AcctNo,>,n_EndAcctNo
			@EXIT_repeat
		@ELSE
			@IF B01_AcctNo,!<,n_StartAcctNo
 
				@INTEGERS_CALC x_Accts,=,c_FALSE
				@CALL f_ValueAcct
 
				@IF RETURN_CODE,=,c_TRUE
					@INTEGERS_CALC x_AcctNo,=,B01_AcctNo
					@CALL B03_1_BuildTable
					@CALL B03_Process_Print_Details
				@END_If
 
			@END_If
		@END_If
 
		@CALL B01_Process
 
    @END_repeat
 
;	-----------------------
;	Totals if Trial Balance
;	-----------------------
	@IF w_PrintTrans,=,"N"
	    @words_pad {w_Spaces,1,80},w_prtLine 
	    @words_copy "==========",{w_prtLine,45} 
	    @words_copy "==========",{w_prtLine,56} 
	    @FILES $write,B03_PRINT,w_prtLine
	    @words_copy n_TotalDebits,{w_prtLine,45} 
	    @words_copy n_TotalCredits,{w_prtLine,56} 
	    @FILES $write,B03_PRINT,w_prtLine
	@END_If
 
	@FILES_Close B03_PRINT
 
@END_SUB B03_Process_Print
 
;-----------------------------------------------------------------------
;	Account Enquiry Print Headings
;-----------------------------------------------------------------------
@BEGIN_SUB B03_Process_Print_Headings
 
    @IF n_LineCtr,<,55
       @EXIT_Sub B03_Process_Print_Headings
    @END_If
    @FILES $write,B03_PRINT,x_NewPage
 
    @NUMBERS_CALC  n_PageNo,=,n_PageNo,+,1
 
	@FILES $write,B03_PRINT,w_Underlines
 
    @words_pad {w_Spaces,1,80},w_prtLine 
	@words_pad "B0300001",w_prtLine 
	@words_copy "TRANSACTION LISTING",{w_prtLine,11} 
	@words_copy "PAGE",{w_prtLine,72} 
	@words_copy n_PageNo,{w_prtLine,77} 
	@FILES $write,B03_PRINT,w_prtLine
 
	@FILES $write,B03_PRINT,w_Underlines
 
    @words_pad {w_Spaces,1,80},w_prtLine 
	@words_copy "Description",{w_prtLine,14} 
	@words_copy "Debit",{w_prtLine,50} 
	@words_copy "Credit",{w_prtLine,60} 
    @IF w_PrintTrans,=,"Y"
		@words_copy "Date",{w_prtLine,06} 
		@words_copy "Balance",{w_prtLine,72} 
	@END_If
	@FILES $write,B03_PRINT,w_prtLine
 
    @words_pad {w_Spaces,1,80},w_prtLine 
	@words_copy "===========",{w_prtLine,14} 
	@words_copy "=====",{w_prtLine,50} 
	@words_copy "======",{w_prtLine,60} 
    @IF w_PrintTrans,=,"Y"
		@words_copy "====",{w_prtLine,05} 
		@words_copy "=======",{w_prtLine,72} 
	@END_If
	@FILES $write,B03_PRINT,w_prtLine
 
    @INTEGERS_CALC n_LineCtr,=,6
 
@END_SUB B03_Process_Print_Headings
 
;-----------------------------------------------------------------------
;	Account Enquiry Print Details
;	This routine will be used for each account as they
;	are presented in B03_Table (which built for each account)
;-----------------------------------------------------------------------
@BEGIN_SUB B03_Process_Print_Details
 
	@IF w_PrintNewPage,=,"Y"
		@INTEGERS_CALC n_LineCtr,=,99
	@END_If
	@CALL B03_Process_Print_Headings
 
;	-------------------------------------------
;	Exit on No Transactions
;	else Get the Last Entry (for Trial Balance)
;	-------------------------------------------
  	@IF B03_Table_UBOUND,=,0
		@EXIT_sub B03_Process_Print_Details
  	@ELSE
		@TABLES_rget B03_Table,B03_Table_UBOUND 
	@END_If
 
;	-----------------------------------
;	If you don't want to print accounts
;	with zero Balance then exit
;	-----------------------------------
	@_IF w_PrintZero,=,"N"
	@_AND B03_RunningBalance,=,0
	@_END
		@EXIT_sub B03_Process_Print_Details
	@END_If
 
;	------------------------
;	Print the Account Header
;	------------------------
    @words_pad {w_Spaces,1,80},w_prtLine 
	@words_copy x_AcctNo,{w_prtLine,05} 
	@words_copy B01_Description,{w_prtLine,14} 
 
;	-------------
;	TRIAL BALANCE
;	-------------
	@IF w_PrintTrans,=,"N"
 
		@NUMBERS_CALC  n_RunningBalance,=,B03_RunningBalance
 
		@IF n_RunningBalance,<,0
		@NUMBERS_CALC  n_RunningBalance,=,n_RunningBalance,*,-1
			@IF B03_BalanceIndicator,=,"DR"
				@words_copy n_RunningBalance,{w_prtLine,56} 
				@NUMBERS_CALC  n_TotalCredits,=,n_TotalCredits,+,n_RunningBalance
			@ELSE
				@words_copy n_RunningBalance,{w_prtLine,45} 
				@NUMBERS_CALC  n_TotalDebits,=,n_TotalDebits,+,n_RunningBalance
			@END_If
		@ELSE
			@IF B03_BalanceIndicator,=,"DR"
				@words_copy n_RunningBalance,{w_prtLine,45} 
				@NUMBERS_CALC  n_TotalDebits,=,n_TotalDebits,+,n_RunningBalance
			@ELSE
				@words_copy n_RunningBalance,{w_prtLine,56} 
				@NUMBERS_CALC  n_TotalCredits,=,n_TotalCredits,+,n_RunningBalance
			@END_If
		@END_If
 
		@FILES $write,B03_PRINT,w_prtLine
		@NUMBERS_CALC  n_LineCtr,=,n_LineCtr,+,
		@EXIT_sub B03_Process_Print_Details
 
	@END_If
 
;	---------------
;	ACCOUNT LISTING
;	--------------
    @Repeat_for B03_Record_NO,1,B03_Table_UBOUND
 
		@TABLES_rget B03_Table,B03_Record_NO 
 
		@words_pad {w_Spaces,1,80},w_prtLine 
 
		@IF w_PrintTrans,=,"Y"
			@words_copy B03_TranDate,{w_prtLine,02} 
			@words_copy B03_Description,{w_prtLine,14} 
 
			@IF B03_Value,>,0
				@IF B03_DRAcctNo,=,x_AcctNo
					@words_copy B03_Value,{w_prtLine,45} 
					@NUMBERS_CALC  n_TotalDebits,=,n_TotalDebits,+,B03_Value
				@ELSE
					@words_copy B03_Value,{w_prtLine,56} 
					@NUMBERS_CALC  n_TotalCredits,=,n_TotalCredits,+,B03_Value
				@END_If
			@END_If
 
			@IF B03_RunningBalance,<,0
				@NUMBERS_CALC  B03_RunningBalance,=,B03_RunningBalance,*,-1
				@words_copy "(",{w_prtLine,67} 
				@words_copy ")",{w_prtLine,79} 
			@END_If
 
			@NUMBERS_CALC  n_RunningBalance,=,B03_RunningBalance
			@words_copy n_RunningBalance,{w_prtLine,69} 
			@FILES $write,B03_PRINT,w_prtLine
			@NUMBERS_CALC  n_LineCtr,=,n_LineCtr,+,
 
		@END_If
 
    @END_repeat
 
;	--------------
;	Account Totals
;	--------------
    @words_pad {w_Spaces,1,80},w_prtLine 
    @words_copy "==========",{w_prtLine,45} 
    @words_copy "==========",{w_prtLine,56} 
    @FILES $write,B03_PRINT,w_prtLine
    @words_copy n_TotalDebits,{w_prtLine,45} 
    @words_copy n_TotalCredits,{w_prtLine,56} 
    @FILES $write,B03_PRINT,w_prtLine
	@NUMBERS_CALC  n_LineCtr,=,n_LineCtr,+,
 
@END_SUB B03_Process_Print_Details
 
;-----------------------------------------------------------------------
;	Profit/Loss (Trading Statement) & Balance Sheet
;-----------------------------------------------------------------------
@BEGIN_SUB B04_Process
 
;	Because the Financial Reports can be run for multi-companies the
;	the tables are accessed directly. More so because a mult-company
;	report is in Account/Company order, an Alternate key is built and
;	used to acces the Chart of Account
 
;	---------------------------
;   Start & End Account Numbers
;	---------------------------
 	@INTEGERS_CALC n_ReportNo,			=,x_RecNo
	@IF n_ReportNo,_IN,{1,2}
       @INTEGERS_CALC n_StartAcctNo,=,40000
       @INTEGERS_CALC n_EndAcctNo,	=,59999
       @IF n_ReportNo,	=,1
       	  @words_pad "B0400001 Profit/Loss",w_ReportName 
       @ELSE
       	  @words_pad "B0400001 Trading Statement",w_ReportName 
       @END_If
    @ELSE
       @INTEGERS_CALC n_StartAcctNo,=,10000
       @INTEGERS_CALC n_EndAcctNo,	=,39999
       @words_pad "B0400001 Balance Sheet",w_ReportName 
    @END_If
 
;	--------------------
;	Accounts OKay ?
;	--------------------
 	@IF f_B04_1_ValidRequest
   		@CALL A99_LoadCompany_Array
   		@CALL B99_AltIndex
 	@ELSE
 		@INTEGERS_CALC RETURN_CODE,=,ERROR_CODE
 		@EXIT_sub B04_Process
 	@END_if
 
    @Arrays_Put n_Totals,{1},0    
    @Arrays_Put n_Totals,{2},0    
    @Arrays_Put n_Totals,{3},0    
    @Arrays_Put n_Totals,{4},0    
    @INTEGERS_CALC n_PreviousAcctNo,	=,0
    @NUMBERS_CALC  n_CtrlAcctBalance,=,0
 
 
	@INTEGERS_CALC n_LineCtr,		=,99
	@INTEGERS_CALC n_PageNo,		=,0
	@FILES_Open B04_PRINT,$write+$beginning
 
;	----------------------------------------
;	Loop thru the Alt Index - AcctNo/Company
;	----------------------------------------
	@Repeat_for n_Idx,1,B01_AltIdx_Table_UBOUND
 
		@TABLES_rget B01_AltIdx_Table,n_Idx 
		@TABLES_rget B01_Table,B01_AltIdx_RecNo 
 
         @_IF  n_PreviousAcctNo,>,0
         @_AND B01_AcctNo,		>,n_PreviousAcctNo
         @_END
             @CALL B04_2_DetailLine
         @END_If
 
         @INTEGERS_CALC n_PreviousAcctNo,	=,B01_AcctNo
         ;words_pad B01_Description,w_PreviousDescription 
         MOV RSI,B01_Description  
         MOV RDI,w_PreviousDescription  
         mov rcx,000030 
         Call _MOVSTR   
         mov RDI,w_PreviousDescription  
         add RDI,000030 
         mov RCX,000064 
         sub RCX,000030 
         Call _PADSTR                                     
         @INTEGERS_CALC n_PreviousCtrlAcctNo,=,B01_CntlAcctNo
         ;words_pad B01_Flag1,w_PreviousFlag1 
         MOV RSI,B01_Flag1  
         MOV RDI,w_PreviousFlag1  
         mov rcx,000002 
         Call _MOVSTR                         
         @INTEGERS_CALC n_PreviousFlag2,	=,B01_Flag2
         @INTEGERS_CALC n_PreviousFlag3,	=,B01_Flag3
         @INTEGERS_CALC n_PreviousFlag4,	=,B01_Flag4
         ;words_pad B01_BalanceIndicator,w_PreviousIndicator 
         MOV RSI,B01_BalanceIndicator  
         MOV RDI,w_PreviousIndicator  
         mov rcx,000002 
         Call _MOVSTR                                        
 
	@END_Repeat
 
;	--------
;	Last One
;	--------
	@CALL B04_2_DetailLine
	@INTEGERS_CALC ERROR_CODE,=,0
 
@END_SUB B04_Process
 
 
;-----------------------------------------------------------------------
;	Validation
;-----------------------------------------------------------------------
@BEGIN_FUNCTION f_B04_1_ValidRequest
 
;	-----------------------------
;   Not Required for Consolidated
;	-----------------------------
	@IF A01_ParameterNo,=,3
		@INTEGERS_CALC RETURN_CODE,=,c_TRUE
   		@EXIT_Function f_B04_1_ValidRequest
   	@END_If
 
;	---------------------------
;   PreRequisites
;	---------------------------
    @INTEGERS_CALC n_PAAcctNo,=,0
    @INTEGERS_CALC n_PLAcctNo,=,0
    @INTEGERS_CALC n_ASAcctNo,=,0
    @INTEGERS_CALC n_TOAcctNo,=,0
    @INTEGERS_CALC n_TCAcctNo,=,0
 
;	Because we have not exited this routine we now this is for a single company
;	and that we can use the internal routines to only return records for that company
 
	@INTEGERS_CALC x_Request,		=,c_Start
	@INTEGERS_CALC x_RecNo,			=,1
	@CALL B01_Process
	@INTEGERS_CALC x_Request,		=,c_PreviousNext
 
	@Repeat_while ERROR_CODE,!=,10
 
		@BEGIN_test B01_Flag1
			@WHEN =,"PA"
			@INTEGERS_CALC n_PAAcctNo,=,B01_AcctNo
			@WEND
			@WHEN =,"PL"
			@INTEGERS_CALC n_PLAcctNo,=,B01_AcctNo
			@WEND
			@WHEN =,"AS"
			@INTEGERS_CALC n_ASAcctNo,=,B01_AcctNo
			@WEND
			@WHEN =,"TO"
			@INTEGERS_CALC n_TOAcctNo,=,B01_AcctNo
			@WEND
			@WHEN =,"TC"
			@INTEGERS_CALC n_TCAcctNo,=,B01_AcctNo
			@WEND
		@END_test
 
		@CALL B01_Process
 
	@END_repeat
 
;	----------------------------------
;   Get PA Account if not Consolidated
;	----------------------------------
   	@IF n_ReportNo,_IN,{1,2}
      	@IF 0,_IN,{n_PAAcctNo,n_PLAcctNo}
      		@INTEGERS_CALC ERROR_CODE,=,1
      		@EXIT_Function f_B04_1_ValidRequest
      	@END_If
    @END_If
 
;	---------------------------
;   Maintain Stock Transactions
;	---------------------------
	@IF n_ReportNo,=,2
      	@IF 0,_IN,{n_ASAcctNo,n_TOAcctNo,n_TCAcctNo}
      		@INTEGERS_CALC ERROR_CODE,=,2
      		@EXIT_Function f_B04_1_ValidRequest
      	@END_If
 
      	@CALL B04_1_1_StockTransactions
    @END_If
 
	@INTEGERS_CALC RETURN_CODE,=,c_TRUE
 
@END_FUNCTION f_B04_1_ValidRequest
 
;-----------------------------------------------------------------------
;   Maintain Stock Transactions
;-----------------------------------------------------------------------
@BEGIN_SUB B04_1_1_StockTransactions
 
;	This is only done when running for a single company so we can use
;	the internal routines to only work with that company
 
;	It 1st deletes the existing 2 stock transfer records and creates
;	a new record to transfer Stock On Hand ("AS") to Opening Stock ("TO")
;	and then to transfer Closing Stock ("TC") to Stock On Hand
 
;	--------------------------------
;	Gets the 1st records
;	--------------------------------
	@INTEGERS_CALC x_Request,		=,c_Start
	@INTEGERS_CALC x_RecNo,			=,1
	@CALL B02_Process
	@INTEGERS_CALC x_Request,		=,c_PreviousNext
 
;   Process
	@NUMBERS_CALC  n_AcctBalance,=,0
 
	@Repeat_while ERROR_CODE,!=,10
 
	;	---------------------
	;	Delete TO Transaction
	;	---------------------
		@IF B02_DRAcctNo,=,n_TOAcctNo
			@INTEGERS_CALC x_Request,=,c_Delete
			@INTEGERS_CALC x_RecNo,	=,B02_Record_NO
			@CALL B02_Process
 
			@INTEGERS_CALC x_Request,=,c_Read
			@INTEGERS_CALC x_RecNo,	=,B02_Record_NO
			@CALL B02_Process
 
        @END_If
 
	;	---------------------
	;	Delete TC Transaction
	;	---------------------
      	@IF B02_CRAcctNo,=,n_TCAcctNo
			@INTEGERS_CALC x_Request,=,c_Delete
			@INTEGERS_CALC x_RecNo,	=,B02_Record_NO
			@CALL B02_Process
 
			@INTEGERS_CALC x_Request,=,c_Read
			@INTEGERS_CALC x_RecNo,	=,B02_Record_NO
			@CALL B02_Process
 
		@END_If
 
	;	---------------------
	;	Get Balance
	;	TO and TC transaction posted to this account will
	;	now have been removed by virtue of the above steps
	;	---------------------
      	@IF B02_DRAcctNo,=,n_ASAcctNo
         	@NUMBERS_CALC  n_AcctBalance,=,n_AcctBalance,+,B02_Value
        @END_If
 
        @IF B02_CRAcctNo,=,n_ASAcctNo
        	@NUMBERS_CALC  n_AcctBalance,=,n_AcctBalance,-,B02_Value
        @END_If
 
       	@INTEGERS_CALC x_Request,=,c_PreviousNext
		@CALL B02_Process
 
	@END_repeat
 
;	-----------------------------------------------------------------------
;   Assuming that the Stock account will never have a credit balance
;   AS to TO
;	-----------------------------------------------------------------------
	@INTEGERS_CALC B02_Company,			=,A01_Parameter
	;words_pad w_Date,B02_TranDate 
	MOV RSI,w_Date  
	MOV RDI,B02_TranDate  
	mov rcx,000010 
	Call _MOVSTR                   
	@words_pad "23:59:01",B02_TranTime 
	@INTEGERS_CALC B02_DRAcctNo,		=,n_TOAcctNo
	@INTEGERS_CALC B02_CRAcctNo,		=,n_ASAcctNo
	@words_pad "Stock on Hand to Opening Stock",B02_Description 
	@NUMBERS_CALC  B02_Value,				=,n_AcctBalance
		@words_pad B02_Value,w_B02_Value 
	@INTEGERS_CALC B02_DRCtrlAcctNo,=,0
	@INTEGERS_CALC B02_CRCtrlAcctNo,=,0
	@INTEGERS_CALC B02_NoOfUnits,		=,0
	@words_pad "System",B02_Reference 
	@INTEGERS_CALC B02_INVTranType,	=,0
	@INTEGERS_CALC B02_INVAcctNo,		=,0
	@INTEGERS_CALC B02_INVParcelNo,	=,0
	@INTEGERS_CALC B02_INVGrouping,	=,0
 
		@words_pad "0",w_B02_FrankedAmt 
		@words_pad "0",w_B02_ImputedCredit 
		@words_pad "0",w_B02_SUnitPrice 
 
	@words_pad " ",B02_SReference 
 
	@INTEGERS_CALC x_Request,	=,c_Write
	@INTEGERS_CALC x_RecNo,	=,0
	@CALL B02_Process
 
;	--------
;   TC to AS
;	--------
	@INTEGERS_CALC B02_Company,			=,A01_Parameter
	;words_pad w_Date,B02_TranDate 
	MOV RSI,w_Date  
	MOV RDI,B02_TranDate  
	mov rcx,000010 
	Call _MOVSTR                   
	@words_pad "23:59:02",B02_TranTime 
	@INTEGERS_CALC B02_DRAcctNo,		=,n_ASAcctNo
	@INTEGERS_CALC B02_CRAcctNo,		=,n_TCAcctNo
	@words_pad "Closing Stock to Stock on Hand",B02_Description 
	@NUMBERS_CALC  B02_Value,			=,w_Closing
		@words_pad B02_Value,w_B02_Value 
	@INTEGERS_CALC B02_DRCtrlAcctNo,	=,0
	@INTEGERS_CALC B02_CRCtrlAcctNo,	=,0
	@INTEGERS_CALC B02_NoOfUnits,		=,0
	@words_pad "System",B02_Reference 
	@INTEGERS_CALC B02_INVTranType,		=,0
	@INTEGERS_CALC B02_INVAcctNo,		=,0
	@INTEGERS_CALC B02_INVParcelNo,		=,0
	@INTEGERS_CALC B02_INVGrouping,		=,0
 
		@words_pad "0",w_B02_FrankedAmt 
		@words_pad "0",w_B02_ImputedCredit 
		@words_pad "0",w_B02_SUnitPrice 
 
	@words_pad " ",B02_SReference 
 
	@INTEGERS_CALC x_Request,=,c_Write
	@INTEGERS_CALC x_RecNo,	=,0
	@CALL B02_Process
 
@END_SUB B04_1_1_StockTransactions
 
;-----------------------------------------------------------------------
;   Print the Detail Line
;-----------------------------------------------------------------------
@BEGIN_SUB B04_2_DetailLine
 
	@CALL B04_1_1_1_Headings
    @words_pad {w_Spaces,1,80},w_prtLine 
 
;	-----
;   Clear
;	-----
	@IF w_PreviousFlag1,=,"C "
		@Arrays_Put n_Totals,{n_PreviousFlag4},0    
		@EXIT_Sub B04_2_DetailLine
    @END_If
 
;	----
;   Text
;	----
	@IF w_PreviousFlag1,=,"X "
		m001 ; I = [N_PREVIOUSFLAG2 * 2] - 1                             
		@words_copy w_PreviousDescription,{w_prtLine,I} 
		@FILES $write,B04_PRINT,w_prtLine
		@NUMBERS_CALC  n_LineCtr,=,n_LineCtr,+,1
		@EXIT_Sub B04_2_DetailLine
   @END_If
 
;	------
;   Totals
;	------
	@IF w_PreviousFlag1,_IN,{"T ","BA"}
		@CALL B04_1_1_1_Totals
		@EXIT_Sub B04_2_DetailLine
   @END_If
 
;	-----------
;   Profit/Loss
;	-----------
   @IF  w_PreviousFlag1,=,"PL"
      	@CALL B04_1_1_1_Totals
      	@CALL B04_1_1_2_ProfitLoss
		@EXIT_Sub B04_2_DetailLine
   @END_If
 
;	-----------
;   Get Balance
;	-----------
	@INTEGERS_CALC x_Accts,		=,c_FALSE
	;words_pad B01_Flag1,w_saveFlag1 
	MOV RSI,B01_Flag1  
	MOV RDI,w_saveFlag1  
	mov rcx,000002 
	Call _MOVSTR                     
	;words_pad w_PreviousFlag1,B01_Flag1 
	MOV RSI,w_PreviousFlag1  
	MOV RDI,B01_Flag1  
	mov rcx,000002 
	Call _MOVSTR                         
	@CALL f_ValueAcct
 
	@IF RETURN_CODE,=,c_TRUE
 
		@CALL B04_1_1_3_GetBalance
 
		;--------------------------
		;Control Account Processing
		;--------------------------
	    @IF w_Sub,=,"C"
	    	@IF n_PreviousCtrlAcctNo,=,99999
	    		@NUMBERS_CALC  n_AcctBalance,	=,n_CtrlAcctBalance
	    		@NUMBERS_CALC  n_CtrlAcctBalance,=,0
	    	@ELSE
        		@IF  n_PreviousCtrlAcctNo,>,0
	    			@NUMBERS_CALC  n_CtrlAcctBalance,=,n_CtrlAcctBalance,+,n_AcctBalance
	    			@EXIT_SUB B04_2_DetailLine
	    		@END_If
            @END_If
        @END_If
 
		;-----
		;Print
		;-----
		@IF n_AcctBalance,!=,0
 
			;-----------
			;Description
			;-----------
			m002 ; I = [N_PREVIOUSFLAG2 * 2] - 1                             
			@words_copy w_PreviousDescription,{w_prtLine,I} 
 
			;-----------
			;Balance
			;-----------
			@NUMBERS_CALC  n_Value,=,n_AcctBalance
            @Arrays_Add n_Totals,{n_PreviousFlag3},n_Value     
 
            m003 ; N_VALUELOCATION = [N_PREVIOUSFLAG3 * 10] + 32                             
 
            @IF  w_PreviousIndicator,	=,"DR"
            	@IF n_Value,<,0
            		@INTEGERS_CALC I,=,n_ValueLocation,-,1
            		@words_copy "(",{w_prtLine,I} 
            		@INTEGERS_CALC I,=,n_ValueLocation,+,7
            		@words_copy ")",{w_prtLine,I} 
            	@END_If
            @END_If
 
            @IF  w_PreviousIndicator,	=,"CR"
            	@IF n_Value,>,0
            		@INTEGERS_CALC I,=,n_ValueLocation,-,1
            		@words_copy "(",{w_prtLine,I} 
            		@INTEGERS_CALC I,=,n_ValueLocation,+,7
            		@words_copy ")",{w_prtLine,I} 
            	@END_If
            @END_If
 
            @IF n_Value,<,0
            	@INTEGERS_CALC n_Value,=,n_Value,*,-1
            @END_If
 
            @words_copy n_Value,{w_prtLine,n_ValueLocation} 
 
			@FILES $write,B04_PRINT,w_prtLine
			@NUMBERS_CALC  n_AcctBalance,=,0
 
		@END_If
 
	@END_If
 
	;words_pad w_saveFlag1,B01_Flag1 
	MOV RSI,w_saveFlag1  
	MOV RDI,B01_Flag1  
	mov rcx,000002 
	Call _MOVSTR                     
 
@END_SUB B04_2_DetailLine
 
;-----------------------------------------------------------------------
;   Print the Headings
;-----------------------------------------------------------------------
@BEGIN_SUB B04_1_1_1_Headings
 
	@IF n_LineCtr,<,55
		@EXIT_Sub B04_1_1_1_Headings
	@END_If
 
	@NUMBERS_CALC  n_PageNo,=,n_PageNo,+,1
 
	@FILES $write,B04_PRINT,w_Underlines
 
    @words_pad {w_Spaces,1,80},w_prtLine 
	;words_pad w_ReportName,w_prtLine 
	MOV RSI,w_ReportName  
	MOV RDI,w_prtLine  
	mov rcx,000030 
	Call _MOVSTR   
	mov RDI,w_prtLine  
	add RDI,000030 
	mov RCX,000080 
	sub RCX,000030 
	Call _PADSTR                      
	@words_copy "PAGE",{w_prtLine,72} 
	@words_copy n_PageNo,{w_prtLine,77} 
	@FILES $write,B04_PRINT,w_prtLine
 
	@FILES $write,B04_PRINT,w_Underlines
 
	@INTEGERS_CALC n_LineCtr,=,3
 
@END_SUB B04_1_1_1_Headings
 
 
;-----------------------------------------------------------------------
;   Totals processing
;-----------------------------------------------------------------------
@BEGIN_SUB B04_1_1_1_Totals
 
	@Arrays_Get n_Totals,{n_PreviousFlag4},n_Value    
	m004 ; N_VALUELOCATION = [N_PREVIOUSFLAG3 * 10] + 32                             
 
	m005 ; I = [N_PREVIOUSFLAG4 * 10] + 32 - 1                             
    @words_copy "---------",{w_prtLine,I} 
	@FILES $write,B04_PRINT,w_prtLine
 	@NUMBERS_CALC  n_LineCtr,=,n_LineCtr,+,1
    @words_pad {w_Spaces,1,80},w_prtLine 
 
 
	m006 ; J = [N_PREVIOUSFLAG2 * 2] - 1                             
	@words_copy w_PreviousDescription,{w_prtLine,J} 
 
 
	@IF n_PreviousFlag4,<,4
		@INTEGERS_CALC I,=,n_PreviousFlag4,+,1
		@Arrays_Add n_Totals,{I},n_Totals,{n_PreviousFlag4}    
	@END_If
 
	@IF  w_PreviousIndicator,	=,"DR"
		@IF n_Value,<,0
            @INTEGERS_CALC I,=,n_ValueLocation,-,1
			@words_copy "(",{w_prtLine,I} 
			@INTEGERS_CALC I,=,n_ValueLocation,+,7
			@words_copy ")",{w_prtLine,I} 
		@END_If
	@END_If
 
	@IF  w_PreviousIndicator,	=,"CR"
		@IF n_Value,>,0
            @INTEGERS_CALC I,=,n_ValueLocation,-,1
			@words_copy "(",{w_prtLine,I} 
			@INTEGERS_CALC I,=,n_ValueLocation,+,7
			@words_copy ")",{w_prtLine,I} 
		@END_If
	@END_If
 
	@IF n_Value,<,0
		@INTEGERS_CALC n_Value,=,n_Value,*,-1
	@END_If
 
    @words_copy n_Value,{w_prtLine,n_ValueLocation} 
 
	@FILES $write,B04_PRINT,w_prtLine
 	@NUMBERS_CALC  n_LineCtr,=,n_LineCtr,+,1
 
@END_SUB B04_1_1_1_Totals
 
;-----------------------------------------------------------------------
;   Profit/Loss processing
;-----------------------------------------------------------------------
@BEGIN_SUB B04_1_1_2_ProfitLoss
 
;	This is only done when running for a single company so we can use
;	the internal routines to only work with that company
 
;	It 1st deletes the existing Profit/Loss transfer and writes a new one
;	transfering Profit/Loss ("PL") to Accumulated Profit/Loss ("POA")
 
;	------------------------
;	Only if NOT Consolidated
;	------------------------
	@IF A01_Company02,!=,0
		@EXIT_sub B04_1_1_2_ProfitLoss
	@END_If
 
;	------------------------
;   Delete current record
;	------------------------
	@INTEGERS_CALC x_Request,		=,c_Start
	@INTEGERS_CALC x_RecNo,			=,1
	@CALL B02_Process
   	@INTEGERS_CALC x_Request,			=,c_PreviousNext
 
	@Repeat_for I,1,B02_Table_UBOUND
		@_IF B02_DRAcctNo,=,n_PAAcctNo
		@_OR B02_CRAcctNo,=,n_PAAcctNo
		@_END
			@INTEGERS_CALC x_Request,=,c_Delete
			@INTEGERS_CALC x_RecNo,	=,B02_Record_NO
			@CALL B02_Process
			@EXIT_Repeat
		@ELSE
			@CALL B02_Process
		@END_If
 
	@END_Repeat
 
   @INTEGERS_CALC B02_Company,				=,A01_Parameter
   ;words_pad w_Date,B02_TranDate 
   MOV RSI,w_Date  
   MOV RDI,B02_TranDate  
   mov rcx,000010 
   Call _MOVSTR                   
   @words_pad "23:59:03",B02_TranTime 
   @ARRAYS_IF n_Totals,{n_PreviousFlag4},>,0
      @INTEGERS_CALC B02_DRAcctNo,			=,n_PAAcctNo
      @INTEGERS_CALC B02_CRAcctNo,			=,n_PreviousAcctNo
      @words_pad "Loss",B02_Description 
      @INTEGERS_CALC I,=,n_PreviousFlag4
      @Arrays_Get n_Totals,{I},J    
      @NUMBERS_CALC  B02_Value,=,J
      	@words_pad B02_Value,w_B02_Value 
   @ELSE
      @INTEGERS_CALC B02_DRAcctNo,			=,n_PreviousAcctNo
      @INTEGERS_CALC B02_CRAcctNo,			=,n_PAAcctNo
      @words_pad "Profit",B02_Description 
      @INTEGERS_CALC I,=,n_PreviousFlag4
      @Arrays_Get n_Totals,{I},J    
      @NUMBERS_CALC  B02_Value,=,J,*,-1
      	@words_pad B02_Value,w_B02_Value 
   @END_If
   @INTEGERS_CALC B02_DRCtrlAcctNo,		=,0
   @INTEGERS_CALC B02_CRCtrlAcctNo,		=,0
   @INTEGERS_CALC B02_NoOfUnits,			=,0
	@words_pad "System",B02_Reference 
   @INTEGERS_CALC B02_INVTranType,			=,0
   @INTEGERS_CALC B02_INVAcctNo,			=,0
   @INTEGERS_CALC B02_INVParcelNo,			=,0
   @INTEGERS_CALC B02_INVGrouping,			=,0
 
   @words_pad "0",w_B02_FrankedAmt 
   @words_pad "0",w_B02_ImputedCredit 
   @words_pad "0",w_B02_SUnitPrice 
 
   @words_pad 0,B02_SReference 
 
   @INTEGERS_CALC x_Request,=,c_Write
   @INTEGERS_CALC x_RecNo,	=,0
   @CALL B02_Process
 
;	-------------------------------------------------------------
;	Because B02_Process has validated the B02_Record by referring
;	to B01 we need to re-read B01 to get the current record
;	-------------------------------------------------------------
   	@TABLES_rget B01_Table,B01_AltIdx_RecNo 
 
@END_SUB B04_1_1_2_ProfitLoss
 
;-----------------------------------------------------------------------
;   Get the Account Balance
;-----------------------------------------------------------------------
@BEGIN_SUB B04_1_1_3_GetBalance
;
;	Reading thru the whole file here because we could be consolidated
 
    @NUMBERS_CALC  n_AcctBalance,=,0
    @INTEGERS_CALC n_NoOfUnits,=,0
 
    @Repeat_for B02_Record_NO,1,B02_Table_UBOUND
 
   		@TABLES_rget B02_Table,B02_Record_NO 
 
		@Repeat_for J,n_CpyIdx,12
			@ARRAYS_IF  n_Companies,{J},=,B02_Company
 
				@_IF  B01_AcctNo,!<,n_StartAcctNo
				@_AND B01_AcctNo,!>,n_EndAcctNo
				@_END
 
 
					@_IF  B02_DRAcctNo,=,n_PreviousAcctNo
					@_AND B02_TranDate,<=,w_Date
					@_END
						@NUMBERS_CALC  n_AcctBalance,=,n_AcctBalance,+,B02_Value
						@INTEGERS_CALC n_NoOfUnits,	 =,n_NoOfUnits,+,B02_NoOfUnits
					@END_If
 
					@_IF  B02_CRAcctNo,=,n_PreviousAcctNo
					@_AND B02_TranDate,<=,w_Date
					@_END
						@NUMBERS_CALC  n_AcctBalance,=,n_AcctBalance,-,B02_Value
						@INTEGERS_CALC n_NoOfUnits,	 =,n_NoOfUnits,-,B02_NoOfUnits
					@END_If
 
				@END_If
			@END_If
 
		@END_Repeat
 
    @END_Repeat
 
@END_SUB B04_1_1_3_GetBalance
 
 
;-----------------------------------------------------------------------
;	Build Alternate Index for Chart of Account
;-----------------------------------------------------------------------
@BEGIN_SUB B99_AltIndex
 
	@INTEGERS_CALC B01_AltIdx_Table_UBOUND,=,0
	@Repeat_for I,1,B01_Table_UBOUND
		@TABLES_rget B01_Table,I 
		@Repeat_for J,n_CpyIdx,12
			@ARRAYS_IF  n_Companies,{J},=,B01_Company
 
				@_IF  B01_AcctNo,!<,n_StartAcctNo
				@_AND B01_AcctNo,!>,n_EndAcctNo
				@_END
					@INTEGERS_CALC B01_AltIdx_AcctNo,	=,B01_AcctNo
					@INTEGERS_CALC B01_AltIdx_Company,	=,B01_Company
					@INTEGERS_CALC B01_AltIdx_RecNo,	=,I
					@NUMBERS_CALC  B01_AltIdx_Table_UBOUND,=,B01_AltIdx_Table_UBOUND,+,1
					@TABLES_rput B01_AltIdx_Table,B01_AltIdx_Table_UBOUND 
 
				@END_If
 
			@END_If
		@END_repeat
	@END_Repeat
 
	@TABLES_sort B01_AltIdx_Table,1,7
 
@END_SUB B99_AltIndex
 
;-----------------------------------------------------------------------
;	load the Company Array
;-----------------------------------------------------------------------
@BEGIN_SUB A99_LoadCompany_Array
 
	@BEGIN_assembler
		mov rsi,A01_Company01
		mov rdi,n_Companies
		add rdi,8
		mov rcx,12
	_loop:
		push qword[rsi]
		pop  qword[rdi]
		add	 rsi,35
		add  rdi,8
		loop _loop
	@END_assembler
	@ARRAYS_Sort n_Companies
 
	@Repeat_for n_CpyIdx,1,12
		@ARRAYS_IF n_Companies,{n_CpyIdx},!=,0
			@EXIT_repeat
		@END_If
	@END_repeat
 
@END_SUB A99_LoadCompany_Array
 
;-----------------------------------------------------------------------
;	Date
;-----------------------------------------------------------------------
@BEGIN_SUB B99_Process
 
;	----------
;	Initialise
;	----------
	@INTEGERS_CALC ERROR_CODE,=,0
 
;	----------------
;	Get current date
;	----------------
	@IF x_Request,=,c_B99_GetDate
		@INTEGERS_CALC ERROR_CODE,=,0
		@DATE_Get  I,w_Date 
		@IF ERROR_CODE,!=,0
			@INTEGERS_CALC ERROR_CODE,=,99
		@END_If
	@END_If
 
;	---------------
;	Validate a date
;	---------------
	@IF x_Request,=,c_B99_ValidDate
		@INTEGERS_CALC ERROR_CODE,=,0
		@DATE_DaysFromDate  I,w_Date 
		@IF ERROR_CODE,!=,0
			@INTEGERS_CALC ERROR_CODE,=,99
		@END_If
	@END_If
 
 
@END_SUB B99_Process
 
 
;=======================================================================
;	FINALISATION
;=======================================================================
@BEGIN_SUB Z_1_Finalise
 
;	---------------
;	Write A01_Table
;	---------------
	@FILES_Open A01_FILE,$write+$beginning
	@Repeat_for A01_Record_NO,1,A01_Table_UBOUND
		@TABLES_rget A01_Table,A01_Record_NO 
		@FILES $write,A01_FILE, \
			A101,A102,A103,A104,A105,A106,A107,A108,A109,A110,A110, \
			A111,A112,A113,A114,A115,A116,A117,A118,A119,A120
	@END_Repeat
	@FILES_Close A01_FILE
 
;	---------------
;	Write B01_Table
;	---------------
	@FILES_Open B01_FILE,$write+$beginning
	@Repeat_for  B01_Record_NO,1,B01_Table_UBOUND 
		@TABLES_rget B01_Table,B01_Record_NO 
		@FILES $write,B01_FILE, \
			B101,B102,B103,B104,B105,B106,B107,B108,B109,B110,B111
	@END_Repeat
	@FILES_Close B01_FILE
 
;	---------------
;	Write B02_Table
;	---------------
	@FILES_Open B02_FILE,$write+$beginning
	@Repeat_for  B02_Record_NO,1,B02_Table_UBOUND 
		@TABLES_rget B02_Table,B02_Record_NO 
		@FILES $write,B02_FILE, \
			B201,B202,B203,B204,B205,B206,B207,B208,B209,B210, \
			B211,B212,B213,B214,B215,B216,B217,B218,B219
	@END_Repeat
	@FILES_Close B02_FILE
 
@END_SUB Z_1_Finalise
