unit enquire1;

{$mode ObjFPC}{$H+}
{$R *.lfm}

{ ============================================================================= }
{ INTERFACE - Gloablity                                                         }
{ ============================================================================= }
{	The "interface" section of a Pascal UNIT exports PUBLIC variables, constants	}
{ types, and routines, while the USES clause imports exported identifiers from	}
{ another UNITS interface section }

	interface

	{	EXTERNAL }
		uses
			Classes,SysUtils,Forms,Controls,Graphics,Dialogs,StdCtrls,ComCtrls,ExtCtrls,
			LCLType,ExtDlgs,StrUtils,Math;

		type

			{ TEnq1 }

   TEnq1 = class(TForm)

				Label1								:TLabel;
					acctno							:TEdit;
					acctno_spinner			:TUpDown;
					acctno_description	:TLabel;
				Label3								:TLabel;
					start_dd						:TEdit;
					start_mm						:TEdit;
					start_ccyy					:TEdit;
				Label4								:TLabel;
					end_dd							:TEdit;
					end_mm							:TEdit;
					end_ccyy						:TEdit;
				ListView							:TListView;

				pfkey									:TPanel;
 				Calc									:TPanel;
					calc1								:TEdit;
					calc2								:TEdit;
					result								:TButton;
					calcWhat						:TButton;

        procedure FormCreate(Sender:TObject);
				procedure FormShow(Sender:TObject);
				procedure FormKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
				procedure ListViewClick(Sender:TObject);
				procedure onKeyPress(Sender:TObject;var Key:char);
				procedure acctnoKeyUp(Sender:TObject;var Key:Word;Shift:TShiftState);
				procedure acctno_spinnerClick(Sender:TObject;Button:TUDBtnType);

				procedure calc2KeyUp(Sender:TObject;var Key:Word;Shift:TShiftState);

				private
				public
			end;

		var

			Enq1: TEnq1;


{ ============================================================================= }
{ IMPLEMENTATION- private/Local                                                 }
{ ============================================================================= }
{	The "inplementation" section declares PRIVATE variables, constants, types, 		}
{ and routines. }

  Implementation
		uses
			unit0, enquire2, search1, journal1;

 	{ NOTE:- procedures/functions declared in the implementation section must			}
	{	contain the keyword "forward"																								}

		procedure TRAN_LISTVIEW(); forward;
		procedure DOCALC(); forward;

{ =============================================================================}
{ PROCEDURES/FUNCTIONS                                                         }
{ =============================================================================}

{ -----------------------------------------------------------------------------}
{ on Create														                                         }
{ -----------------------------------------------------------------------------}
	procedure TEnq1.FormCreate(Sender:TObject);
	begin

		{ Form to get Keystroke 1st	}
		KeyPreview := true;

	end;

{ ----------------------------------------------------------------------------}
{ Form Show	setup Defaults																										}
{ ----------------------------------------------------------------------------}
	procedure TEnq1.FormShow(Sender:TObject);
	begin

		Enq1.Caption := Format('%0.2d',[A01_Parameter]) + ' Account Enquiry';

		If A01_ParameterNo = 3 then
			begin
    		acctno_spinner.Visible 			:= false;
  			acctno.Text									:= '0';
  			acctno_description.Caption	:= '';
			end
		else
			begin
    		acctno_spinner.Visible 			:= true;
				l1_Call(c_B01,c_Start,1,0,0);
    		acctno.Text									:= IntToStr(B01_AcctNo);
    		acctno_description.Caption	:= B01_Description;
			end
		; // END IF

   	start_dd.Text								:= '01';
   	start_mm.Text								:= '07';
		X							 							:= nFinancialYear - 1;
   	start_ccyy.Text							:= IntToStr(X);

   	end_dd.Text									:= '30';
   	end_mm.Text									:= '06';
   	end_ccyy.Text								:= IntToStr(nFinancialYear);

 		Enq1.ListView.Items.Clear;

	end;

{ -----------------------------------------------------------------------------}
{ on form key down check for function keys                                     }
{ -----------------------------------------------------------------------------}
	procedure TEnq1.FormKeyUp(Sender:TObject;var Key:Word;Shift:TShiftState);
	begin

	{	----------- }
	{	PF3 - Print }
	{	----------- }
		If  (key = 114) then
			If A01_ParameterNo = 2 then
				begin
					Key := 0;
     			Enq2.ShowModal
				end // END BEGIN
			; // END IF
    ; // End If

	{	------------ }
	{	PF5 - Accept }
	{	------------ }
		If  (key = 116) then
			begin
				Key 	:= 0;
				TRAN_LISTVIEW;
			end
		; // END IF


	{	------------ }
	{	calculator	 }
	{	------------ }
		If  (key = 112) then
			begin
				calc1.Text			:= result.Caption;
				calc2.Text			:= '0.00';
				result.Caption	:= '0.00';
				calc2.SetFocus;
				exit;
			end // END BEGIN
    ; // END IF

    case key of 107,109,106,111:
			begin
				case key of
					107 : calcWhat.Caption := '+';
					109 : calcWhat.Caption := '-';
					106 : calcWhat.Caption := '*';
					111 : calcWhat.Caption := '/';
				end; // END CASE

				key := 0;
				DOCALC;
				calc2.SetFocus;

			end // END BEGIN
		end; // END CASE

	end;

{ -----------------------------------------------------------------------------}
{ Only allow numeric characters                                            		 }
{ -----------------------------------------------------------------------------}
	procedure TEnq1.onKeyPress(Sender:TObject;var Key:char);
	begin

			If Key = '.' then
				If (Sender = calc1)
				Or (Sender = calc2) then
			else
				begin
					Key := #0;
					exit;
				end;
			; // END IF

 		If not (Key in ['0'..'9', Char(VK_BACK), Char(VK_DELETE)]) then Key := #0;

	end;

{ -----------------------------------------------------------------------------}
{ Account Search					                                                     }
{ -----------------------------------------------------------------------------}
	procedure TEnq1.acctnoKeyUp(Sender:TObject;var Key:Word;Shift:TShiftState);
	begin

	{	------------ }
	{	PF2 - Search }
	{	------------ }
		If  (key = 113) and (A01_ParameterNo = 2) then
			begin
				Key 		:= 0;
				S.ID		:= 4;
				S.Acct	:= StrToInt(acctno.Text);
     		Sch1.ShowModal;
			end // END BEGIN
		; // End If

	end;

{ -----------------------------------------------------------------------------}
{ Account No Spinner                                                 				   }
{ -----------------------------------------------------------------------------}
	procedure TEnq1.acctno_spinnerClick(Sender:TObject;Button:TUDBtnType);
	begin

  	If Button = btNext then
			X := 1
		else
			X := -1
		; // END IF

		X := ACCT_SPINNER(StrToInt(acctno.Text),X);
		If (X > 0) then
			begin
				acctno.Text 								:= IntToStr(X);
				acctno_description.Caption	:= B01_Description;
			end // END BEGIN
		; // END IF

	end;

{ -----------------------------------------------------------------------------}
{	populate ListView																														 }
{ -----------------------------------------------------------------------------}
	procedure TRAN_LISTVIEW();
	var
		Line		: TListItem;

	begin
		w_StartDate	:= l1_getDate(Enq1.start_dd.Text,Enq1.start_mm.Text,Enq1.start_ccyy.Text);
		w_EndDate		:= l1_getDate(Enq1.end_dd.Text,Enq1.end_mm.Text,Enq1.end_ccyy.Text);
		X 					:= StrToInt(Enq1.acctno.Text);    { Consolidated Accounts rely on the acct no being correct }

		If A01_ParameterNo = 2 then
			b01_recNo		:= l1_findAcct(X,l1_False)
		; // END IF

		If A01_ParameterNo = 3 then
			b01_recNo		:= l1_findConsAcct(X,l1_False)
		; // END IF

		If RETURN_CODE <> 0 then
			begin
				MessageDlgPos('Account does not exist', mtConfirmation, [mbYes, mbNo, mbCancel],0,150,150);
				exit;
			end // END BEGIN
		; // END IF

		CurrencyString:= '';
		Enq1.ListView.Items.Clear;

		l1_Call(c_B03,c_Enquire,0,X,0);
		If RETURN_CODE <> 0 then
			exit;

	{	----------------- }
	{	Transactions Loop	}
	{	----------------- }
		X	:= 0;
		while 1=1 do
			begin

			{ get Record }
				X := X + 1;
				l1_Call(c_B03,c_Read,X,0,0);
				if RETURN_CODE <> 0 then
						break;

				Str := MidStr(B03_TranDate,1,4);
				Str := Str + '/' + MidStr(B03_TranDate,6,2);
				Str := Str + '/' + MidStr(B03_TranDate,9,2);

			{ Populate ListView }
				Line := Enq1.ListView.Items.add;
					Line.Caption:= Format('%0.3d',[B03_TranRecNo]);
						Line.SubItems.Add(Str);
						If A01_parameterNo = 3 then
							Str := Format('%0.2d',[B03_Company]) + ' ' + B03_Description
						else
							Str := B03_Description
						; // END IF
						Line.SubItems.Add(Str);

					{ DEBIT or CREDIT }
  					Str := FloatToStrF((B03_Value / 100),ffCurrency,6,2);   { Format Value									}
						if (B01_BalanceIndicator = 'DR') then										{ If the Acct maps a DR Balance	}
   						begin
  							if (B03_DRAcctNo = B01_AcctNo) then									{ If the tran DR acctno matches our acctno	}
  								begin                   													{ It's a Debit									}
  									Line.SubItems.Add(Str);													{ Populate the Debit Column			}
  									Line.SubItems.Add('');                          { Space out the Credit Column		}
  								end // END BEGIN                                  { and Done											}
  							else																								{ ELSE													}
  								begin                                             { It's a Credit									}
  									Line.SubItems.Add('');                          { Space out the Debit Column		}
  									Line.SubItems.Add(Str);													{ Populate the Credit Column		}
  								end // END BEGIN                                  { and Done											}
  							; // END IF
  						end // END BEGIN
						else																										{ If the Acct maps a CR Balance	}
  						begin
  							if (B03_CRAcctNo = B01_AcctNo) then		              { If the tran CR Acctno matches our acctno	}
   								begin																							{ It's a Credit									}
  									Line.SubItems.Add('');													{ Space out the Debit Column		}
  									Line.SubItems.Add(Str);                         { Populate the Credit Column		}
  								end // END BEGIN                                  { and Done											}
  							else                                                { ELSE													}
  								begin                                             { It's a Debit									}
  									Line.SubItems.Add(Str);													{ Populate the ebit Column			}
  									Line.SubItems.Add('');                          { Space out the Credit Column		}
  								end // END BEGIN
  							; // END IF
   						end // END BEGIN
    				; // END IF

					{ RUNNING BALANCE }
						Y := B03_RunningBalance div 100;												{ Grab a copy of Balance		}
						If (Y < 0) then                                         { If value is -ve						}
							B03_RunningBalance := B03_RunningBalance * -1;        { then make it +ve					}

						Str := FloatToStrF((B03_RunningBalance / 100),ffCurrency,8,2);
 						If (Y < 0) then																					{ If Balance is -ve					}
							Str := '(' + Str + ')'																{ We need to add brackets		}
						else                                                    { else											}
							Str := ' ' + Str + ' ';																{ we dont										}

						Line.SubItems.Add(Str);

      end // END BEGIN
    ; // END WHILE

	{	----------------- }
	{	Empty List				}
	{	----------------- }
		If (X = 1) and (RETURN_CODE <> 0) then
			MessageDlgPos('No transactions for this account as yet',mtConfirmation, [mbOk],0,150,150)
		else
			Enq1.ListView.Items[0].MakeVisible(true)
		; // End IF

	end;

{ -----------------------------------------------------------------------------}
{ Selected from List View   	                                             		 }
{ -----------------------------------------------------------------------------}
	procedure TEnq1.ListViewClick(Sender: TObject);
	begin

		if(ListView.ItemIndex > -1) and (A01_ParameterNo = 2) then
			begin
				b02_recNo := StrToInt(ListView.Selected.Caption);
				FROM_ENQUIRY;
        TRAN_LISTVIEW();
 			end // END BEGIN
 		; // END IF

	end;

{ -----------------------------------------------------------------------------}
{ Calculater Key Stroke		   	                                             		 }
{ -----------------------------------------------------------------------------}
	procedure TEnq1.calc2KeyUp(Sender:TObject;var Key:Word;Shift:TShiftState);
  begin
		DOCALC;
	end;

{ -----------------------------------------------------------------------------}
{ Calculater							   	                                             		 }
{ -----------------------------------------------------------------------------}
	procedure DOCALC();
	var
		X1	: extended;
		X2	: extended;

	begin

		Val (Enq1.calc1.Text,X1,X);
    If X = 0 then
			X1 := RoundTo(StrToFloat(Enq1.calc1.Text), -2);

		Val (Enq1.calc2.Text,X2,X);
    If X = 0 then
			X2 := RoundTo(StrToFloat(Enq1.calc2.Text), -2);

 		case Enq1.calcWhat.Caption of
			'+'	: Enq1.result.Caption := FloatToStrF((X1 + X2),fffixed,8,2);
			'-'	: Enq1.result.Caption := FloatToStrF((X1 - X2),fffixed,8,2);
			'*' : Enq1.result.Caption := FloatToStrF((X1 * X2),fffixed,8,2);
			'/' : Enq1.result.Caption := FloatToStrF((X1 / X2),fffixed,8,2);
		end;

	end;

{ -----------------------------------------------------------------------------}
{ End Of Program						 	                                             		 }
{ -----------------------------------------------------------------------------}
end.

