unit system2;

{$mode ObjFPC}{$H+}
{$R *.lfm}

{ ============================================================================= }
{ INTERFACE - Gloablity                                                         }
{ ============================================================================= }
{	The "interface" section of a Pascal UNIT exports PUBLIC variables, constants	}
{ types, and routines, while the USES clause imports exported identifiers from	}
{ another UNITS interface section }

	interface

	{	EXTERNAL }
		uses
  		Classes, SysUtils, Forms, Controls, Graphics, Dialogs, StdCtrls,
			LCLType, unit0, display1;

		type

  		TSys2 = class(TForm)
    		Label1            	: TLabel;
    			start_parameterno : TEdit;
    		Label2            	: TLabel;
    			end_parameter     : TEdit;
    		Label3            	: TLabel;
    			start_parameter   : TEdit;
    		Label4: TLabel    	;
    			end_parameterno   : TEdit;
    		bPrint            	: TButton;

			procedure onKeyPress(Sender:TObject;var Key:char);
    	procedure bPrintClick(Sender: TObject);
    	private
    	public
  	end;

		var
  		Sys2: TSys2;

{ ============================================================================= }
{ IMPLEMENTATION- private/Local                                                 }
{ ============================================================================= }
{	The "inplementation" section declares PRIVATE variables, constants, types, 		}
{ and routines. }

	implementation
		uses
			unit0;

{ =============================================================================}
{ PROCEDURES/FUNCTIONS                                                         }
{ =============================================================================}

{ -----------------------------------------------------------------------------}
{ Only allow numeric characters                                            		 }
{ -----------------------------------------------------------------------------}
	procedure TSys2.onKeyPress(Sender:TObject;var Key:char);
	begin
		If not (Key in ['0'..'9', Char(VK_BACK), Char(VK_DELETE)]) then Key := #0;
	end;

{ -----------------------------------------------------------------------------}
{ PRINT                                                                        }
{ -----------------------------------------------------------------------------}
	procedure TSys2.bPrintClick(Sender: TObject);
	begin

  	n_StartParmNo	:= StrToInt(start_parameterno.Text);
  	n_EndParmNo		:= StrToInt(end_parameterno.Text);
  	n_StartParm		:= StrToInt(start_parameter.Text);
  	n_EndParm			:= StrToInt(end_parameter.Text);

  	if (n_EndParmNo < n_StartParmNo) then
			MessageDlgPos('End Parameter No cannot be less then Start Parameter No',
				mtConfirmation, [mbOk],0,150,150)
		else
	  	if n_EndParm < n_StartParm then
				MessageDlgPos('End Parameter cannot be less then Start Parameter',
					mtConfirmation, [mbOk],0,150,150)
			else
				L1_CALL(c_A01,c_Print,0,0,0)
			; // End If
		; // End If

  	Close;

		Str := 'A01_' + aFinancialYear + '.PRT';
		Dsp1.ShowModal;

	end;

{ -----------------------------------------------------------------------------}
{ End Of Program						 	                                             		 }
{ -----------------------------------------------------------------------------}
end.

