unit Chart2;

{$mode ObjFPC}{$H+}
{$R *.lfm}

{ ============================================================================= }
{ INTERFACE - Gloablity                                                         }
{ ============================================================================= }
{	The "interface" section of a Pascal UNIT exports PUBLIC variables, constants	}
{ types, and routines, while the USES clause imports exported identifiers from	}
{ another UNITS interface section }

	interface

	{	EXTERNAL }
		uses
  		Classes, SysUtils, Forms, Controls, Graphics, Dialogs, StdCtrls,
  		LCLType, display1;

		type

			{ TCoa2 }

     TCoa2 = class(TForm)
				Label1:TLabel;
					start_acctno:TEdit;
				Label2:TLabel;
					end_acctno:TEdit;
				bPrint:TButton;

			procedure FormShow(Sender:TObject);
      procedure onKeyPress(Sender:TObject;var Key:char);
			procedure bPrintClick(Sender:TObject);
			private
			public
		end;

		var
			Coa2: TCoa2;

{ ============================================================================= }
{ IMPLEMENTATION- private/Local                                                 }
{ ============================================================================= }
{	The "inplementation" section declares PRIVATE variables, constants, types, 		}
{ and routines. }

	implementation
		uses
			unit0;

{ =============================================================================}
{ PROCEDURES/FUNCTIONS                                                         }
{ =============================================================================}

{ -----------------------------------------------------------------------------}
{ Only allow numeric characters                                            		 }
{ -----------------------------------------------------------------------------}
	procedure TCoa2.onKeyPress(Sender:TObject;var Key:char);
	begin
 		If not (Key in ['0'..'9', Char(VK_BACK), Char(VK_DELETE)]) then Key := #0;
	end;

{ -----------------------------------------------------------------------------}
{ Form Show														                                         }
{ -----------------------------------------------------------------------------}
	procedure TCoa2.FormShow(Sender:TObject);
	begin
 		Coa2.Caption := Format('%0.2d',[A01_Parameter]) + ' Print Chart Of Accounts';
	end;

{ -----------------------------------------------------------------------------}
{ PRINT                                                                        }
{ -----------------------------------------------------------------------------}
	procedure TCoa2.bPrintClick(Sender:TObject);
	begin

  	n_StartAcctNo	:= StrToInt(start_acctno.Text);
  	n_EndAcctNo		:= StrToInt(end_acctno.Text);

  	if n_EndAcctNo < n_StartAcctNo then
			MessageDlgPos('End Parameter No cannot be less then Start Parameter No',
			mtConfirmation, [mbOk],0,150,150)
		else
			begin
				L1_CALL(c_B01,c_Print,0,0,0);
  			Close;

				Str := 'B01_' + aFinancialYear + '.PRT';
				Dsp1.ShowModal;

			end // END BEGIN
		; // End If

 end;

{ -----------------------------------------------------------------------------}
{ End Of Program						 	                                             		 }
{ -----------------------------------------------------------------------------}
end.

