unit menu1;

{$mode objfpc}{$H+}
{$R *.lfm}

{ ============================================================================= }
{ INTERFACE - Gloablity                                                         }
{ ============================================================================= }
{	The "interface" section of a Pascal UNIT exports PUBLIC variables, constants	}
{ types, and routines, while the USES clause imports exported identifiers from	}
{ another UNITS interface section }

	interface

	{	EXTERNAL }
		uses
			Classes, SysUtils, Forms, Controls, Graphics, Dialogs, StdCtrls, ComCtrls,
				ExtCtrls, Menus, ActnList, Spin, LCLType;

		function  l1_findCompany(companyNo: Int64) : boolean; external;

		procedure ValidCompanyNo (CompanyNo: Int64);
		procedure buildMenu ();

 	{	GLOBAL/PUBLIC -> all that follows until "implementation" }
		type

			{ Tmen1 }

    Tmen1 = class(TForm)
				Label1					: TLabel;
				company_no			: TEdit;
				company_spinner	: TUpDown;
				company_desc		: TLabel;
				sidebar					: TTreeView;
				bCommit					: TButton;

  			procedure FormCreate(Sender: TObject);
    		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
				procedure sidebarClick(Sender: TObject);
				procedure onKeyPress(Sender:TObject;var Key:char);
				procedure company_spinnerClick(Sender: TObject;Button: TUDBtnType);
				procedure bCommitClick(Sender:TObject);
				private
				public
			end;

		var
			men1: Tmen1;

{ ============================================================================= }
{ IMPLEMENTATION- private/Local                                                 }
{ ============================================================================= }
{	The "inplementation" section declares PRIVATE variables, constants, types, 		}
{ and routines. }

  Implementation
		uses
			unit0, system1, chart1, journal1, enquire1, report1;

	{ NOTE:- procedures/functions declared in the implementation section must			}
	{	contain the keyword "forward"																								}

		procedure getStart (); forward;

{ =============================================================================}
{ PROCEDURES/FUNCTIONS                                                         }
{ =============================================================================}

{ -----------------------------------------------------------------------------}
{ Validate Company                    pA01_ParameterNo                                         }
{ -----------------------------------------------------------------------------}
	procedure ValidCompanyNo (CompanyNo : Int64);

	begin
		men1.company_no.Text 					:= '0';
		men1.company_desc.Caption 		:= '';

		if l1_findCompany(CompanyNo) then
			begin
				a01_system_recno					:= A01_Record_NO;
				men1.company_no.Text 			:= IntToStr(A01_Parameter);
				men1.company_desc.Caption := A01_Description;
			end // END BEGIN
    ; // End If

	end;

{ =============================================================================}
{ EVENT driven Code 			                                                     }
{ =============================================================================}
{ -----------------------------------------------------------------------------}
{ on Create get & display current year                                         }
{ -----------------------------------------------------------------------------}
	procedure Tmen1.FormCreate(Sender: TObject);
	begin

		men1.Caption	:= aFinancialYear;

	{ Checking for a valid company no. Will do a start on the file and if lucky	}
	{ we might even have a company 1																						}
		ValidCompanyNo(1);

		buildMenu;
		sidebar.Items[0].Selected:= true;

	end;

{ -----------------------------------------------------------------------------}
{ Only allow numeric characters                                            		 }
{ -----------------------------------------------------------------------------}
	procedure Tmen1.onKeyPress(Sender:TObject;var Key:char);
	begin
		If not (Key in ['0'..'9', Char(VK_BACK), Char(VK_DELETE)]) then Key := #0;
	end;

{ -----------------------------------------------------------------------------}
{ Commit										 	                                             		 }
{ -----------------------------------------------------------------------------}
	procedure Tmen1.bCommitClick(Sender:TObject);
	begin

		case MessageDlgPos('Are you sure', mtConfirmation, [mbYes, mbNo, mbCancel],0,100,100) of
			mrCancel:;
			mrNO 		:;
			mrYes		: L1_CALL (0,c_Commit,0,0,0);
		end; // END CASE

	end;

{ -----------------------------------------------------------------------------}
{ EXIT											 	                                             		 }
{ -----------------------------------------------------------------------------}
	procedure Tmen1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
	begin

		case MessageDlgPos('Save Changes', mtConfirmation, [mbYes, mbNo, mbCancel],0,100,100) of
			mrCancel	: CanClose := false;
			mrNO 			: CanClose := true;
			mrYes 		: begin
										L1_CALL (0,c_Commit,0,0,0);
										CanClose := true;
									end // END BEGIN
		end; // END CASE

	end;

{ -----------------------------------------------------------------------------}
{ Company spinner                                                              }
{ -----------------------------------------------------------------------------}
	procedure Tmen1.company_spinnerClick(Sender: TObject; Button: TUDBtnType);
	var
		direction : Int64 = 0;

	begin

		{	----------------- }
		{	Set the direction }
		{	----------------- }
		If Button = btNext then
			direction := direction + 1
		else
			direction := direction - 1;

		{	----------------------------- }
		{	Find the Next/Previous record }
		{	----------------------------- }
		l1_Call(c_A01,c_Read,a01_system_recno,0,0);
		l1_Call(c_A01,c_PreviousNext,direction,0,0);
		If RETURN_CODE = 0 then
			begin
				a01_system_recno 					:= A01_Record_NO;
				men1.company_no.Text      := IntToStr(A01_Parameter);
				men1.company_desc.Caption := A01_Description;
				men1.company_no.SetFocus;
			end // END BEGIN
		; // END IF

	end;

{ -----------------------------------------------------------------------------}
{ MENU Selection                                                               }
{ -----------------------------------------------------------------------------}
	procedure Tmen1.sidebarClick(Sender: TObject);
	begin

		{ ------------------------------------- }
		{ Valid Company selected								}
		{ ------------------------------------- }
		ValidCompanyNo(StrToInt(men1.company_no.Text));
		if RETURN_CODE = 0 then
			If TTreeView(Sender).Selected.StateIndex > 1 then
				begin
					MessageDlgPos('Invalid Company No', mtConfirmation, [mbOk],0,100,100);
					exit;
				end
		; // END IF

		{ ------------------------------------- }
		{ Menu Item selected										}
		{ ------------------------------------- }
		Case TTreeView(Sender).Selected.StateIndex of
			01 :
				begin
					sys1.show;
				end;
			02 : ;		{ General Ledger }
				21 : begin getStart; Coa1.ShowModal(); end;
				22 : begin getStart; Jrn1.ShowModal(); end;
				23 : begin getStart; Enq1.ShowModal(); end;
				24 : begin getStart; Rpt1.ShowModal(); end;
				25 : ;    {	Generate Depreciation	}
				26 : begin
							case MessageDlgPos('Run End Of Year ?', mtConfirmation, [mbYes, mbNo, mbCancel],0,100,100) of
								mrCancel:;
								mrNO 		:;
								mrYes		: L1_CALL (c_B07,c_EOY,0,0,0);
							end

						end;

			03 : ;		{ Asset management }
				31 : ;		{	Franked Dividend			}
				32 : ;    {	Asset History					}
				33 : ;    {	Generate Revaluation	}
				34 : ;    {	Asset Dale						}
		end; // END CASE

	end;

{ ----------------------------------------------------------------------------}
{ Get Start Position on files																									}
{ ----------------------------------------------------------------------------}
	procedure getStart ();
	begin

		l1_Call(c_B01,c_Start,1,0,1); b01_recNo := B01_Record_NO;
		l1_Call(c_B02,c_Start,1,0,0); b02_recNo := B02_Record_NO;

	end;

{ ----------------------------------------------------------------------------}
{ Build the Menu																															}
{ ----------------------------------------------------------------------------}
	procedure buildMenu ();
	begin

		men1.sidebar.Items[1].Visible := false;
  	men1.sidebar.Items[8].Visible := false;

		l1_Call(c_A01,c_Read,2,0,0);
		if RETURN_CODE = 0 then
			If (A01_ParameterNo = 1) and (A01_parameter = 2) then
				men1.sidebar.Items[1].Visible := true
			; // END IF
			If (A01_ParameterNo = 1) and (A01_parameter = 3) then
				men1.sidebar.Items[8].Visible := true
			; // END IF
		; // END IF

		l1_Call(c_A01,c_Read,3,0,0);
		if RETURN_CODE = 0 then
			If (A01_ParameterNo = 1) and (A01_parameter = 3) then
				men1.sidebar.Items[8].Visible := true
			; // END IF
			If (A01_ParameterNo = 1) and (A01_parameter = 2) then
				men1.sidebar.Items[1].Visible := true
			; // END IF
		; // END IF

	end;

{ -----------------------------------------------------------------------------}
{ End Of Program						 	                                             		 }
{ -----------------------------------------------------------------------------}
end.

