unit Asset3;

{$mode ObjFPC}{$H+}

interface

uses
	Classes, SysUtils, Forms, Controls, Graphics, Dialogs,StdCtrls,ComCtrls,
	LCLType, Grids, display1, strutils;

type

			{ TAss3A }

	TAss3A = class(TForm)

		AsAtDate:TLabel;
			asat_ccyy:TEdit;
			asat_dd:TEdit;
			asat_mm:TEdit;
		StringGrid1:TStringGrid;
		Button1:TButton;

   	procedure FormCreate(Sender:TObject);
		procedure FormShow(Sender:TObject);
		procedure onKeyPress(Sender:TObject;var Key:char);
		procedure Button1Click(Sender:TObject);
		procedure StringGrid1Selection(Sender:TObject;aCol,aRow:Integer);
		private
		public

	end;

  TAss3B = class(TForm)
	public
		StringGrid2 : TStringGrid;
    Button2: TButton;

    constructor Create(AOwner: TComponent); override;
		procedure StringGrid2Selection(Sender:TObject;aCol,aRow:Integer);
		procedure Button2Click(Sender:TObject);

  end;

var
	Ass3A		: TAss3A;
	Ass3B		: TAss3B;


implementation
	uses
		unit0;

{$R *.lfm}

{ TAss3A }

{ =============================================================================}
{ PROCEDURES/FUNCTIONS                                                         }
{ =============================================================================}

{ -----------------------------------------------------------------------------}
{ on Create																																		 }
{ -----------------------------------------------------------------------------}
procedure TAss3A.FormCreate(Sender:TObject);
begin

{ Form to get Keystroke 1st	}
	KeyPreview := true;

end;


{ -----------------------------------------------------------------------------}
{ on Show setup Defaults							                                         }
{ -----------------------------------------------------------------------------}
procedure TAss3A.FormShow(Sender:TObject);
begin

	w_EndDate := asat_ccyy.text + '/' + asat_mm.text + '/' + asat_dd.text;
	l1_CALL(c_C03,1,0,0,0);

	for Y := 1 to 32 do
		begin

  		StringGrid1.Cells[1, Y] := '0';

			Str := '';
			for X := 1 to 5 do
				begin
					Str := Str + px_Array1^;
					inc(px_Array1);
				end // END BEGIN
			; // END FOR
  		StringGrid1.Cells[2, Y] := Str;

			If Str = '     ' then
				break;

			Str := '';
			for X := 6 to 35 do
				begin
					Str := Str + px_Array1^;
					inc(px_Array1);
				end // END BEGIN
			; // END FOR
  		StringGrid1.Cells[3, Y] := Str;

			px_Array1 := px_Array1 + 10;

			Str := '';
			for X := 36 to 45 do
				begin
					Str := Str + px_Array1^;
					inc(px_Array1);
				end // END BEGIN
			; // END FOR
  		StringGrid1.Cells[4, Y] := Str;

			px_Array1 := px_Array1 + 30;

		end // END BEGIN
	; // END FOR

	Ass3A.Caption := Format('%0.2d',[A01_Parameter]) + ' Generate Revaluation';
	asat_dd.Text		:= '01';
	asat_mm.Text		:= '07';
	X					 			:= nFinancialYear - 1;
	asat_ccyy.Text	:= IntToStr(X);

end;

{ -----------------------------------------------------------------------------}
{ Only allow Col 1 to be selected                                          		 }
{ -----------------------------------------------------------------------------}
procedure TAss3A.StringGrid1Selection(Sender:TObject;aCol,aRow:Integer);
begin

	if ACol = 1 then
    StringGrid1.Options := StringGrid1.Options + [goEditing]
  else
    StringGrid1.Options := StringGrid1.Options - [goEditing];

end;

{ -----------------------------------------------------------------------------}
{ Only allow numeric characters                                            		 }
{ -----------------------------------------------------------------------------}
	procedure TAss3A.onKeyPress(Sender:TObject;var Key:char);
	begin
  	If not (Key in ['0'..'9', Char(VK_BACK), Char(VK_DELETE)]) then Key := #0;
	end;

{ -----------------------------------------------------------------------------}
{ On Proceed																																	 }
{ -----------------------------------------------------------------------------}
procedure TAss3A.Button1Click(Sender:TObject);

begin

	for Y := 1 to 32 do
 		If StringGrid1.Cells[1, Y] = '1' then
				l1_CALL(c_C03,2,0,0,0);



	Ass3B.ShowModal;

end;

{ ============================================================================ }
{ Build 2nd screen					 	                                             		 }
{ ============================================================================ }
constructor TAss3B.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  VertScrollBar.Visible := False;
  HorzScrollBar.Visible := False;

	StringGrid2 := TStringGrid.Create (self);
	with StringGrid2 do
		begin
    	Parent := Self;
    	Caption := 'Revaluation Schedule';
    	Top := 25;
    	Height := 300;
    	Left := 25;
    	Width := 835;
			colcount := 7;
			rowcount := 32;
			ScrollBars := ssVertical;
			onSelection := @StringGrid2Selection;

			for X := 1 to 7 do
	 			Columns.Add;
			Columns.Items[0].Width:=50;
				Columns.Items[0].Title.Caption := 'Acct';
				Columns.Items[0].Alignment := taRightJustify;

			Columns.Items[1].Width:=300;
				Columns.Items[1].Title.Caption := 'Description';
				Columns.Items[1].Alignment := taLeftJustify;

			Columns.Items[2].Width:=80;
				Columns.Items[2].Title.Caption := 'Units';
				Columns.Items[2].Alignment := taRightJustify;

			Columns.Items[3].Width:=80;
				Columns.Items[3].Title.Caption := 'Unit Price';
				Columns.Items[3].Alignment := taRightJustify;

			Columns.Items[4].Width:=80;
				Columns.Items[4].Title.Caption := 'Curr Bal';
				Columns.Items[4].Alignment := taRightJustify;

			Columns.Items[5].Width:=80;
				Columns.Items[5].Title.Caption := 'Calc Bal';
				Columns.Items[5].Alignment := taRightJustify;

			Columns.Items[6].Width:=80;
				Columns.Items[6].Title.Caption := 'Adjust';
				Columns.Items[6].Alignment := taRightJustify;

	end;

  Button2 := TButton.Create(Self);
  with Button2 do
  begin
    Parent := Self;
    Top := 350;
    Height := 26;
    Left := 760;
    Width := 75;
    Caption := 'Process';
    OnClick := @Button2Click;

  end;


  // Add other component creation and property setting code here
end;

{ -----------------------------------------------------------------------------}
{ Button2 Click									                                          		 }
{ -----------------------------------------------------------------------------}
procedure TAss3B.Button2Click(Sender:TObject);
begin


end;

{ -----------------------------------------------------------------------------}
{ Only allow Col 1 to be selected                                          		 }
{ -----------------------------------------------------------------------------}
procedure TAss3B.StringGrid2Selection(Sender:TObject;aCol,aRow:Integer);
begin

	if ACol = 7 then
    StringGrid2.Options := StringGrid2.Options + [goEditing]
  else
    StringGrid2.Options := StringGrid2.Options - [goEditing];

end;

{ -----------------------------------------------------------------------------}
{ End Of Program						 	                                             		 }
{ -----------------------------------------------------------------------------}
end.

