unit system1;

{$mode ObjFPC}{$H+}
{$R *.lfm}

{ ============================================================================= }
{ INTERFACE - Gloablity                                                         }
{ ============================================================================= }
{	The "interface" section of a Pascal UNIT exports PUBLIC variables, constants	}
{ types, and routines, while the USES clause imports exported identifiers from	}
{ another UNITS interface section }

	interface

	{	EXTERNAL }
		uses
			Classes, SysUtils, Forms, Controls, Graphics, Dialogs, StdCtrls, ComCtrls,
			ExtCtrls, LCLType,MaskEdit;
			function  l1_findParameters(ParmNo: Int64; Parm: Int64) : Int64; external;

	{	GLOBAL/PUBLIC -> all that follows until "implementation" }
		type

			{ Tsys1 }

    Tsys1 = class(TForm)
				Panel1									: TPanel;
					Label1								: TLabel;
						key_parameter				: TEdit;
					Label2								: TLabel;
						key_parameterno			: TEdit;
				Panel2									: TPanel;
					Label3								: TLabel;
						description					: TEdit;
					PageControl1					: TPageControl;
						TabSheet1						: TTabSheet;
							Label4						: TLabel;
							password					: TEdit;
						TabSheet2						: TTabSheet;
							Label5						: TLabel;
								lastreference		: TEdit;
							Label6						: TLabel;
								gstaccount			: TEdit;
							Label7						: TLabel;
								startyear				: TEdit;
							Label8						: TLabel;
								unitprice				: TEdit;
						TabSheet3						: TTabSheet;
							Label9						: TLabel;
								company01				: TEdit;
								company02				: TEdit;
								company03				: TEdit;
								company04				: TEdit;
								company05				: TEdit;
								company06				: TEdit;
								company07				: TEdit;
								company08				: TEdit;
								company09				: TEdit;
								company10				: TEdit;
								company11				: TEdit;
								company12				: TEdit;

				bCancel									: TButton;
				bDelete									: TButton;
				bSave										: TButton;

				ListView								: TListView;
				Panel3									: TPanel;

     		procedure FormCreate(Sender: TObject);
				procedure FormShow(Sender: TObject);
				procedure FormKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
				procedure onKeyPress(Sender:TObject;var Key:char);
				procedure FormClose(Sender:TObject;var CloseAction:TCloseAction);
				procedure bSaveClick(Sender: TObject);
				procedure bDeleteClick(Sender: TObject);
				procedure bCancelClick(Sender: TObject);
				procedure ListViewClick(Sender: TObject);
				private
				public
			end;

		var
			Sys1: TSys1;
			l1_Initial					: boolean = true;

{ ============================================================================= }
{ IMPLEMENTATION- private/Local                                                 }
{ ============================================================================= }
{	The "inplementation" section declares PRIVATE variables, constants, types, 		}
{ and routines. }

  Implementation
		uses
			unit0, menu1, system2;

  { NOTE:- procedures/functions declared in the implementation section must			}
	{	contain the keyword "forward"																								}

		procedure SYS_LISTVIEW(); forward;
		procedure Key_Enable(); forward;
		procedure Details_Enable(); forward;
		procedure init_parms(); forward;

		function  GET_SYS() : boolean; forward;
		function	DETAILS_OKAY(): boolean; forward;
		function	ValidParm1(): boolean; forward;
		function	ValidParm2(): boolean; forward;
		function	ValidParm3(): boolean; forward;

{ =============================================================================}
{ PROCEDURES/FUNCTIONS                                                         }
{ =============================================================================}

{ ----------------------------------------------------------------------------}
{ on Create Set ABLE/DISABLE fields																						}
{ ----------------------------------------------------------------------------}
	procedure TSys1.FormCreate(Sender: TObject);
	begin

		{ Form to get Keystroke 1st	}
		KeyPreview := true;

	end;

{ ----------------------------------------------------------------------------}
{ Form Close																																	}
{ ----------------------------------------------------------------------------}
	procedure Tsys1.FormClose(Sender:TObject;var CloseAction:TCloseAction);
	begin
  	ValidCompanyNo(1);
		buildMenu
	end;

{ ----------------------------------------------------------------------------}
{ Form Show																																		}
{ ----------------------------------------------------------------------------}
	procedure TSys1.FormShow(Sender: TObject);
	begin

		Key_Enable;
		SYS_LISTVIEW();

	end;

{ ----------------------------------------------------------------------------}
{ on form key down check for function keys																		}
{ ----------------------------------------------------------------------------}
	procedure TSys1.FormKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
	begin

	{	----------- }
	{	PF3 - Print }
	{	----------- }
		If  (key = 114)
		and (key_parameterno.enabled) then
			begin
				Key := 0;
				Sys2.ShowModal;
			end;

	{	------------ }
	{	PF5 - Accept }
	{	------------ }
		If  (key = 116)
		and (key_parameterno.enabled) then
			begin
        Key 			:= 0;
				a01_recNo := 0;
				if GET_SYS then
					Details_Enable
				; // END IF
			end // END BEGIN
		; // End If

	end;

{ -----------------------------------------------------------------------------}
{ Only allow numeric characters                                            		 }
{ -----------------------------------------------------------------------------}
	procedure Tsys1.onKeyPress(Sender:TObject;var Key:char);
	begin
		If not (Key in ['0'..'9', Char(VK_BACK), Char(VK_DELETE)]) then Key := #0;
	end;

{ ----------------------------------------------------------------------------}
{ Selected from List View																											}
{ ----------------------------------------------------------------------------}
	procedure TSys1.ListViewClick(Sender: TObject);
	begin

		if(ListView.ItemIndex > -1) then
			begin
				a01_recNo := StrToIntDef(ListView.Selected.Caption,0);
				if  GET_SYS then
						Details_Enable
				; // END IF
			end // END BEGIN
		; // End If

end;

{ ----------------------------------------------------------------------------}
{ Details DELETE																															}
{ ----------------------------------------------------------------------------}
	procedure TSys1.bDeleteClick(Sender: TObject);
	begin

		case MessageDlgPos('Are you sure', mtConfirmation, [mbYes, mbNo, mbCancel],0,150,150) of
			mrCancel:;
			mrNO 		:;
			mrYes		:
				begin

				{	---------------------------	}
				{ Delete System Parameters		}
				{	---------------------------	}
					If  (A01_Parameter		= 1)
					and (A01_ParameterNo	= 1) then
						l1_Initial := true;
					; // END IF

				{	---------------------------	}
				{ All													}
				{	---------------------------	}
					L0_Call(c_A01,c_Delete,a01_recNo,0,0);
					if RETURN_CODE = 0 then
						begin
							SYS_LISTVIEW();
							Key_Enable;
						end // END BEGIN
					else
						case RETURN_CODE of
							30: MessageDlgPos('Accounts exist for this Company so it cannot be deleted',
									mtConfirmation, [mbOk],0,150,150);
							31: MessageDlgPos('Company belongs to consolidated group so it cannot be deleted',
									mtConfirmation, [mbOk],0,150,150);
						end // END CASE
					; // END IF
				end // END BEGIN
		end; // END CASE

 end;
{ ----------------------------------------------------------------------------}
{ Details SAVE																																}
{ ----------------------------------------------------------------------------}
	procedure TSys1.bSaveClick(Sender: TObject);
	begin

		if DETAILS_OKAY() then
			Key_Enable
		; // END IF

	end;

{ ----------------------------------------------------------------------------}
{ Detals CANCEL																																}
{ ----------------------------------------------------------------------------}
	procedure TSys1.bCancelClick(Sender: TObject);
	begin

		Key_Enable;

	end;

{ ----------------------------------------------------------------------------}
{ Key Enable																																	}
{ ----------------------------------------------------------------------------}
	procedure Key_Enable ();
	begin

	{	------------ }
	{	Enable KEY	 }
	{	------------ }
		Sys1.key_parameterno.enabled	:= true;
		Sys1.key_parameter.enabled		:= true;

	{	--------------- }
	{	Disable DETAILS }
	{	--------------- }
		Sys1.description.enabled			:= false;
		Sys1.PageControl1.Enabled			:= false;
		Sys1.bSave.enabled						:= false;
		Sys1.bDelete.enabled					:= false;
		Sys1.bCancel.enabled					:= false;

		Sys1.ListView.enabled					:= true;

	end;

{ ----------------------------------------------------------------------------}
{ Details Enable																															}
{ ----------------------------------------------------------------------------}
	procedure Details_Enable ();
	begin

	{	------------ }
	{	Disable KEY	 }
	{	------------ }
		Sys1.key_parameterno.enabled	:= false;
		Sys1.key_parameter.enabled		:= false;

	{	--------------- }
	{	Enable DETAILS	}                                     
	{	--------------- }
		Sys1.description.enabled			:= true;
 		Sys1.description.SetFocus;

		Sys1.PageControl1.Enabled			:= true;
		Sys1.bSave.enabled						:= true;
		If not newRecord then
			Sys1.bDelete.enabled				:= true
		; // END IF
		Sys1.bCancel.enabled					:= true;

		Sys1.ListView.enabled					:= false;

	{	------------------ }
	{	Enable default TAB }
	{	------------------ }
		case A01_ParameterNo of
			1: begin
				Sys1.PageControl1.ActivePage	:= Sys1.Tabsheet1;
				Sys1.Tabsheet1.Enabled				:= true;
				Sys1.Tabsheet2.Enabled				:= false;
				Sys1.Tabsheet3.Enabled				:= false;
			end; // END OPTION
			2: begin
				Sys1.PageControl1.ActivePage	:= Sys1.Tabsheet2;
				Sys1.Tabsheet1.Enabled				:= false;
				Sys1.Tabsheet2.Enabled				:= true;
				Sys1.Tabsheet3.Enabled				:= false;
			end; // END OPTION
			3: begin
				Sys1.PageControl1.ActivePage	:= Sys1.Tabsheet3;
				Sys1.Tabsheet1.Enabled				:= false;
				Sys1.Tabsheet2.Enabled				:= false;
				Sys1.Tabsheet3.Enabled				:= true;
			end; // END OPTION
		end; // END CSE

	end;

{ -----------------------------------------------------------------------------}
{	populate ListView																														 }
{ -----------------------------------------------------------------------------}
	procedure SYS_LISTVIEW();
	var
		Line	: TListItem;

	begin
		Sys1.ListView.Items.Clear;
		A01_Record_NO := 0;

	{	----------------- }
	{	Transactions Loop	}
	{	----------------- }
		while 1=1 do
			begin

			{ get Record }
				A01_Record_NO := A01_Record_NO + 1;
				L0_Call(c_A01,c_Read,A01_Record_NO,0,0);
				if RETURN_CODE <> 0 then
						break;

			{ Save 1st ones values}
				if A01_Record_NO = 1 then
					Sys1.key_parameterno.Text	:= IntToStr(A01_ParameterNo);
					Sys1.key_parameter.Text		:= IntToStr(A01_Parameter);
					Sys1.Tabsheet1.Enabled		:= true;
					a01_recNo 								:= 1;
        ; // END IF

			{ Populate ListView }
				Line := Sys1.ListView.Items.add;
					Line.Caption:= Format('%0.3d',[A01_Record_NO]);
						Line.SubItems.Add(Format('%3d',[A01_ParameterNo]));
						Line.SubItems.Add(Format('%3d',[A01_Parameter]));
						Line.SubItems.Add(A01_Description);
			end // END BEGIN
		; // END WHILR

	{	----------------- }
	{	Empty List				}
	{	----------------- }
		If (A01_Record_NO = 1) and (RETURN_CODE <> 0) then
			MessageDlgPos('No System records exist as yet',mtConfirmation, [mbOk],0,150,150)
		else
			begin
				l1_initial := false;
				Sys1.ListView.Items[0].MakeVisible(true);
    		GET_SYS;
			end // END BEGIN
		; // End IF

	end;

{ ----------------------------------------------------------------------------}
{ GET_SYS																																			}
{ ----------------------------------------------------------------------------}
	function GET_SYS() : boolean;
	begin

	{ ------------------------- }
	{ Get The Key Values				}
	{-------------------------- }
		If Trim(Sys1.key_parameterno.Text) = '' then
			X := 0
		else
			X := StrToIntDef(Sys1.key_parameterno.Text,0)
		; // END IF
		If Trim(Sys1.key_parameter.Text) = '' then
			Y := 0
		else
			Y := StrToIntDef(Sys1.key_parameter.Text,0)
		; // END IF

	{ ------------------------- }
	{ System Initialation				}
	{-------------------------- }
		If 	l1_Initial then
			If (X <> 1) or (Y <> 1) then
				begin
					MessageDlgPos('blank System, please enter record 1/1', mtConfirmation, [mbOk],0,150,150);
					GET_SYS := false;
					exit;
				end // END BEGIN
			; // END IF
		; //ENDIF

		If (X = 2) then
			begin
				Z := L0_findParameters(1,2);
				If Z = 0 then
					begin
						MessageDlgPos('No General Ledger defined, please enter record 1/2',
							mtConfirmation, [mbOk],0,150,150);
						GET_SYS := false;
						exit;
          end // END BEGIN
				; // END IF                                    1
      end // END BEGIN
		; // END IF


	{ ------------------------- }
	{ F5 PRESSED -> Valid Key ? }
	{-------------------------- }
		if a01_recNo = 0 then
 			begin
 				if (X < 1) or (X > 3) then
					begin
						MessageDlgPos('ParameterNo must be 1,2 or 3',
							mtConfirmation, [mbOk],0,150,150);
						GET_SYS := false;
						exit;
					end // END BEGIN
				; //ENDIF

				if (Y < 1) or (Y > 98) then
					begin
						MessageDlgPos('Parameter must be between 1 and 98',
							mtConfirmation, [mbOk],0,150,150);
						GET_SYS := false;
						exit;
					end // END BEGIN
				; //ENDIF

			{ ------------------------- }
			{ EXISTING OR NEW						}
			{ ------------------------- }
				a01_recNo := L0_findParameters(X,Y);
				if a01_recNo = 0 then
				{ NEW }
					begin
						newRecord := true;
						init_parms;
						GET_SYS := true;
						exit;
					end // END BEGIN
				else
					newRecord := false
				; // END IF
  		end // END BEGIN

  { ------------------------- }
	{ from ListView 						}
	{-------------------------- }
		else

		{ -------------------------------------- }
		{ Selected from Browser or existing (F5) }
		{ -------------------------------------- }
			begin
				newRecord := false;
				L0_Call(c_A01,c_Read,a01_recNo,0,0);
				Sys1.key_parameterno.Text	:= IntToStr(A01_ParameterNo);
				Sys1.key_parameter.Text		:= IntToStr(A01_Parameter);
			end // END BEGIN
 		; // END IF

	{ ------- }
	{ Details }
	{ ------- }
		Sys1.description.Text		:= A01_Description;
		Sys1.password.Text 			:= A01_Password;
		Sys1.lastreference.Text := '';
		Sys1.lastreference.Text	:= A01_LastReference;
		Sys1.gstaccount.Text		:= IntToStr(A01_GSTAccount);
		Sys1.startyear.Text			:= IntToStr(A01_StartYear);
		Sys1.unitprice.Text			:= w_A01_UnitPrice;

		Sys1.company01.Text			:= IntToStr(A01_Company01);
		Sys1.company02.Text			:= IntToStr(A01_Company02);
		Sys1.company03.Text			:= IntToStr(A01_Company03);
		Sys1.company04.Text			:= IntToStr(A01_Company04);
		Sys1.company05.Text			:= IntToStr(A01_Company05);
		Sys1.company06.Text			:= IntToStr(A01_Company06);
		Sys1.company07.Text			:= IntToStr(A01_Company07);
		Sys1.company08.Text			:= IntToStr(A01_Company08);
		Sys1.company09.Text			:= IntToStr(A01_Company09);
		Sys1.company10.Text			:= IntToStr(A01_Company10);
		Sys1.company11.Text			:= IntToStr(A01_Company11);
		Sys1.company12.Text			:= IntToStr(A01_Company12);

		GET_SYS := true;

	end;

{ ----------------------------------------------------------------------------}
{ INIT_PARMS																															}
{ ----------------------------------------------------------------------------}
	procedure init_parms();
	begin

	{ ----- }
	{ KEY		}
	{ ----- }
		A01_ParameterNo					:= StrToIntDef(Sys1.key_parameterno.Text,0);
		A01_Parameter						:= StrToIntDef(Sys1.key_parameter.Text,0);

	{ --------- }
	{ DETAILS		}
	{ --------- }
		Sys1.description.Text		:='';
		Sys1.password.Text			:='';
		Sys1.lastreference.Text	:='';
		Sys1.gstaccount.Text		:='0';
		Sys1.startyear.Text			:='0';
		Sys1.unitprice.Text			:='0000.0000';
		Sys1.company01.Text			:='0';
		Sys1.company02.Text			:='0';
		Sys1.company03.Text			:='0';
		Sys1.company04.Text			:='0';
		Sys1.company05.Text			:='0';
		Sys1.company06.Text			:='0';
		Sys1.company07.Text			:='0';
		Sys1.company08.Text			:='0';
		Sys1.company09.Text			:='0';
		Sys1.company10.Text			:='0';
		Sys1.company11.Text			:='0';
		Sys1.company12.Text			:='0';

		If a01_recNo <> 0 then
			Sys1.bDelete.enabled	:= true;
		; // END IF

	end;

{ ----------------------------------------------------------------------------}
{ DETAILS OKAY																																}
{ ------------------------------------------------------------0----------------}
	function DETAILS_OKAY(): boolean;
	begin

		DETAILS_OKAY := false;

	{ ------------ }
	{ Valid Data ? }
	{ ------------ }

	{ DESCRIPTION  }
		if Trim(Sys1.description.Text) = '' then
			begin
				MessageDlgPos('Please enter a description',
					mtConfirmation, [mbOk],0,150,150);
				exit;
			end // END BEGIN
		else
			A01_Description := Format('%-30s',[Sys1.description.Text]);
		; // END IF

	{ ------------------ }
	{ Parameter Records	 }
	{ ------------------ }
		case A01_ParameterNo of
			01: if not validParm1 then exit;
			02: if not validParm2 then exit;
			03: if not validParm3 then exit;
		end;

	{ ------------------ }
	{ Company No				 }
	{ ------------------ }
		if (a01_recNo = 0) and (A01_ParameterNo = 2) then
			A01_Company01 := A01_Parameter
		; // END IF

	{ --------- }
	{ Proceed ? }
	{ --------- }
		L0_Call(c_A01,c_Write,a01_recNo,0,0);
		if RETURN_CODE = 0 then
			begin
				l1_Initial := FALSE;
				DETAILS_OKAY := true;
				SYS_LISTVIEW();
			end // END BEGIN
		else
			begin
				case RETURN_CODE of
					30: MessageDlgPos('Cannot Delete - Company has active accounts',mtConfirmation, [mbOk],0,150,150);
					31: MessageDlgPos('Invalid - Company belongs to a Consolidated Group',mtConfirmation, [mbOk],0,150,150);
					32: MessageDlgPos('Invalid GST Account',mtConfirmation, [mbOk],0,150,150);
					33: MessageDlgPos('Invalid Company No',mtConfirmation, [mbOk],0,150,150);
					34: MessageDlgPos('Consolidated Group No must be different to Company No',mtConfirmation, [mbOk],0,150,150);
				end; // END CASE
			end // END BEGIN
		; // End If


end;

{ ----------------------------------------------------------------------------}
{ Validate Parameter 1 fields																									}
{ ----------------------------------------------------------------------------}
	function ValidParm1(): boolean;
	begin

		ValidParm1 := true;

	{ PASSWORD }
		if Trim(Sys1.password.Text) = '' then
			begin
				MessageDlgPos('Please enter password',mtConfirmation, [mbOk],0,150,150);
      	validParm1 := false;
				exit;
			end // END BEGIN
		else
			A01_Password := Format('%-8s',[Sys1.password.Text]);
		; // End If

	end;

{ ----------------------------------------------------------------------------}
{ Validate Parameter 1 fields																									}
{ ----------------------------------------------------------------------------}
	function ValidParm2(): boolean;
	begin

 		ValidParm2 := true;

	{ LAST REFERENCE }
		if Trim(Sys1.lastreference.Text) = '' then
			begin
				MessageDlgPos('Please enter last reference',mtConfirmation, [mbOk],0,150,150);
      	validParm2 := false;
				exit;
			end // END BEGIN
		else
			A01_LastReference := Format('%-10s',[Sys1.lastreference.Text]);
		; // END IF

	{ GSTACCOUNT - can be zero }
		if Trim(Sys1.gstaccount.Text) <> ''  then
			A01_GSTAccount := StrToIntDef(Sys1.gstaccount.Text,0)
    ; // END IF

	{ START YEAR }
		If Trim(Sys1.startyear.Text) = '' then
				begin
					MessageDlgPos('Please enter Start Year',mtConfirmation, [mbOk],0,150,150);
      		validParm2 := false;
					exit;
				end // END BEGIN
		else
			A01_StartYear := StrToIntDef(Sys1.startyear.Text,0);
			If A01_StartYear = 0 then
				begin
					MessageDlgPos('Please enter Start Year',mtConfirmation, [mbOk],0,150,150);
	      	validParm2 := false;
					exit;
				end // END BEGIN
			; // END IF
   	; // END IF

	{ UNITPRICE - can be zero }
		if Trim(Sys1.unitprice.Text) <> '' then
			w_A01_UnitPrice := Sys1.unitprice.Text
		; // END IF

	end;

{ ----------------------------------------------------------------------------}
{ Validate Parameter 1 fields																									}
{ ----------------------------------------------------------------------------}
	function ValidParm3(): boolean;
	begin

 		ValidParm3 := true;

	{ COMPANIES - Validated by languageONE }
		if Trim(Sys1.company01.Text) <> '' then
			A01_Company01 := StrToIntDef(Sys1.company01.Text,0)
		else
			A01_Company01 := 0;

		if Trim(Sys1.company02.Text) <> '' then
			A01_Company02 := StrToIntDef(Sys1.company02.Text,0)
		else
			A01_Company02 := 0;

		if Trim(Sys1.company03.Text) <> '' then
			A01_Company03 := StrToIntDef(Sys1.company03.Text,0)
		else
			A01_Company03 := 0;

		if Trim(Sys1.company04.Text) <> '' then
			A01_Company04 := StrToIntDef(Sys1.company04.Text,0)
		else
			A01_Company04 := 0;

		if Trim(Sys1.company05.Text) <> '' then
			A01_Company05 := StrToIntDef(Sys1.company05.Text,0)
		else
			A01_Company05 := 0;

		if Trim(Sys1.company06.Text) <> '' then
			A01_Company06 := StrToIntDef(Sys1.company06.Text,0)
		else
			A01_Company06 := 0;

		if Trim(Sys1.company07.Text) <> '' then
			A01_Company07 := StrToIntDef(Sys1.company07.Text,0)
		else
			A01_Company07 := 0;

		if Trim(Sys1.company08.Text) <> '' then
			A01_Company08 := StrToIntDef(Sys1.company08.Text,0)
		else
			A01_Company08 := 0;

		if Trim(Sys1.company09.Text) <> '' then
			A01_Company09 := StrToIntDef(Sys1.company09.Text,0)
		else
			A01_Company09 := 0;

		if Trim(Sys1.company10.Text) <> '' then
			A01_Company10 := StrToIntDef(Sys1.company10.Text,0)
		else
			A01_Company10 := 0;

		if Trim(Sys1.company11.Text) <> '' then
			A01_Company11 := StrToIntDef(Sys1.company11.Text,0)
		else
			A01_Company11 := 0;

		if Trim(Sys1.company12.Text) <> '' then
			A01_Company12 := StrToIntDef(Sys1.company12.Text,0)
		else
			A01_Company12 := 0;

	end;

{ -----------------------------------------------------------------------------}
{ End Of Program						 	                                             		 }
{ -----------------------------------------------------------------------------}
end.

