unit journal2;

{$mode ObjFPC}{$H+}
{$R *.lfm}                                                                               


{ ============================================================================= }
{ INTERFACE - Gloablity                                                         }
{ ============================================================================= }
{	The "interface" section of a Pascal UNIT exports PUBLIC variables, constants	}
{ types, and routines, while the USES clause imports exported identifiers from	}
{ another UNITS interface section }

	interface

	{	EXTERNAL }
		uses
			Classes, SysUtils, Forms, Controls, Graphics, Dialogs, StdCtrls,
  		StrUtils, LCLType, display1;

		type
			TJrn2 = class(TForm)
				Label1								:TLabel;
					start_dd						:TEdit;
					start_mm						:TEdit;
					start_ccyy					:TEdit;
				Label2								:TLabel;
					end_dd							:TEdit;
					end_mm							:TEdit;
					end_ccyy						:TEdit;
				Label3								:TLabel;
					reference						:TEdit;
				Label4								:TLabel;
					printdetails_Combo	:TComboBox;
    		bPrint								:TButton;

    	procedure FormShow(Sender:TObject);
 			procedure bPrintClick(Sender:TObject);
 			procedure onKeyPress(Sender:TObject;var Key:char);
			private
			public
		end;

		var
			Jrn2: TJrn2;

{ ============================================================================= }
{ IMPLEMENTATION- private/Local                                                 }
{ ============================================================================= }
{	The "inplementation" section declares PRIVATE variables, constants, types, 		}
{ and routines. }

	implementation
		uses
			unit0;

{ =============================================================================}
{ PROCEDURES/FUNCTIONS                                                         }
{ =============================================================================}

{ ----------------------------------------------------------------------------}
{ Form Show	setup Defaults																										}
{ ----------------------------------------------------------------------------}
	procedure TJrn2.FormShow(Sender:TObject);
	begin

		Jrn2.Caption := Format('%0.2d',[A01_Parameter]) + ' Print General Journal';

  	start_dd.Text		:= '01';
   	start_mm.Text		:= '07';
		X					 			:= nFinancialYear - 1;
   	start_ccyy.Text	:= IntToStr(X);

   	end_dd.Text			:= '30';
   	end_mm.Text			:= '06';
   	end_ccyy.Text		:= IntToStr(nFinancialYear);

		printdetails_Combo.Items.Clear;

		printdetails_Combo.Items.Add('Y');
		printdetails_Combo.Items.Add('N');
		printdetails_Combo.ItemIndex := 00;

	end;

{ -----------------------------------------------------------------------------}
{ Only allow numeric characters                              graph display `x/10b &w_Reference`
              		 }
{ -----------------------------------------------------------------------------}
	procedure TJrn2.onKeyPress(Sender:TObject;var Key:char);
	begin
 		If not (Key in ['0'..'9', Char(VK_BACK), Char(VK_DELETE)]) then Key := #0;
	end;

{ -----------------------------------------------------------------------------}
{ PRINT                                                                        }
{ -----------------------------------------------------------------------------}
	procedure TJrn2.bPrintClick(Sender:TObject);
	begin

	{ --------------------------- }
	{ Validate Dates							}
	{ --------------------------- }
		w_StartDate	:= L0_getDate(start_dd.Text,start_mm.Text,start_ccyy.Text);
		w_EndDate		:= L0_getDate(end_dd.Text,end_mm.Text,end_ccyy.Text);

		X := CompareStr(w_StartDate,w_EndDate);
  	if (X > 0) then
			begin
				MessageDlgPos('End date cannot be less then Start Date',
					mtConfirmation, [mbOk],0,200,200)
			end // END BEGIN
		; // END BEGIN

	{ --------------------------- }
	{ Other Options								}
	{ --------------------------- }
		w_reference := PadRight(reference.Text,10);
		If (printdetails_Combo.ItemIndex = 0) then
			w_PrintDetails	:= 'Y'
		else
			w_PrintDetails	:= 'N'
		; // END IF

	{ --------------------------- }
	{ MAKE THE CALL								}
	{ --------------------------- }
		L0_CALL(c_B02,c_Print,0,0,0);
		Close;

		Str := 'B02_' + aFinancialYear + '.PRT';
		Dsp1.ShowModal;


	end;

{ -----------------------------------------------------------------------------}
{ End Of Program						 	                                             		 }
{ -----------------------------------------------------------------------------}
end.

