unit report1;

{$mode ObjFPC}{$H+}
{$R *.lfm}

{ ============================================================================= }
{ INTERFACE - Gloablity                                                         }
{ ============================================================================= }
{	The "interface" section of a Pascal UNIT exports PUBLIC variables, constants	}
{ types, and routines, while the USES clause imports exported identifiers from	}
{ another UNITS interface section }

	interface

	{	EXTERNAL }
		uses
			Classes, SysUtils, Forms, Controls, Graphics, Dialogs,StdCtrls,
			LCLType, unit0, display1;

		type
   		TRpt1 = class(TForm)
				Label3						:TLabel;
					eop_dd					:TEdit;
					eop_mm					:TEdit;
					eop_ccyy				:TEdit;
				Label4						:TLabel;
					sub_Combo				:TComboBox;

				bProfit						:TButton;
				bBalance					:TButton;
				bTrading					:TButton;
				Label5						:TLabel;
					closing					:TEdit;

   		procedure FormShow(Sender:TObject);
			procedure onKeyPress(Sender:TObject;var Key:char);
   		procedure bProfitClick(Sender:TObject);
			procedure bTradingClick(Sender:TObject);
			procedure bBalanceClick(Sender:TObject);

			private
			public

		end;

var
			Rpt1: TRpt1;

{ ============================================================================= }
{ IMPLEMENTATION- private/Local                                                 }
{ ============================================================================= }
{	The "inplementation" section declares PRIVATE variables, constants, types, 		}
{ and routines. }

  Implementation

 	{ NOTE:- procedures/functions declared in the implementation section must			}
	{	contain the keyword "forward"																								}

		procedure PRINT(option:Int64;Ctrl:Int64); forward;

{ =============================================================================}
{ PROCEDURES/FUNCTIONS                                                         }
{ =============================================================================}

{ ----------------------------------------------------------------------------}
{ Form Show	setup Defaults																										}
{ ----------------------------------------------------------------------------}
	procedure TRpt1.FormShow(Sender:TObject);
	begin

		Rpt1.Caption := Format('%0.2d',[A01_Parameter]) + ' Print Reports';

   	eop_dd.Text			:= '30';
   	eop_mm.Text			:= '06';
   	eop_ccyy.Text		:= IntToStr(nFinancialYear);

		If A01_ParameterNo = 3 then
			begin
				sub_Combo.ItemIndex := 00;
				Label4.Visible 			:= FALSE;
				sub_Combo.Visible 	:= FALSE;
			end // END BEGIN
		else
			begin
				sub_Combo.Items.Clear;
				sub_Combo.Items.Add('S');
				sub_Combo.Items.Add('C');
				sub_Combo.ItemIndex := 00;
				Label4.Visible 			:= TRUE;
				sub_Combo.Visible 	:= TRUE;
			end // END BEGIN
		; // END IF

		closing.Text				:= '0.0';

	end;

{ -----------------------------------------------------------------------------}
{ Only allow numeric characters                                            		 }
{ -----------------------------------------------------------------------------}
	procedure TRpt1.onKeyPress(Sender:TObject;var Key:char);
	begin
 		If not (Key in ['0'..'9', Char(VK_BACK), Char(VK_DELETE)]) then Key := #0;
	end;

{ -----------------------------------------------------------------------------}
{ Profit/Loss                                                                  }
{ -----------------------------------------------------------------------------}
	procedure TRpt1.bProfitClick(Sender:TObject);
	begin
		PRINT(1,0);
	end;

{ -----------------------------------------------------------------------------}
{ Profit/Loss                                                                  }
{ -----------------------------------------------------------------------------}
	procedure TRpt1.bTradingClick(Sender:TObject);
	begin
  	PRINT(2,0);
	end;

{ -----------------------------------------------------------------------------}
{ Trading Statement                                                            }
{ -----------------------------------------------------------------------------}
	procedure TRpt1.bBalanceClick(Sender:TObject);
	begin
  	PRINT(3,sub_Combo.ItemIndex);
	end;


{ -----------------------------------------------------------------------------}
{ PRINT                                                                        }
{ -----------------------------------------------------------------------------}
	procedure PRINT(option:Int64;Ctrl:Int64);
	begin

	{ --------------------------- }
	{ Validate Date								}
	{ --------------------------- }
		w_Date	:= L0_getDate(Rpt1.eop_dd.Text,Rpt1.eop_mm.Text,Rpt1.eop_ccyy.Text);

		L0_Call(c_B99,c_B99_ValidDate,0,0,0);
		if (RETURN_CODE <> 0) then
			begin
				MessageDlgPos('Invalid Date',mtConfirmation, [mbOk],0,150,150);
				exit;
			end // END BEGIN
		; // END IF

	{ --------------------------- }
	{ MAKE THE CALL								}
	{ --------------------------- }
		L0_Call(c_B04,c_Print,option,Ctrl,0);
		if (RETURN_CODE = 0) then
			begin
				Rpt1.Close;

				Str := 'B04_' + aFinancialYear;
				case option of
					01: Str := Str + '.P&L';
					02: Str := Str + '.TRD';
        	03: Str := Str + '.BAL';
				end; // END CASE
				Dsp1.ShowModal;
			end // END BEGIN

		else
			case RETURN_CODE of
				01: MessageDlgPos('Missing PA or PL Account',mtConfirmation, [mbOk],0,150,150);
				02: MessageDlgPos('Missing AS,TO or TC Account',mtConfirmation, [mbOk],0,150,150);
			end; // END CASE

	end;

{ -----------------------------------------------------------------------------}
{ End Of Program						 	                                             		 }
{ -----------------------------------------------------------------------------}
end.

