;========================================================================				
;	BEGIN CONSTANTS
;========================================================================
;
;	NOTE:-
;	Consider the following
;		Field defined in the data section		%IFDEF			
;		EQU 1									%IFID
;		EQU "Hello"								%IFID
;		%define 1								%IFDEF/IFNUM
;		%define "Hello"							%IFDEF/IFSTR
;	
;	EQU does not get detected by NASM as a number or string. This causes 
;	problems when you do something like IF A = c_TRUE as the value of 
;	c_TRUE will be used as an address. Note that such field must be %defined
;
;========================================================================

	%define	c_TRUE  1
	%define	c_FALSE	0

;	-----
;	V2.13
;	-----	
;	STDIO
	
	%define c_RETURN			000
	%define c_FUNCTIONKEY1   	001
	%define c_FUNCTIONKEY2   	002
	%define c_FUNCTIONKEY3   	003
	%define c_FUNCTIONKEY4   	004
	%define c_FUNCTIONKEY5   	005
	%define c_FUNCTIONKEY6   	006
	%define c_FUNCTIONKEY7   	007
	%define c_FUNCTIONKEY8   	008
	%define c_FUNCTIONKEY9   	009
	%define c_FUNCTIONKEY10  	010
	%define c_FUNCTIONKEY11  	011
	%define c_FUNCTIONKEY12  	012
	%define c_ALT				013
	%define c_ARROWUP			014
	%define c_ARROWDOWN			015
	%define c_ARROWRIGHT		016
	%define c_ARROWLEFT			017
	%define c_END				018
	%define c_HOME				019
	%define c_INSERT			020
	%define c_ENDOFFIELD		021
	%define c_TAB				022
	%define c_ESCAPE			027
	%define c_BACKSPACE			127
	%define c_NONE				999
	

;	DECISIONS
;	=========
;-----------------
;	Alternative A - Works in Linux
; ---------------
	;=						equ 00000001b
	;!=						equ 00000010b
	;<						equ 00000100b
	;!<			 			equ 00001000b
	;>						equ 00010000b													
	;!>						equ	00100000b
;----------------
;	Alternative B - And Mandatory for Windows/MASM
; ---------------
	_EQ						equ 00000001b
	_NEQ					equ 00000010b
	_LT						equ 00000100b
	_NLT		 			equ 00001000b
	_GT						equ 00010000b													
	_NGT					equ	00100000b	
												  	
;	Alternative C - Deprecated
;	-------------
;	Equals					equ 00000001b
;	isNOTEqualTo			equ 00000010b
;	isLessThan				equ 00000100b
;	isNOTLessThan 			equ 00001000b
;	isGreaterThanOREqualTo	equ 00001000b
;
;	isGreaterThan			equ 00010000b													
;	isNOTGreaterThan		equ	00100000b
;	isLessThanOREqualTo		equ 00100000b



;	Also can use IN
	_IN						equ 01000000b
	_NIN					equ 10000000b
;----------------

;	FILES
;	=====								  		
	$read 					equ	0x000
	$write	 				equ	0x001
	$readwrite				equ 0x002
	$open					equ 0x002
		$create				equ 0064	;0100octal
		$beginning			equ 0512	;1000octal
		$end				equ 1024	;2000octal
		$lock				equ	2048	;4000octal		
	$close					equ 0x003
	$start					equ 0x004
	$next					equ 0x005
	$delete					equ 0x006

	$filescopy				equ 0x007
	$rename					equ 0x008
	$remove					equ 0x009
	$chdir					equ 0x00A
	$getcwd					equ 0x00B

;	-----
;	V2.03
;	-----	
	$rlock					equ 0x00C
	$runlock				equ 0x00D

;	Record Delimiters/CVS for INSERTFILE	
	c_NULL					equ 00000001b 
	c_LF					equ 00000010b 
	c_CSV					equ 00000100b
	c_RECORD				equ 00001000b
	c_RANDOM				equ 00010000b
	c_INDEXED				equ 00100000b
	c_DIRECTORY				equ	01000000b

;	NUMBERS
;	=======
	$add					EQU 00000001B
	$subtract				EQU 00000010B
	$multiply				EQU 00000100B
	$divide					EQU 00001000B
	$equals					EQU 00010000B
	$random					EQU 00100000B

;	(X)TABLES
;	=========
	$bind					EQU 00000001B
	$sort					EQU 00001000B
	$search					EQU	00010000B

	$rget	 				EQU	00000010B
	$fget					EQU 00000011B
	$rput	 				EQU	00000100B
	$fput					EQU 00000101B
;	XTABLES
	$del					EQU 00100000B
	$load					EQU 01000000B
	$unload					EQU 10000000B
	
;	WORDS
;	=====
	$copy					equ 00000001b
	$pad					equ 00000010b													
	$uppercase 				equ	00000100b							
	$lowercase 				equ	00001000b
	$insert					equ 00010000b
	$find					equ 00100000b
	$replace				equ 01000000b
	$environment 			equ 10000000b
;	-----
;	V2.05
;	-----
	$stringtorecord			equ 10000001b			; be careful with these
	$recordtostring			equ 10000010b			; Must use cmp NOT test

;	WWW
;	===
	$wwwOpen				equ 0000						
	$wwwProcess				equ 0001							
	$wwwClose				equ 0002
;	-----
;	V2.04
;	-----		
	$wwwSendMsg				equ 0003
	$wwwRecvMsg				equ 0004

;	WINDOWS SPECIFIC
;	================
	wc_STD_IN				equ -10		; GetStdHandle
	wc_STD_OUT				equ -11		; GetStdHandle
	wc_STD_ERR				equ -12		; GetStdHandle

;========================================================================				
;	END CONSTANTS
;========================================================================	

