unit unitP;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Forms, Controls, Graphics, Dialogs, SynEdit;

type
  TForm1 = class(TForm)
    procedure FormCreate(Sender: TObject);
  private
    SynEdit: TSynEdit;
    procedure SynEditPaint(Sender: TObject; Canvas: TCanvas);
  end;

var
  TForm1: TForm1;

implementation

{$R *.lfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  SynEdit := TSynEdit.Create(Self);
  SynEdit.Parent := Self;
  SynEdit.Align := alClient;

  // Assign the paint handler
  SynEdit.OnPaint := @SynEditPaint;
end;

// The handler must match TPaintEvent = procedure(Sender: TObject; ACanvas: TCanvas) of object;
procedure TForm1.SynEditPaint(Sender: TObject; Canvas: TCanvas);
begin
  Canvas.Font.Color := clRed;
  Canvas.TextOut(10, 10, 'Custom Paint');
end;

end.

