unit enquire2;

{$mode ObjFPC}{$H+}
{$R *.lfm}

{ ============================================================================= }
{ INTERFACE - Gloablity                                                         }
{ ============================================================================= }
{	The "interface" section of a Pascal UNIT exports PUBLIC variables, constants	}
{ types, and routines, while the USES clause imports exported identifiers from	}
{ another UNITS interface section }

	interface

	{	EXTERNAL }
		uses
			Classes, SysUtils, Forms, Controls, Graphics, Dialogs,StdCtrls,ComCtrls,
			LCLType, display1;

		type
   		TEnq2 = class(TForm)
				Label1										:TLabel;
					start_acctno						:TEdit;
					start_acctno_spinner		:TUpDown;
				Label2										:TLabel;
					end_acctno							:TEdit;
					end_acctno_spinner			:TUpDown;
				Label3										:TLabel;
					start_dd								:TEdit;
					start_mm								:TEdit;
					start_ccyy							:TEdit;
				Label4										:TLabel;
					end_dd									:TEdit;
					end_mm									:TEdit;
					end_ccyy								:TEdit;
				Label5										:TLabel;
					printtrans_Combo				:TComboBox;
				Label6										:TLabel;
					printzero_Combo					:TComboBox;
				Label7										:TLabel;
					printnewpage_Combo			:TComboBox;
				bPrint										:TButton;

				procedure FormShow(Sender:TObject);
				procedure onKeyPress(Sender:TObject;var Key:char);
				procedure start_acctnoKeyUp(Sender:TObject;var Key:Word;Shift:TShiftState);
				procedure end_acctnoKeyUp(Sender:TObject;var Key:Word;Shift:TShiftState);
				procedure start_acctno_spinnerClick(Sender:TObject;Button:TUDBtnType);
				procedure end_acctno_spinnerClick(Sender:TObject;Button:TUDBtnType);
				procedure bPrintClick(Sender:TObject);
				private
				public
			end;

		var
			Enq2: TEnq2;

{ ============================================================================= }
{ IMPLEMENTATION- private/Local                                                 }
{ ============================================================================= }
{	The "inplementation" section declares PRIVATE variables, constants, types, 		}
{ and routines. }

	implementation
		uses
			unit0, search1;

{ =============================================================================}
{ PROCEDURES/FUNCTIONS                                                         }
{ =============================================================================}

{ -----------------------------------------------------------------------------}
{ on Show setup Defaults							                                         }
{ -----------------------------------------------------------------------------}
	procedure TEnq2.FormShow(Sender:TObject);
	begin

		Enq2.Caption := Format('%0.2d',[A01_Parameter]) + ' Print Accounts';

		l1_Call(c_B01,c_Start,1,0,0);
    start_acctno.Text	:= IntToStr(B01_AcctNo);
    end_acctno.Text		:= '59999';

   	start_dd.Text			:= '01';
   	start_mm.Text			:= '07';
		X						 			:= nFinancialYear - 1;
   	start_ccyy.Text		:= IntToStr(X);

   	end_dd.Text				:= '30';
   	end_mm.Text				:= '06';
   	end_ccyy.Text			:= IntToStr(nFinancialYear);

		printtrans_Combo.Items.Clear;
		printtrans_Combo.Items.Add('Y');
		printtrans_Combo.Items.Add('N');
		printtrans_Combo.ItemIndex := 00;

		printzero_Combo.Items.Clear;
		printzero_Combo.Items.Add('Y');
		printzero_Combo.Items.Add('N');
		printzero_Combo.ItemIndex := 01;

		printnewpage_Combo.Items.Clear;
		printnewpage_Combo.Items.Add('Y');
		printnewpage_Combo.Items.Add('N');
		printnewpage_Combo.ItemIndex := 01;

	end;

{ -----------------------------------------------------------------------------}
{ Only allow numeric characters                                            		 }
{ -----------------------------------------------------------------------------}
	procedure TEnq2.onKeyPress(Sender:TObject;var Key:char);
	begin
  	If not (Key in ['0'..'9', Char(VK_BACK), Char(VK_DELETE)]) then Key := #0;
	end;

{ -----------------------------------------------------------------------------}
{ Account Search					                                                     }
{ -----------------------------------------------------------------------------}
	procedure TEnq2.start_acctnoKeyUp(Sender:TObject;var Key:Word;Shift:TShiftState);
	begin

	{	------------ }
	{	PF2 - Search }
	{	------------ }
		If  (key = 113) then
			begin
				Key 		:= 0;
				S.ID		:= 5;
				S.Acct	:= StrToInt(start_acctno.Text);
      	Sch1.ShowModal;
			end // END BEGIN
		; // End If

	end;

{ -----------------------------------------------------------------------------}
{ Account Search					                                                     }
{ -----------------------------------------------------------------------------}
	procedure TEnq2.end_acctnoKeyUp(Sender:TObject;var Key:Word;Shift:TShiftState);
	begin

	{	------------ }
	{	PF2 - Search }
	{	------------ }
		If  (key = 113) then
			begin
				Key 		:= 0;
				S.ID		:= 6;
				S.Acct	:= StrToInt(end_acctno.Text);
      	Sch1.ShowModal;
			end // END BEGIN
		; // End If

	end;

{ -----------------------------------------------------------------------------}
{ Flag 2 spinner 	                                                             }
{ -----------------------------------------------------------------------------}
	procedure TEnq2.start_acctno_spinnerClick(Sender:TObject;Button:TUDBtnType);
	begin

		If Button = btNext then
			X := 1
		else
			X := -1
		; // END IF

		X := ACCT_SPINNER(StrToInt(start_acctno.Text),X);
		If (X > 0) then
			begin
				start_acctno.Text := IntToStr(X);
			end // END BEGIN
		; // END IF

	end;

{ -----------------------------------------------------------------------------}
{ Flag 2 spinner 	                                                             }
{ -----------------------------------------------------------------------------}
	procedure TEnq2.end_acctno_spinnerClick(Sender:TObject;Button:TUDBtnType);
	begin

		If Button = btNext then
			X := 1
		else
			X := -1
		; // END IF

		X := ACCT_SPINNER(StrToInt(end_acctno.Text),X);
		If (X > 0) then
			begin
				end_acctno.Text := IntToStr(X);
			end // END BEGIN
		; // END IF

	end;

{ -----------------------------------------------------------------------------}
{ PRINT                                                                        }
{ -----------------------------------------------------------------------------}
	procedure TEnq2.bPrintClick(Sender:TObject);
	begin

	{ --------------------------- }
	{ Validate Accounts						}
	{ --------------------------- }
  	n_StartAcctNo	:= StrToInt(start_acctno.Text);
  	n_EndAcctNo		:= StrToInt(end_acctno.Text);
  	if n_EndAcctNo < n_StartAcctNo then
			begin
				MessageDlgPos('End Parameter No cannot be less then Start Parameter No',
					mtConfirmation, [mbOk],0,150,150);
				exit;
			end; // END BEGIN
		; // END IF

	{ --------------------------- }
	{ Validate Dates							}
	{ --------------------------- }
		w_StartDate	:= l1_getDate(start_dd.Text,start_mm.Text,start_ccyy.Text);
		w_EndDate		:= l1_getDate(end_dd.Text,end_mm.Text,end_ccyy.Text);
		X := CompareStr(w_StartDate,w_EndDate);
  	if (X > 0) then
			begin
				MessageDlgPos('End date cannot be less then Start Date',
					mtConfirmation, [mbOk],0,200,200)
			end // END BEGIN
		; // END BEGIN


	{ --------------------------- }
	{ Other Options								}
	{ --------------------------- }
		If (printtrans_Combo.ItemIndex = 0) then
			w_PrintTrans	:= 'Y'
		else
			w_PrintTrans	:= 'N'
		; // END IF

		If (printzero_Combo.ItemIndex = 0) then
			w_PrintZero		:= 'Y'
		else
			w_PrintZero		:= 'N'
		; // END IF

		If (printnewpage_Combo.ItemIndex = 0) then
			w_PrintNewPage	:= 'Y'
		else
			w_PrintNewPage	:= 'N'
		; // END IF

	{ --------------------------- }
	{ MAKE THE CALL								}
	{ --------------------------- }
		l1_Call(c_B03,c_Print,0,0,0);
  	Close;

		Str := 'B03_' + aFinancialYear + '.PRT';
		Dsp1.ShowModal;

	end;

{ -----------------------------------------------------------------------------}
{ End Of Program						 	                                             		 }
{ -----------------------------------------------------------------------------}
end.

