unit journal1;

{$mode ObjFPC}{$H+}
{$R *.lfm}

{ ============================================================================= }
{ INTERFACE - Gloablity                                                         }
{ ============================================================================= }
{	The "interface" section of a Pascal UNIT exports PUBLIC variables, constants	}
{ types, and routines, while the USES clause imports exported identifiers from	}
{ another UNITS interface section }

	interface

	{	EXTERNAL }
		uses
			Classes,SysUtils,Forms,Controls,Graphics,Dialogs,ExtCtrls,StdCtrls,ComCtrls,
			LCLType,StrUtils,Math;

		type

			{ TJrn1 }

    TJrn1 = class(TForm)
					Calc:TPanel;
					calc1:TEdit;
					calc2:TEdit;
					result:TButton;
					calcWhat:TButton;
				Panel1														:TPanel;
		 			Label1:TLabel;
						key_ccyy											:TEdit;
						key_dd												:TEdit;
						key_mm												:TEdit;
						key_time											:TEdit;
				Panel2														:TPanel;
					PageControl1										:TPageControl;
						TabSheet1											:TTabSheet;
							Label4											:TLabel;
								dracctno									:TEdit;
								dracctno_spinner					:TUpDown;
								dracctno_description			:TLabel;
							Label10											:TLabel;
								cracctno									:TEdit;
								cracctno_spinner					:TUpDown;
								cracctno_description			:TLabel;
							Label3											:TLabel;
								description								:TEdit;
							Label11											:TLabel;
								value											:TEdit;
							Label12											:TLabel;
								noofunits									:TEdit;
							Label13											:TLabel;
								reference									:TEdit;
						TabSheet2											:TTabSheet;
							Label5											:TLabel;
 								invtrantype								:TEdit;
								invtrantype_spinner				:TUpDown;
								invtrantype_description		:TLabel;
							Label6											:TLabel;
								invacctno									:TEdit;
								invacctno_spinner					:TUpDown;
								invacctno_description			:TLabel;
							Label7											:TLabel;
								invparcelno								:TEdit;
							Label8											:TLabel;
								invgrouping								:TEdit;
						TabSheet3											:TTabSheet;
							Label9											:TLabel;
								invfrankedamt							:TEdit;
							Label14											:TLabel;
								invimputedcredit					:TEdit;

				bCancel														:TButton;
				bDelete														:TButton;
				bSave															:TButton;

 			ListView														:TListView;
		pfKey																:TPanel;

   	procedure cracctnoKeyUp(Sender:TObject;var Key:Word;Shift:TShiftState);
  	procedure dracctnoKeyUp(Sender:TObject;var Key:Word;Shift:TShiftState);
    procedure FormCreate(Sender:TObject);
		procedure FormShow(Sender: TObject);
		procedure FormKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
		procedure invacctnoKeyUp(Sender:TObject;var Key:Word;Shift:TShiftState);
   	procedure onKeyPress(Sender:TObject;var Key:char);
		procedure dracctno_spinnerClick(Sender:TObject;Button:TUDBtnType);
	 	procedure cracctno_spinnerClick(Sender:TObject;Button:TUDBtnType);
  	procedure bSaveClick(Sender:TObject);
  	procedure bDeleteClick(Sender:TObject);
	 	procedure bCancelClick(Sender:TObject);
		procedure invacctno_spinnerClick(Sender:TObject;Button:TUDBtnType);
		procedure invtrantype_spinnerClick(Sender:TObject;Button:TUDBtnType);
	 	procedure ListViewClick(Sender:TObject);
	 	procedure TabSheet3Show(Sender:TObject);

		procedure calc2KeyUp(Sender:TObject;var Key:Word;Shift:TShiftState);
		procedure resultClick(Sender:TObject);

		private
		public
	end;

	var
		Jrn1					: TJrn1;
		bFromEnquiry	: boolean = false;
		messX					: Int64;
		messY					: Int64;

	{ NOTE:- procedures/functions declared in the interface section enable  			}
	{	to be used by another unit (enquire1 in this case)													}
		procedure FROM_ENQUIRY ();

{ ============================================================================= }
{ IMPLEMENTATION- private/Local                                                 }
{ ============================================================================= }
{	The "inplementation" section declares PRIVATE variables, constants, types, 		}
{ and routines. }

  Implementation
		uses
			Unit0, Journal2, Search1;

	{ NOTE:- procedures/functions declared in the implementation section must			}
	{	contain the keyword "forward"																								}
		procedure Details_Enable(); forward;
		procedure TRAN_LISTVIEW(); forward;
  	procedure Key_Enable(); forward;
  	procedure init_trans(); forward;
 		function	DETAILS_OKAY(): boolean; forward;
 		function  GET_TRAN() : boolean; forward;
		procedure DOCALC(); forward;

{ =============================================================================}
{ PROCEDURES/FUNCTIONS                                                         }
{ =============================================================================}

{ -----------------------------------------------------------------------------}
{ This drived things required to work when called from enquire1	               }
{ -----------------------------------------------------------------------------}
	procedure FROM_ENQUIRY ();
	begin

		if GET_TRAN then
			begin
				bFromEnquiry := true;
				Jrn1.SetBounds(150,150,615,640);
				messX := 200; messY := 200;
				Jrn1.ShowModal;
				Jrn1.SetBounds(100,100,615,640);
				messX := 150; messY := 150;
			end // END BEGIN
		; // END IF

	end;

{ -----------------------------------------------------------------------------}
{ on Create Set ABLE/DISABLE fields		                                         }
{ -----------------------------------------------------------------------------}
	procedure TJrn1.FormCreate(Sender:TObject);
	begin

	{ Form to get Keystroke 1st	}
		KeyPreview	:= true;
	{ Co-ordinance for messages	}
		messX				:= 150;
		messY				:= 150;

	end;

{ ----------------------------------------------------------------------------}
{ Form Show																																		}
{ ----------------------------------------------------------------------------}
	procedure TJrn1.FormShow(Sender: TObject);
	begin

		{ Only Print allowed for Consolidated Companies }
		If A01_ParameterNo = 3 then
			begin
				Close;
			end // END BEGIN
		; // END IF

		Jrn1.Caption := Format('%0.2d',[A01_Parameter]) + ' General Journal';

		If bFromEnquiry then
			Details_Enable
		else
			Key_Enable
		; // END IF

		TRAN_LISTVIEW();

	end;

{ -----------------------------------------------------------------------------}
{ on form key down check for function keys                                     }
{ -----------------------------------------------------------------------------}
	procedure TJrn1.FormKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
	begin

	{	----------- }
	{	PF3 - Print }
	{	----------- }
		If  (key = 114)
		and (key_dd.enabled) then
			begin
				Key := 0;
      	Jrn2.ShowModal;
			end
		; // End If

	{	------------ }
	{	PF5 - Accept }
	{	------------ }
		If  (key = 116)
		and (key_dd.enabled) then
			begin
				Key 			:= 0;
		    b02_recNo := 0;
				if GET_TRAN then
          	Details_Enable
        ; // END IF
			end // END BEGIN
    ; // END IF

	{	------------ }
	{	calculator	 }
	{	------------ }
		If  (key = 112) then
			begin
				calc1.Text			:= result.Caption;
				calc2.Text			:= '0.00';
				result.Caption	:= '0.00';
				calc2.SetFocus;
				exit;
			end // END BEGIN
    ; // END IF

    case key of 107,109,106,111:
			begin
				case key of
					107 : calcWhat.Caption := '+';
					109 : calcWhat.Caption := '-';
					106 : calcWhat.Caption := '*';
					111 : calcWhat.Caption := '/';
				end; // END CASE

				key := 0;
				DOCALC;
				calc2.SetFocus;

			end // END BEGIN
		end; // END CASE

	end;

{ ----------------------------------------------------------------------------}
{ Field must be numeric																												}
{ ----------------------------------------------------------------------------}
	procedure TJrn1.onKeyPress(Sender:TObject;var Key:char);
		begin

			If Key = '.' then
				If (Sender = value)
				Or (Sender = invfrankedamt)
				Or (Sender = invimputedcredit)
				Or (Sender = calc1)
				Or (Sender = calc2) then
			else
				begin
					Key := #0;
					exit;
				end;
			; // END IF

		If not (Key in ['0'..'9', Char(VK_BACK), Char(VK_DELETE)]) then Key := #0;

	end;

{ -----------------------------------------------------------------------------}
{ Account Search					                                                     }
{ -----------------------------------------------------------------------------}
	procedure TJrn1.dracctnoKeyUp(Sender:TObject;var Key:Word;Shift:TShiftState);
	begin

	{	------------ }
	{	PF2 - Search }
	{	------------ }
		If  (key = 113) then
			begin
				Key 		:= 0;
				S.ID		:= 1;
				S.Acct	:= StrToInt(dracctno.Text);
      	Sch1.ShowModal;
			end // END BEGIN
		; // End If

	end;

{ -----------------------------------------------------------------------------}
{ Account Search					                                                     }
{ -----------------------------------------------------------------------------}
	procedure TJrn1.cracctnoKeyUp(Sender:TObject;var Key:Word;Shift:TShiftState);
	begin

	{	------------ }
	{	PF2 - Search }
	{	------------ }
		If  (key = 113) then
			begin
				Key 		:= 0;
				S.ID		:= 2;
				S.Acct	:= StrToInt(cracctno.Text);
      	Sch1.ShowModal;
			end // END BEGIN
		; // End If

	end;

{ -----------------------------------------------------------------------------}
{ Account Search					                                                     }
{ -----------------------------------------------------------------------------}
	procedure TJrn1.invacctnoKeyUp(Sender:TObject;var Key:Word;Shift:TShiftState);
	begin

	{	------------ }
	{	PF2 - Search }
	{	------------ }
		If  (key = 113) then
			begin
				Key 		:= 0;
				S.ID		:= 3;
				S.Acct	:= StrToInt(invacctno.Text);
      	Sch1.ShowModal;
			end // END BEGIN
		; // End If

	end;

{ -----------------------------------------------------------------------------}
{ Populate Franked Ammount                                                     }
{ -----------------------------------------------------------------------------}
	procedure TJrn1.TabSheet3Show(Sender:TObject);
	begin

			If (invtrantype.Text = '2') or (invtrantype.Text = '5') then
				If invfrankedamt.Text = '0.00' then
					invfrankedamt.Text := value.Text
				; // END IF
			; // END IF

	end;

{ -----------------------------------------------------------------------------}
{ Debit Account No Spinner                                                     }
{ -----------------------------------------------------------------------------}
	procedure TJrn1.dracctno_spinnerClick(Sender:TObject;Button:TUDBtnType);
	begin

		If Button = btNext then
			X := 1
		else
			X := -1
		; // END IF

		X := ACCT_SPINNER(StrToInt(dracctno.Text),X);
		If (X > 0) then
			begin
				dracctno.Text := IntToStr(X);
				dracctno_description.Caption := B01_Description;
			end // END BEGIN
		; // END IF

	end;

{ -----------------------------------------------------------------------------}
{ Credit Account No Spinner                                                    }
{ -----------------------------------------------------------------------------}
	procedure TJrn1.cracctno_spinnerClick(Sender:TObject;Button:TUDBtnType);
	begin

		If Button = btNext then
			X := 1
		else
			X := -1
		; // END IF

		X := ACCT_SPINNER(StrToInt(cracctno.Text),X);
		If (X > 0) then
			begin
				cracctno.Text := IntToStr(X);
				cracctno_description.Caption := B01_Description;
			end // END BEGIN
		; // END IF

	end;

{ -----------------------------------------------------------------------------}
{ Investment Transaction Type Spinner                                          }
{ -----------------------------------------------------------------------------}
	procedure TJrn1.invtrantype_spinnerClick(Sender:TObject;Button:TUDBtnType);
	begin

		If Button = btNext then
			X := 1
		else
			X := -1
		; // END IF

		X := StrToInt(invtrantype.Text) + X;
		If (X > 8) then X := 8;
		If (X = 0) then X := 1;
		invtrantype.Text := IntToStr(X);

    Case X of
      1:	begin
						invtrantype_description.Caption	:= 'Purchase';
						invgrouping.Text								:= '100';
					end;
      2:	begin
						invtrantype_description.Caption	:= 'ReInvested Income';
						invgrouping.Text								:= '200';
					end;
      3:	begin
						invtrantype_description.Caption	:= 'Revaluation';
						invgrouping.Text								:= '300';
					end;
      4:	begin
						invtrantype_description.Caption	:= 'Sale';
						invgrouping.Text								:= '400';
					end;
      5:	begin
						invtrantype_description.Caption	:= 'Income';
						invgrouping.Text								:= '500';
					end;
      6:	begin
						invtrantype_description.Caption	:= 'Expense';
						invgrouping.Text								:= '600';
					end;
      7:	begin
						invtrantype_description.Caption	:= 'Capital Gain/Loss';
						invgrouping.Text								:= '700';
					end;
      8:	begin
						invtrantype_description.Caption	:= 'Tax';
						invgrouping.Text								:= '800';
					end;
    End; // END CASE

	end;

{ -----------------------------------------------------------------------------}
{ Investment Account No Spinner                                                }
{ -----------------------------------------------------------------------------}
	procedure TJrn1.invacctno_spinnerClick(Sender:TObject;Button:TUDBtnType);
	begin

		If Button = btNext then
			X := 1
		else
			X := -1
		; // END IF

		X := ACCT_SPINNER(StrToInt(invacctno.Text),X);
		If (X > 0) then
			begin
				invacctno.Text := IntToStr(X);
				invacctno_description.Caption := B01_Description;
			end // END BEGIN
		; // END IF

	end;

{ -----------------------------------------------------------------------------}
{ Selected from List View   	                                             		 }
{ -----------------------------------------------------------------------------}
	procedure TJrn1.ListViewClick(Sender: TObject);
	begin

		if(ListView.ItemIndex > -1) then
			begin
				b02_recNo := StrToInt(ListView.Selected.Caption);
				if  GET_TRAN then
						Details_Enable;
				; // END IF
 			end // END BEGIN
 		; // END IF

	end;

{ ----------------------------------------------------------------------------}
{ Details DELETE																															}
{ ----------------------------------------------------------------------------}
	procedure TJrn1.bDeleteClick(Sender: TObject);
	begin

		case MessageDlgPos('Are you sure', mtConfirmation, [mbYes, mbNo, mbCancel],0,messX,messY) of
			mrCancel:;
			mrNO 		:;
			mrYes		:
				begin

					l1_CALL(c_B02,c_Delete,b02_recNo,0,0);
					if RETURN_CODE = 0 then
						begin
							TRAN_LISTVIEW();
							Key_Enable;
						end // END BEGIN
					else
						case RETURN_CODE of
							52: MessageDlgPos('Debit Account does not exist',mtConfirmation, [mbOk],0,messX,messY);
							53: MessageDlgPos('Credit Account does not exist',mtConfirmation, [mbOk],0,messX,messY);
							54: MessageDlgPos('Investment Account does not exist',mtConfirmation, [mbOk],0,messX,messY);
							55: MessageDlgPos('Value cannot be zero',mtConfirmation, [mbOk],0,messX,messY);
						end // END CASE
					; // END IF
				end // END BEGIN
		end; // END CASE

end;

{ ----------------------------------------------------------------------------}
{ Details SAVE																																}
{ ----------------------------------------------------------------------------}
procedure TJrn1.bSaveClick(Sender: TObject);
begin

	If DETAILS_OKAY() then
		Key_Enable
	; // END IF

end;

{ ----------------------------------------------------------------------------}
{ Details CANCEL																															}
{ ----------------------------------------------------------------------------}
	procedure TJrn1.bCancelClick(Sender: TObject);
	begin
		key_Enable;
	end;

{ ----------------------------------------------------------------------------}
{ Key Enable																																	}
{ ----------------------------------------------------------------------------}
	procedure Key_Enable ();
	begin

	{	------------ }
	{	Enable KEY	 }
	{	------------ }
		Jrn1.key_dd.enabled						:= true;
		Jrn1.key_mm.enabled						:= true;
		Jrn1.key_ccyy.enabled					:= true;

	{	--------------- }
	{	Disable DETAILS }
	{	--------------- }
		Jrn1.PageControl1.enabled			:= false;
		Jrn1.bSave.enabled						:= false;
		Jrn1.bDelete.enabled					:= false;
		Jrn1.bCancel.enabled					:= false;

		Jrn1.ListView.enabled					:= true;

	end;

{ ----------------------------------------------------------------------------}
{ Details Enable																															}
{ ----------------------------------------------------------------------------}
	procedure Details_Enable ();
	begin

	{	------------ }
	{	Disable KEY	 }
	{	------------ }
		Jrn1.key_dd.enabled						:= false;
		Jrn1.key_mm.enabled						:= false;
		Jrn1.key_ccyy.enabled					:= false;

	{	--------------- }
	{	Enable DETAILS	}
	{	--------------- }
		Jrn1.PageControl1.enabled			:= true;
		Jrn1.PageControl1.ActivePage	:= Jrn1.Tabsheet1;
 		Jrn1.dracctno.SetFocus;

		Jrn1.bSave.enabled						:= true;
		Jrn1.bDelete.enabled					:= true;
		Jrn1.bCancel.enabled					:= true;

		Jrn1.ListView.enabled					:= false;

	end;

{ -----------------------------------------------------------------------------}
{	populate ListView																														 }
{ -----------------------------------------------------------------------------}
	procedure TRAN_LISTVIEW();
	var
		Line	: TListItem;

	begin
		Jrn1.ListView.Items.Clear;

		l1_Call(c_B02,c_Start,0,0,0);
		If RETURN_CODE <> 0 then
			exit;

	{	----------------- }
	{	Transactions Loop	}
	{	----------------- }
		X	:= 0;
		while 1=1 do
			begin

				X := X + 1;

			{ get Record }
				l1_Call(c_B02,c_PreviousNext,1,0,0);
				if RETURN_CODE <> 0 then
						break;

				Str := MidStr(B02_TranDate,1,4);
				Str := Str + '/' + MidStr(B02_TranDate,6,2);
				Str := Str + '/' + MidStr(B02_TranDate,9,2);

			{ Populate ListView }
				Line := Jrn1.ListView.Items.add;
					Line.Caption:= Format('%0.3d',[B02_Record_NO]);
						Line.SubItems.Add(Str);
						Line.SubItems.Add(B02_Description);
 // 					Str := FloatToStrF((w_B02_Value / 100),ffCurrency,6,2);
						Line.SubItems.Add(w_B02_Value);

			end // END BEGIN
		; // END WHILE

	{ Get the details of the 1st one }
		If (X = 1) and (RETURN_CODE <> 0) then
			MessageDlgPos('No transactions for this account as yet',mtConfirmation, [mbOk],0,X,Y)
		else
			begin
				l1_Call(c_B02,c_Start,0,0,0);
				Jrn1.key_dd.Text 		:= MidStr(B02_TranDate,9,2);
				Jrn1.key_mm.Text		:= MidStr(B02_TranDate,6,2);
				Jrn1.key_ccyy.Text	:= MidStr(B02_TranDate,1,4);
    		Jrn1.key_time.Text	:= B02_TranTime;
				Jrn1.ListView.Items[0].MakeVisible(true);

			end // END BEGIN
		; // End IF

	end;

{ ----------------------------------------------------------------------------}
{ GET_TRAN																																		}
{ ----------------------------------------------------------------------------}
	function GET_TRAN() : boolean;
	begin

	{ ------------------------- }
	{ F5 PRESSED -> Valid Key ? }
	{-------------------------- }
		if b02_recNo = 0 then

			begin

				w_Date	:= l1_getDate(Jrn1.key_dd.Text,Jrn1.key_mm.Text,Jrn1.key_ccyy.Text);
				L1_CALL(c_B99,c_B99_ValidDate,0,0,0);
				if (RETURN_CODE <> 0) then
					begin
						MessageDlgPos('Invalid Date',mtConfirmation, [mbOk],0,150,150);
						GET_TRAN := false;
						exit;
					end // END BEGIN

				else

				{ ----------------------------------------------------- }
				{ EXISTING OR NEW (Transactions are always new from	PF5	}
				{ ----------------------------------------------------- }
					begin
						newRecord		 := true;
						B02_TranDate := w_Date;
						init_trans;
						GET_TRAN := true;
						exit;
          end // END BEGIN
				; // END BEGIN
			end // END BEGIN

  { ------------------------- }
	{ from ListView 						}
	{-------------------------- }
		else

		{ -------------------------------------- }
		{ Selected from Browser or existing (F5) }
		{ -------------------------------------- }
			begin
				newRecord 					:= false;
				l1_Call(c_B02,c_Read,b02_recNo,0,0);
				Jrn1.key_ccyy.Text	:= MidStr(B02_TranDate,1,4);
				Jrn1.key_mm.Text 		:= MidStr(B02_TranDate,6,2);
				Jrn1.key_dd.Text		:= MidStr(B02_TranDate,9,2);
				Jrn1.key_time.Text 	:= B02_TranTime;
			end // END BEGIN
 		; // END IF

	{ ------- }
	{ Details }
	{ ------- }
		Jrn1.dracctno.Text						:= IntToStr(B02_DRAcctNo);
		Jrn1.cracctno.Text						:= IntToStr(B02_CRAcctNo);
		Jrn1.description.Text					:= B02_Description;
		Jrn1.value.Text								:= w_B02_Value;
			Str := w_B02_Value;
		Jrn1.noofunits.Text						:= IntToStr(B02_NoOfUnits);
		Jrn1.reference.Text						:= B02_Reference;

		Jrn1.invtrantype.Text					:= IntToStr(B02_INVTranType);
    Case B02_INVTranType of
      1: Jrn1.invtrantype_description.Caption := 'Purchase';
      2: Jrn1.invtrantype_description.Caption := 'ReInvested Income';
      3: Jrn1.invtrantype_description.Caption := 'Revaluation';
      4: Jrn1.invtrantype_description.Caption := 'Sale';
      5: Jrn1.invtrantype_description.Caption := 'Income';
      6: Jrn1.invtrantype_description.Caption := 'Expense';
      7: Jrn1.invtrantype_description.Caption := 'Capital Gain/Loss';
      8: Jrn1.invtrantype_description.Caption := 'Tax';
    End; // END CASE

		Jrn1.invacctno.Text						:= IntToStr(B02_INVAcctNo);
		Jrn1.invparcelno.Text					:= IntToStr(B02_INVParcelNo);
		Jrn1.invgrouping.Text					:= IntToStr(B02_INVGrouping);
		Jrn1.invfrankedamt.Text				:= w_B02_FrankedAmt;
		Jrn1.invimputedcredit.Text		:= w_B02_ImputedCredit;

		GET_TRAN := true;

	end;

{ ----------------------------------------------------------------------------}
{ INIT_PARMS																																	}
{ ----------------------------------------------------------------------------}
	procedure init_trans();
	begin

	{ ----- }
	{ KEY		}
	{ ----- }
//	B02_TranDate  := Done in GET_TRAN
		B02_TranTime 	:= TimeToStr(Time);

	{ --------- }
	{ DETAILS		}
	{ --------- }
		Jrn1.dracctno.Text					:= '0';
		Jrn1.cracctno.Text					:= '0';
		Jrn1.description.Text				:= '';
		Jrn1.value.Text							:= '0.00';
		Jrn1.noofunits.Text					:= '0';
		Jrn1.reference.Text					:= '';
		Jrn1.invtrantype.Text				:= '0';
		Jrn1.invacctno.Text					:= '0';
		Jrn1.invparcelno.Text				:= '0';
		Jrn1.invgrouping.Text				:= '0';
		Jrn1.invfrankedamt.Text			:= '0.00';
		Jrn1.invimputedcredit.Text	:= '0.00';

	end;

{ ----------------------------------------------------------------------------}
{ DETAILS OKAY																																}
{ ----------------------------------------------------------------------------}
function DETAILS_OKAY() : boolean;
var
	gstFlag	: Int64;
begin

		DETAILS_OKAY := false;

		gstFlag := l1_false;

		If A01_GSTAccount <> 0 then
			If (b02_recNo = 0) then
				begin
					case MessageDlgPos('Split for GST', mtConfirmation, [mbYes, mbNo, mbCancel],0,150,150) of
						mrCancel	: gstFlag := l1_False;
						mrNO 			: gstFlag := l1_False;
						mrYes 		: gstFlag := l1_True;
					end; // END CASE
				end // END BEGIN
			; // END IF
		; // END IF

	{ ------------ }
	{ Valid Data ? }
	{ ------------ }

	{ DEBIT ACCOUNT }
		B02_DRAcctNo := StrToInt(Jrn1.dracctno.Text);

		if (B02_DRAcctNo = 0) then
			begin
				MessageDlgPos('Please enter a Debit Account No',mtConfirmation, [mbOk],0,150,150);
				exit;
			end // END BEGIN
		; // END IF

	{ CREDIT ACCOUNT }
		B02_CRAcctNo := StrToInt(Jrn1.Cracctno.Text);
		if (B02_CRAcctNo = 0) THEN
			begin
				MessageDlgPos('Please enter a Credit Account No',mtConfirmation, [mbOk],0,150,150);
				exit;;
			end // END BEGIN
		; // END IF

	{ DESCRIPTION }
		if ansistring.IsNullOrWhiteSpace(Jrn1.description.Text) then
			begin
				MessageDlgPos('Please enter a description',mtConfirmation, [mbOk],0,150,150);
				exit;
			end // END BEGIN
		else
			B02_Description := Format('%-30s',[Jrn1.description.Text]);
		; // END IF

	{ VALUE }
	{ ----------------------------------------------------------------------------}
	{ Need to drop any more than (n) decimal places 															}
	{ ----------------------------------------------------------------------------}
	{ ************ LET languageONE do this when it converts (n_Value = w_value }
		w_B02_Value := Format('%10s',[Jrn1.value.Text]);

	{ NOOFUNITS }
		B02_NoOfUnits := StrToInt(Jrn1.noofunits.Text);

	{ REFERENCE }
		B02_Reference 	:= Format('%-10s',[Jrn1.reference.Text]);

	{ INVTRANTYPE }
		B02_INVTranType := StrToInt(Jrn1.invtrantype.Text);
		If (B02_INVTranType < 0) or (B02_INVTranType > 8) then
			begin
				MessageDlgPos('If not zero, then Transaction Type must be 1 thru 9',
					mtConfirmation, [mbOk],0,150,150);
				exit;
			end // END BEGIN
		; // END IF

	{ INVACCTNO }
		B02_INVAcctNo := StrToInt(Jrn1.invacctno.Text);

	{ INVPARCELNO }
		B02_INVParcelNo := StrToInt(Jrn1.invparcelno.Text);

	{ INVGROUPING }
		B02_INVGrouping := StrToInt(Jrn1.invgrouping.Text);

	{ FRANKEDAMOUNT }
	{ ----------------------------------------------------------------------------}
	{ Need to drop any more than (n) decimal places 															}
	{ ----------------------------------------------------------------------------}
	{ ************ LET languageONE do this when it converts (n_Value = w_value }
		w_B02_FrankedAmt := Format('%7s',[Jrn1.invfrankedamt.Text]);

	{ IMPUTEDCREDIT }
	{ ----------------------------------------------01------------------------------}
	{ Need to drop any more than (n) decimal places 															}
	{ ----------------------------------------------------------------------------}
	{ ************ LET languageONE do this when it converts (n_Value = w_value }
		w_B02_ImputedCredit := Format('%7s',[Jrn1.invimputedcredit.Text]);

	//SUNITPRICE
	{ ----------------------------------------------------------------------------}
	{ Need to drop any more than (n) decimal places 															}
	{ ----------------------------------------------------------------------------}
	{ ************ LET languageONE do this when it converts (n_Value = w_value }
//	w_B02_SUnitPrice := StrToInt(Jrn1.sunitprice.Text);
//	B02_SReference := Jrn1.sreference.Text;

	//-------------------------------------------------
	//Proceed ?
	//------------------------------------------------- 
		l1_Call(c_B02,c_Write,b02_recNo,gstFlag,0);
		if (RETURN_CODE = 0) then
			begin
				DETAILS_OKAY := true;
				TRAN_LISTVIEW();
			end
		else
			begin
				case RETURN_CODE of
					52: MessageDlgPos('Invalid Debit Account',mtConfirmation, [mbOk],0,150,150);
					53: MessageDlgPos('Invalid Credit Account',mtConfirmation, [mbOk],0,150,150);
					54: MessageDlgPos('Invalid Investment Account',mtConfirmation, [mbOk],0,150,150);
					55: MessageDlgPos('Value cannot be zero',mtConfirmation, [mbOk],0,150,150);
				end; // END CASE
			end // END BEGIN
		; // END IF

	end;

{ ============================================================================ }
{ CALCULATOR							   	                                             		 }
{ ============================================================================ }

{ -----------------------------------------------------------------------------}
{ Calculater Key Stroke		   	                                             		 }
{ -----------------------------------------------------------------------------}
	procedure TJrn1.calc2KeyUp(Sender:TObject;var Key:Word;Shift:TShiftState);
  begin
		DOCALC;
	end;

{ -----------------------------------------------------------------------------}
{ Calculate								   	                                             		 }
{ -----------------------------------------------------------------------------}
	procedure DOCALC();
	var
		X1	: extended;
		X2	: extended;

	begin

		Val (Jrn1.calc1.Text,X1,X);
    If X = 0 then
			X1 := RoundTo(StrToFloat(Jrn1.calc1.Text), -2);

		Val (Jrn1.calc2.Text,X2,X);
    If X = 0 then
			X2 := RoundTo(StrToFloat(Jrn1.calc2.Text), -2);

 		case Jrn1.calcWhat.Caption of
			'+'	: Jrn1.result.Caption := FloatToStrF((X1 + X2),fffixed,8,2);
			'-'	: Jrn1.result.Caption := FloatToStrF((X1 - X2),fffixed,8,2);
			'*' : jrn1.result.Caption := FloatToStrF((X1 * X2),fffixed,8,2);
			'/' : If X2 > 0 then
							Jrn1.result.Caption := FloatToStrF((X1 / X2),fffixed,8,2)
						else
							Jrn1.result.Caption := '0.00';
		end;

	end;

{ -----------------------------------------------------------------------------}
{ Copy Result								 	                                             		 }
{ -----------------------------------------------------------------------------}
	procedure TJrn1.resultClick(Sender:TObject);
	begin
 		value.Text := result.Caption;
	end;


{ -----------------------------------------------------------------------------}
{ End Of Program						 	                                             		 }
{ -----------------------------------------------------------------------------}
end.

