unit Asset1;

{$mode ObjFPC}{$H+}

interface

uses
	Classes, SysUtils, Forms, Controls, Graphics, Dialogs,StdCtrls,ComCtrls,
	LCLType, display1;

type

			{ TAss1 }

	TAss1 = class(TForm)

		Label1:TLabel;
			start_dd:TEdit;
			start_mm:TEdit;
			start_ccyy:TEdit;

		Label2:TLabel;
			end_dd:TEdit;
			end_mm:TEdit;
			end_ccyy:TEdit;
			pButton:TToggleBox;

		procedure FormCreate(Sender:TObject);
		procedure FormShow(Sender:TObject);
		procedure pButtonClick(Sender:TObject);

		procedure onKeyPress(Sender:TObject;var Key:char);

		private
		public

	end;

var
			Ass1: TAss1;

{ ============================================================================= }
{ IMPLEMENTATION- private/Local                                                 }
{ ============================================================================= }
{	The "inplementation" section declares PRIVATE variables, constants, types, 		}
{ and routines. }

implementation
	uses
		unit0;

{$R *.lfm}

{ =============================================================================}
{ PROCEDURES/FUNCTIONS                                                         }
{ =============================================================================}

{ -----------------------------------------------------------------------------}
{ on Create																																		 }
{ -----------------------------------------------------------------------------}
procedure TAss1.FormCreate(Sender:TObject);
begin

{ Form to get Keystroke 1st	}
	KeyPreview := true;

end;

{ -----------------------------------------------------------------------------}
{ on Show setup Defaults							                                         }
{ -----------------------------------------------------------------------------}
procedure TAss1.FormShow(Sender:TObject);
begin

	Ass1.Caption := Format('%0.2d',[A01_Parameter]) + ' Franked Dividends';

	start_dd.Text		:= '01';
	start_mm.Text		:= '07';
	start_ccyy.Text	:= IntToStr(nFinancialYear - 1);

	end_dd.Text			:= '30';
	end_mm.Text			:= '06';
	end_ccyy.Text		:= IntToStr(nFinancialYear);

end;

{ -----------------------------------------------------------------------------}
{ Only allow numeric characters                                            		 }
{ -----------------------------------------------------------------------------}
	procedure TAss1.onKeyPress(Sender:TObject;var Key:char);
	begin
  	If not (Key in ['0'..'9', Char(VK_BACK), Char(VK_DELETE)]) then Key := #0;
	end;

{ -----------------------------------------------------------------------------}
{ So do it										                                            		 }
{ -----------------------------------------------------------------------------}
procedure TAss1.pButtonClick(Sender:TObject);
begin

	{ --------------------------- }
	{ Validate Dates							}
	{ --------------------------- }
	w_StartDate	:= L0_getDate(start_dd.Text,start_mm.Text,start_ccyy.Text);
	w_EndDate		:= L0_getDate(end_dd.Text,end_mm.Text,end_ccyy.Text);
	X := CompareStr(w_StartDate,w_EndDate);
  if (X > 0) then
		begin
			MessageDlgPos('End date cannot be less then Start Date',
				mtConfirmation, [mbOk],0,200,200);
			exit;
		end // END BEGIN
	; // END BEGIN

	{ --------------------------- }
	{ MAKE THE CALL								}
	{ --------------------------- }
	L0_Call(c_C01,c_Print,1,0,0);
  Close;

	Str := 'C01_' + aFinancialYear + '.PRT';
	Dsp1.ShowModal;

end;

{ -----------------------------------------------------------------------------}
{ End Of Program						 	                                             		 }
{ -----------------------------------------------------------------------------}
end.

