unit Asset2;

{$mode ObjFPC}{$H+}

interface

uses
	Classes, SysUtils, Forms, Controls, Graphics, Dialogs,StdCtrls,ComCtrls,
	LCLType, display1;

type

			{ TAss2 }

	TAss2 = class(TForm)
					Archived:TComboBox;
					end_ccyy:TEdit;
					end_dd:TEdit;
					end_mm:TEdit;
		Label1:TLabel;
			AcctNo:TEdit;
		bPrint:TButton;
		Label2:TLabel;
		Label3:TLabel;
		Label4:TLabel;
		start_ccyy:TEdit;
		start_dd:TEdit;
		start_mm:TEdit;

		procedure ArchivedChange(Sender:TObject);
   procedure FormCreate(Sender:TObject);
		procedure FormShow(Sender:TObject);
		procedure Label2Click(Sender:TObject);
		procedure onKeyPress(Sender:TObject;var Key:char);
		procedure bPrintClick(Sender:TObject);

		private
		public

	end;

var
			Ass2: TAss2;

implementation
	uses
		unit0;

{$R *.lfm}

{ TAss2 }

{ =============================================================================}
{ PROCEDURES/FUNCTIONS                                                         }
{ =============================================================================}

{ -----------------------------------------------------------------------------}
{ on Create																																		 }
{ -----------------------------------------------------------------------------}
procedure TAss2.FormCreate(Sender:TObject);
begin

{ Form to get Keystroke 1st	}
	KeyPreview := true;

 	Archived.Items.Clear;
  Archived.Items.Add('N');        //Add an choice
  Archived.Items.Add('Y');

end;

procedure TAss2.ArchivedChange(Sender:TObject);
begin

	If Archived.ItemIndex = 0 then
		begin
			Label3.Visible			:= FALSE;
			Label4.Visible			:= FALSE;
			start_dd.Visible		:= FALSE;
			start_mm.Visible		:= FALSE;
			start_ccyy.Visible	:= FALSE;
			end_dd.Visible			:= FALSE;
			end_mm.Visible			:= FALSE;
			end_ccyy.Visible		:= FALSE;
		end // END BEGIN
	else
		begin
			Label3.Visible			:= TRUE;
			Label4.Visible			:= TRUE;
			start_dd.Visible		:= TRUE;
			start_mm.Visible		:= TRUE;
			start_ccyy.Visible	:= TRUE;
			end_dd.Visible			:= TRUE;
			end_mm.Visible			:= TRUE;
			end_ccyy.Visible		:= TRUE;
		end // END BEGIN
	; // END IF

end;

{ -----------------------------------------------------------------------------}
{ on Show setup Defaults							                                         }
{ -----------------------------------------------------------------------------}
procedure TAss2.FormShow(Sender:TObject);
begin

	Ass2.Caption := Format('%0.2d',[A01_Parameter]) + ' Asset History';

	start_dd.Text				:= '01';
	start_mm.Text				:= '07';
	start_ccyy.Text			:= IntToStr(nFinancialYear-1);

	end_dd.Text					:= '30';
	end_mm.Text					:= '06';
	end_ccyy.Text				:= IntToStr(nFinancialYear);

	Archived.ItemIndex	:= 0;
	Label3.Visible			:= FALSE;
	Label4.Visible			:= FALSE;
	start_dd.Visible		:= FALSE;
	start_mm.Visible		:= FALSE;
	start_ccyy.Visible	:= FALSE;
	end_dd.Visible			:= FALSE;
	end_mm.Visible			:= FALSE;
	end_ccyy.Visible		:= FALSE;

end;

procedure TAss2.Label2Click(Sender:TObject);
begin

end;

{ -----------------------------------------------------------------------------}
{ Only allow numeric characters                                            		 }
{ -----------------------------------------------------------------------------}
	procedure TAss2.onKeyPress(Sender:TObject;var Key:char);
	begin
  	If not (Key in ['0'..'9', Char(VK_BACK), Char(VK_DELETE)]) then Key := #0;
	end;

{ -----------------------------------------------------------------------------}
{ on Print Click																															 }
{ -----------------------------------------------------------------------------}
procedure TAss2.bPrintClick(Sender:TObject);
begin

	{ --------------------------- }
	{ Validate Commit							}
	{ --------------------------- }
	case MessageDlgPos('If you have changed the database you must commit'
									+ sLineBreak + 'your changes prior to proceeding'
									+ sLineBreak + 'Commit?',
								mtConfirmation, [mbYes,mbNo],0,150,150) of
			mrYes	:		L0_CALL (0,c_Commit,0,0,0);
		end; // END CASE

	{ --------------------------- }
	{ Validate Dates							}
	{ --------------------------- }
	w_StartDate	:= L0_getDate(start_dd.Text,start_mm.Text,start_ccyy.Text);
	w_EndDate		:= L0_getDate(end_dd.Text,end_mm.Text,end_ccyy.Text);
	X := CompareStr(w_StartDate,w_EndDate);
  if (X > 0) then
		begin
			MessageDlgPos('End date cannot be less then Start Date',
				mtConfirmation, [mbOk],0,200,200);
			exit;
		end // END BEGIN
	; // END BEGIN

	{ --------------------------- }
	{ MAKE THE CALL								}
	{ --------------------------- }
	X := StrToInt(AcctNo.Text);
	L0_CALL(c_C02,X,Archived.ItemIndex,0,0);
	Ass2.Close();

	{ --------------------------- }
	{ And Display the result			}
	{ --------------------------- }
	Str := 'C02_' + aFinancialYear + '.PRT';
	Dsp1.ShowModal;

end;

{ -----------------------------------------------------------------------------}
{ End Of Program						 	                                             		 }
{ -----------------------------------------------------------------------------}
end.

