unit search1;

{$mode ObjFPC}{$H+}
{$R *.lfm}

{ ============================================================================= }
{ INTERFACE - Gloablity                                                         }
{ ============================================================================= }
{	The "interface" section of a Pascal UNIT exports PUBLIC variables, constants	}
{ types, and routines, while the USES clause imports exported identifiers from	}
{ another UNITS interface section }

	interface

	{	EXTERNAL }
		uses
			Classes, SysUtils, Forms, Controls, Graphics, Dialogs,ComCtrls, LCLType;

		type
    	TSch1 = class(TForm)
				ListView:TListView;

				procedure FormShow(Sender:TObject);
				procedure ListViewClick(Sender:TObject);
				private
				public
			end;

		var
			Sch1: TSch1;

{ ============================================================================= }
{ IMPLEMENTATION- private/Local                                                 }
{ ============================================================================= }
{	The "inplementation" section declares PRIVATE variables, constants, types, 		}
{ and routines. }

	implementation uses
		unit0, journal1, enquire1, enquire2;

{ =============================================================================}
{ PROCEDURES/FUNCTIONS                                                         }
{ =============================================================================}

{ -----------------------------------------------------------------------------}
{	populate ListView																														 }
{ -----------------------------------------------------------------------------}
	procedure TSch1.FormShow(Sender:TObject);
	var
		Line	: TListItem;

	begin
		Sch1.ListView.Items.Clear;

	{	----------------- }
	{	Start							}
	{	----------------- }
 		X := L0_findAcct(S.Acct,l1_False);
		L0_Call(c_B01,c_PreviousNext,-1,0,0);

	{	----------------- }
	{	Transactions Loop	}
	{	----------------- }
		X	:= 0;
		while 1=1 do
			begin

			{ get Record }
				L0_Call(c_B01,c_PreviousNext,1,0,0);
				if RETURN_CODE <> 0 then
						break;

			{ Populate ListView }
				Line := Sch1.ListView.Items.add;
					Line.Caption:= Format('%0.3d',[B01_Record_NO]);
						Line.SubItems.Add(Format('%5d',[B01_AcctNo]));
						Line.SubItems.Add(B01_Description);

			end // END BEGIN
		; // END WHILE

	{ Get the details of the 1st one }
		L0_Call(c_B01,c_Start,0,0,b01_AllAccts);
		Sch1.ListView.Items[0].MakeVisible(true);

	end;

{ -----------------------------------------------------------------------------}
{	Select ListView																															 }
{ -----------------------------------------------------------------------------}
	procedure TSch1.ListViewClick(Sender:TObject);
	begin

		if(ListView.ItemIndex < 0) then
			exit
		; // END IF

		X	:= StrToIntDef(ListView.Selected.Caption,0);
		L0_CALL(c_B01,c_Read,X,0,0);

		case S.ID of
			01: begin
						Jrn1.dracctno.Text 								:= IntToStr(B01_AcctNo);
						Jrn1.dracctno_description.Caption	:= B01_Description;
          end
			;
			02: begin
						Jrn1.cracctno.Text 								:= IntToStr(B01_AcctNo);
						Jrn1.cracctno_description.Caption	:= B01_Description;
          end
			;
			03: begin
						Jrn1.invacctno.Text 								:= IntToStr(B01_AcctNo);
						Jrn1.invacctno_description.Caption	:= B01_Description;
          end
			;
			04: begin
						Enq1.acctno.Text 										:= IntToStr(B01_AcctNo);
						Enq1.acctno_description.Caption			:= B01_Description;
          end
			;
			05: begin
						Enq2.Start_acctno.Text 							:= IntToStr(B01_AcctNo);
          end
			;
			06: begin
						Enq2.end_acctno.Text 								:= IntToStr(B01_AcctNo);
          end

		end;

		Sch1.Close;

	end;

{ -----------------------------------------------------------------------------}
{ End Of Program						 	                                             		 }
{ -----------------------------------------------------------------------------}
end.

