 include <include/BEGIN.PROGRAM>
;
;	Refer to VERSION.HISTORY for...well...version history
 
;	END.SYNONYMS ****************************************
 
;=======================================================================
;		PROGRAM DATA
;=======================================================================
 
;-----------------------------------------------------------------------
;		DICTIONARY
;-----------------------------------------------------------------------
 include <include/BEGIN.DICTIONARY>
 
;(BEGIN):Temporary Words by languageONE
;(END..):Temporary Words by languageONE
 
	@INSERTWORD w_finYear,004,' '
	@INSERTWORD w_nextYear,004,' '
 
	@INSERTWORD w_prtLine80,080,' '
	@INSERTWORD w_prtLine132,132,' '
	@INSERTWORD w_Underlines80,080,' '
	@INSERTWORD w_Underlines132,132,' '
	@INSERTWORD w_Command,080,' '
	@INSERTWORD x_NewPage,001,0Ch
	@INSERTWORD x_Null,001,00h
	@INSERTWORD w_FileName,255,' '
 
  @INSERTWORD x_OpenBracket,001,028h
	@INSERTWORD x_CloseBracket,001,029h
 
 include <include/END.DICTIONARY>
 
;-----------------------------------------------------------------------
;		MATRIX
;-----------------------------------------------------------------------
 include <include/BEGIN.MATRIX>
 
;(BEGIN):Temporary Integers by languageONE
 @insertnumber i0001,0,'9999999'
 @insertnumber i0002,0,'99'
;(END..):Temporary Integers by languageONE
 
;(BEGIN):Temporary FixedPoint numbers by languageONE
;(END..):Temporary FixedPoint numbers by languageONE
 
;	--------------------------------
;	Fields used calling this program
;	--------------------------------
	@INSERTNUMBER x_TableNo,00
	@INSERTNUMBER x_Request,00
	@INSERTNUMBER x_RecNo,00
	@INSERTNUMBER x_AcctNo,00,'99999'
	@INSERTNUMBER x_Accts,00
;	---------------------------------
 
	@INSERTNUMBER n_CompanyNo,00,'99'
 
	@INSERTNUMBER I,00,'9999999'
	@INSERTNUMBER J,00,'9999999'
	@INSERTNUMBER K,00,'9999999'
 
	@INSERTNUMBER n_finYear,00,'9999'
	@INSERTNUMBER n_nextYear,00,'9999'
 
	@INSERTNUMBER A01_StartRecNo,00
	@INSERTNUMBER B01_StartRecNo,00
	@INSERTNUMBER B02_StartRecNo,00
	

	@INSERTNUMBER n_CpyIdx,00
	@INSERTNUMBER n_StartRecNo,00
 
	public w_A01_UnitPrice
	@INSERTWORD w_A01_UnitPrice,09,' '
	public w_B01_UnitPrice
	@INSERTWORD w_B01_UnitPrice,09,' '
	public w_B02_Value
	@INSERTWORD w_B02_Value,10,' '
	public w_B02_FrankedAmt
	@INSERTWORD w_B02_FrankedAmt,07,' '
	public w_B02_ImputedCredit
	@INSERTWORD w_B02_ImputedCredit,07,' '
	public w_B02_SUnitPrice
	@INSERTWORD w_B02_SUnitPrice,09,' '
 
	@INSERTWORD w_B03_Value,10,' '
	@INSERTWORD w_B03_RunningBalance,11,' '
 
	@INSERTNUMBER n_AcctNo,00
	@INSERTNUMBER n_CntlAcctNo,00
	public w_Date
	@INSERTWORD w_Date,10,' '
 
	public w_StartDate
	@INSERTWORD w_StartDate,10,' '
	public w_EndDate
	@INSERTWORD w_EndDate,10,' '
 
	public n_RunningBalance
	@INSERTNUMBER n_RunningBalance,00,'#######.99'
	@INSERTNUMBER n_TotalNoOfUnits,000000,'#####9.9999'
 
	@INSERTNUMBER b_Start,%c_TRUE
 
	@INSERTNUMBER n_LineCtr,00,'9999'
	@INSERTNUMBER n_PageNo,00,'9999'
 
;	--------------
;	Printing - A01
;	--------------
	public n_StartParmNo
	@INSERTNUMBER n_StartParmNo,00,'99'
	public n_StartParm
	@INSERTNUMBER n_StartParm,00,'99'
	public n_EndParmNo
	@INSERTNUMBER n_EndParmNo,00,'99'
	public n_EndParm
	@INSERTNUMBER n_EndParm,00,'99'
 
;	--------------
;	Printing - B01
;	--------------
	public n_StartAcctNo
	@INSERTNUMBER n_StartAcctNo,00,'99999'
	public n_EndAcctNo
	@INSERTNUMBER n_EndAcctNo,00,'99999'
 
;	--------------
;	Printing - B02
;	--------------
	public w_Reference
	@INSERTWORD w_Reference,10,' '
	public w_PrintDetails
	@INSERTWORD w_PrintDetails,01,'Y'
 
;	--------------
;	Printing - B03
;	--------------
	public w_PrintTrans
	@INSERTWORD w_PrintTrans,01,'Y'
	public w_PrintZero
	@INSERTWORD w_PrintZero,01,'Y'
	public w_PrintNewPage
	@INSERTWORD w_PrintNewPage,01,'Y'
	@INSERTNUMBER n_TotalDebits,0000,'######9.99'
	@INSERTNUMBER n_TotalCredits,0000,'######9.99'
 
;	--------------
;	Printing - B04
;	--------------
	public w_Sub
	@INSERTWORD w_Sub,01,' '
	public w_Closing
	@INSERTWORD w_Closing,10,' '
	public n_ReportNo
	@INSERTNUMBER n_ReportNo,00
 
	@INSERTWORD w_ReportName,30,' '
	@INSERTNUMBER n_Idx,00
 
	@INSERTNUMBER n_CAAcctNo,00,'99999'
	@INSERTNUMBER n_PAAcctNo,00,'99999'
	@INSERTNUMBER n_PLAcctNo,00,'99999'
	@INSERTNUMBER n_ASAcctNo,00,'99999'
	@INSERTNUMBER n_TOAcctNo,00,'99999'
	@INSERTNUMBER n_TCAcctNo,00,'99999'
 
	@INSERTNUMBER n_PreviousAcctNo,00,'99999'
	@INSERTWORD w_saveFlag1,02,' '
	@INSERTWORD w_PreviousDescription,64,' '
	@INSERTNUMBER n_PreviousCntlAcctNo,00,'99999'
	@INSERTWORD w_PreviousFlag1,02,' '
	@INSERTNUMBER n_PreviousFlag2,00,'9'
	@INSERTNUMBER n_PreviousFlag3,00,'9'
	@INSERTNUMBER n_PreviousFlag4,00,'9'
	@INSERTWORD w_PreviousIndicator,02,' '
 
	@INSERTNUMBER n_AcctBalance,0000,'9999999.99'
	@INSERTNUMBER n_AcctBalanceRounded,00,'######9'
	@INSERTNUMBER n_CntlAcctBalance,0000,'9999999.99'
	@INSERTNUMBER n_NoOfUnits,00,'99999'
 
	@INSERTNUMBER n_Value,00,'#,###,##9'
	@INSERTNUMBER n_ValueLocation,00,'99'
 
	@INSERTNUMBER n_GST,0000,'9999999.99'
 
	@INSERTARRAY n_Totals,4
 
 include <include/END.MATRIX>
 
;-----------------------------------------------------------------------
;		@files
;-----------------------------------------------------------------------
 include <include/BEGIN.FILES>
 
;	----------
;	Parameters
;	----------
	@INSERTFILE c_CSV,A01_FILE,'./A01_9999.CSV'
	@INSERTFILE c_CSV,A01_EOY,'./A01_9999.CSV'
 
	c_A01_RecordLength EQU 94
	c_A01_MaxRecords EQU 99
 
	public A01_Record_NO
	public A01_Table_STATUS
 
	@BEGIN_RECORD c_A01_RecordLength,A01_Record
		public A01_ParameterNo
		@INSERTNUMBER <A101,A01_ParameterNo>,00,'99'
		public A01_Parameter
		@INSERTNUMBER <A102,A01_Parameter>,00,'99'
		public A01_Description
		@INSERTWORD <A103,A01_Description>,30,' '
		public A01_Password
		@INSERTWORD <A104,A01_Password>,08,' '
		public A01_LastReference
		@INSERTWORD <A105,A01_LastReference>,10,' '
		public A01_GSTAccount
		@INSERTNUMBER <A106,A01_GSTAccount>,00,'99999'
		public A01_StartYear
		@INSERTNUMBER <A107,A01_StartYear>,00,'9999'
		public A01_UnitPrice
		@INSERTNUMBER <A108,A01_UnitPrice>,00,'9999.9999'
		public A01_Company01
		@INSERTNUMBER <A109,A01_Company01>,00,'99'
		public A01_Company02
		@INSERTNUMBER <A110,A01_Company02>,00,'99'
		public A01_Company03
		@INSERTNUMBER <A111,A01_Company03>,00,'99'
		public A01_Company04
		@INSERTNUMBER <A112,A01_Company04>,00,'99'
		public A01_Company05
		@INSERTNUMBER <A113,A01_Company05>,00,'99'
		public A01_Company06
		@INSERTNUMBER <A114,A01_Company06>,00,'99'
		public A01_Company07
		@INSERTNUMBER <A115,A01_Company07>,00,'99'
		public A01_Company08
		@INSERTNUMBER <A116,A01_Company08>,00,'99'
		public A01_Company09
		@INSERTNUMBER <A117,A01_Company09>,00,'99'
		public A01_Company10
		@INSERTNUMBER <A118,A01_Company10>,00,'99'
		public A01_Company11
		@INSERTNUMBER <A119,A01_Company11>,00,'99'
		public A01_Company12
		@INSERTNUMBER <A120,A01_Company12>,00,'99'
	@END_RECORD A01_Record
	

;	----------
;	Accounts
;	----------
 
	@INSERTFILE c_CSV,B01_FILE,'./B01_9999.CSV'
	@INSERTFILE c_CSV,B01_EOY,'./B01_9999.CSV'
 
	c_B01_RecordLength EQU 62
	c_B01_MaxRecords EQU 1024
 
	public B01_Record_NO
	public B01_Table_STATUS
 
	@BEGIN_RECORD c_B01_RecordLength,B01_Record
		public B01_Company
		@INSERTNUMBER <B101,B01_Company>,00,'99'
		public B01_AcctNo
		@INSERTNUMBER <B102,B01_AcctNo>,00,'99999'
		public B01_Description
		@INSERTWORD <B103,B01_Description>,30,' '
		public B01_Flag1
		@INSERTWORD <B104,B01_Flag1>,02,' '
		public B01_Flag2
		@INSERTNUMBER <B105,B01_Flag2>,01,'9'
		public B01_Flag3
		@INSERTNUMBER <B106,B01_Flag3>,01,'9'
		public B01_Flag4
		@INSERTNUMBER <B107,B01_Flag4>,01,'9'
		public B01_BalanceIndicator
		@INSERTWORD <B108,B01_BalanceIndicator>,02,' '
		public B01_CntlAcctNo
		@INSERTNUMBER <B109,B01_CntlAcctNo>,00,'99999'
		public B01_Depreciation
		@INSERTNUMBER <B110,B01_Depreciation>,00,'999'
		public B01_UnitPrice
		@INSERTNUMBER <B111,B01_UnitPrice>,00,'9999.9999'
     public B01_Archived
     @INSERTNUMBER <B112,B01_Archived>,00,'9'
	@END_RECORD B01_Record
 
	c_B01_AltIdx_RecordLength EQU 12
	

	@BEGIN_RECORD c_B01_AltIdx_RecordLength,B01_AltIdx_Record
		@INSERTNUMBER B01_AltIdx_AcctNo,00,'99999'
		@INSERTNUMBER B01_AltIdx_Company,00,'99'
		@INSERTNUMBER B01_AltIdx_RecNo,00,'99999'
	@END_RECORD B01_AltIdx_Record
 
;	------------
;	Transactions
;	------------
 
	@INSERTFILE c_CSV,B02_FILE,'./B02_9999.CSV'
	@INSERTFILE c_CSV,B02_EOY,'./B02_9999.CSV'
 
	c_B02_RecordLength EQU 152
	c_B02_MaxRecords EQU 4096
 
	public B02_Record_NO
	public B02_Table_STATUS
 
	@BEGIN_RECORD c_B02_RecordLength,B02_Record
		public B02_Company
		@INSERTNUMBER <B201,B02_Company>,00,'99'
		public B02_TranDate
		@INSERTWORD <B202,B02_TranDate>,10,' '
		public B02_TranTime
		@INSERTWORD <B203,B02_TranTime>,08,' '
		public B02_DRAcctNo
		@INSERTNUMBER <B204,B02_DRAcctNo>,00,'99999'
		public B02_CRAcctNo
		@INSERTNUMBER <B205,B02_CRAcctNo>,00,'99999'
		public B02_DRCntlAcctNo
		@INSERTNUMBER <B206,B02_DRCntlAcctNo>,00,'99999'
		public B02_CRCntlAcctNo
		@INSERTNUMBER <B207,B02_CRCntlAcctNo>,00,'99999'
		public B02_Description
		@INSERTWORD <B208,B02_Description>,30,' '
		public B02_Value
		@INSERTNUMBER <B209,B02_Value>,00,'######9.99'
		public B02_NoOfUnits
		@INSERTNUMBER <B210,B02_NoOfUnits>,00,'999999'
		public B02_Reference
		@INSERTWORD <B211,B02_Reference>,10,' '
		public B02_INVTranType
		@INSERTNUMBER <B212,B02_INVTranType>,00,'999'
		public B02_INVAcctNo
		@INSERTNUMBER <B213,B02_INVAcctNo>,00,'99999'
		public B02_INVParcelNo
		@INSERTNUMBER <B214,B02_INVParcelNo>,00,'999'
		public B02_INVGrouping
		@INSERTNUMBER <B215,B02_INVGrouping>,00,'999'
		public B02_FrankedAmt
		@INSERTNUMBER <B216,B02_FrankedAmt>,00,'###9.99'
		public B02_ImputedCredit
		@INSERTNUMBER <B217,B02_ImputedCredit>,00,'###9.99'
		public B02_SUnitPrice
		@INSERTNUMBER <B218,B02_SUnitPrice>,00,'###9.9999'
		public B02_SReference
		@INSERTWORD <B219,B02_SReference>,10,' '
 	 @END_RECORD B02_Record
 
 
	c_B03_RecordLength EQU 98
	c_B03_MaxRecords EQU 1024
 
	public B03_Record_NO
	public B03_Table_STATUS
 
	@BEGIN_RECORD c_B03_RecordLength,B03_Record
		public B03_TranRecNo
		@INSERTNUMBER <B301,B03_TranRecNo>,00,'99999'
		public B03_TranDate
		@INSERTWORD <B302,B03_TranDate>,10,' '
		public B03_Company
		@INSERTNUMBER <B303,B03_Company>,00,'99'
		public B03_DRAcctNo
		@INSERTNUMBER <B304,B03_DRAcctNo>,00,'99999'
		public B03_CRAcctNo
		@INSERTNUMBER <B305,B03_CRAcctNo>,00,'99999'
		public B03_Description
		@INSERTWORD <B306,B03_Description>,36,' '
 		 public B03_Value
 		 @INSERTNUMBER <B307,B03_Value>,00,'######9.99'
		public B03_NoOfUnits
		@INSERTNUMBER <B308,B03_NoOfUnits>,00,'999999'
 		 public B03_RunningBalance
 		 @INSERTNUMBER <B309,B03_RunningBalance>,00,'######9.99-'
		public B03_BalanceIndicator
		@INSERTWORD <B310,B03_BalanceIndicator>,02,' '
		public B03_RunningUnits
		@INSERTNUMBER <B311,B03_RunningUnits>,00,'999999'
 	 @END_RECORD B03_Record
 
	c_C02_RecordLength EQU 75
	c_C02_MaxRecords EQU 256
 
	@BEGIN_RECORD c_C02_RecordLength,C02_Record
  	 @INSERTNUMBER C02_INVTranType,00,'9'
		@INSERTNUMBER C02_INVParcelNo,00,'999'
     @INSERTWORD C02_TranDate,10,' '
     @INSERTNUMBER C02_DRAcctNo,00,'99999'
     @INSERTNUMBER C02_CRAcctNo,00,'99999'
     @INSERTNUMBER C02_INVAcctNo,00,'99999'
     @INSERTWORD C02_Description,30,' '
     @INSERTNUMBER C02_NoOfUnits,00,'999999'
     @INSERTNUMBER C02_Value,0000,'######9.99'
 	 @END_RECORD C02_Record
 
 	 @INSERTNUMBER n_PreviousINVTranType,00,'9'
 
 
	@INSERTFILE c_LF,A01_PRINT,'./A01_9999.PRT'
	@INSERTFILE c_LF,B01_PRINT,'./B01_9999.PRT'
	@INSERTFILE c_LF,B02_PRINT,'./B02_9999.PRT'
	@INSERTFILE c_LF,B03_PRINT,'./B03_9999.PRT'
	@INSERTFILE c_LF,B04_PRINT,'./B04_9999.PRT'
 	 @INSERTFILE c_LF,C01_PRINT,'./C01_9999.PRT'
 	 @INSERTFILE c_LF,C02_PRINT,'./C02_9999.PRT'
 
;	This file is used as recepticles for stdout and stderr
;	used by a child process. As such they are opened by the run
;	command and only need to be closed by the parent program  this one
	@INSERTFILE c_LF,RSP1_FILE,'pipe'
 
 
	@INSERTFILE c_LF,DBG_FILE,'./DBG_FILE.TXT'
 
 
 include <include/END.FILES>
 
;-----------------------------------------------------------------------
;		@tables
;-----------------------------------------------------------------------
 include <include/BEGIN.TABLES>
 
		@INSERTTABLE A01_Table,c_A01_RecordLength*c_A01_MaxRecords
		@INSERTTABLE B01_Table,c_B01_RecordLength*c_B01_MaxRecords
		@INSERTTABLE B01_AltIdx_Table,c_B01_AltIdx_RecordLength*c_B01_MaxRecords
 
		@INSERTTABLE B02_Table,c_B02_RecordLength*c_B02_MaxRecords
		@INSERTTABLE B03_Table,c_B03_RecordLength*c_B03_MaxRecords
 
     @INSERTTABLE C02_Table,c_C02_RecordLength*c_C02_MaxRecords
 
	c_NoOfCompanies EQU 12
	@INSERTARRAY n_Companies,c_NoOfCompanies
 
 include <include/END.TABLES>
 
;=======================================================================
;		PROGRAM INSTRUCTIONS
;		Mainline
;
;		The program is linked using the "_l1" as the public entry point
;		It must then Bind any Xtables to reserve the memory else C++
;		will screw around and move stuff
;		Then it calls "_start" the C++ entry point which does some
;		initialisation before calling "main"
;
;=======================================================================
	c_A01 EQU 1
	c_B01 EQU 2
	c_B02 EQU 3
	c_B03 EQU 4
	c_B04 EQU 5
	c_B07 EQU 7
	c_C01 EQU 11
	c_C02 EQU 12
 
	c_B99 EQU 99
		c_B99_GetDate EQU 1
		c_B99_ValidDate EQU 2
 
	c_Initial EQU 0
	c_Read EQU 1
	c_Write EQU 2
	c_Start EQU 3
	c_PreviousNext EQU 4
	c_Delete EQU 5
	c_Commit EQU 6
	c_Print EQU 7
	c_Enquire EQU 11
	c_EOY EQU 99
 
 
;(BEGIN):Macros created by languageONE
 
m001 MACRO
	@INTEGERS_CALC  i0001,=,<n_PreviousFlag2,*,2>
	@INTEGERS_CALC  I,=,<i0001,-,1>
ENDM
 
m002 MACRO
	@INTEGERS_CALC  i0001,=,<n_PreviousFlag2,*,2>
	@INTEGERS_CALC  I,=,<i0001,-,1>
ENDM
 
m003 MACRO
	@INTEGERS_CALC  i0002,=,<n_PreviousFlag3,*,10>
	@INTEGERS_CALC  n_ValueLocation,=,<i0002,+,30>
ENDM
 
m004 MACRO
	@INTEGERS_CALC  i0002,=,<n_PreviousFlag3,*,10>
	@INTEGERS_CALC  n_ValueLocation,=,<i0002,+,30>
ENDM
 
m005 MACRO
	@INTEGERS_CALC  i0001,=,<n_PreviousFlag4,*,10>
	@INTEGERS_CALC  I,=,<i0001,+,31,-,1>
ENDM
 
m006 MACRO
	@INTEGERS_CALC  i0001,=,<n_PreviousFlag2,*,2>
	@INTEGERS_CALC  J,=,<i0001,-,1>
ENDM
;(END)..:Macros created by languageONE
 
 include <include/BEGIN.INSTRUCTIONS>
 
;	Unit testing can be done here as the entrypoint for a lazarus front end
;	is L1_PROCESS or the functions coded directly below. When this code is
;	linked separately then _l1 is set as the entry point
 
;	x_Array1Idx =+ 45
 
	@INTEGERS_CALC  x_RecNo,=,<2026>
	@CALL L0_loadTables
 
	@INTEGERS_CALC  A01_Record_NO,=,<4>
	@TABLES_RGET A01_Table,4
 
	@INTEGERS_CALC  x_Request,=,<%c_Print>
	@WORDS_PAD "2025/07/01",w_StartDate
   @WORDS_PAD "2026/06/30",w_EndDate
   @WORDS_PAD 'Y',w_PrintDetails
	@CALL B02_Process
   @TERMINATE 1
 
;	L0_Call(c_B03,c_Enquire,0,X,0);
   @INTEGERS_CALC  x_Request,=,<%c_Enquire>
	@INTEGERS_CALC  x_AcctNo,=,<20200>
	@WORDS_PAD "2025/07/01",w_StartDate
   @WORDS_PAD "2026/06/30",w_EndDate
	@CALL B03_Process
   @TERMINATE 1
 
 
 
;	A01_Company01		= 1
;	A01_Company02		= 0
;	A01_Company03		= 0
;	A01_Company04		= 0
;	A01_Company05		= 0
;	A01_Company06		= 0
;	A01_Company07		= 0
;	A01_Company08		= 0
;	A01_Company09		= 0
;	A01_Company10		= 0
;	A01_Company11		= 0
;	A01_Company11		= 0
 
	@WORDS_PAD "2026/06/30",w_Date
	@WORDS_PAD "2025/07/01",w_StartDate
   @WORDS_PAD "2026/06/30",w_EndDate
 
;	x_RecNo					= 1    ; profit/Loss
;	x_RecNo					= 3    ; Balance Sheet
;	Call B15_Process
;	Call B19_Finalise			; Commit
;	x_RecNo	= 20233
   @INTEGERS_CALC  x_RecNo,=,<1> ; Archived
	@INTEGERS_CALC  x_Request,=,<20232>
   @INTEGERS_CALC  n_finYear,=,<2026>
   @WORDS_PAD "2015/07/01",w_StartDate
   @WORDS_PAD "2024/06/30",w_EndDate
 
	@CALL C02_Process
 
;	l1_Call(c_B01,c_Write,b01_recNo,0,b01_AllAccts);
;	l1_Call(c_B04,c_Print,option,Ctrl,0);
;	x_TableNo				= c_B04
;	x_Request				= c_Print
;  x_RecNo					= 3
;  x_AcctNo				= 0			; 0 = Standard, 1 = Control Accounts
;  x_Accts					= 0
;  B01_CntlAcctNo	= 99999
;  x_B01_UnitPrice	= '24.40'
;	Call B15_Process
 
 
 include <include/END.INSTRUCTIONS>
 include <include/END.PROGRAM>
 
;=======================================================================
;		PROGRAM PROCEDURES
;=======================================================================
;***********************************************************************
;	EXTERNAL:This function only used by the Pascal front end
;***********************************************************************
public L0_findParameters
@BEGIN_SUB L0_findParameters
 
;	This is a SUBROUTINE that acts as a FUNCTION for Pascal
;	 LINUX  The 1st six parameter are passed in RDI, RSI, RDX, RCX, R8, and R9
;	 WINDOWS  The 1st four parameters are passed in RCX, RDX, R8, R9
;	Each Functon needs to grab the parameter s  for itself and then save all
;	the registers
 
;	This is singularly called by system1.pas to validate existance of a
;	parameter
 
	@BEGIN_RAW
		mov QWORD PTR[n_StartParmNo],rcx
		mov QWORD PTR[n_StartParm],rdx
		$pushAll rbx,rcx,rdx,rsi,rdi,rbp,r8,r9,r10,r11,r12,r13,r14,r15
	@END_RAW
 
	@IF A01_Table_UBOUND,_EQ,0
			@BEGIN_RAW
				mov rax,0
				jmp L0_findParameters_end
			@END_RAW
	@END_IF
 
	@REPEAT_FOR A01_Record_NO,1,A01_Table_UBOUND
		@TABLES_RGET A01_Table,A01_Record_NO
		@_IF A01_ParameterNo,_EQ,n_StartParmNo ; Passes in as ParameterNo
		@_AND A01_Parameter,_EQ,n_StartParm ; Passed in as Parameter
		@_END
			@BEGIN_RAW
				mov rax,QWORD PTR[A01_Record_NO]
				mov QWORD PTR[RETURN_CODE],0
				jmp L0_findParameters_end
			@END_RAW
		@END_IF
	@END_REPEAT
 
	@BEGIN_RAW
		mov rax,0
		mov QWORD PTR[RETURN_CODE],10
	@END_RAW
 
	@BEGIN_RAW
	L0_findParameters_end:
		mov QWORD PTR[RETURN_CODE],rax
		$popAll r15,r14,r13,r12,r11,r10,r9,r8,rbp,rdi,rsi,rdx,rcx,rbx
	@END_RAW
 
@END_SUB L0_findParameters
 
;***********************************************************************
;	EXTERNAL:This function only used by the Pascal front end
;***********************************************************************
public L0_findCompany
@BEGIN_SUB L0_findCompany
 
;	This is a SUBROUTINE that acts as a FUNCTION for Pascal
;	 LINUX  The 1st six parameter are passed in RDI, RSI, RDX, RCX, R8, and R9
;	 WINDOWS  The 1st four parameters are passed in RCX, RDX, R8, R9
;	Each Functon needs to grab the parameter s  for itself  in this case just
;	one parameter  and then save all the registers
;	The most common access should be a singe entry point with the calling
;	Pascal program saving and restoring registers
 
;	This is singularly called by menu1.pas to validate entry into
;	the Accounting System
 
	@BEGIN_RAW
		mov QWORD PTR[n_CompanyNo],rcx
		$pushAll rbx,rcx,rdx,rsi,rdi,rbp,r8,r9,r10,r11,r12,r13,r14,r15
	@END_RAW
 
	@INTEGERS_CALC  x_Request,=,<%c_Start>
	@INTEGERS_CALC  x_RecNo,=,<0> ; return the record  - 1
	@INTEGERS_CALC  x_Accts,=,<c_TRUE>
	@CALL A01_Process
 
	@INTEGERS_CALC  x_Request,=,<%c_PreviousNext>
	@INTEGERS_CALC  x_RecNo,=,<1> ; return the next record
 
	@REPEAT_WHILE 1,_EQ,1
		@CALL A01_Process
		@IF ERROR_CODE,_EQ,10
			@BEGIN_RAW
				mov rax,0															; false for Pascal
				mov QWORD PTR[RETURN_CODE],10							; Set Return Code
				jmp L0_findCompany_end
			@END_RAW
		@ELSE
			@IF A01_Parameter,_GT,n_CompanyNo
				@BEGIN_RAW
					mov rax,0														; false for Pascal
					mov QWORD PTR[RETURN_CODE],23						; Set Return Code
					jmp L0_findCompany_end
				@END_RAW
			@ELSE
				@IF A01_Parameter,_EQ,n_CompanyNo
					@BEGIN_RAW
						mov rax,QWORD PTR[n_CompanyNo]				; not false for Pascal
						mov QWORD PTR[RETURN_CODE],0					; Set Return Code
						jmp L0_findCompany_end
					@END_RAW
				@END_IF
			@END_IF
		@END_IF
	@END_REPEAT
 
	@BEGIN_RAW
	L0_findCompany_end:
		mov QWORD PTR[RETURN_CODE],rax
		$popAll r15,r14,r13,r12,r11,r10,r9,r8,rbp,rdi,rsi,rdx,rcx,rbx
	@END_RAW
 
@END_SUB L0_findCompany
 
;***********************************************************************
;	EXTERNAL:This function only used by the Pascal front end
;***********************************************************************
public L0_findAcct
@BEGIN_SUB L0_findAcct
 
;	This is a SUBROUTINE that acts as a FUNCTION for Pascal
;	 LINUX  The 1st six parameter are passed in RDI, RSI, RDX, RCX, R8, and R9
;	 WINDOWS  The 1st four parameters are passed in RCX, RDX, R8, R9
;	Each Functon needs to grab the parameter s  for itself  in this case 2
;	parameters  and then save all the registers
 
;	This is called by chart1.pas & enquire1.pas and honours the Company that
;	it belongs to.
 
;	NOTE:-	It indicates the outcome by setting the RETURN_CODE and returns
;					the record number or zero if not found
 
	@BEGIN_RAW
		mov QWORD PTR[x_AcctNo],rcx																						; Account we are lookig for
		mov QWORD PTR[x_Accts],rdx																						; Financial or All Accounts Flag
		$pushAll rbx,rcx,rdx,rsi,rdi,rbp,r8,r9,r10,r11,r12,r13,r14,r15
	@END_RAW
 
;	-----
;	START
;	-----
	@INTEGERS_CALC  x_Request,=,<%c_Start> ; Do a start
	@INTEGERS_CALC  x_RecNo,=,<0> ; return the record  - 1
	@CALL B01_Process
 
;	---------
;	READ NEXT
;	---------
		@INTEGERS_CALC  x_Request,=,<%c_PreviousNext> ; Next/Previous
		@INTEGERS_CALC  x_RecNo,=,<1> ; return the next record
		@REPEAT_WHILE 1,_EQ,1
			@CALL B01_Process
 
			@IF ERROR_CODE,_EQ,10 ; End of File
				@BEGIN_RAW
					mov rax,0														; None returned
					mov QWORD PTR[RETURN_CODE],10						; Set Return Code
					jmp L0_findAcct_end									; exit.sub L0_findAcct
				@END_RAW
			@END_IF
 
			@IF B01_AcctNo,_GT,x_AcctNo ; Invalid Key
				@BEGIN_RAW
					mov rax,0														; None returned
					mov QWORD PTR[RETURN_CODE],23						; Set Return Code
					jmp L0_findAcct_end									; exit.sub L0_findAcct
				@END_RAW
			@END_IF
 
			@IF B01_AcctNo,_EQ,x_AcctNo
					@WORDS_PAD B01_UnitPrice,w_B01_UnitPrice
					@BEGIN_RAW
						mov rax,QWORD PTR[B01_Record_NO]			; Return the record Number
						mov QWORD PTR[RETURN_CODE],0					; Set Return Code
						jmp L0_findAcct_end								; exit.sub L0_findAcct
					@END_RAW
			@END_IF
 
		@END_REPEAT
 
	@BEGIN_RAW
	L0_findAcct_end:
		$popAll r15,r14,r13,r12,r11,r10,r9,r8,rbp,rdi,rsi,rdx,rcx,rbx
	@END_RAW
 
@END_SUB L0_findAcct
 
;***********************************************************************
;	EXTERNAL:This function only used by the Pascal front end
;***********************************************************************
public L0_findConsAcct
@BEGIN_SUB L0_findConsAcct
 
;	This is a SUBROUTINE that acts as a FUNCTION for Pascal
;	 LINUX  The 1st six parameter are passed in RDI, RSI, RDX, RCX, R8, and R9
;	 WINDOWS  The 1st four parameters are passed in RCX, RDX, R8, R9
;	Each Functon needs to grab the parameter s  for itself  in this case 2
;	parameters  and then save all the registers
 
;	This is called by enquire1.pas and is for finding an account in ANY Company in a
;	Consolidated group
 
;	NOTE:-	It indicates the outcome by setting the RETURN_CODE and returns
;					the record number or zero if not found
 
	@BEGIN_RAW
		mov QWORD PTR[x_AcctNo],rcx																						; Account we are lookig for
		mov QWORD PTR[x_Accts],rdx																						; Financial or All Accounts Flag
		$pushAll rbx,rcx,rdx,rsi,rdi,rbp,r8,r9,r10,r11,r12,r13,r14,r15
	@END_RAW
 
	@CALL X_LoadCompany_Array
 
	@REPEAT_FOR B01_Record_NO,1,B01_Table_UBOUND
 
		@TABLES_RGET B01_Table,B01_Record_NO
		@IF B01_AcctNo,_EQ,x_AcctNo
			@CALL f_ValueAcct
			@IF RETURN_CODE,_EQ,%c_TRUE
 
				@REPEAT_FOR I,n_CpyIdx,%c_NoOfCompanies
					@ARRAYS_IF n_Companies,<<I>>,_EQ,B01_Company
						@BEGIN_RAW
							mov rax,QWORD PTR[B01_Record_NO]			; Return the record Number
							mov QWORD PTR[RETURN_CODE],0					; Set Return Code
							jmp L0_findConsAcct_end
						@END_RAW
					@END_IF
				@END_REPEAT
			@END_IF
		@END_IF
	@END_REPEAT
 
	@BEGIN_RAW
		mov rax,0																; None returned
		mov QWORD PTR[RETURN_CODE],10								; Set Return Code
	@END_RAW
 
	@BEGIN_RAW
	L0_findConsAcct_end:
		$popAll r15,r14,r13,r12,r11,r10,r9,r8,rbp,rdi,rsi,rdx,rcx,rbx
	@END_RAW
 
@END_SUB L0_findConsAcct
 
;-----------------------------------------------------------------------
;	INTERNAL:Only Value Accounts
;-----------------------------------------------------------------------
@BEGIN_SUB f_ValueAcct
 
;	Changed from the VBA version here because you should be allowed to
;	post to a Control Account
 
	@INTEGERS_CALC  RETURN_CODE,=,<c_FALSE>
 
	@IF x_Accts,_EQ,%c_TRUE
		@INTEGERS_CALC  RETURN_CODE,=,<c_TRUE>
	@ELSE
		@IF B01_Flag1,_IN,<<"A ","AB","AS","CA","DA","TO","TC">>
			@IF B01_CntlAcctNo,_NEQ,99999
				@INTEGERS_CALC  RETURN_CODE,=,<c_TRUE>
			@END_IF
		@END_IF
	@END_IF
 
@END_SUB f_ValueAcct
 
;-----------------------------------------------------------------------
;	INTERNAL:Function to see  if Account exists
;-----------------------------------------------------------------------
@BEGIN_FUNCTION f_AcctExists
	@USING <<n1_Acct,'99999'>>
	

	@REPEAT_FOR B01_Record_NO,B01_StartRecNo,B01_Table_UBOUND
		@TABLES_RGET B01_Table,B01_Record_NO
 
		@IF B01_Company,_GT,A01_Parameter
			@INTEGERS_CALC  RETURN_CODE,=,<c_FALSE>
			@EXIT_FUNCTION f_AcctExists
		@ELSE
			@IF B01_AcctNo,_GT,n1_Acct
				@INTEGERS_CALC  RETURN_CODE,=,<c_FALSE>
				@EXIT_FUNCTION f_AcctExists
 
			@ELSE
				@IF B01_AcctNo,_EQ,n1_Acct
					@INTEGERS_CALC  RETURN_CODE,=,<c_TRUE>
					@EXIT_FUNCTION f_AcctExists
				@END_IF
			@END_IF
		@END_IF
	@END_REPEAT
 
@END_FUNCTION f_AcctExists
 
;-----------------------------------------------------------------------
;	INTERNAL:Function to see  if Control Account has any children
;-----------------------------------------------------------------------
@BEGIN_FUNCTION f_CntlAcctChildren
	@USING <<n2_Acct,'99999'>>
 
	@REPEAT_FOR B01_Record_NO,B01_StartRecNo,B01_Table_UBOUND
		@TABLES_RGET B01_Table,B01_Record_NO
 
		@IF B01_Company,_GT,A01_Parameter
			@INTEGERS_CALC  RETURN_CODE,=,<c_FALSE>
			@EXIT_FUNCTION f_CntlAcctChildren
		@ELSE
			@IF B01_CntlAcctNo,_EQ,n2_Acct
				@INTEGERS_CALC  RETURN_CODE,=,<c_TRUE>
				@EXIT_FUNCTION f_CntlAcctChildren
			@END_IF
		@END_IF
	@END_REPEAT
 
@END_FUNCTION f_CntlAcctChildren
 
 
;=======================================================================
;		Initialisation
;=======================================================================
@BEGIN_SUB L0_loadTables
 
;	NOTE that the last occurence in each table is used as a holding area
;	such that the maximum no of records before a table is full is
;	c_?01_MaxRecords - 1
 
;	----------
;	Initialise
;	----------
	@INTEGERS_CALC  ERROR_CODE,=,<0>
	@INTEGERS_CALC  n_finYear,=,<x_RecNo>
	@WORDS_PAD n_finYear,w_finYear
 
;	----------------------
;	setup file names
;	----------------------
 
	@WORDS_COPY w_finYear,<<A01_FILE,7,4>>
	@WORDS_COPY w_finYear,<<B01_FILE,7,4>>
	@WORDS_COPY w_finYear,<<B02_FILE,7,4>>
 
	@WORDS_COPY w_finYear,<<A01_PRINT,7,4>>
	@WORDS_COPY w_finYear,<<B01_PRINT,7,4>>
	@WORDS_COPY w_finYear,<<B02_PRINT,7,4>>
	@WORDS_COPY w_finYear,<<B03_PRINT,7,4>>
	@WORDS_COPY w_finYear,<<B04_PRINT,7,4>>
	@WORDS_COPY w_finYear,<<C01_PRINT,7,4>>
	@WORDS_COPY w_finYear,<<C02_PRINT,7,4>>
 
;	--------------
;	Load A01_Table
;	--------------
	@TABLES_BIND A01_Table,A01_Record,%%c_A01_MaxRecords
	@FILES_OPEN A01_FILE,$read
	@REPEAT_FOR A01_Table_UBOUND,1,%%c_A01_MaxRecords
		@FILES $read,A01_FILE,A101,A102,A103,A104,A105,A106,A107,A108,A109,A110,A111,A112,A113,A114,A115,A116,A117,A118,A119,A120,

		@IF A01_FILE_STATUS,_EQ,0
			@TABLES_RPUT A01_Table,A01_Table_UBOUND
		@ELSE
			@EXIT_REPEAT
		@END_IF
	@END_REPEAT
	@FILES_CLOSE A01_FILE
 
;	When we get here the A01_Table_UBOUND is 1 more than the number
;	of records so we subtract 1
	@INTEGERS_CALC  A01_Table_UBOUND,=,<A01_Table_UBOUND,-,1>
	@IF A01_Table_UBOUND,_EQ,%%c_A01_MaxRecords
			@INTEGERS_CALC  ERROR_CODE,=,<1>
			@EXIT_SUB L0_loadTables
	@END_IF
 
;	--------------
;	Load B01_Table
;	--------------
	@TABLES_BIND B01_Table,B01_Record,%%c_B01_MaxRecords
	@TABLES_BIND B01_AltIdx_Table,B01_AltIdx_Record,%%c_B01_MaxRecords
	

	@FILES_OPEN B01_FILE,$read
	@REPEAT_FOR B01_Table_UBOUND,1,%%c_B01_MaxRecords
		@FILES $read,B01_FILE,B101,B102,B103,B104,B105,B106,B107,B108,B109,B110,B111,B112
 
		@IF B01_FILE_STATUS,_EQ,0
			@TABLES_RPUT B01_Table,B01_Table_UBOUND
		@ELSE
			@EXIT_REPEAT
		@END_IF
	@END_REPEAT
	@FILES_CLOSE B01_FILE
 
;	When we get here the A01_Table_UBOUND is 1 more than the number
;	of records so we subtract 1
	@INTEGERS_CALC  B01_Table_UBOUND,=,<B01_Table_UBOUND,-,1>
 
	@IF B01_Table_UBOUND,_EQ,%%c_B01_MaxRecords
			@INTEGERS_CALC  ERROR_CODE,=,<2>
			@EXIT_SUB L0_loadTables
	@END_IF
 
;	--------------
;	Load B02_Table
;	--------------
	@TABLES_BIND B02_Table,B02_Record,%%c_B02_MaxRecords
	@FILES_OPEN B02_FILE,$read
	@REPEAT_FOR B02_Table_UBOUND,1,%%c_B02_MaxRecords
		@FILES $read,B02_FILE,B201,B202,B203,B204,B205,B206,B207,B208,B209,B210,B211,B212,B213,B214,B215,B216,B217,B218,B219
 
		@IF B02_FILE_STATUS,_EQ,0
			@TABLES_RPUT B02_Table,B02_Table_UBOUND
		@ELSE
			@EXIT_REPEAT
		@END_IF
	@END_REPEAT
	@FILES_CLOSE B02_FILE
 
;	When we get here the A01_Table_UBOUND is 1 more than the number
;	of records so we subtract 1
	@INTEGERS_CALC  B02_Table_UBOUND,=,<B02_Table_UBOUND,-,1>
 
	@IF B02_Table_UBOUND,_EQ,%%c_B02_MaxRecords
			@INTEGERS_CALC  ERROR_CODE,=,<3>
			@EXIT_SUB L0_loadTables
	@END_IF
 
;	-------------------
;	Bind B03/C02_Tables
;	-------------------
	@TABLES_BIND B03_Table,B03_Record,%%c_B03_MaxRecords
	@TABLES_BIND C02_Table,C02_Record,%%c_C02_MaxRecords
 
;	--------------
;	For Printing
;	--------------
	@REPEAT_FOR I,1,132
  	 @IF I,_LT,81
			@WORDS_COPY "-",<<w_Underlines80,I,1>>
     @END_IF
		@WORDS_COPY "-",<<w_Underlines132,I,1>>
	@END_REPEAT
 
@END_SUB L0_loadTables
 
;=======================================================================
;		Processes
;=======================================================================
	 public L0_PROCESS
@BEGIN_SUB L0_PROCESS
 
	@BEGIN_RAW
		$pushAll rax,rbx,rcx,rdx,rsi,rdi,rbp,r8,r9,r10,r11,r12,r13,r14,r15
	@END_RAW
 
;	---------------------
;	Get Request
;	---------------------
	@BEGIN_RAW
		movq QWORD PTR[x_TableNo],xmm0
		movq QWORD PTR[x_Request],xmm1
		movq QWORD PTR[x_RecNo],xmm2
		movq QWORD PTR[x_AcctNo],xmm3				; Sub = 0, Ctrl = 1
		movq QWORD PTR[x_Accts],xmm4
	@END_RAW
 
;	---------------------
;	Call required section
;	---------------------
	@IF x_Request,_EQ,%c_Initial
		@CALL L0_loadTables
	@ELSE
		@IF x_Request,_EQ,%c_Commit
			@CALL Z09_Finalise
		@ELSE
 
			@BEGIN_TEST x_TableNo
 
				@WHEN _EQ,%c_A01
					@CALL A01_Process
				@WEND
 
				@WHEN _EQ,%c_B01
					@CALL B01_Process
				@WEND
 
				@WHEN _EQ,%c_B02
					@CALL B02_Process
				@WEND
 
				@WHEN _EQ,%c_B03
					@CALL B03_Process
				@WEND
 
				@WHEN _EQ,%c_B04
					@CALL B04_Process
				@WEND
 
				@WHEN _EQ,%c_B07
					@CALL B07_Process
				@WEND
 
				@WHEN _EQ,%c_C01
					@CALL C01_Process
				@WEND
 
				@WHEN _EQ,%c_C02
					@CALL C02_Process
				@WEND
 
				@WHEN _EQ,%c_B99
					@CALL X_Process
				@WEND
 
			@END_TEST
		@END_IF
	@END_IF
 
	@INTEGERS_CALC  RETURN_CODE,=,<ERROR_CODE>
 
	@BEGIN_RAW
		$popAll r15,r14,r13,r12,r11,r10,r9,r8,rbp,rdi,rsi,rdx,rcx,rbx,rax
	@END_RAW
 
@END_SUB L0_PROCESS
 
;-----------------------------------------------------------------------
;	Company processing
;-----------------------------------------------------------------------
@BEGIN_SUB A01_Process
;	----------
;	Initialise
;	----------
	@INTEGERS_CALC  ERROR_CODE,=,<0>
 
;	-----
;	Start
;	-----
;	0 is return the record No of the 1st LOGICAL record - 1
;	1 is return the record No of our 1st LOGICAL record
;		the 1st record of type ParameterNo = 2
 
;	We process from the start to the upper boundary  which was set
;	during the load process
;	We are doing a LOGICAL start as only Parameter No's above 1
;	represents Companies or Consolidated Companies.
;	If we have found the record then its No is stored in A01-StartRecNo
;	If the start parameter is 0 then we return the record no less 1
;	whilst a start parameter of 1 denotes returning the found record
;	no as is. The error code is set to the table status, which will
;	be zero and that is moved to the RETURN_CODE at the end of the
;	mainline code
;	If we have passed the Upper Bounday then it is End Of File
 
	@IF x_Request,_EQ,%c_Start
 
		@REPEAT_FOR A01_Record_NO,1,A01_Table_UBOUND
			@TABLES_RGET A01_Table,A01_Record_NO
			@IF A01_ParameterNo,_EQ,2
					@INTEGERS_CALC  A01_StartRecNo,=,<A01_Record_NO>
					@IF x_RecNo,_EQ,0
						@INTEGERS_CALC  A01_Record_NO,=,<A01_StartRecNo,-,1>
					@END_IF
					@INTEGERS_CALC  ERROR_CODE,=,<A01_Table_STATUS>
					@EXIT_SUB A01_Process
			@END_IF
		@END_REPEAT
		@INTEGERS_CALC  ERROR_CODE,=,<10>
		@EXIT_SUB A01_Process
	@END_IF
 
;	----
;	Read
;	----
	@IF x_Request,_EQ,%c_Read
		@INTEGERS_CALC  A01_Record_NO,=,<x_RecNo>
		@IF A01_Record_NO,_GT,A01_Table_UBOUND
			@INTEGERS_CALC  ERROR_CODE,=,<10>
			@EXIT_SUB A01_Process
		@ELSE
			@TABLES_RGET A01_Table,A01_Record_NO
			@INTEGERS_CALC  ERROR_CODE,=,<A01_Table_STATUS>
			@WORDS_PAD A01_UnitPrice,w_A01_UnitPrice
			@EXIT_SUB A01_Process
		@END_IF
	@END_IF
 
;	-------------
;	Previous/Next
;	-------------
	@IF x_Request,_EQ,%c_PreviousNext
 
		@REPEAT_WHILE 1,_EQ,1
 
			@INTEGERS_CALC  A01_Record_NO,=,<A01_Record_NO,+,x_RecNo>
 
			@_IF A01_Record_NO,_EQ,0
			@_OR A01_Record_NO,_GT,A01_Table_UBOUND
			@_END
				@INTEGERS_CALC  ERROR_CODE,=,<10>
				@EXIT_SUB A01_Process
			@END_IF
 
			@TABLES_RGET A01_Table,A01_Record_NO
 
			@IF A01_Table_STATUS,_NEQ,0
				@INTEGERS_CALC  A01_Record_NO,=,<A01_Record_NO,-,x_RecNo>
				@TABLES_RGET A01_Table,A01_Record_NO
				@INTEGERS_CALC  ERROR_CODE,=,<10>
				@EXIT_SUB A01_Process
			@ELSE
				@IF A01_ParameterNo,_GT,1
					@INTEGERS_CALC  ERROR_CODE,=,<A01_Table_STATUS>
					@EXIT_SUB A01_Process
				@END_IF
			@END_IF
		@END_REPEAT
		@EXIT_SUB A01_Process
	@END_IF
 
;	------
;	Delete
;	------
	@IF x_Request,_EQ,%c_Delete
		@IF A011_f_Valid_Record
			@INTEGERS_CALC  A01_ParameterNo,=,<99>
			@INTEGERS_CALC  A01_Parameter,=,<99>
			@TABLES_RPUT A01_Table,x_RecNo
			@TABLES_SORT A01_Table,1,4
			@INTEGERS_CALC  A01_Table_UBOUND,=,<A01_Table_UBOUND,-,1>
		@END_IF
		@EXIT_SUB A01_Process
	@END_IF
 
;	-----
;	Write
;	-----
	@IF x_Request,_EQ,%c_Write
 
		@NUMBERS_CALC  A01_UnitPrice,=,<w_A01_UnitPrice>
 
		@TABLES_RPUT A01_Table,%%c_A01_MaxRecords
 
		@IF A011_f_Valid_Record
			@TABLES_RGET A01_Table,%%c_A01_MaxRecords
			@IF x_RecNo,_EQ,0
				@INTEGERS_CALC  A01_Table_UBOUND,=,<A01_Table_UBOUND,+,1>
				@IF A01_Table_UBOUND,_LT,%%c_A01_MaxRecords
					@TABLES_RPUT A01_Table,A01_Table_UBOUND
					@TABLES_SORT A01_Table,1,4
				@ELSE
					@DISPLAY_LINE "A01_Table size has been exceeded"
					@TERMINATE 1
				@END_IF
			@ELSE
				@INTEGERS_CALC  A01_Record_NO,=,<x_RecNo>
				@TABLES_RPUT A01_Table,A01_Record_NO
			@END_IF
		@ELSE
			@TABLES_RGET A01_Table,%%c_A01_MaxRecords
		@END_IF
	@END_IF
 
;	-----;	Print
;	-----
	@IF x_Request,_EQ,%c_Print
		@CALL A012_Process_Print
	@END_IF
 
@END_SUB A01_Process
;-----------------------------------------------------------------------
;	Validate A01 record
;-----------------------------------------------------------------------
@BEGIN_FUNCTION A011_f_Valid_Record
 
;	------
;	DELETE
;	------
 
;	If the Company has active accounts
	@IF x_Request,_EQ,%c_Delete
		@REPEAT_FOR I,1,B01_Table_UBOUND
			@TABLES_RGET B01_Table,I
			@_IF A01_ParameterNo,_EQ,2
			@_AND B01_Company,_EQ,A01_Parameter
			@_END
				@INTEGERS_CALC  ERROR_CODE,=,<30>
				@EXIT_FUNCTION A011_f_Valid_Record
			@END_IF
		@END_REPEAT
	@END_IF
 
;	If the Company belongs to a Consolidated group [Parameter No=3]
	@IF x_Request,_EQ,%c_Delete
		@IF A01_ParameterNo,_EQ,2
			@REPEAT_FOR I,1,A01_Table_UBOUND
				@TABLES_RGET A01_Table,I
				@IF A01_ParameterNo,_EQ,3
					@CALL X_LoadCompany_Array
					@TABLES_RGET A01_Table,x_RecNo
					@REPEAT_FOR J,n_CpyIdx,%c_NoOfCompanies
						@ARRAYS_IF n_Companies,<<J>>,_NEQ,0
							@ARRAYS_IF n_Companies,<<J>>,_EQ,A01_Parameter
						 		@INTEGERS_CALC  RETURN_CODE,=,<c_FALSE>
						 		@INTEGERS_CALC  ERROR_CODE,=,<31>
						 		@EXIT_FUNCTION A011_f_Valid_Record
						 	@END_IF
						 @END_IF
					@END_REPEAT
				@END_IF
			@END_REPEAT
			@INTEGERS_CALC  RETURN_CODE,=,<c_TRUE>
			@EXIT_FUNCTION A011_f_Valid_Record
		@END_IF
	@END_IF
 
;	--------------
;	GST Account No
;	--------------
	@TABLES_RGET A01_Table,%%c_A01_MaxRecords
 
	@IF A01_ParameterNo,_EQ,2
 
		@_IF A01_GSTAccount,_GT,0
		@_AND A01_GSTAccount,_LT,59999
		@_END
 
			@INTEGERS_CALC  ERROR_CODE,=,<32>
			@REPEAT_FOR B01_Record_NO,1,B01_Table_UBOUND
				@TABLES_RGET B01_Table,B01_Record_NO
				@IF A01_GSTAccount,_EQ,B01_AcctNo
					@IF B01_CntlAcctNo,_NEQ,99999
						@INTEGERS_CALC  ERROR_CODE,=,<0>
						@EXIT_REPEAT
					@ELSE
						@EXIT_REPEAT
					@END_IF
				@END_IF
			@END_REPEAT
			@IF ERROR_CODE,_EQ,32
			 	@INTEGERS_CALC  RETURN_CODE,=,<c_FALSE>
				@EXIT_FUNCTION A011_f_Valid_Record
			@ELSE
				@INTEGERS_CALC  RETURN_CODE,=,<c_TRUE>
				@EXIT_FUNCTION A011_f_Valid_Record
			@END_IF
		@END_IF
	 	@INTEGERS_CALC  RETURN_CODE,=,<c_TRUE>
		@EXIT_FUNCTION A011_f_Valid_Record
	@END_IF
 
;	---------
;	Companies
;	---------
;	The Comapny entered in a Consolidated Group does not exist
	@TABLES_RGET A01_Table,%%c_A01_MaxRecords
 
	@IF A01_ParameterNo,_EQ,3
 
		@CALL X_LoadCompany_Array
 
		@REPEAT_FOR J,n_CpyIdx,12
 
			@INTEGERS_CALC  I,=,<0>
 
			@REPEAT_FOR A01_Record_NO,1,A01_Table_UBOUND
				@TABLES_RGET A01_Table,A01_Record_NO
 
				@IF A01_ParameterNo,_GT,2
			 		@INTEGERS_CALC  RETURN_CODE,=,<c_FALSE>
			 		@INTEGERS_CALC  ERROR_CODE,=,<33>
			 		@EXIT_FUNCTION A011_f_Valid_Record
				@END_IF
 
				@IF A01_ParameterNo,_EQ,2
			 		@ARRAYS_IF n_Companies,<<J>>,_EQ,A01_Parameter
						@INTEGERS_CALC  I,=,<1>
			 			@EXIT_REPEAT
			 		@END_IF
				@END_IF
 
			@END_REPEAT
 
			@IF I,_EQ,0
		 		@INTEGERS_CALC  RETURN_CODE,=,<c_FALSE>
		 		@INTEGERS_CALC  ERROR_CODE,=,<33>
		 		@EXIT_FUNCTION A011_f_Valid_Record
			@END_IF
 
		@END_REPEAT
 
	@END_IF
 
;	------------------------------
;	Consolidated No must be unique
;	------------------------------
;	The Consolidated Group No must be unique
	@TABLES_RGET A01_Table,%%c_A01_MaxRecords
 
	@IF A01_ParameterNo,_EQ,3
 
		@INTEGERS_CALC  I,=,<A01_Parameter>
 
		@REPEAT_FOR A01_Record_NO,1,A01_Table_UBOUND
			@TABLES_RGET A01_Table,A01_Record_NO
 
			@_IF A01_ParameterNo,_EQ,2
			@_AND A01_Parameter,_EQ,I
			@_END
			 		@INTEGERS_CALC  RETURN_CODE,=,<c_FALSE>
			 		@INTEGERS_CALC  ERROR_CODE,=,<34>
			 		@EXIT_FUNCTION A011_f_Valid_Record
			@END_IF
 
		@END_REPEAT
 
	@END_IF
 
 
 	 @INTEGERS_CALC  RETURN_CODE,=,<c_TRUE>
 
@END_FUNCTION A011_f_Valid_Record
 
 
;-----------------------------------------------------------------------
;	System Parameters Print
;-----------------------------------------------------------------------
@BEGIN_SUB A012_Process_Print
 
	@INTEGERS_CALC  n_LineCtr,=,<99>
	@INTEGERS_CALC  n_PageNo,=,<0>
 
	@FILES_OPEN A01_PRINT,$write+$beginning
 
	@REPEAT_FOR A01_Record_NO,1,%%c_A01_MaxRecords
 
		@TABLES_RGET A01_Table,A01_Record_NO
		@IF A01_Table_STATUS,_EQ,0
 
			@_IF A01_ParameterNo,_NLT,n_StartParmNo
			@_AND A01_ParameterNo,_NGT,n_EndParmNo
			@_AND A01_Parameter,_NLT,n_StartParm
			@_AND A01_Parameter,_NGT,n_EndParm
			@_END
 
				@INTEGERS_CALC  n_LineCtr,=,<n_LineCtr,+,1>
 
				@CALL A0121_Process_Print_Headings
				@CALL A0122_Process_Print_Details
			@END_IF
		@ELSE
			@EXIT_REPEAT
		@END_IF
 
	@END_REPEAT
 
	@FILES_CLOSE A01_PRINT
 
@END_SUB A012_Process_Print
 
;-----------------------------------------------------------------------
;	System Parameters Headings
;-----------------------------------------------------------------------
@BEGIN_SUB A0121_Process_Print_Headings
 
	@IF n_LineCtr,_LT,55
		@EXIT_SUB A0121_Process_Print_Headings
	@END_IF
 
	@FILES $write,A01_PRINT,x_NewPage
 
	@INTEGERS_CALC  n_PageNo,=,<n_PageNo,+,1>
 
	@FILES $write,A01_PRINT,w_Underlines80
 
	@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
	@WORDS_PAD "A0100001",w_prtLine80
	@WORDS_COPY "SYSTEM PARAMETRS",<<w_prtLine80,11>>
	@WORDS_COPY "PAGE",<<w_prtLine80,72>>
	@WORDS_COPY n_PageNo,<<w_prtLine80,77>>
	@FILES $write,A01_PRINT,w_prtLine80
 
	@FILES $write,A01_PRINT,w_Underlines80
 
	@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
	@WORDS_PAD "ParamNo",w_prtLine80
	@WORDS_COPY "Param",<<w_prtLine80,09>>
	@WORDS_COPY "Description",<<w_prtLine80,15>>
	@FILES $write,A01_PRINT,w_prtLine80
 
	@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
	@WORDS_PAD "-------",w_prtLine80
	@WORDS_COPY "------",<<w_prtLine80,09>>
	@WORDS_COPY "-----------",<<w_prtLine80,15>>
	@FILES $write,A01_PRINT,w_prtLine80
 
	@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
	@FILES $write,A01_PRINT,w_prtLine80
 
	@INTEGERS_CALC  n_LineCtr,=,<7>
 
@END_SUB A0121_Process_Print_Headings
 
;-----------------------------------------------------------------------
;	System Parameters Details
;-----------------------------------------------------------------------
@BEGIN_SUB A0122_Process_Print_Details
 
	@IF A01_ParameterNo,_GT,1
		@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
		@FILES $write,A01_PRINT,w_prtLine80
	@END_IF
 
	@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
	@WORDS_COPY A01_ParameterNo,<<w_prtLine80,06>>
	@WORDS_COPY A01_Parameter,<<w_prtLine80,12>>
	@WORDS_COPY A01_Description,<<w_prtLine80,15>>
	@FILES $write,A01_PRINT,w_prtLine80
 
	@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
 
	@BEGIN_TEST A01_ParameterNo
		@WHEN _EQ,1
			@WORDS_COPY "Password=",<<w_prtLine80,15>>
			@WORDS_COPY A01_Password,<<w_prtLine80,24>>
			@FILES $write,A01_PRINT,w_prtLine80
		@WEND
		@WHEN _EQ,2
			@WORDS_COPY "Ref=",<<w_prtLine80,15>>
			@WORDS_COPY A01_LastReference,<<w_prtLine80,19>>
			@WORDS_COPY "GST Acct=",<<w_prtLine80,30>>
			@WORDS_COPY A01_GSTAccount,<<w_prtLine80,39>>
			@WORDS_COPY "StartYear=",<<w_prtLine80,45>>
			@WORDS_COPY A01_StartYear,<<w_prtLine80,55>>
			@WORDS_COPY "UnitPrice=",<<w_prtLine80,60>>
			@WORDS_COPY A01_UnitPrice,<<w_prtLine80,70>>
			@FILES $write,A01_PRINT,w_prtLine80
		@WEND
		@WHEN _EQ,3
			@WORDS_COPY "Companies=",<<w_prtLine80,15>>
			@WORDS_COPY A01_Company01,<<w_prtLine80,25>>
			@WORDS_COPY A01_Company02,<<w_prtLine80,28>>
			@WORDS_COPY A01_Company03,<<w_prtLine80,31>>
			@WORDS_COPY A01_Company04,<<w_prtLine80,34>>
			@WORDS_COPY A01_Company05,<<w_prtLine80,37>>
			@WORDS_COPY A01_Company06,<<w_prtLine80,40>>
			@WORDS_COPY A01_Company07,<<w_prtLine80,43>>
			@WORDS_COPY A01_Company08,<<w_prtLine80,46>>
			@WORDS_COPY A01_Company09,<<w_prtLine80,49>>
			@WORDS_COPY A01_Company10,<<w_prtLine80,52>>
			@WORDS_COPY A01_Company11,<<w_prtLine80,55>>
			@WORDS_COPY A01_Company12,<<w_prtLine80,58>>
			@FILES $write,A01_PRINT,w_prtLine80
		@WEND
	@END_TEST
 
@END_SUB A0122_Process_Print_Details
 
;-----------------------------------------------------------------------
;	Chart of Account
;-----------------------------------------------------------------------
@BEGIN_SUB B01_Process
;	These IO Routines are mainly called by the LAZARUS front-end and will
;	make working thru the multi-company Chart Of Account invisible to
;	that fornt-end
 
;	----------
;	Initialise
;	----------
	@INTEGERS_CALC  ERROR_CODE,=,<0>
 
;	-----
;	Start
;	-----
;	0 is return the record No of the 1st LOGICAL record - 1
;	1 is return the record No of our 1st LOGICAL record
;		Logical records are those belonging to the selected COMPANY
 
	@IF x_Request,_EQ,%c_Start
 
		@REPEAT_FOR B01_Record_NO,1,B01_Table_UBOUND
			@TABLES_RGET B01_Table,B01_Record_NO
			@INTEGERS_CALC  ERROR_CODE,=,<B01_Table_STATUS>
			@IF B01_Company,_EQ,A01_Parameter
				@CALL f_ValueAcct
				@IF RETURN_CODE,_EQ,%c_TRUE
					@INTEGERS_CALC  B01_StartRecNo,=,<B01_Record_NO>
					@IF x_RecNo,_EQ,0
						@INTEGERS_CALC  B01_Record_NO,=,<B01_StartRecNo,-,1>
					@END_IF
					@EXIT_SUB B01_Process
				@END_IF
			@END_IF
		@END_REPEAT
 
		@INTEGERS_CALC  ERROR_CODE,=,<10>
		@EXIT_SUB B01_Process
	@END_IF
 
;	----
;	Read
;	----
	@IF x_Request,_EQ,%c_Read
		@INTEGERS_CALC  B01_Record_NO,=,<x_RecNo>
		@IF B01_Record_NO,_GT,B01_Table_UBOUND
			@INTEGERS_CALC  ERROR_CODE,=,<10>
			@EXIT_SUB B01_Process
		@ELSE
			@TABLES_RGET B01_Table,B01_Record_NO
			@INTEGERS_CALC  ERROR_CODE,=,<B01_Table_STATUS>
			@WORDS_PAD B01_UnitPrice,w_B01_UnitPrice
			@EXIT_SUB B01_Process
		@END_IF
	@END_IF
 
;	-------------
;	Previous/Next
;	-------------
;	Logical records are those belonging to the selected COMPANY
@IF x_Request,_EQ,%c_PreviousNext
		@REPEAT_WHILE 1,_EQ,1
			@INTEGERS_CALC  B01_Record_NO,=,<B01_Record_NO,+,x_RecNo>
			@_IF B01_Record_NO,_EQ,0
			@_OR B01_Record_NO,_GT,B01_Table_UBOUND
			@_END
				@INTEGERS_CALC  ERROR_CODE,=,<10>
				@EXIT_SUB B01_Process
			@END_IF
 
			@TABLES_RGET B01_Table,B01_Record_NO
 
			@_IF B01_Table_STATUS,_NEQ,0
			@_OR B01_Company,_NEQ,A01_Parameter
			@_END
				@INTEGERS_CALC  B01_Record_NO,=,<B01_Record_NO,-,x_RecNo>
				@TABLES_RGET B01_Table,B01_Record_NO
				@INTEGERS_CALC  ERROR_CODE,=,<10>
				@EXIT_SUB B01_Process
			@ELSE
				@CALL f_ValueAcct
				@IF RETURN_CODE,_EQ,%c_TRUE
					@INTEGERS_CALC  ERROR_CODE,=,<B01_Table_STATUS>
					@EXIT_SUB B01_Process
				@END_IF
			@END_IF
		@END_REPEAT
		@EXIT_SUB B01_Process
	@END_IF
 
;	------
;	Delete
;	------
	@IF x_Request,_EQ,%c_Delete
		@IF B011_f_Valid_Record
			@INTEGERS_CALC  B01_Company,=,<99>
			@INTEGERS_CALC  B01_AcctNo,=,<99999>
			@TABLES_RPUT B01_Table,x_RecNo
			@TABLES_SORT B01_Table,1,7
			@INTEGERS_CALC  B01_Table_UBOUND,=,<B01_Table_UBOUND,-,1>
		@END_IF
		@EXIT_SUB B01_Process
	@END_IF
 
;	-----
;	Write
;	-----
	@IF x_Request,_EQ,%c_Write
 
		@INTEGERS_CALC  B01_Company,=,<A01_Parameter>
		@NUMBERS_CALC  B01_UnitPrice,=,<w_B01_UnitPrice>
 
		@TABLES_RPUT B01_Table,%%c_B01_MaxRecords
 
		@IF B011_f_Valid_Record
			@TABLES_RGET B01_Table,%%c_B01_MaxRecords
 
			@IF x_RecNo,_EQ,0
				@INTEGERS_CALC  B01_Table_UBOUND,=,<B01_Table_UBOUND,+,1>
				@IF B01_Table_UBOUND,_LT,%%c_B01_MaxRecords
					@TABLES_RPUT B01_Table,B01_Table_UBOUND
					@TABLES_SORT B01_Table,1,7
				@ELSE
					@DISPLAY_LINE "B01_Table size has been exceeded"
					@TERMINATE 1
				@END_IF
			@ELSE
				@INTEGERS_CALC  B01_Record_NO,=,<x_RecNo>
				@TABLES_RPUT B01_Table,B01_Record_NO
			@END_IF
 
		@ELSE
			@TABLES_RGET B01_Table,%%c_B01_MaxRecords
		@END_IF
	@END_IF
 
;	-----
;	Print
;	-----
	@IF x_Request,_EQ,%c_Print
		@CALL B012_Process_Print
	@END_IF
 
@END_SUB B01_Process
 
 
;-----------------------------------------------------------------------
;	Validate B01 record
;-----------------------------------------------------------------------
@BEGIN_FUNCTION B011_f_Valid_Record
 
;	Functions default to FALSE
 
	@INTEGERS_CALC  n_AcctNo,=,<B01_AcctNo>
	@INTEGERS_CALC  n_CntlAcctNo,=,<B01_CntlAcctNo>
 
;	------
;	DELETE
;	------
 
	@IF x_Request,_EQ,%c_Delete
 
	;	If Account has active transactions
		@REPEAT_FOR I,1,B02_Table_UBOUND
			@TABLES_RGET B02_Table,I
			@IF B02_Company,_EQ,A01_Parameter
				@_IF B02_DRAcctNo,_EQ,B01_AcctNo
				@_OR B02_CRAcctNo,_EQ,B01_AcctNo
				@_END
					@INTEGERS_CALC  ERROR_CODE,=,<40>
					@EXIT_FUNCTION B011_f_Valid_Record
				@END_IF
			@END_IF
		@END_REPEAT
 
	;	Child Accounts still exist
		@IF B01_CntlAcctNo,_EQ,99999
			@IF <<f_CntlAcctChildren,n_AcctNo>>
				@INTEGERS_CALC  ERROR_CODE,=,<41>
				@EXIT_FUNCTION B011_f_Valid_Record
			@END_IF
		@END_IF
 
		@INTEGERS_CALC  RETURN_CODE,=,<c_TRUE>
		@EXIT_FUNCTION B011_f_Valid_Record
 
	@END_IF
 
;	---------------
;	CONTROL ACCOUNT
;	---------------
;	Child Accounts still exist  Control Account can be changed from 99999 to 0
	@IF n_CntlAcctNo,_EQ,0
 
		@IF <<f_CntlAcctChildren,n_AcctNo>>
			@INTEGERS_CALC  RETURN_CODE,=,<c_FALSE>
			@INTEGERS_CALC  ERROR_CODE,=,<42>
			@EXIT_FUNCTION B011_f_Valid_Record
		@END_IF
 
		@INTEGERS_CALC  RETURN_CODE,=,<c_TRUE>
		@EXIT_FUNCTION B011_f_Valid_Record
 
	@END_IF
 
;	-----------------------
;	INVALID CONTROL ACCOUNT
;	-----------------------
;	Control Account does not exist
	@_IF n_CntlAcctNo,_GT,0
	@_AND n_CntlAcctNo,_LT,59999
	@_END
 
		@IF <<f_AcctExists,n_CntlAcctNo>>
 
			@IF B01_CntlAcctNo,_NEQ,99999
				@INTEGERS_CALC  RETURN_CODE,=,<c_FALSE>
				@INTEGERS_CALC  ERROR_CODE,=,<43>
				@EXIT_FUNCTION B011_f_Valid_Record
			@END_IF
 
		@ELSE
 
			@INTEGERS_CALC  RETURN_CODE,=,<c_FALSE>
			@INTEGERS_CALC  ERROR_CODE,=,<43>
			@EXIT_FUNCTION B011_f_Valid_Record
 
		@END_IF
	@END_IF
 
   @INTEGERS_CALC  RETURN_CODE,=,<c_TRUE>
   @INTEGERS_CALC  ERROR_CODE,=,<0>
 
@END_FUNCTION B011_f_Valid_Record
 
;-----------------------------------------------------------------------
;	Chart of Accounts Print
;-----------------------------------------------------------------------
@BEGIN_SUB B012_Process_Print
 
;	Because the Chart of Accounts can be run for multi-companies the
;	the tables are accessed directly. More so because a mult-company
;	report is in Account/Company order, an Alternate key is built and
;	used to acces the Chart of Account
 
	@INTEGERS_CALC  n_LineCtr,=,<99>
	@INTEGERS_CALC  n_PageNo,=,<0>
	@FILES_OPEN B01_PRINT,$write+$beginning
 
;	--------------------
;	Load Alt Index Table
;	--------------------
	@CALL X_LoadCompany_Array
	@CALL X_AltIndex
	

;	----------------------------------------
;	Loop thru the Alt Index - AcctNo/Company
;	----------------------------------------
	@REPEAT_FOR I,1,B01_AltIdx_Table_UBOUND
 
		@TABLES_RGET B01_AltIdx_Table,I
		@TABLES_RGET B01_Table,B01_AltIdx_RecNo
 
		@CALL B0121_Process_Print_Headings
		@CALL B0122_Process_Print_Details
 
     @END_REPEAT
 
	@FILES_CLOSE B01_PRINT
 
@END_SUB B11_Process_Print
 
;-----------------------------------------------------------------------
;	Chart of Accounts Headings
;-----------------------------------------------------------------------
@BEGIN_SUB B0121_Process_Print_Headings
 
	@IF n_LineCtr,_LT,55
		@EXIT_SUB B0121_Process_Print_Headings
	@END_IF
 
	@FILES $write,B01_PRINT,x_NewPage
 
	@INTEGERS_CALC  n_PageNo,=,<n_PageNo,+,1>
 
	@FILES $write,B01_PRINT,w_Underlines80
 
	@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
 
	@WORDS_PAD "[B0100001-COA]",w_prtLine80
	@WORDS_COPY A01_Parameter,<<w_prtLine80,16>>
	@WORDS_COPY A01_Description,<<w_prtLine80,19>>
	@WORDS_COPY "PAGE",<<w_prtLine80,72>>
	@WORDS_COPY n_PageNo,<<w_prtLine80,77>>
	@FILES $write,B01_PRINT,w_prtLine80
 
	@FILES $write,B01_PRINT,w_Underlines80
 
	@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
	@WORDS_COPY "Co",<<w_prtLine80,01>>
	@WORDS_COPY "AcctNo",<<w_prtLine80,04>>
	@WORDS_COPY "Description",<<w_prtLine80,11>>
	@WORDS_COPY "F1",<<w_prtLine80,40>>
	@WORDS_COPY "F2",<<w_prtLine80,43>>
	@WORDS_COPY "F3",<<w_prtLine80,46>>
	@WORDS_COPY "F4",<<w_prtLine80,49>>
	@WORDS_COPY "IN",<<w_prtLine80,52>>
	@WORDS_COPY "CntlAcct",<<w_prtLine80,56>>
	@WORDS_COPY "Deprec",<<w_prtLine80,65>>
	@WORDS_COPY "UnitPrice",<<w_prtLine80,72>>
	@FILES $write,B01_PRINT,w_prtLine80
 
	@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
	@WORDS_COPY "--",<<w_prtLine80,01>>
	@WORDS_COPY "------",<<w_prtLine80,04>>
	@WORDS_COPY "-----------",<<w_prtLine80,11>>
	@WORDS_COPY "--",<<w_prtLine80,40>>
	@WORDS_COPY "--",<<w_prtLine80,43>>
	@WORDS_COPY "--",<<w_prtLine80,46>>
	@WORDS_COPY "--",<<w_prtLine80,49>>
	@WORDS_COPY "--",<<w_prtLine80,52>>
	@WORDS_COPY "--------",<<w_prtLine80,56>>
	@WORDS_COPY "------",<<w_prtLine80,65>>
	@WORDS_COPY "---------",<<w_prtLine80,72>>
	@FILES $write,B01_PRINT,w_prtLine80
 
	@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
	@FILES $write,B01_PRINT,w_prtLine80
 
	@INTEGERS_CALC  n_LineCtr,=,<7>
 
@END_SUB B0121_Process_Print_Headings
 
;-----------------------------------------------------------------------
;	Chart of Accounts Details
;-----------------------------------------------------------------------
@BEGIN_SUB B0122_Process_Print_Details
 
	@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
	@WORDS_COPY B01_Company,<<w_prtLine80,01>>
	@WORDS_COPY B01_AcctNo,<<w_prtLine80,05>>
	@WORDS_COPY B01_Description,<<w_prtLine80,11>>
	@WORDS_COPY B01_Flag1,<<w_prtLine80,40>>
	@WORDS_COPY B01_Flag2,<<w_prtLine80,44>>
	@WORDS_COPY B01_Flag3,<<w_prtLine80,47>>
	@WORDS_COPY B01_Flag4,<<w_prtLine80,50>>
	@WORDS_COPY B01_BalanceIndicator,<<w_prtLine80,52>>
	@WORDS_COPY B01_CntlAcctNo,<<w_prtLine80,59>>
	@WORDS_COPY B01_Depreciation,<<w_prtLine80,68>>
	@WORDS_COPY B01_UnitPrice,<<w_prtLine80,72>>
 
	@FILES $write,B01_PRINT,w_prtLine80
	@INTEGERS_CALC  n_LineCtr,=,<n_LineCtr,+,1>
 
@END_SUB B0122_Process_Print_Details
 
;-----------------------------------------------------------------------
;	General Journal
;-----------------------------------------------------------------------
@BEGIN_SUB B02_Process
 
;	These IO Routines are mainly called by the LAZARUS front-end and will
;	make working thru the multi-company Transaction invisible to
;	that fornt-end
 
;	----------
;	Initialise
;	----------
	@INTEGERS_CALC  ERROR_CODE,=,<0>
 
;	-----
;	Start
;	-----
;	0 is return the record No of the 1st LOGICAL record - 1
;	1 is return the record No of our 1st LOGICAL record
;		Logical records are those belonging to the selected COMPANY
 
	@IF x_Request,_EQ,%c_Start
 
		@REPEAT_FOR B02_Record_NO,1,B02_Table_UBOUND
			@TABLES_RGET B02_Table,B02_Record_NO
			@INTEGERS_CALC  ERROR_CODE,=,<B02_Table_STATUS>
 
			@IF B02_Company,_EQ,A01_Parameter
				@INTEGERS_CALC  B02_StartRecNo,=,<B02_Record_NO>
				@IF x_RecNo,_EQ,0
					@INTEGERS_CALC  B02_Record_NO,=,<B02_StartRecNo,-,1>
				@END_IF
				@WORDS_PAD B02_Value,w_B02_Value
				@WORDS_PAD B02_FrankedAmt,w_B02_FrankedAmt
				@WORDS_PAD B02_ImputedCredit,w_B02_ImputedCredit
				@WORDS_PAD B02_SUnitPrice,w_B02_SUnitPrice
				@EXIT_SUB B02_Process
			@END_IF
 
		@END_REPEAT
 
		@INTEGERS_CALC  ERROR_CODE,=,<10>
		@EXIT_SUB B02_Process
	@END_IF
 
;	-----
;	Read
;	----
	@IF x_Request,_EQ,%c_Read
		@INTEGERS_CALC  B02_Record_NO,=,<x_RecNo>
		@IF B02_Record_NO,_GT,B02_Table_UBOUND
			@INTEGERS_CALC  ERROR_CODE,=,<10>
			@EXIT_SUB B02_Process
		@ELSE
			@TABLES_RGET B02_Table,B02_Record_NO
			@INTEGERS_CALC  ERROR_CODE,=,<B02_Table_STATUS>
			@WORDS_PAD B02_Value,w_B02_Value
			@WORDS_PAD B02_FrankedAmt,w_B02_FrankedAmt
			@WORDS_PAD B02_ImputedCredit,w_B02_ImputedCredit
			@WORDS_PAD B02_SUnitPrice,w_B02_SUnitPrice
			@EXIT_SUB B02_Process
		@END_IF
	@END_IF
 
;	-------------
;	Previous/Next
;	-------------
;	Logical records are those belonging to the selected COMPANY
 
	@IF x_Request,_EQ,%c_PreviousNext
 
		@REPEAT_WHILE 1,_EQ,1
			@INTEGERS_CALC  B02_Record_NO,=,<B02_Record_NO,+,x_RecNo>
			@_IF B02_Record_NO,_EQ,0
			@_OR B02_Record_NO,_GT,B02_Table_UBOUND
			@_END
				@INTEGERS_CALC  ERROR_CODE,=,<10>
				@EXIT_SUB B02_Process
			@END_IF
 
			@TABLES_RGET B02_Table,B02_Record_NO
 
			@_IF B02_Table_STATUS,_NEQ,0
			@_OR B02_Company,_NEQ,A01_Parameter
			@_END
				@INTEGERS_CALC  B02_Record_NO,=,<B02_Record_NO,-,x_RecNo>
				@TABLES_RGET B02_Table,B02_Record_NO
				@INTEGERS_CALC  ERROR_CODE,=,<10>
				@EXIT_SUB B02_Process
			@ELSE
				@INTEGERS_CALC  ERROR_CODE,=,<B02_Table_STATUS>
				@WORDS_PAD B02_Value,w_B02_Value
				@WORDS_PAD B02_FrankedAmt,w_B02_FrankedAmt
				@WORDS_PAD B02_ImputedCredit,w_B02_ImputedCredit
				@WORDS_PAD B02_SUnitPrice,w_B02_SUnitPrice
				@EXIT_SUB B02_Process
			@END_IF
		@END_REPEAT
		@EXIT_SUB B02_Process
	@END_IF
 
;	------
;	Delete
;	------
	@IF x_Request,_EQ,%c_Delete
		@IF B021_f_Valid_Record
			@INTEGERS_CALC  B02_Company,=,<99>
			@WORDS_PAD "9999/99/99",B02_TranDate
			@WORDS_PAD "99:99:99",B02_TranTime
			@TABLES_RPUT B02_Table,x_RecNo
			@TABLES_SORT B02_Table,1,20
			@INTEGERS_CALC  B02_Table_UBOUND,=,<B02_Table_UBOUND,-,1>
		@END_IF
		@EXIT_SUB B02_Process
	@END_IF
 
;	-----
;	Write
;	-----
	@IF x_Request,_EQ,%c_Write
	

		@INTEGERS_CALC  B02_Company,=,<A01_Parameter>
		@NUMBERS_CALC  B02_Value,=,<w_B02_Value>
		@NUMBERS_CALC  B02_FrankedAmt,=,<w_B02_FrankedAmt>
		@NUMBERS_CALC  B02_ImputedCredit,=,<w_B02_ImputedCredit>
		@NUMBERS_CALC  B02_SUnitPrice,=,<w_B02_SUnitPrice>
 
		@TABLES_RPUT B02_Table,%%c_B02_MaxRecords
 
		@IF B021_f_Valid_Record
 
			@_IF x_RecNo,_EQ,0
			@_AND x_AcctNo,_EQ,%c_TRUE
			@_END
				@CALL B022_Process_GST
			@END_IF
			@TABLES_RGET B02_Table,%%c_B02_MaxRecords
			@_IF x_RecNo,_EQ,0
			@_AND x_AcctNo,_EQ,%c_TRUE
			@_END
				@NUMBERS_CALC  B02_Value,=,<B02_Value,-,n_GST>
			@END_IF
 
			@CALL B023_Process_CntlAccts
 
			@IF x_RecNo,_EQ,0
				@INTEGERS_CALC  B02_Table_UBOUND,=,<B02_Table_UBOUND,+,1>
				@IF B02_Table_UBOUND,_LT,%%c_B02_MaxRecords
					@TABLES_RPUT B02_Table,B02_Table_UBOUND
					@TABLES_SORT B02_Table,1,20
				@ELSE
					@DISPLAY_LINE "B02_Table size has been exceeded"
					@TERMINATE 1
				@END_IF
			@ELSE
				@INTEGERS_CALC  B02_Record_NO,=,<x_RecNo>
				@TABLES_RPUT B02_Table,B02_Record_NO
			@END_IF
		@ELSE
			@TABLES_RGET B02_Table,%%c_B02_MaxRecords
		@END_IF
	@END_IF
 
;	-----
;	Print
;	-----
	@IF x_Request,_EQ,%c_Print
		@CALL B024_Process_Print
	@END_IF
 
@END_SUB B02_Process
 
;-----------------------------------------------------------------------
;	Validate B02 record
;-----------------------------------------------------------------------
@BEGIN_FUNCTION B021_f_Valid_Record
 
;	-------------
;	DEBIT ACCOUNT
;	-------------
	@IF <<f_AcctExists,B02_DRAcctNo>>
	@ELSE
		@INTEGERS_CALC  RETURN_CODE,=,<c_FALSE>
		@INTEGERS_CALC  ERROR_CODE,=,<52>
		@EXIT_FUNCTION B021_f_Valid_Record
	@END_IF
 
;	--------------
;	CREDIT ACCOUNT
;	--------------
	@IF <<f_AcctExists,B02_CRAcctNo>>
	@ELSE
		@INTEGERS_CALC  RETURN_CODE,=,<c_FALSE>
		@INTEGERS_CALC  ERROR_CODE,=,<53>
		@EXIT_FUNCTION B021_f_Valid_Record
	@END_IF
 
;	-----------
;	INV ACCOUNT
;	-----------
	@IF B02_INVAcctNo,_GT,0
		@IF <<f_AcctExists,B02_INVAcctNo>>
		@ELSE
			@INTEGERS_CALC  RETURN_CODE,=,<c_FALSE>
			@INTEGERS_CALC  ERROR_CODE,=,<54>
			@EXIT_FUNCTION B021_f_Valid_Record
		@END_IF
	@END_IF
 
;	-----
;	Value
;	-----
	@IF B02_Value,_EQ,0
		@INTEGERS_CALC  RETURN_CODE,=,<c_FALSE>
		@INTEGERS_CALC  ERROR_CODE,=,<55>
		@EXIT_FUNCTION B021_f_Valid_Record
	@END_IF
 
	@INTEGERS_CALC  RETURN_CODE,=,<c_TRUE>
 
@END_FUNCTION B021_f_Valid_Record
 
;-----------------------------------------------------------------------
;	Write GST routine
;-----------------------------------------------------------------------
@BEGIN_SUB B022_Process_GST
 
		@NUMBERS_CALC  n_GST,=,<B02_Value,/,11>
		@NUMBERS_CALC  B02_Value,=,<n_GST>
		@WORDS_INSERT "GST-:",<<B02_Description,1>>
 
	;	If crediting Income then credit the GST account
		@_IF B02_CRAcctNo,_GT,39999
		@_AND B02_CRAcctNo,_LT,50000
		@_END
				@INTEGERS_CALC  B02_CRAcctNo,=,<A01_GSTAccount>
		@END_IF
 
 
	;	If debitting expense then debit the GST account
		@IF B02_DRAcctNo,_GT,49999
				@INTEGERS_CALC  B02_DRAcctNo,=,<A01_GSTAccount>
		@END_IF
 
	;	If stock purchase then debit the GST account
		@_IF B02_DRAcctNo,_GT,19999
		@_AND B02_DRAcctNo,_LT,30000
		@_END
				@INTEGERS_CALC  B02_DRAcctNo,=,<A01_GSTAccount>
		@END_IF
 
	;	Write GST record
		@INTEGERS_CALC  B02_Table_UBOUND,=,<B02_Table_UBOUND,+,1>
		@IF B02_Table_UBOUND,_LT,%%c_B02_MaxRecords
			@TABLES_RPUT B02_Table,B02_Table_UBOUND
		@END_IF
 
@END_SUB B022_Process_GST
 
;-----------------------------------------------------------------------
;	Check for Control Accounts
;-----------------------------------------------------------------------
@BEGIN_SUB B023_Process_CntlAccts
 
	@REPEAT_FOR B01_Record_NO,B01_StartRecNo,B01_Table_UBOUND
		@TABLES_RGET B01_Table,B01_Record_NO
 
		@IF B01_Company,_GT,A01_Parameter
			@EXIT_SUB B023_Process_CntlAccts
		@ELSE
 
			@IF B02_DRAcctNo,_EQ,B01_AcctNo
				@INTEGERS_CALC  B02_DRCntlAcctNo,=,<B01_CntlAcctNo>
			@END_IF
			@IF B02_CRAcctNo,_EQ,B01_AcctNo
				@INTEGERS_CALC  B02_CRCntlAcctNo,=,<B01_CntlAcctNo>
			@END_IF
 
		@END_IF
 
	@END_REPEAT
 
@END_SUB B023_Process_CntlAccts
 
 
;-----------------------------------------------------------------------
;	General Journal Print
;-----------------------------------------------------------------------
@BEGIN_SUB B024_Process_Print
 
;	Because the Transaction Listing can not run Consolidated, we can
;	use the LAZARUS IO routines from here. They will return records
;	for the appropriate company
 
;	--------------------
;	Gets the 1st records
;	--------------------
	@INTEGERS_CALC  x_Request,=,<%c_Start>
	@INTEGERS_CALC  x_RecNo,=,<1>
	@CALL B02_Process
	@INTEGERS_CALC  x_Request,=,<%c_PreviousNext>
 
	@INTEGERS_CALC  n_LineCtr,=,<99>
	@INTEGERS_CALC  n_PageNo,=,<0>
 
	@FILES_OPEN B02_PRINT,$write+$beginning
 
	@INTEGERS_CALC  ERROR_CODE,=,<0>
	@REPEAT_WHILE ERROR_CODE,_EQ,0
 
		@IF B02_TranDate,_GT,w_EndDate
			@EXIT_REPEAT
 
		@ELSE
 
			@IF B02_TranDate,_NLT,w_StartDate
 
				@IF w_Reference,_NEQ,<<w_Spaces,10>>
					@IF B02_Reference,_EQ,w_Reference
						@INTEGERS_CALC  n_LineCtr,=,<n_LineCtr,+,1>
						@CALL B0241_Process_Print_Headings
						@CALL B0242_Process_Print_Details
					@END_IF
				@ELSE
					@INTEGERS_CALC  n_LineCtr,=,<n_LineCtr,+,1>
					@CALL B0241_Process_Print_Headings
					@CALL B0242_Process_Print_Details
				@END_IF
			@END_IF
 
			@CALL B02_Process
 
		@END_IF
 
	@END_REPEAT
 
	@FILES_CLOSE B02_PRINT
 
@END_SUB B024_Process_Print
 
;-----------------------------------------------------------------------
;	General Journal Headings
;-----------------------------------------------------------------------
@BEGIN_SUB B0241_Process_Print_Headings
 
     @IF n_LineCtr,_LT,55
        @EXIT_SUB B0241_Process_Print_Headings
     @END_IF
     @FILES $write,B02_PRINT,x_NewPage
 
     @INTEGERS_CALC  n_PageNo,=,<n_PageNo,+,1>
 
	@FILES $write,B02_PRINT,w_Underlines80
 
	@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
	@WORDS_PAD "[B0200001-GJ]",w_prtLine80
	@WORDS_COPY A01_Parameter,<<w_prtLine80,15>>
	@WORDS_COPY A01_Description,<<w_prtLine80,18>>
	@WORDS_COPY "PAGE",<<w_prtLine80,72>>
	@WORDS_COPY n_PageNo,<<w_prtLine80,77>>
 
	@FILES $write,B02_PRINT,w_prtLine80
 
	@FILES $write,B02_PRINT,w_Underlines80
 
     @WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
	@WORDS_COPY "Date",<<w_prtLine80,04>>
     @WORDS_COPY "Description",<<w_prtLine80,12>>
     @WORDS_COPY "No Of Units",<<w_prtLine80,50>>
     @WORDS_COPY "Value",<<w_prtLine80,70>>
	@FILES $write,B02_PRINT,w_prtLine80
 
     @WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
	@WORDS_COPY "----",<<w_prtLine80,04>>
     @WORDS_COPY "-----------",<<w_prtLine80,12>>
     @WORDS_COPY "-----------",<<w_prtLine80,50>>
     @WORDS_COPY "-----",<<w_prtLine80,70>>
	@FILES $write,B02_PRINT,w_prtLine80
 
	@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
	@FILES $write,B02_PRINT,w_prtLine80
 
     @INTEGERS_CALC  n_LineCtr,=,<7>
 
@END_SUB B0241_Process_Print_Headings
 
;-----------------------------------------------------------------------
;	General Journal Details
;-----------------------------------------------------------------------
@BEGIN_SUB B0242_Process_Print_Details
 
		@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
		@WORDS_COPY B02_TranDate,<<w_prtLine80,01>>
		@WORDS_COPY B02_Description,<<w_prtLine80,12>>
		@IF B02_NoOfUnits,_GT,0
			@WORDS_COPY B02_NoOfUnits,<<w_prtLine80,55>>
		@ELSE
			@WORDS_COPY <<w_Spaces,6>>,<<w_prtLine80,55>>
		@END_IF
		@WORDS_COPY w_B02_Value,<<w_prtLine80,65>>
		@FILES $write,B02_PRINT,w_prtLine80
 
		@IF <<f_AcctExists,B02_DRAcctNo>>
			@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
			@WORDS_COPY "Debit=",<<w_prtLine80,12>>
			@WORDS_COPY B02_DRAcctNo,<<w_prtLine80,18>>
			@WORDS_COPY B01_Description,<<w_prtLine80,24>>
			@FILES $write,B02_PRINT,w_prtLine80
			@INTEGERS_CALC  n_LineCtr,=,<n_LineCtr,+,1>
	@END_IF
 
	@IF <<f_AcctExists,B02_CRAcctNo>>
		@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
		@WORDS_COPY "Credit=",<<w_prtLine80,12>>
		@WORDS_COPY B02_CRAcctNo,<<w_prtLine80,19>>
		@WORDS_COPY B01_Description,<<w_prtLine80,25>>
		@FILES $write,B02_PRINT,w_prtLine80
		@INTEGERS_CALC  n_LineCtr,=,<n_LineCtr,+,1>
	@END_IF
 
	@IF w_PrintDetails,_EQ,"N"
		@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
		@FILES $write,B02_PRINT,w_prtLine80
		@INTEGERS_CALC  n_LineCtr,=,<n_LineCtr,+,1>
		@EXIT_SUB B0242_Process_Print_Details
	@END_IF
	

		@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
		@WORDS_COPY "Reference=",<<w_prtLine80,12>>
		@WORDS_COPY B02_Reference,<<w_prtLine80,22>>
		@FILES $write,B02_PRINT,w_prtLine80
		@INTEGERS_CALC  n_LineCtr,=,<n_LineCtr,+,1>
 
		@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
		@WORDS_COPY "Tran Type=",<<w_prtLine80,12>>
		@WORDS_COPY B02_INVTranType,<<w_prtLine80,22>>
		@WORDS_COPY "Acct=",<<w_prtLine80,26>>
		@WORDS_COPY B02_INVAcctNo,<<w_prtLine80,31>>
		@WORDS_COPY "Parcel=",<<w_prtLine80,37>>
		@WORDS_COPY B02_INVParcelNo,<<w_prtLine80,44>>
		@WORDS_COPY "Grouping=",<<w_prtLine80,48>>
		@WORDS_COPY B02_INVGrouping,<<w_prtLine80,57>>
		@FILES $write,B02_PRINT,w_prtLine80
		@INTEGERS_CALC  n_LineCtr,=,<n_LineCtr,+,1>
 
		@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
		@WORDS_COPY "Franked Amt=",<<w_prtLine80,12>>
		@WORDS_COPY w_B02_FrankedAmt,<<w_prtLine80,24>>
		@WORDS_COPY "ImputedCredit=",<<w_prtLine80,32>>
		@WORDS_COPY w_B02_ImputedCredit,<<w_prtLine80,46>>
		@WORDS_COPY "UnitPrice=",<<w_prtLine80,54>>
		@WORDS_COPY w_B02_SUnitPrice,<<w_prtLine80,64>>
		@FILES $write,B02_PRINT,w_prtLine80
		@INTEGERS_CALC  n_LineCtr,=,<n_LineCtr,+,1>
 
		@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
		@WORDS_COPY "Reference=",<<w_prtLine80,12>>
		@WORDS_COPY B02_SReference,<<w_prtLine80,22>>
		@FILES $write,B02_PRINT,w_prtLine80
		@INTEGERS_CALC  n_LineCtr,=,<n_LineCtr,+,1>
 
		@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
		@FILES $write,B02_PRINT,w_prtLine80
		@INTEGERS_CALC  n_LineCtr,=,<n_LineCtr,+,1>
 
@END_SUB B0242_Process_Print_Details
 
 
;-----------------------------------------------------------------------
;	Account Enquiry
;-----------------------------------------------------------------------
@BEGIN_SUB B03_Process
 
;	---------------------
;	Enquire - build table
;	---------------------
;	The front-end accepts the parameters and an enquiry table is
;	first built here.
 
	@IF x_Request,_EQ,%c_Enquire
		@CALL B031_BuildTable
	@END_IF
 
;	-------------------------------
;	Enquire - read thru built table
;	-------------------------------
;	The front-end then fills a browser  OBJECT!!!  by normal calls
;	here by looping thru the record no
 
	@IF x_Request,_EQ,%c_Read
		@INTEGERS_CALC  B03_Record_NO,=,<x_RecNo>
		@IF B03_Record_NO,_GT,B03_Table_UBOUND
			@INTEGERS_CALC  ERROR_CODE,=,<10>
			@EXIT_SUB B03_Process
		@ELSE
			@TABLES_RGET B03_Table,B03_Record_NO
			@INTEGERS_CALC  ERROR_CODE,=,<B03_Table_STATUS>
			@WORDS_PAD B03_Value,w_B03_Value
			@WORDS_PAD B03_RunningBalance,w_B03_RunningBalance
			@EXIT_SUB B03_Process
		@END_IF
	@END_IF
 
;	-------
;	Print
;	-------
	@IF x_Request,_EQ,%c_Print
		@CALL B032_Process_Print
	@END_IF
	

@END_SUB B03_Process
	

;-----------------------------------------------------------------------
;	Build Table
;-----------------------------------------------------------------------
@BEGIN_SUB B031_BuildTable
 
;	Because this can also run for Consolidated companies, direct table
;	access is required
 
;	----------
;	Initialise
;	----------
	@INTEGERS_CALC  ERROR_CODE,=,<0>
	@INTEGERS_CALC  B03_Table_UBOUND,=,<0>
	@NUMBERS_CALC  n_RunningBalance,=,<0>
   @INTEGERS_CALC  n_NoOfUnits,=,<0>
   @NUMBERS_CALC  n_TotalNoOfUnits,=,<0>
	@WORDS_COPY <<w_Spaces,1,10>>,w_B03_Value
	@WORDS_COPY <<w_Spaces,1,11>>,w_B03_RunningBalance
	@INTEGERS_CALC  b_Start,=,<c_TRUE>
 
;	-----------------------
;	Load Company Array
;	-----------------------
	@CALL X_LoadCompany_Array
 
;	---------------------------
;	Loop thru Transaction Table
;	---------------------------
	@REPEAT_FOR B02_Record_NO,1,B02_Table_UBOUND
 
		@TABLES_RGET B02_Table,B02_Record_NO
 
		@REPEAT_FOR I,n_CpyIdx,%c_NoOfCompanies
			@ARRAYS_IF n_Companies,<<I>>,_EQ,B02_Company
	

				@IF B02_TranDate,_LT,w_StartDate
					@CALL B0311_RunningBalance
				@ELSE
 
					@IF B02_TranDate,_GT,w_EndDate
						@EXIT_SUB B031_BuildTable
					@ELSE
 
						@_IF B02_DRAcctNo,_EQ,x_AcctNo
						@_OR B02_CRAcctNo,_EQ,x_AcctNo
						@_END
 
							@IF b_Start,_EQ,%c_TRUE
								@INTEGERS_CALC  b_Start,=,<c_FALSE>
								@CALL B0312_OpeningBalance
							@END_IF
 
							@INTEGERS_CALC  B03_TranRecNo,=,<B02_Record_NO>
							@WORDS_PAD B02_TranDate,B03_TranDate
							@INTEGERS_CALC  B03_Company,=,<B02_Company>
							@INTEGERS_CALC  B03_DRAcctNo,=,<B02_DRAcctNo>
							@INTEGERS_CALC  B03_CRAcctNo,=,<B02_CRAcctNo>
							@WORDS_PAD B02_Company,B03_Description
							@IF B03_DRAcctNo,_EQ,B01_AcctNo
								@WORDS_PAD B02_CRAcctNo,B03_Description
							@ELSE
								@WORDS_PAD B02_DRAcctNo,B03_Description
							@END_IF
							@WORDS_COPY B02_Description,<<B03_Description,7>>
							@NUMBERS_CALC  B03_Value,=,<B02_Value>
							@INTEGERS_CALC  B03_NoOfUnits,=,<B02_NoOfUnits>
 
							@CALL B0311_RunningBalance
 
							@INTEGERS_CALC  B03_Table_UBOUND,=,<B03_Table_UBOUND,+,1>
							@IF B03_Table_UBOUND,_GT,%%c_B03_MaxRecords
								@DISPLAY_LINE "B03_Table size has been exceeded"
								@TERMINATE 1
							@END_IF
							@TABLES_RPUT B03_Table,B03_Table_UBOUND
 
						@END_IF
					@END_IF
 
				@END_IF
 
			@END_IF
 
		@END_REPEAT
 
	@END_REPEAT
	

@END_SUB B031_BuildTable
 
;-----------------------------------------------------------------------
;	Running Balance
;-----------------------------------------------------------------------
@BEGIN_SUB B0311_RunningBalance
 
	@IF B01_BalanceIndicator,_EQ,'DR'
		@IF B02_DRAcctNo,_EQ,B01_AcctNo
			@NUMBERS_CALC  n_RunningBalance,=,<n_RunningBalance,+,B02_Value>
       @NUMBERS_CALC  n_TotalNoOfUnits,=,<n_TotalNoOfUnits,+,B02_NoOfUnits>
		@END_IF
		@IF B02_CRAcctNo,_EQ,B01_AcctNo
			@NUMBERS_CALC  n_RunningBalance,=,<n_RunningBalance,-,B02_Value>
       @NUMBERS_CALC  n_TotalNoOfUnits,=,<n_TotalNoOfUnits,-,B02_NoOfUnits>
		@END_IF
	@ELSE
		@IF B02_CRAcctNo,_EQ,B01_AcctNo
			@NUMBERS_CALC  n_RunningBalance,=,<n_RunningBalance,+,B02_Value>
       @NUMBERS_CALC  n_TotalNoOfUnits,=,<n_TotalNoOfUnits,+,B02_NoOfUnits>
		@END_IF
		@IF B02_DRAcctNo,_EQ,B01_AcctNo
			@NUMBERS_CALC  n_RunningBalance,=,<n_RunningBalance,-,B02_Value>
       @NUMBERS_CALC  n_TotalNoOfUnits,=,<n_TotalNoOfUnits,-,B02_NoOfUnits>
		@END_IF
	@END_IF
 
	@NUMBERS_CALC  B03_RunningBalance,=,<n_RunningBalance>
  	 @NUMBERS_CALC  B03_RunningUnits,=,<n_TotalNoOfUnits>
	@WORDS_PAD B01_BalanceIndicator,B03_BalanceIndicator
 
@END_SUB B0311_RunningBalance
 
;-----------------------------------------------------------------------
;	Opening Balance
;-----------------------------------------------------------------------
@BEGIN_SUB B0312_OpeningBalance
 
	@IF B02_Description,_EQ,"Opening Balance"
		@EXIT_SUB B0312_OpeningBalance
	@END_IF
 
 	 @INTEGERS_CALC  B03_TranRecNo,=,<0>
	@WORDS_PAD w_StartDate,B03_TranDate
	@INTEGERS_CALC  B03_Company,=,<B02_Company>
	@NUMBERS_CALC  B03_DRAcctNo,=,<<<w_Spaces,1,10>>>
	@NUMBERS_CALC  B03_CRAcctNo,=,<<<w_Spaces,1,10>>>
	@WORDS_PAD "Opening Balance",B03_Description
	@NUMBERS_CALC  B03_Value,=,<0>
	@NUMBERS_CALC  B03_RunningBalance,=,<n_RunningBalance>
 
 
	@INTEGERS_CALC  B03_Table_UBOUND,=,<1>
	@TABLES_RPUT B03_Table,B03_Table_UBOUND
 
@END_SUB B0312_OpeningBalance
 
 
 
;-----------------------------------------------------------------------
;	Account Enquiry Print
;-----------------------------------------------------------------------
@BEGIN_SUB B032_Process_Print
 
;	Because the Transaction Listing can not run Consolidated, we can
;	use the LAZARUS IO routines from here. They will return records
;	for the appropriate company
 
;	The Account Enquiry Print will work in 2 ways.
;	1] When the PRINT TRANSACTIONS option is "N" it will provide a trial balance
;	2] When the PRINT TRANSACTIONS option is "Y" it will provide a normal enquiry
 
;	The trick with this routine is to piggy back on the enquiry in that it will
;	iterately build the B03_Table for each subsequent account and use that to
;	print from. If in Trial Balance mode it will only use the running balance
;	from B03_Table
 
;	--------------------------------
;	Gets the 1st records
;	--------------------------------
	@INTEGERS_CALC  x_Request,=,<%c_Start>
	@INTEGERS_CALC  x_RecNo,=,<1>
	@CALL B01_Process
	@INTEGERS_CALC  x_Request,=,<%c_PreviousNext>
 
	@INTEGERS_CALC  n_LineCtr,=,<99>
	@INTEGERS_CALC  n_PageNo,=,<0>
 
	@NUMBERS_CALC  n_TotalDebits,=,<0>
	@NUMBERS_CALC  n_TotalCredits,=,<0>
 
	@INTEGERS_CALC  ERROR_CODE,=,<0>
	

	@FILES_OPEN B03_PRINT,$write+$beginning
 
;	----------------------
;	Loop thru all accounts
;	----------------------
	@REPEAT_WHILE ERROR_CODE,_EQ,0
 
		@IF B01_AcctNo,_GT,n_EndAcctNo
			@EXIT_REPEAT
		@ELSE
			@IF B01_AcctNo,_NLT,n_StartAcctNo
 
				@INTEGERS_CALC  x_Accts,=,<c_FALSE>
				@CALL f_ValueAcct
 
				@IF RETURN_CODE,_EQ,%c_TRUE
					@INTEGERS_CALC  x_AcctNo,=,<B01_AcctNo>
					@CALL B031_BuildTable
					@CALL B0321_Process_Print_Details
				@END_IF
			@END_IF
		@END_IF
 
		@CALL B01_Process
 
	@END_REPEAT
 
;	-----------------------
;	Totals if Trial Balance
;	-----------------------
	@IF w_PrintTrans,_EQ,"N"
	    @WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
	    @WORDS_COPY "==========",<<w_prtLine80,45>>
	    @WORDS_COPY "==========",<<w_prtLine80,56>>
	    @FILES $write,B03_PRINT,w_prtLine80
	    @WORDS_COPY n_TotalDebits,<<w_prtLine80,45>>
	    @WORDS_COPY n_TotalCredits,<<w_prtLine80,56>>
	    @FILES $write,B03_PRINT,w_prtLine80
	@END_IF
 
	@FILES_CLOSE B03_PRINT
	

@END_SUB B032_Process_Print
 
;-----------------------------------------------------------------------
;	Account Enquiry Print Details
;	This routine will be used for each account as they
;	are presented in B03_Table  which built for each account
;-----------------------------------------------------------------------
@BEGIN_SUB B0321_Process_Print_Details
 
	@IF w_PrintNewPage,_EQ,"Y"
		@INTEGERS_CALC  n_LineCtr,=,<99>
	@END_IF
	@CALL B03211_Process_Print_Headings
 
;	-------------------------------------------
;	Exit on No Transactions
;	else Get the Last Entry  for Trial Balance
;	-------------------------------------------
	@IF B03_Table_UBOUND,_EQ,0
		@EXIT_SUB B0321_Process_Print_Details
	@ELSE
		@TABLES_RGET B03_Table,B03_Table_UBOUND
	@END_IF
 
;	-----------------------------------
;	If you don't want to print accounts
;	with zero Balance then exit
;	-----------------------------------
	@_IF w_PrintZero,_EQ,"N"
	@_AND B03_RunningBalance,_EQ,0
	@_END
		@EXIT_SUB B0321_Process_Print_Details
	@END_IF
 
;	------------------------
;	Print the Account Header
;	------------------------
	@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
	@WORDS_COPY x_AcctNo,<<w_prtLine80,07>>
	@WORDS_COPY B01_Description,<<w_prtLine80,14>>
 
	@IF w_PrintTrans,_EQ,"Y"
		@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
		@FILES $write,B03_PRINT,w_prtLine80
		@WORDS_COPY x_AcctNo,<<w_prtLine80,05>>
		@WORDS_COPY B01_Description,<<w_prtLine80,14>>
		@FILES $write,B03_PRINT,w_prtLine80
		@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
		@FILES $write,B03_PRINT,w_prtLine80
			@INTEGERS_CALC  n_LineCtr,=,<n_LineCtr,+,3>
	@END_IF
 
;	-------------
;	TRIAL BALANCE
;	-------------
	@IF w_PrintTrans,_EQ,"N"
 
		@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
		@WORDS_COPY x_AcctNo,<<w_prtLine80,07>>
		@WORDS_COPY B01_Description,<<w_prtLine80,14>>
 
		@NUMBERS_CALC  n_RunningBalance,=,<B03_RunningBalance>
 
		@IF n_RunningBalance,_LT,0
		@NUMBERS_CALC  n_RunningBalance,=,<n_RunningBalance,*,-1>
			@IF B03_BalanceIndicator,_EQ,"DR"
				@WORDS_COPY n_RunningBalance,<<w_prtLine80,56>>
				@NUMBERS_CALC  n_TotalCredits,=,<n_TotalCredits,+,n_RunningBalance>
			@ELSE
				@WORDS_COPY n_RunningBalance,<<w_prtLine80,45>>
				@NUMBERS_CALC  n_TotalDebits,=,<n_TotalDebits,+,n_RunningBalance>
			@END_IF
		@ELSE
			@IF B03_BalanceIndicator,_EQ,"DR"
				@WORDS_COPY n_RunningBalance,<<w_prtLine80,45>>
				@NUMBERS_CALC  n_TotalDebits,=,<n_TotalDebits,+,n_RunningBalance>
			@ELSE
				@WORDS_COPY n_RunningBalance,<<w_prtLine80,56>>
				@NUMBERS_CALC  n_TotalCredits,=,<n_TotalCredits,+,n_RunningBalance>
			@END_IF
		@END_IF
 
		@FILES $write,B03_PRINT,w_prtLine80
		@INTEGERS_CALC  n_LineCtr,=,<n_LineCtr,+1>
		@EXIT_SUB B0321_Process_Print_Details
 
	@END_IF
 
;	---------------
;	ACCOUNT LISTING
;	--------------
	@REPEAT_FOR B03_Record_NO,1,B03_Table_UBOUND
 
		@TABLES_RGET B03_Table,B03_Record_NO
 
		@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
 
		@IF w_PrintTrans,_EQ,"Y"
			@WORDS_COPY B03_TranDate,<<w_prtLine80,02>>
			@WORDS_COPY B03_Description,<<w_prtLine80,14>>
 
			@IF B03_Value,_GT,0
				@IF B03_DRAcctNo,_EQ,x_AcctNo
					@WORDS_COPY B03_Value,<<w_prtLine80,45>>
					@NUMBERS_CALC  n_TotalDebits,=,<n_TotalDebits,+,B03_Value>
				@ELSE
					@WORDS_COPY B03_Value,<<w_prtLine80,56>>
					@NUMBERS_CALC  n_TotalCredits,=,<n_TotalCredits,+,B03_Value>
				@END_IF
			@END_IF
 
			@IF B03_RunningBalance,_LT,0
				@NUMBERS_CALC  B03_RunningBalance,=,<B03_RunningBalance,*,-1>
				@WORDS_COPY " ",<<w_prtLine80,67>>
				@WORDS_COPY " ",<<w_prtLine80,79>>
			@END_IF
 
			@NUMBERS_CALC  n_RunningBalance,=,<B03_RunningBalance>
			@WORDS_COPY n_RunningBalance,<<w_prtLine80,69>>
			@FILES $write,B03_PRINT,w_prtLine80
			@INTEGERS_CALC  n_LineCtr,=,<n_LineCtr,+1>
 
		@END_IF
 
	@END_REPEAT
 
;	--------------
;	Account Totals
;	--------------
	@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
	@WORDS_COPY "==========",<<w_prtLine80,45>>
	@WORDS_COPY "==========",<<w_prtLine80,56>>
	@FILES $write,B03_PRINT,w_prtLine80
	@WORDS_COPY n_TotalDebits,<<w_prtLine80,45>>
	@WORDS_COPY n_TotalCredits,<<w_prtLine80,56>>
	@FILES $write,B03_PRINT,w_prtLine80
	@INTEGERS_CALC  n_LineCtr,=,<n_LineCtr,+,2>
 
@END_SUB B0321_Process_Print_Details
 
;-----------------------------------------------------------------------
;	Account Enquiry Print Headings
;-----------------------------------------------------------------------
@BEGIN_SUB B03211_Process_Print_Headings
 
	@IF n_LineCtr,_LT,55
		@EXIT_SUB B03211_Process_Print_Headings
	@END_IF
	@FILES $write,B03_PRINT,x_NewPage
 
	@INTEGERS_CALC  n_PageNo,=,<n_PageNo,+,1>
 
	@FILES $write,B03_PRINT,w_Underlines80
 
	@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
	@WORDS_PAD "[B0300001-?????]",w_prtLine80
	@IF w_PrintTrans,_EQ,"Y"
		@WORDS_COPY "TRANS",<<w_prtLine80,11>>
	@ELSE
		@WORDS_COPY "TRIAL",<<w_prtLine80,11>>
	@END_IF
	@WORDS_COPY A01_Parameter,<<w_prtLine80,18>>
	@WORDS_COPY A01_Description,<<w_prtLine80,21>>
	@WORDS_COPY "PAGE",<<w_prtLine80,72>>
	@WORDS_COPY n_PageNo,<<w_prtLine80,77>>
 
	@FILES $write,B03_PRINT,w_prtLine80
 
	@FILES $write,B03_PRINT,w_Underlines80
 
	@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
	@WORDS_COPY "Description",<<w_prtLine80,14>>
	@WORDS_COPY "Debit",<<w_prtLine80,50>>
	@WORDS_COPY "Credit",<<w_prtLine80,60>>
	@IF w_PrintTrans,_EQ,"Y"
		@WORDS_COPY "Date",<<w_prtLine80,05>>
		@WORDS_COPY "Balance",<<w_prtLine80,72>>
	@END_IF
	@FILES $write,B03_PRINT,w_prtLine80
 
	@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
	@WORDS_COPY "===========",<<w_prtLine80,14>>
	@WORDS_COPY "=====",<<w_prtLine80,50>>
	@WORDS_COPY "======",<<w_prtLine80,60>>
	@IF w_PrintTrans,_EQ,"Y"
		@WORDS_COPY "====",<<w_prtLine80,05>>
		@WORDS_COPY "=======",<<w_prtLine80,72>>
	@END_IF
	@FILES $write,B03_PRINT,w_prtLine80
 
	@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
	@FILES $write,B03_PRINT,w_prtLine80
 
	@INTEGERS_CALC  n_LineCtr,=,<7>
 
@END_SUB B03211_Process_Print_Headings
 
 
;-----------------------------------------------------------------------
;	Profit/Loss, Trading Statement & Balance Sheet
;-----------------------------------------------------------------------
@BEGIN_SUB B04_Process
 
;	Because the Financial Reports can be run for multi-companies the
;	the tables are accessed directly. More so because a mult-company
;	report is in Account/Company order, an Alternate key is built and
;	used to acces the Chart of Account
 
;	---------------------------
; Start & End Account Numbers
;	---------------------------
	@INTEGERS_CALC  n_ReportNo,=,<x_RecNo>
	@IF n_ReportNo,_IN,<<1,2>>
		@INTEGERS_CALC  n_StartAcctNo,=,<40000>
		@INTEGERS_CALC  n_EndAcctNo,=,<59999>
		@IF n_ReportNo,_EQ,1
				@WORDS_COPY ".P&L",<<B04_PRINT,11,4>>
				@WORDS_PAD "[B0400001-P/L]",w_ReportName
		@ELSE
				@WORDS_COPY ".TRD",<<B04_PRINT,11,4>>
				@WORDS_PAD "[B0400001-TRD]",w_ReportName
		@END_IF
	@ELSE
		@INTEGERS_CALC  n_StartAcctNo,=,<10000>
		@INTEGERS_CALC  n_EndAcctNo,=,<39999>
		@WORDS_COPY ".BAL",<<B04_PRINT,11,4>>
		@WORDS_PAD "[B0400001-BAL]",w_ReportName
	@END_IF
 
;	--------------------
;	Accounts OKay ?
;	--------------------
	@IF B041_f_ValidRequest
		@CALL X_LoadCompany_Array
		@CALL X_AltIndex
	@ELSE
		@INTEGERS_CALC  RETURN_CODE,=,<ERROR_CODE>
		@EXIT_SUB B04_Process
	@END_IF
 
@ARRAYS_Put  n_Totals,<<1>>,0
@ARRAYS_Put  n_Totals,<<2>>,0
@ARRAYS_Put  n_Totals,<<3>>,0
@ARRAYS_Put  n_Totals,<<4>>,0
	@INTEGERS_CALC  n_PreviousAcctNo,=,<0>
	@NUMBERS_CALC  n_CntlAcctBalance,=,<0>
 
	@INTEGERS_CALC  n_LineCtr,=,<99>
	@INTEGERS_CALC  n_PageNo,=,<0>
 
 	 @IF x_AcctNo,_EQ,0 ; Sub or Control Accounts passed in
  	 @WORDS_PAD "S",w_Sub
   @ELSE
  	 @WORDS_PAD "C",w_Sub
   @END_IF
 
	@FILES_OPEN B04_PRINT,$write+$beginning
 
;	----------------------------------------
;	Loop thru the Alt Index - AcctNo/Company
;	----------------------------------------
	@REPEAT_FOR n_Idx,1,B01_AltIdx_Table_UBOUND
 
		@TABLES_RGET B01_AltIdx_Table,n_Idx
		@TABLES_RGET B01_Table,B01_AltIdx_RecNo
 
		@_IF n_PreviousAcctNo,_GT,0
		@_AND B01_AcctNo,_GT,n_PreviousAcctNo
		@_END
			@CALL B042_DetailLine
		@END_IF
 
		@INTEGERS_CALC  n_PreviousAcctNo,=,<B01_AcctNo>
		@WORDS_PAD B01_Description,w_PreviousDescription
		@INTEGERS_CALC  n_PreviousCntlAcctNo,=,<B01_CntlAcctNo>
		@WORDS_PAD B01_Flag1,w_PreviousFlag1
		@INTEGERS_CALC  n_PreviousFlag2,=,<B01_Flag2>
		@INTEGERS_CALC  n_PreviousFlag3,=,<B01_Flag3>
		@INTEGERS_CALC  n_PreviousFlag4,=,<B01_Flag4>
		@WORDS_PAD B01_BalanceIndicator,w_PreviousIndicator
 
	@END_REPEAT
 
;	--------
;	Last One
;	--------
	@CALL B042_DetailLine
	@INTEGERS_CALC  ERROR_CODE,=,<0>
 
	@FILES_CLOSE B04_PRINT
 
@END_SUB B04_Process
 
 
;-----------------------------------------------------------------------
;	Validation
;-----------------------------------------------------------------------
@BEGIN_FUNCTION B041_f_ValidRequest
 
;	-----------------------------
;   Not Required for Consolidated
;	-----------------------------
	@IF A01_ParameterNo,_EQ,3
		@INTEGERS_CALC  RETURN_CODE,=,<c_TRUE>
		@EXIT_FUNCTION B041_f_ValidRequest
	@END_IF
 
;	---------------------------
;		PreRequisites
;		Gets PA,PL,AS,TO,TC
;	---------------------------
	@CALL X_GetSpecialAccts
 
;	----------------------------------
;   Get PA Account if not Consolidated
;	----------------------------------
	@IF n_ReportNo,_IN,<<1,2>> ; If Profit/Loss or Trading Statement
		@IF 0,_IN,<<n_PAAcctNo,n_PLAcctNo>>
			@INTEGERS_CALC  ERROR_CODE,=,<1>
			@EXIT_FUNCTION B041_f_ValidRequest
		@END_IF
	@END_IF
 
;	---------------------------
;   Maintain Stock Transactions
;	---------------------------
	@IF n_ReportNo,_EQ,2 ; If Trading Statement
		@IF 0,_IN,<<n_ASAcctNo,n_TOAcctNo,n_TCAcctNo>> ; we need the Trading Accounts
			@INTEGERS_CALC  ERROR_CODE,=,<2>
			@EXIT_FUNCTION B041_f_ValidRequest
		@END_IF
		@CALL B0411_StockTransactions
	@END_IF
 
	@INTEGERS_CALC  RETURN_CODE,=,<c_TRUE>
 
@END_FUNCTION B041_f_ValidRequest
 
;-----------------------------------------------------------------------
;   Maintain Stock Transactions
;-----------------------------------------------------------------------
@BEGIN_SUB B0411_StockTransactions
 
;	This is only done when running for a single company so we can use
;	the internal routines to only work with that company
 
;	It 1st deletes the existing 2 stock transfer records and creates
;	a new record to transfer Stock On Hand  "AS"  to Opening Stock  "TO"
;	and then to transfer Closing Stock  "TC"  to Stock On Hand
 
;	--------------------------------
;	Gets the 1st records
;	--------------------------------
	@INTEGERS_CALC  x_Request,=,<%c_Start>
	@INTEGERS_CALC  x_RecNo,=,<1>
	@CALL B02_Process
	@INTEGERS_CALC  x_Request,=,<%c_PreviousNext>
 
;   Process
	@NUMBERS_CALC  n_AcctBalance,=,<0>
 
	@REPEAT_WHILE ERROR_CODE,_NEQ,10
 
	;	---------------------
	;	Delete TO Transaction
	;	---------------------
		@IF B02_DRAcctNo,_EQ,n_TOAcctNo
			@INTEGERS_CALC  x_Request,=,<%c_Delete>
			@INTEGERS_CALC  x_RecNo,=,<B02_Record_NO>
			@CALL B02_Process
 
			@INTEGERS_CALC  x_Request,=,<%c_Read>
			@INTEGERS_CALC  x_RecNo,=,<B02_Record_NO>
			@CALL B02_Process
		@END_IF
 
	;	---------------------
	;	Delete TC Transaction
	;	---------------------
		@IF B02_CRAcctNo,_EQ,n_TCAcctNo
			@INTEGERS_CALC  x_Request,=,<%c_Delete>
			@INTEGERS_CALC  x_RecNo,=,<B02_Record_NO>
			@CALL B02_Process
 
			@INTEGERS_CALC  x_Request,=,<%c_Read> ; Grab the new record
			@INTEGERS_CALC  x_RecNo,=,<B02_Record_NO>
			@CALL B02_Process
 
		@END_IF
 
	;	---------------------
	;	Get Balance
	;	TO and TC transaction posted to this account will
	;	now have been removed by virtue of the above steps
	;	---------------------
 		 @IF B02_DRAcctNo,_EQ,n_ASAcctNo
   		 @NUMBERS_CALC  n_AcctBalance,=,<n_AcctBalance,+,B02_Value>
  	 @END_IF
 
  	 @IF B02_CRAcctNo,_EQ,n_ASAcctNo
   		 @NUMBERS_CALC  n_AcctBalance,=,<n_AcctBalance,-,B02_Value>
  	 @END_IF
 
 		 @INTEGERS_CALC  x_Request,=,<%c_PreviousNext>
		@CALL B02_Process
 
	@END_REPEAT
 
;	-----------------------------------------------------------------------
; Assuming that the Stock account will never have a credit balance
; AS to TO
;	-----------------------------------------------------------------------
	@INTEGERS_CALC  B02_Company,=,<A01_Parameter>
	@WORDS_PAD w_Date,B02_TranDate
	@WORDS_PAD "23:59:01",B02_TranTime
	@INTEGERS_CALC  B02_DRAcctNo,=,<n_TOAcctNo>
	@INTEGERS_CALC  B02_CRAcctNo,=,<n_ASAcctNo>
	@WORDS_PAD "Stock on Hand to Opening Stock",B02_Description
	@NUMBERS_CALC  B02_Value,=,<n_AcctBalance>
		@WORDS_PAD B02_Value,w_B02_Value
	@INTEGERS_CALC  B02_DRCntlAcctNo,=,<0>
	@INTEGERS_CALC  B02_CRCntlAcctNo,=,<0>
	@INTEGERS_CALC  B02_NoOfUnits,=,<0>
	@WORDS_PAD "System",B02_Reference
	@INTEGERS_CALC  B02_INVTranType,=,<0>
	@INTEGERS_CALC  B02_INVAcctNo,=,<0>
	@INTEGERS_CALC  B02_INVParcelNo,=,<0>
	@INTEGERS_CALC  B02_INVGrouping,=,<0>
 
		@WORDS_PAD "0",w_B02_FrankedAmt
		@WORDS_PAD "0",w_B02_ImputedCredit
		@WORDS_PAD "0",w_B02_SUnitPrice
	

	@WORDS_PAD " ",B02_SReference
	

	@INTEGERS_CALC  x_Request,=,<%c_Write>
	@INTEGERS_CALC  x_RecNo,=,<0>
	@CALL B02_Process
 
;	--------
; TC to AS
;	--------
	@INTEGERS_CALC  B02_Company,=,<A01_Parameter>
	@WORDS_PAD w_Date,B02_TranDate
	@WORDS_PAD "23:59:02",B02_TranTime
	@INTEGERS_CALC  B02_DRAcctNo,=,<n_ASAcctNo>
	@INTEGERS_CALC  B02_CRAcctNo,=,<n_TCAcctNo>
	@WORDS_PAD "Closing Stock to Stock on Hand",B02_Description
	@NUMBERS_CALC  B02_Value,=,<w_Closing>
		@WORDS_PAD B02_Value,w_B02_Value
	@INTEGERS_CALC  B02_DRCntlAcctNo,=,<0>
	@INTEGERS_CALC  B02_CRCntlAcctNo,=,<0>
	@INTEGERS_CALC  B02_NoOfUnits,=,<0>
	@WORDS_PAD "System",B02_Reference
	@INTEGERS_CALC  B02_INVTranType,=,<0>
	@INTEGERS_CALC  B02_INVAcctNo,=,<0>
	@INTEGERS_CALC  B02_INVParcelNo,=,<0>
	@INTEGERS_CALC  B02_INVGrouping,=,<0>
 
		@WORDS_PAD "0",w_B02_FrankedAmt
		@WORDS_PAD "0",w_B02_ImputedCredit
		@WORDS_PAD "0",w_B02_SUnitPrice
 
	@WORDS_PAD " ",B02_SReference
	

	@INTEGERS_CALC  x_Request,=,<%c_Write>
	@INTEGERS_CALC  x_RecNo,=,<0>
	@CALL B02_Process
 
@END_SUB B0411_StockTransactions
 
;-----------------------------------------------------------------------
;   Print the Detail Line
;-----------------------------------------------------------------------
@BEGIN_SUB B042_DetailLine
 
	@CALL B0421_Headings
	@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
 
;	-------
;	Clear
;	-------
	@IF w_PreviousFlag1,_EQ,"C "
@ARRAYS_Put  n_Totals,<<n_PreviousFlag4>>,0
		@EXIT_SUB B042_DetailLine
	@END_IF
 
;	------
;	Text
;	------
	@IF w_PreviousFlag1,_EQ,"X "
		m001 ;		@INTEGERS_CALC  I,=,i0001,-,1
		@WORDS_COPY w_PreviousDescription,<<w_prtLine80,I>>
		@FILES $write,B04_PRINT,w_prtLine80
		@INTEGERS_CALC  n_LineCtr,=,<n_LineCtr,+,1>
		@EXIT_SUB B042_DetailLine
	@END_IF
 
;	--------
;	Totals
;	--------
	@IF w_PreviousFlag1,_IN,<<"T ","BA">>
		@CALL B0422_Totals
		@EXIT_SUB B042_DetailLine
	@END_IF
 
;	-------------
;	Profit/Loss
;	-------------
	@IF w_PreviousFlag1,_EQ,"PL"
		@CALL B0422_Totals
		@CALL B0423_ProfitLoss
		@EXIT_SUB B042_DetailLine
	@END_IF
 
;	-----------
;	Get Balance
;	-----------
	@IF w_PreviousFlag1,_IN,<<"CA","PA","PL","A ","AB","AS","DA","TO","TC">>
 
		@CALL B0424_GetBalance
 
		;--------------------------
		;Control Account Processing
		;--------------------------
		@IF w_Sub,_EQ,"C"
			@IF n_PreviousCntlAcctNo,_EQ,99999
				@NUMBERS_CALC  n_AcctBalance,=,<n_CntlAcctBalance>
				@NUMBERS_CALC  n_CntlAcctBalance,=,<0>
			@ELSE
				@IF n_PreviousCntlAcctNo,_GT,0
					@NUMBERS_CALC  n_CntlAcctBalance,=,<n_CntlAcctBalance,+,n_AcctBalance>
					@EXIT_SUB B042_DetailLine
				@END_IF
			@END_IF
		@END_IF
 
		;-----
		;Print
		;-----
		@IF n_AcctBalance,_NEQ,0
 
			;-----------
			;Description
			;-----------
			m002 ;			@INTEGERS_CALC  I,=,i0001,-,1
			@WORDS_COPY w_PreviousDescription,<<w_prtLine80,I>>
 
			;-----------
			;Balance
			;-----------
			@NUMBERS_CALC  n_Value,=,<n_AcctBalance>
@ARRAYS_Add  n_Totals,<<n_PreviousFlag3>>,n_Value
 
			m003 ;			@INTEGERS_CALC  n_ValueLocation,=,i0002,+,30
 
			@IF w_PreviousIndicator,_EQ,"DR"
				@IF n_Value,_LT,0
					@INTEGERS_CALC  I,=,<n_ValueLocation,-,1>
					@WORDS_COPY x_OpenBracket,<<w_prtLine80,I>>
					@INTEGERS_CALC  I,=,<n_ValueLocation,+,9>
					@WORDS_COPY x_CloseBracket,<<w_prtLine80,I>>
				@END_IF
			@END_IF
 
			@IF w_PreviousIndicator,_EQ,"CR"
				@IF n_Value,_GT,0
					@INTEGERS_CALC  I,=,<n_ValueLocation,-,1>
					@WORDS_COPY x_OpenBracket,<<w_prtLine80,I>>
					@INTEGERS_CALC  I,=,<n_ValueLocation,+,9>
					@WORDS_COPY x_CloseBracket,<<w_prtLine80,I>>
				@END_IF
			@END_IF
 
			@IF n_Value,_LT,0
				@INTEGERS_CALC  n_Value,=,<n_Value,*,-1>
			@END_IF
 
			@WORDS_COPY n_Value,<<w_prtLine80,n_ValueLocation>>
 
			@FILES $write,B04_PRINT,w_prtLine80
			@NUMBERS_CALC  n_AcctBalance,=,<0>
 
		@END_IF
 
	@END_IF
 
@END_SUB B042_DetailLine
 
;-----------------------------------------------------------------------
;   Print the Headings
;-----------------------------------------------------------------------
@BEGIN_SUB B0421_Headings
 
	@IF n_LineCtr,_LT,55
		@EXIT_SUB B0421_Headings
	@END_IF
 
	@INTEGERS_CALC  n_PageNo,=,<n_PageNo,+,1>
 
	@FILES $write,B04_PRINT,w_Underlines80
 
	@WORDS_PAD w_ReportName,w_prtLine80
	@WORDS_COPY A01_Parameter,<<w_prtLine80,16>>
	@WORDS_COPY A01_Description,<<w_prtLine80,19>>
	@WORDS_COPY "PAGE",<<w_prtLine80,72>>
	@WORDS_COPY n_PageNo,<<w_prtLine80,77>>
	@FILES $write,B04_PRINT,w_prtLine80
 
	@FILES $write,B04_PRINT,w_Underlines80
 
	@INTEGERS_CALC  n_LineCtr,=,<3>
  

@END_SUB B0421_Headings
 
 
;-----------------------------------------------------------------------
;   Totals processing
;-----------------------------------------------------------------------
@BEGIN_SUB B0422_Totals
 
@ARRAYS_GET n_Totals,<<n_PreviousFlag4>>,n_Value
	m004 ;	@INTEGERS_CALC  n_ValueLocation,=,i0002,+,30
 
	m005 ;	@INTEGERS_CALC  I,=,i0001,+,31,-,1
	@WORDS_COPY "---------",<<w_prtLine80,I>>
	@FILES $write,B04_PRINT,w_prtLine80
	@INTEGERS_CALC  n_LineCtr,=,<n_LineCtr,+,1>
	@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
 
	m006 ;	@INTEGERS_CALC  J,=,i0001,-,1
	@WORDS_COPY w_PreviousDescription,<<w_prtLine80,J>>
 
 
	@IF n_PreviousFlag4,_LT,4
		@INTEGERS_CALC  I,=,<n_PreviousFlag4,+,1>
@ARRAYS_Add  n_Totals,<<I>>,n_Totals,<<n_PreviousFlag4>>
	@END_IF
 
	@IF w_PreviousIndicator,_EQ,"DR"
		@IF n_Value,_LT,0
			@INTEGERS_CALC  I,=,<n_ValueLocation,-,1>
			@WORDS_COPY x_OpenBracket,<<w_prtLine80,I>>
			@INTEGERS_CALC  I,=,<n_ValueLocation,+,9>
			@WORDS_COPY x_CloseBracket,<<w_prtLine80,I>>
		@END_IF
	@END_IF
 
	@IF w_PreviousIndicator,_EQ,"CR"
		@IF n_Value,_GT,0
			@INTEGERS_CALC  I,=,<n_ValueLocation,-,1>
			@WORDS_COPY x_OpenBracket,<<w_prtLine80,I>>
			@INTEGERS_CALC  I,=,<n_ValueLocation,+,9>
			@WORDS_COPY x_CloseBracket,<<w_prtLine80,I>>
		@END_IF
	@END_IF
 
	@IF n_Value,_LT,0
		@INTEGERS_CALC  n_Value,=,<n_Value,*,-1>
	@END_IF
 
	@WORDS_COPY n_Value,<<w_prtLine80,n_ValueLocation>>
 
	@FILES $write,B04_PRINT,w_prtLine80
 	 @INTEGERS_CALC  n_LineCtr,=,<n_LineCtr,+,1>
 
@END_SUB B0422_Totals
 
;-----------------------------------------------------------------------
;   Profit/Loss processing
;-----------------------------------------------------------------------
@BEGIN_SUB B0423_ProfitLoss
 
;	This is only done when running for a single company so we can use
;	the internal routines to only work with that company
 
;	It 1st deletes the existing Profit/Loss transfer and writes a new one
;	transfering Profit/Loss  "PL"  to Accumulated Profit/Loss  "PA"
 
;	------------------------
;	Only if NOT Consolidated
;	------------------------
	@IF A01_Company02,_NEQ,0
		@EXIT_SUB B0423_ProfitLoss
	@END_IF
 
;	------------------------
;   Delete current record
;	------------------------
	@INTEGERS_CALC  x_Request,=,<%c_Start>
	@INTEGERS_CALC  x_RecNo,=,<1>
	@CALL B02_Process
	@INTEGERS_CALC  x_Request,=,<%c_PreviousNext>
 
	@REPEAT_FOR I,1,B02_Table_UBOUND
		@_IF B02_DRAcctNo,_EQ,n_PLAcctNo
		@_OR B02_CRAcctNo,_EQ,n_PLAcctNo
		@_END
			@INTEGERS_CALC  x_Request,=,<%c_Delete>
			@INTEGERS_CALC  x_RecNo,=,<B02_Record_NO>
			@CALL B02_Process
			@EXIT_REPEAT
		@ELSE
			@CALL B02_Process
		@END_IF
 
	@END_REPEAT
 
    @INTEGERS_CALC  B02_Company,=,<A01_Parameter>
    @WORDS_PAD w_Date,B02_TranDate
 
    @WORDS_PAD "23:59:03",B02_TranTime
    @ARRAYS_IF n_Totals,<<n_PreviousFlag4>>,_GT,0
       @INTEGERS_CALC  B02_DRAcctNo,=,<n_PAAcctNo>
       @INTEGERS_CALC  B02_CRAcctNo,=,<n_PLAcctNo>
       @WORDS_PAD "Loss",B02_Description
       @INTEGERS_CALC  I,=,<n_PreviousFlag4>
@ARRAYS_GET n_Totals,<<I>>,J
       @NUMBERS_CALC  B02_Value,=,<J> ; no control block
      	 @WORDS_PAD B02_Value,w_B02_Value
    @ELSE
       @INTEGERS_CALC  B02_DRAcctNo,=,<n_PLAcctNo>
       @INTEGERS_CALC  B02_CRAcctNo,=,<n_PAAcctNo>
       @WORDS_PAD "Profit",B02_Description
       @INTEGERS_CALC  I,=,<n_PreviousFlag4>
@ARRAYS_GET n_Totals,<<I>>,J
       @NUMBERS_CALC  B02_Value,=,<J,*,-1> ; no control block
      	 @WORDS_PAD B02_Value,w_B02_Value
    @END_IF
    @INTEGERS_CALC  B02_DRCntlAcctNo,=,<0>
    @INTEGERS_CALC  B02_CRCntlAcctNo,=,<0>
    @INTEGERS_CALC  B02_NoOfUnits,=,<0>
		@WORDS_PAD "System",B02_Reference
    @INTEGERS_CALC  B02_INVTranType,=,<0>
    @INTEGERS_CALC  B02_INVAcctNo,=,<0>
    @INTEGERS_CALC  B02_INVParcelNo,=,<0>
    @INTEGERS_CALC  B02_INVGrouping,=,<0>
 
    @WORDS_PAD "0",w_B02_FrankedAmt
    @WORDS_PAD "0",w_B02_ImputedCredit
    @WORDS_PAD "0",w_B02_SUnitPrice
 
    @WORDS_PAD 0,B02_SReference
 
    @INTEGERS_CALC  x_Request,=,<%c_Write>
    @INTEGERS_CALC  x_RecNo,=,<0>
    @CALL B02_Process
 
;	-------------------------------------------------------------
;	Because B02_Process has validated the B02_Record by referring
;	to B01 we need to re-read B01 to get the current record
;	-------------------------------------------------------------
   	 @TABLES_RGET B01_Table,B01_AltIdx_RecNo
 
@END_SUB B0423_ProfitLoss
 
;-----------------------------------------------------------------------
;   Get the Account Balance
;-----------------------------------------------------------------------
@BEGIN_SUB B0424_GetBalance
;
;	Reading thru the whole file here because we could be consolidated
 
	@NUMBERS_CALC  n_AcctBalance,=,<0>
	@INTEGERS_CALC  n_NoOfUnits,=,<0>
 
	@REPEAT_FOR B02_Record_NO,1,B02_Table_UBOUND
 
		@TABLES_RGET B02_Table,B02_Record_NO
 
		@REPEAT_FOR J,n_CpyIdx,%c_NoOfCompanies
			@ARRAYS_IF n_Companies,<<J>>,_EQ,B02_Company
 
				@_IF n_PreviousAcctNo,_NLT,n_StartAcctNo
				@_AND n_PreviousAcctNo,_NGT,n_EndAcctNo
				@_END
 
					@_IF B02_DRAcctNo,_EQ,n_PreviousAcctNo
					@_AND B02_TranDate,_NGT,w_Date
					@_END
						@NUMBERS_CALC  n_AcctBalance,=,<n_AcctBalance,+,B02_Value>
						@INTEGERS_CALC  n_NoOfUnits,=,<n_NoOfUnits,+,B02_NoOfUnits>
					@END_IF
 
					@_IF B02_CRAcctNo,_EQ,n_PreviousAcctNo
					@_AND B02_TranDate,_NGT,w_Date
					@_END
						@NUMBERS_CALC  n_AcctBalance,=,<n_AcctBalance,-,B02_Value>
						@INTEGERS_CALC  n_NoOfUnits,=,<n_NoOfUnits,-,B02_NoOfUnits>
					@END_IF
 
				@END_IF
			@END_IF
 
		@END_REPEAT
 
	@END_REPEAT
 
@END_SUB B0424_GetBalance
 
;-----------------------------------------------------------------------
;	End Of Year processing
;-----------------------------------------------------------------------
@BEGIN_SUB B07_Process
 
;	---------------------------
;	Check for a Capital Account
;	---------------------------
	@CALL X_GetSpecialAccts
	@IF n_CAAcctNo,_EQ,0
		@INTEGERS_CALC  ERROR_CODE,=,<1>
		@EXIT_SUB B07_Process
	@ELSE
		@INTEGERS_CALC  n_CompanyNo,=,<A01_Parameter>
	@END_IF
 
;	---------------------------
;	Setup Next Year Files
;	---------------------------
	@INTEGERS_CALC  n_nextYear,=,<n_finYear,+,1>
	@WORDS_PAD n_nextYear,w_nextYear
	@WORDS_COPY w_nextYear,<<A01_EOY,7,4>>
	@WORDS_COPY w_nextYear,<<B01_EOY,7,4>>
	@WORDS_COPY w_nextYear,<<B02_EOY,7,4>>
 
;	--------------------------------
;	Setup to build transaction table
;	--------------------------------
	@WORDS_PAD "0001/01/01",w_StartDate
	@WORDS_PAD "9999/06/30",w_EndDate
	@WORDS_PAD n_finYear,w_finYear
	@WORDS_COPY w_finYear,<<w_EndDate,1>>
 
;	------------------------------------
;	make sure it hasn't already been run
;	------------------------------------
	@FILES_OPEN B02_EOY,$read
	@FILES $read,B02_EOY,B201,B202,B203,B204,B205,B206,B207,B208,B209,B210,B211,B212,B213,B214,B215,B216,B217,B218,B219
 
	@REPEAT_WHILE B02_EOY_STATUS,_NEQ,EOF
 
		@IF B02_Company,_EQ,n_CompanyNo
			@INTEGERS_CALC  ERROR_CODE,=,<2>
			@EXIT_SUB B07_Process
		@END_IF
 
		@FILES $read,B02_EOY,B201,B202,B203,B204,B205,B206,B207,B208,B209,B210,B211,B212,B213,B214,B215,B216,B217,B218,B219
 
	@END_REPEAT
 
;	---------------
;	Write A01_Table -> ;	Always write the Parameter file
;	---------------
	@INTEGERS_CALC  I,=,<A01_Record_NO>
 
	@FILES_OPEN A01_EOY,$write+$beginning
	@REPEAT_FOR A01_Record_NO,1,A01_Table_UBOUND
		@TABLES_RGET A01_Table,A01_Record_NO
		@FILES $write,A01_EOY,A101,A102,A103,A104,A105,A106,A107,A108,A109,A110,A111,A112,A113,A114,A115,A116,A117,A118,A119,A120,

	@END_REPEAT
	@FILES_CLOSE A01_EOY
 
	@TABLES_RGET A01_Table,I
 
;	---------------
;	Write B01_Table
;	---------------
	@FILES_OPEN B01_EOY,$write+$end
	@REPEAT_FOR B01_Record_NO,1,B01_Table_UBOUND
		@TABLES_RGET B01_Table,B01_Record_NO
		@IF B01_Company,_GT,n_CompanyNo
			@EXIT_REPEAT
		@ELSE
			@_IF B01_Company,_EQ,n_CompanyNo
       @_AND B01_Archived,_EQ,0
       @_END
				@FILES $write,B01_EOY,B101,B102,B103,B104,B105,B106,B107,B108,B109,B110,B111
			@END_IF
		@END_IF
	@END_REPEAT
	@FILES_CLOSE B01_EOY
 
;	------------------
;	Transaction File
;	------------------
	@FILES_OPEN B02_EOY,$write+$end
 
	@REPEAT_FOR B01_Record_NO,1,B01_Table_UBOUND
		@TABLES_RGET B01_Table,B01_Record_NO
 
		@IF B01_Company,_GT,n_CompanyNo
			@EXIT_REPEAT
		@ELSE
			@IF B01_Company,_EQ,n_CompanyNo
				@_IF B01_AcctNo,_LT,39999
				@_AND B01_Flag1,_IN,<<"A ","AB","AS">>
				@_END
					@INTEGERS_CALC  x_AcctNo,=,<B01_AcctNo>
					@CALL B031_BuildTable
					@IF n_RunningBalance,_NEQ,0
						@CALL B071_Transactions
					@END_IF
				@END_IF
			@END_IF
		@END_IF
 
	@END_REPEAT
 
;	------------------------------
;	Move future dated Transactions
;	------------------------------
	@REPEAT_FOR B02_Record_NO,1,B02_Table_UBOUND
		@TABLES_RGET B02_Table,B02_Record_NO
 
		@IF B02_Company,_GT,n_CompanyNo
			@EXIT_REPEAT
		@ELSE
			@_IF B02_Company,_EQ,n_CompanyNo
			@_AND B02_TranDate,_GT,w_EndDate
			@_END
				@FILES $write,B02_EOY,B201,B202,B203,B204,B205,B206,B207,B208,B209,B210,B211,B212,B213,B214,B215,B216,B217,B218,B219
 
				; ----------------------------------
				; Do the delete here NOT B02_Process
				; as we don't care about validation
				; ----------------------------------
					@INTEGERS_CALC  B02_Company,=,<99>
					@WORDS_PAD "9999/99/99",B02_TranDate
					@WORDS_PAD "99:99:99",B02_TranTime
					@TABLES_RPUT B02_Table,B02_Record_NO
					@TABLES_SORT B02_Table,1,20
					@INTEGERS_CALC  B02_Table_UBOUND,=,<B02_Table_UBOUND,-,1>
					@INTEGERS_CALC  B02_Record_NO,=,<B02_Record_NO,-,1>
 
			@END_IF
		@END_IF
	@END_REPEAT
 
	@FILES_CLOSE B02_EOY
 
;	------------------------------
;	SORT the new transaction file
;	------------------------------
	 .data
		@INSERTWORD w_Sort,46," "
	 .code
 
	 @WORDS_PAD "/usr/bin/sort ./???_9999.CSV -o ./???_9999.CSV",w_Command
	@WORDS_COPY <<B01_EOY,1,14>>,<<w_Command,15>>
	@WORDS_COPY <<B01_EOY,1,14>>,<<w_Command,33>>
 
	@RUN w_Command,RSP1_FILE_HANDLE
	@WAIT CHILD_PID
 
	@WORDS_COPY "B02",<<w_Command,17>>
	@WORDS_COPY "B02",<<w_Command,35>>
	@RUN w_Command,RSP1_FILE_HANDLE
	@WAIT CHILD_PID
 
	@FILES_CLOSE RSP1_FILE
 
;	------------------------------
;	Write the Current Year files
;	-----------------------------
	@CALL Z09_Finalise
 
@END_SUB B07_Process
 
;-----------------------------------------------------------------------
;	Calculate and Create the Opening Balances
;-----------------------------------------------------------------------
@BEGIN_SUB B071_Transactions
 
	@INTEGERS_CALC  B02_Company,=,<n_CompanyNo>
	@WORDS_PAD "9999/07/01",B02_TranDate
	@WORDS_COPY w_finYear,<<B02_TranDate,1>>
	@WORDS_PAD "00:00:01",B02_TranTime
 
	@IF B01_BalanceIndicator,_EQ,"DR"
		@IF B03_RunningBalance,_GT,0
			@INTEGERS_CALC  B02_DRAcctNo,=,<B01_AcctNo>
			@INTEGERS_CALC  B02_CRAcctNo,=,<n_CAAcctNo>
		@ELSE
			@NUMBERS_CALC  B03_RunningBalance,=,<n_RunningBalance,*,-1>
			@INTEGERS_CALC  B02_DRAcctNo,=,<n_CAAcctNo>
			@INTEGERS_CALC  B02_CRAcctNo,=,<B01_AcctNo>
		@END_IF
	@END_IF
 
	@IF B01_BalanceIndicator,_EQ,"CR"
		@IF B03_RunningBalance,_LT,0
			@NUMBERS_CALC  B03_RunningBalance,=,<n_RunningBalance,*,-1>
			@INTEGERS_CALC  B02_DRAcctNo,=,<n_CAAcctNo>
			@INTEGERS_CALC  B02_CRAcctNo,=,<B01_AcctNo>
		@ELSE
			@INTEGERS_CALC  B02_DRAcctNo,=,<n_CAAcctNo>
			@INTEGERS_CALC  B02_CRAcctNo,=,<B01_AcctNo>
		@END_IF
	@END_IF
 
	@_IF B01_BalanceIndicator,_EQ,"DR"
	@_AND B01_CntlAcctNo,_NEQ,99999
	@_END
		@INTEGERS_CALC  B02_DRCntlAcctNo,=,<B01_CntlAcctNo>
		@INTEGERS_CALC  B02_CRCntlAcctNo,=,<0>
	@END_IF
 
	@_IF B01_BalanceIndicator,_EQ,"CR"
	@_AND B01_CntlAcctNo,_NEQ,99999
	@_END
		@INTEGERS_CALC  B02_DRCntlAcctNo,=,<0>
		@INTEGERS_CALC  B02_CRCntlAcctNo,=,<B01_CntlAcctNo>
	@END_IF
 
	@WORDS_PAD "Opening Balance",B02_Description
	@NUMBERS_CALC  B02_Value,=,<B03_RunningBalance>
	@INTEGERS_CALC  B02_NoOfUnits,=,<B03_NoOfUnits>
	@WORDS_PAD "OpeningBal",B02_Reference
	@INTEGERS_CALC  B02_INVTranType,=,<0>
	@INTEGERS_CALC  B02_INVAcctNo,=,<0>
	@INTEGERS_CALC  B02_INVParcelNo,=,<0>
	@INTEGERS_CALC  B02_INVGrouping,=,<0>
	@NUMBERS_CALC  B02_FrankedAmt,=,<0>
	@NUMBERS_CALC  B02_ImputedCredit,=,<0>
	@NUMBERS_CALC  B02_SUnitPrice,=,<0>
	@WORDS_COPY <<w_Spaces,1,10>>,B02_SReference
 
	@FILES $write,B02_EOY,B201,B202,B203,B204,B205,B206,B207,B208,B209,B210,B211,B212,B213,B214,B215,B216,B217,B218,B219
 
@END_SUB B071_Transactions
 
;=======================================================================
;	ASSET MANAGEMENT - Dividend Listing
;=======================================================================
@BEGIN_SUB C01_Process
 
	@INTEGERS_CALC  ERROR_CODE,=,<0>
 
   @INTEGERS_CALC  n_PageNo,=,<0>
   @INTEGERS_CALC  n_LineCtr,=,<60>
@ARRAYS_Put  n_Totals,<<1>>,0
@ARRAYS_Put  n_Totals,<<2>>,0
@ARRAYS_Put  n_Totals,<<3>>,0
 
 	 @FILES_OPEN C01_PRINT,$write+$beginning
 
;	Process Loop
	@INTEGERS_CALC  x_Request,=,<%c_Start>
	@CALL B02_Process
 	 @INTEGERS_CALC  x_Request,=,<%c_PreviousNext>
	@REPEAT_WHILE ERROR_CODE,_EQ,0
 
		@_IF B02_TranDate,_NLT,w_StartDate
		@_AND B02_TranDate,_NGT,w_EndDate
		@_AND B02_FrankedAmt,_GT,0
		@_END
			@CALL C011_Headings
			@CALL C012_DetailLine
		@END_IF
 
     @CALL B02_Process
 
	@END_REPEAT
 
;	Totals
	@CALL C013_Totals
 
   @FILES_CLOSE C01_PRINT
 
@END_SUB C11_Process
 
;-----------------------------------------------------------------------
;	ASSET MANAGEMENT - Dividend Listing - Headings
;-----------------------------------------------------------------------
@BEGIN_SUB C011_Headings
 
	@IF n_LineCtr,_LT,55
		@EXIT_SUB C011_Headings
	@END_IF
 
	@FILES $write,C01_PRINT,x_NewPage
 
	@INTEGERS_CALC  n_PageNo,=,<n_PageNo,+,1>
 
	@FILES $write,C01_PRINT,w_Underlines80
 
	@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
 
	@WORDS_PAD "[C0100001-Franked Dividends]",w_prtLine80
	@WORDS_COPY A01_Parameter,<<w_prtLine80,30>>
	@WORDS_COPY A01_Description,<<w_prtLine80,33>>
	@WORDS_COPY "PAGE",<<w_prtLine80,72>>
	@WORDS_COPY n_PageNo,<<w_prtLine80,77>>
	@FILES $write,C01_PRINT,w_prtLine80
 
	@FILES $write,C01_PRINT,w_Underlines80
 
	@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
	@WORDS_COPY "Date",<<w_prtLine80,06>>
	@WORDS_COPY "Description",<<w_prtLine80,17>>
	@WORDS_COPY "Value",<<w_prtLine80,46>>
	@WORDS_COPY "Franked Amt",<<w_prtLine80,53>>
	@WORDS_COPY "Imputed Credit",<<w_prtLine80,67>>
	@FILES $write,C01_PRINT,w_prtLine80
 
	@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
	@WORDS_COPY "----",<<w_prtLine80,06>>
	@WORDS_COPY "-----------",<<w_prtLine80,17>>
	@WORDS_COPY "-----",<<w_prtLine80,46>>
	@WORDS_COPY "-----------",<<w_prtLine80,53>>
 	 @WORDS_COPY "--------------",<<w_prtLine80,67>>
	@FILES $write,C01_PRINT,w_prtLine80
 
	@WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
	@FILES $write,C01_PRINT,w_prtLine80
 
	@INTEGERS_CALC  n_LineCtr,=,<6>
 
@END_SUB C011_Headings
 
;-----------------------------------------------------------------------
;	ASSET MANAGEMENT - Dividend Listing - Detail Line
;-----------------------------------------------------------------------
@BEGIN_SUB C012_DetailLine
 
 	 @WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
	@WORDS_COPY B02_TranDate,<<w_prtLine80,02>>
	@WORDS_COPY B02_Description,<<w_prtLine80,17>>
	@WORDS_COPY w_B02_Value,<<w_prtLine80,41>>
	@WORDS_COPY w_B02_FrankedAmt,<<w_prtLine80,57>>
	@WORDS_COPY w_B02_ImputedCredit,<<w_prtLine80,74>>
	@FILES $write,C01_PRINT,w_prtLine80
 
	@INTEGERS_CALC  n_LineCtr,=,<n_LineCtr,+,1>
 
; Totals
@ARRAYS_Add  n_Totals,<<1>>,B02_Value
@ARRAYS_Add  n_Totals,<<2>>,B02_FrankedAmt
@ARRAYS_Add  n_Totals,<<3>>,B02_ImputedCredit
 
@END_SUB C012_DetailLine
 
;----------------------------------------------------------
;	ASSET MANAGEMENT - Dividend Listing - Totals
;----------------------------------------------------------
@BEGIN_SUB C013_Totals
 
 	 @WORDS_COPY <<w_Spaces,1,80>>,w_prtLine80
 	 @WORDS_COPY '----------',<<w_prtLine80,41>>
 	 @WORDS_COPY '----------',<<w_prtLine80,54>>
 	 @WORDS_COPY '----------',<<w_prtLine80,71>>
	@FILES $write,C01_PRINT,w_prtLine80
 
@ARRAYS_GET n_Totals,<<1>>,n_TotalDebits
	@WORDS_COPY n_TotalDebits,<<w_prtLine80,41>>
@ARRAYS_GET n_Totals,<<2>>,n_TotalDebits
	@WORDS_COPY n_TotalDebits,<<w_prtLine80,54>>
@ARRAYS_GET n_Totals,<<3>>,n_TotalDebits
	@WORDS_COPY n_TotalDebits,<<w_prtLine80,71>>
	@FILES $write,C01_PRINT,w_prtLine80
 
@END_SUB C013_Totals
 
;----------------------------------------------------------
;	ASSET MANAGEMENT - Asset History
;----------------------------------------------------------
@BEGIN_SUB C02_Process
 
	 .data
  	 @INSERTNUMBER n_Year,00,'9999'
  	 @INSERTNUMBER n_EndYear,00,'9999'
    .code
 
;	Ordinarily this program will open A01/B01/B02, load them into a table
;	and then Close the files. This process however, goes back thru history
;	so it will work directly on the files themselves, opening and closing
;	tem as necessary. This is perfectly safe as the files are only ever read.
 
;	Clear Table
	@REPEAT_FOR C02_Table_UBOUND,1,%%c_C02_MaxRecords
		@INTEGERS_CALC  C02_INVTranType,=,<0>
		@INTEGERS_CALC  C02_INVParcelNo,=,<0>
     @WORDS_COPY <<w_Spaces,10>>,C02_TranDate
     @INTEGERS_CALC  C02_DRAcctNo,=,<0>
     @INTEGERS_CALC  C02_CRAcctNo,=,<0>
     @INTEGERS_CALC  C02_INVAcctNo,=,<0>
     @WORDS_COPY <<w_Spaces,30>>,C02_Description
     @INTEGERS_CALC  C02_NoOfUnits,=,<0>
     @NUMBERS_CALC  C02_Value,=,<0>
   	 @TABLES_RPUT C02_Table,C02_Table_UBOUND
	@END_REPEAT
   @INTEGERS_CALC  C02_Table_UBOUND,=,<0>
   @NUMBERS_CALC  n_RunningBalance,=,<0>
   @INTEGERS_CALC  n_PreviousINVTranType,=,<0>
 
   @NUMBERS_CALC  n_Year,=,<<<w_StartDate,1,4>>>
   @NUMBERS_CALC  I,=,<<<w_StartDate,6,2>>> ; Grab the month
   @IF I,_GT,6 ; if it 7 thru 12
  	 @INTEGERS_CALC  n_Year,=,<n_Year,+,1> ; finyear (filename) is plus 1
   @END_IF ; ie 01/07/2015 is in the 2016 fin year
 
   @NUMBERS_CALC  n_EndYear,=,<<<w_EndDate,1,4>>>
 	 @WORDS_COPY n_Year,<<B01_FILE,7,4>>
	@WORDS_COPY n_Year,<<B02_FILE,7,4>>
 
   @FILES_OPEN B01_FILE,$read
   @FILES_OPEN B02_FILE,$read
 
   @REPEAT_WHILE 1,_EQ,1
 
		@CALL C021_EachYear
 
  	 @FILES_CLOSE B01_FILE
  	 @FILES_CLOSE B02_FILE
 
		@INTEGERS_CALC  n_Year,=,<n_Year,+,1>
 
		@IF n_Year,_GT,n_EndYear
    	 @EXIT_REPEAT
     @ELSE
 			 @WORDS_COPY n_Year,<<B01_FILE,7,4>>
			@WORDS_COPY n_Year,<<B02_FILE,7,4>>
  		 @FILES_OPEN B01_FILE,$read
  		 @FILES_OPEN B02_FILE,$read
     @END_IF
 
   @END_REPEAT
 
   @TABLES_SORT C02_Table,1,14
 
;	---------------
;	and Print it
;	---------------
 	 @FILES_OPEN C02_PRINT,$write+$beginning
	@INTEGERS_CALC  n_LineCtr,=,<60>
 
   @REPEAT_FOR I,1,C02_Table_UBOUND
  	 @TABLES_RGET C02_Table,I
		@CALL C022_Headings
     @CALL C023_DetailLine
	@END_REPEAT
 
   @FILES_CLOSE C02_PRINT
 
@END_SUB C02_Process
 
;----------------------------------------------------------
;	ASSET MANAGEMENT - Process each year
;----------------------------------------------------------
@BEGIN_SUB C021_EachYear
 
	@FILES $read,B01_FILE,B101,B102,B103,B104,B105,B106,B107,B108,B109,B110,B111,B112
 
	@REPEAT_WHILE B01_FILE_STATUS,_EQ,0
 
  	 @_IF B01_Company,_EQ,A01_Parameter
  	 @_AND B01_AcctNo,_EQ,x_Request
     @_END
 
			@FILES $read,B02_FILE,B201,B202,B203,B204,B205,B206,B207,B208,B209,B210,B211,B212,B213,B214,B215,B216,B217,B218,B219
 
			@REPEAT_WHILE B02_FILE_STATUS,_EQ,0
 
      ;	This hard codes the start year
      ;	Prior to this year I used the VBA accounts
      ;	Changing to uppercase will let this one thru
				@_IF n_Year,_EQ,2016
         @_AND B02_Description,_EQ,'Opening Balance'
         @_END
        		 @WORDS_PAD 'OPENING BALANCE',B02_Description
         @END_IF
 
      ;	Grab the transaction
				@_IF B02_Company,_EQ,A01_Parameter ; If we have the right Company
         @_AND B02_Description,_NEQ,'Opening Balance' ; and it's NOT an generated opening balance
				@_END ; END
 
        	 @IF x_RecNo,_EQ,0 ; Requesting Archived is N
						@IF B01_Archived,_EQ,0 ; If Account is NOT archived
         			 @CALL C1211_Details ; Process it
             @END_IF ; END
           @ELSE ; ELSE - Requesting Archived is Y
						@IF B01_Archived,_EQ,1 ; If Account is archived
         			 @CALL C1211_Details ; Process It
             @END_IF ; END
					@END_IF ; END
 
				@END_IF ; END
 
				@FILES $read,B02_FILE,B201,B202,B203,B204,B205,B206,B207,B208,B209,B210,B211,B212,B213,B214,B215,B216,B217,B218,B219
 
  		 @END_REPEAT
 
     @END_IF
 
		@FILES $read,B01_FILE,B101,B102,B103,B104,B105,B106,B107,B108,B109,B110,B111,B112
 
	@END_REPEAT
 
@END_SUB C121_EachYear
 
;-----------------------------------------------------------------------
;	ASSET MANAGEMENT - History Details
;-----------------------------------------------------------------------
@BEGIN_SUB C1211_Details
 
	@_IF B02_DRAcctNo,_NEQ,x_Request
   @_AND B02_CRAcctNo,_NEQ,x_Request
   @_AND B02_INVAcctNo,_NEQ,x_Request
   @_END
  	 @EXIT_SUB C1211_Details
   @END_IF
 
	@IF B02_INVTranType,_EQ,3 ; Revaluation
  	 @EXIT_SUB C1211_Details
   @END_IF
 
   @_IF B02_TranDate,_LT,w_StartDate
	@_OR B02_TranDate,_GT,w_EndDate
   @_END
  	 @EXIT_SUB C1211_Details
   @END_IF
 
	@INTEGERS_CALC  C02_INVParcelNo,=,<B02_INVParcelNo>
	@INTEGERS_CALC  C02_INVTranType,=,<B02_INVTranType>
   @INTEGERS_CALC  C02_INVTranType,=,<B02_INVTranType>
   @WORDS_PAD B02_TranDate,C02_TranDate
   @INTEGERS_CALC  C02_DRAcctNo,=,<B02_DRAcctNo>
	@INTEGERS_CALC  C02_CRAcctNo,=,<B02_CRAcctNo>
	@INTEGERS_CALC  C02_INVAcctNo,=,<B02_INVAcctNo>
	@WORDS_PAD B02_Description,C02_Description
   @INTEGERS_CALC  C02_NoOfUnits,=,<B02_NoOfUnits>
	@NUMBERS_CALC  C02_Value,=,<B02_Value>
 
	@INTEGERS_CALC  C02_Table_UBOUND,=,<C02_Table_UBOUND,+,1>
   @IF C02_Table_UBOUND,_GT,%%c_C02_MaxRecords
  	 @DISPLAY_LINE "Internal Table C02 has been exceeded"
     @TERMINATE 1
   @END_IF
	@TABLES_RPUT C02_Table,C02_Table_UBOUND
 
	@IF C02_INVTranType,_EQ,2 ; ReInvested Income
  	 @INTEGERS_CALC  C02_INVTranType,=,<5> ; Income Transaction
		@INTEGERS_CALC  C02_NoOfUnits,=,<0>
		@INTEGERS_CALC  C02_Table_UBOUND,=,<C02_Table_UBOUND,+,1>
  	 @IF C02_Table_UBOUND,_GT,%%c_C02_MaxRecords
  		 @DISPLAY_LINE "Internal Table C02 has been exceeded"
    	 @TERMINATE 1
  	 @END_IF
		@TABLES_RPUT C02_Table,C02_Table_UBOUND
   @END_IF
 
 
@END_SUB C1211_Details
 
;-----------------------------------------------------------------------
;	ASSET MANAGEMENT - History Headings
;-----------------------------------------------------------------------
@BEGIN_SUB C022_Headings
 
	@IF n_LineCtr,_LT,55
		@EXIT_SUB C022_Headings
	@END_IF
 
	@FILES $write,C02_PRINT,x_NewPage
 
	@INTEGERS_CALC  n_PageNo,=,<n_PageNo,+,1>
 
	@FILES $write,C02_PRINT,w_Underlines132
 
	@WORDS_COPY <<w_Spaces,1,132>>,w_prtLine132
 
	@WORDS_PAD "[C0200001-Asset History]",w_prtLine132
	@WORDS_COPY A01_Parameter,<<w_prtLine132,30>>
	@WORDS_COPY A01_Description,<<w_prtLine132,33>>
	@WORDS_COPY "PAGE",<<w_prtLine132,124>>
	@WORDS_COPY n_PageNo,<<w_prtLine132,129>>
	@FILES $write,C02_PRINT,w_prtLine132
 
	@FILES $write,C02_PRINT,w_Underlines132
 
	@WORDS_COPY <<w_Spaces,1,132>>,w_prtLine132
	@WORDS_COPY "Type",<<w_prtLine132,001>>
	@WORDS_COPY "ParcelNo",<<w_prtLine132,006>>
	@WORDS_COPY "TranDate",<<w_prtLine132,016>>
	@WORDS_COPY "DRAcct",<<w_prtLine132,026>>
	@WORDS_COPY "CRAcct",<<w_prtLine132,033>>
	@WORDS_COPY "INVAcct",<<w_prtLine132,040>>
	@WORDS_COPY "Description",<<w_prtLine132,048>>
	@WORDS_COPY "NoOfUnits",<<w_prtLine132,079>>
	@WORDS_COPY "Value",<<w_prtLine132,094>>
	@WORDS_COPY "Balance",<<w_prtLine132,104>>
	@FILES $write,C02_PRINT,w_prtLine132
 
	@WORDS_COPY <<w_Spaces,1,132>>,w_prtLine132
	@WORDS_COPY "----",<<w_prtLine132,001>>
	@WORDS_COPY "--------",<<w_prtLine132,006>>
	@WORDS_COPY "--------",<<w_prtLine132,016>>
	@WORDS_COPY "------",<<w_prtLine132,026>>
	@WORDS_COPY "------",<<w_prtLine132,033>>
	@WORDS_COPY "-------",<<w_prtLine132,040>>
	@WORDS_COPY "-----------",<<w_prtLine132,048>>
	@WORDS_COPY "---------",<<w_prtLine132,079>>
	@WORDS_COPY "-----",<<w_prtLine132,094>>
	@WORDS_COPY "-------",<<w_prtLine132,104>>
	@FILES $write,C02_PRINT,w_prtLine132
 
	@WORDS_COPY <<w_Spaces,1,132>>,w_prtLine132
	@FILES $write,C02_PRINT,w_prtLine132
 
	@INTEGERS_CALC  n_LineCtr,=,<6>
 
@END_SUB C022_Headings
 
;-----------------------------------------------------------------------
;	ASSET MANAGEMENT - History Print
;-----------------------------------------------------------------------
@BEGIN_SUB C023_DetailLine
 
	@WORDS_COPY <<w_Spaces,1,132>>,w_prtLine132
 
	@IF C02_INVTranType,_GT,n_PreviousINVTranType
		@INTEGERS_CALC  n_PreviousINVTranType,=,<C02_INVTranType>
   	 @IF C02_INVTranType,_GT,4
			@NUMBERS_CALC  n_RunningBalance,=,<0>
			@FILES $write,C02_PRINT,w_prtLine132
		@END_IF
	@END_IF
 
   @BEGIN_TEST C02_INVTranType
  	 @WHEN _EQ,1
  	 @WORDS_PAD "Purc",w_prtLine132
  	 @WEND
  	 @WHEN _EQ,2
  	 @WORDS_PAD "ReIn",w_prtLine132
  	 @WEND
  	 @WHEN _EQ,4
  	 @WORDS_PAD "Sale",w_prtLine132
  	 @WEND
  	 @WHEN _EQ,5
  	 @WORDS_PAD "Inc ",w_prtLine132
  	 @WEND
  	 @WHEN _EQ,6
  	 @WORDS_PAD "Exp ",w_prtLine132
  	 @WEND
  	 @WHEN _EQ,7
  	 @WORDS_PAD "Cap ",w_prtLine132
  	 @WEND
  	 @WHEN _EQ,8
  	 @WORDS_PAD "Tax ",w_prtLine132
  	 @WEND
	@END_TEST
 
	@WORDS_COPY C02_INVParcelNo,<<w_prtLine132,011>>
	@WORDS_COPY C02_TranDate,<<w_prtLine132,015>>
	@WORDS_COPY C02_DRAcctNo,<<w_prtLine132,027>>
	@WORDS_COPY C02_CRAcctNo,<<w_prtLine132,034>>
	@WORDS_COPY C02_INVAcctNo,<<w_prtLine132,042>>
	@WORDS_COPY C02_Description,<<w_prtLine132,048>>
	@WORDS_COPY C02_NoOfUnits,<<w_prtLine132,082>>
	@WORDS_COPY C02_Value,<<w_prtLine132,089>>
 
   @INTEGERS_CALC  n_Idx,=,<0>
 
   @IF C02_INVTranType,_LT,5
 
		@IF C02_DRAcctNo,_EQ,x_Request
     	 @NUMBERS_CALC  n_RunningBalance,=,<n_RunningBalance,+,C02_Value>
   		 @IF n_RunningBalance,_LT,0
				@INTEGERS_CALC  n_Idx,=,<1>
			@END_IF
     @ELSE
   		 @NUMBERS_CALC  n_RunningBalance,=,<n_RunningBalance,-,C02_Value>
   		 @IF n_RunningBalance,_LT,0
				@INTEGERS_CALC  n_Idx,=,<1>
			@END_IF
      @END_IF
 
	@ELSE
 
		@IF C02_CRAcctNo,_GT,40000
     	 @NUMBERS_CALC  n_RunningBalance,=,<n_RunningBalance,+,C02_Value>
   		 @IF n_RunningBalance,_LT,0
				@INTEGERS_CALC  n_Idx,=,<1>
			@END_IF
 
     @ELSE
 
			@IF C02_DRAcctNo,_GT,40000
     		 @NUMBERS_CALC  n_RunningBalance,=,<n_RunningBalance,-,C02_Value>
 	   		 @IF n_RunningBalance,_LT,0
				@INTEGERS_CALC  n_Idx,=,<1>
				@END_IF
       @END_IF
		@END_IF
 
	@END_IF
 
 	 @WORDS_COPY n_RunningBalance,<<w_prtLine132,101>>
   @IF n_Idx,_GT,0
		@WORDS_COPY x_OpenBracket,<<w_prtLine132,100>>
		@WORDS_COPY x_CloseBracket,<<w_prtLine132,111>>
   @END_IF
 
   @FILES $write,C02_PRINT,w_prtLine132
 	 @INTEGERS_CALC  n_LineCtr,=,<n_LineCtr,+,1>
 
@END_SUB C023_DetailLine
 
;-----------------------------------------------------------------------
;	Build Alternate Index for Chart of Account
;-----------------------------------------------------------------------
@BEGIN_SUB X_AltIndex
 
	@INTEGERS_CALC  B01_AltIdx_Table_UBOUND,=,<0>
	@REPEAT_FOR I,1,B01_Table_UBOUND
		@TABLES_RGET B01_Table,I
		@REPEAT_FOR J,n_CpyIdx,%c_NoOfCompanies
			@ARRAYS_IF n_Companies,<<J>>,_EQ,B01_Company
 
				@_IF B01_AcctNo,_NLT,n_StartAcctNo
				@_AND B01_AcctNo,_NGT,n_EndAcctNo
				@_END
					@INTEGERS_CALC  B01_AltIdx_Company,=,<B01_Company>
					@INTEGERS_CALC  B01_AltIdx_AcctNo,=,<B01_AcctNo>
					@INTEGERS_CALC  B01_AltIdx_RecNo,=,<I>
					@INTEGERS_CALC  B01_AltIdx_Table_UBOUND,=,<B01_AltIdx_Table_UBOUND,+,1>
					@TABLES_RPUT B01_AltIdx_Table,B01_AltIdx_Table_UBOUND
 
				@END_IF
 
			@END_IF
		@END_REPEAT
	@END_REPEAT
 
	@TABLES_SORT B01_AltIdx_Table,1,7
 
@END_SUB X_AltIndex
 
;-----------------------------------------------------------------------
;	Date
;-----------------------------------------------------------------------
@BEGIN_SUB X_Process
 
;	----------
;	Initialise
;	----------
	@INTEGERS_CALC  ERROR_CODE,=,<0>
 
;	----------------
;	Get current date
;	----------------
	@IF x_Request,_EQ,%%c_B99_GetDate
		@INTEGERS_CALC  ERROR_CODE,=,<0>
		@DATE_GET I,w_Date
		@IF ERROR_CODE,_NEQ,0
			@INTEGERS_CALC  ERROR_CODE,=,<99>
		@END_IF
	@END_IF
 
;	---------------
;	Validate a date
;	---------------
	@IF x_Request,_EQ,%%c_B99_ValidDate
		@INTEGERS_CALC  ERROR_CODE,=,<0>
		@DATE_DAYSFROMDATE I,w_Date
		@IF ERROR_CODE,_NEQ,0
			@INTEGERS_CALC  ERROR_CODE,=,<99>
		@END_IF
	@END_IF
 
@END_SUB X_Process
 
;-----------------------------------------------------------------------
;	load the Company Array
;-----------------------------------------------------------------------
@BEGIN_SUB X_LoadCompany_Array
 
	@BEGIN_RAW
		LEA rsi,A01_Company01
		LEA rdi,n_Companies
		add rdi,8
		mov rcx,c_NoOfCompanies
	_loop:
		push QWORD PTR[rsi]
		pop  QWORD PTR[rdi]
		add	 rsi,35
		add  rdi,8
		loop _loop
	@END_RAW
	@ARRAYS_SORT n_Companies
 
	@REPEAT_FOR n_CpyIdx,1,%c_NoOfCompanies
		@ARRAYS_IF n_Companies,<<n_CpyIdx>>,_NEQ,0
			@EXIT_REPEAT
		@END_IF
	@END_REPEAT
 
@END_SUB X_LoadCompany_Array
 
;-----------------------------------------------------------------------
;	get Special Accounts
;-----------------------------------------------------------------------
@BEGIN_SUB X_GetSpecialAccts
 
	@INTEGERS_CALC  n_CAAcctNo,=,<0>
	@INTEGERS_CALC  n_PAAcctNo,=,<0>
	@INTEGERS_CALC  n_PLAcctNo,=,<0>
	@INTEGERS_CALC  n_ASAcctNo,=,<0>
	@INTEGERS_CALC  n_TOAcctNo,=,<0>
	@INTEGERS_CALC  n_TCAcctNo,=,<0>
 
	@INTEGERS_CALC  x_Request,=,<%c_Start>
	@INTEGERS_CALC  x_RecNo,=,<1>
	@INTEGERS_CALC  x_Accts,=,<c_TRUE>
 
	@CALL B01_Process
	@INTEGERS_CALC  x_Request,=,<%c_PreviousNext>
 
	@REPEAT_WHILE ERROR_CODE,_NEQ,10
 
		@BEGIN_TEST B01_Flag1
			@WHEN _EQ,"CA"
			@INTEGERS_CALC  n_CAAcctNo,=,<B01_AcctNo>
			@WEND
			@WHEN _EQ,"PA"
			@INTEGERS_CALC  n_PAAcctNo,=,<B01_AcctNo>
			@WEND
			@WHEN _EQ,"PL"
			@INTEGERS_CALC  n_PLAcctNo,=,<B01_AcctNo>
			@WEND
			@WHEN _EQ,"AS"
			@INTEGERS_CALC  n_ASAcctNo,=,<B01_AcctNo>
			@WEND
			@WHEN _EQ,"TO"
			@INTEGERS_CALC  n_TOAcctNo,=,<B01_AcctNo>
			@WEND
			@WHEN _EQ,"TC"
			@INTEGERS_CALC  n_TCAcctNo,=,<B01_AcctNo>
			@WEND
		@END_TEST
		@CALL B01_Process
 
	@END_REPEAT
 
@END_SUB X_GetSpecialAccts
 
 
;=======================================================================
;	FINALISATION
;=======================================================================
@BEGIN_SUB Z09_Finalise
 
;	---------------
;	Write A01_Table
;	---------------
	@INTEGERS_CALC  I,=,<A01_ParameterNo> ; Required if commit prior
   @INTEGERS_CALC  J,=,<A01_Parameter> ; without exiting or Asset history
   @INTEGERS_CALC  K,=,<A01_Record_NO>
 
	@FILES_OPEN A01_FILE,$write+$beginning
	@REPEAT_FOR A01_Record_NO,1,A01_Table_UBOUND
		@TABLES_RGET A01_Table,A01_Record_NO
		@FILES $write,A01_FILE,A101,A102,A103,A104,A105,A106,A107,A108,A109,A110,A111,A112,A113,A114,A115,A116,A117,A118,A119,A120,

	@END_REPEAT
	@FILES_CLOSE A01_FILE
 
	@INTEGERS_CALC  A01_ParameterNo,=,<I>
   @INTEGERS_CALC  A01_Parameter,=,<J>
	@INTEGERS_CALC  A01_Record_NO,=,<K>
 
;	---------------
;	Write B01_Table
;	---------------
	@FILES_OPEN B01_FILE,$write+$beginning
	@REPEAT_FOR B01_Record_NO,1,B01_Table_UBOUND
		@TABLES_RGET B01_Table,B01_Record_NO
		@FILES $write,B01_FILE,B101,B102,B103,B104,B105,B106,B107,B108,B109,B110,B111,B112
	@END_REPEAT
	@FILES_CLOSE B01_FILE
 
;	---------------
;	Write B02_Table
;	---------------
	@FILES_OPEN B02_FILE,$write+$beginning
	@REPEAT_FOR B02_Record_NO,1,B02_Table_UBOUND
		@TABLES_RGET B02_Table,B02_Record_NO
		@FILES $write,B02_FILE,B201,B202,B203,B204,B205,B206,B207,B208,B209,B210,B211,B212,B213,B214,B215,B216,B217,B218,B219
	@END_REPEAT
	@FILES_CLOSE B02_FILE
	

@END_SUB Z09_Finalise
END
