;========================================================================				
;	BEGIN CONSTANTS
;========================================================================

	c_TRUE  				EQU		1
	c_FALSE					EQU 	0

;	Record Delimiters/CVS for INSERTFILE	
	c_NULL					equ 00000001b 
	c_LF					equ 00000010b 
	c_CSV					equ 00000100b
	c_RECORD				equ 00001000b
	c_RANDOM				equ 00010000b
	c_INDEXED				equ 00100000b
	c_DIRECTORY				equ	01000000b

;	STDIO
;	=====	
	c_RETURN				EQU		000
	c_FUNCTIONKEY1			EQU   	001
	c_FUNCTIONKEY2			EQU   	002
	c_FUNCTIONKEY3			EQU   	003
	c_FUNCTIONKEY4			EQU   	004
	c_FUNCTIONKEY5			EQU   	005
	c_FUNCTIONKEY6			EQU   	006
	c_FUNCTIONKEY7			EQU   	007
	c_FUNCTIONKEY8			EQU   	008
	c_FUNCTIONKEY9			EQU   	009
	c_FUNCTIONKEY10			EQU  	010
	c_FUNCTIONKEY11			EQU  	011
	c_FUNCTIONKEY12			EQU  	012
	c_ALT					EQU		013
	c_ARROWUP				EQU		014
	c_ARROWDOWN				EQU		015
	c_ARROWRIGHT			EQU		016
	c_ARROWLEFT				EQU		017
	c_END					EQU		018
	c_HOME					EQU		019
	c_INSERT				EQU		020
	c_ENDOFFIELD			EQU		021
	c_ESCAPE				EQU		027
	c_BACKSPACE				EQU		127
	c_NONE					EQU		999


;	DECISIONS
;	=========
;----------------
;	Alternative B - And Mandatory for Windows/MASM
; ---------------
	_EQ						equ 00000001b
	_NEQ					equ 00000010b
	_LT						equ 00000100b
	_NLT		 			equ 00001000b
	_GT						equ 00010000b													
	_NGT					equ	00100000b	
												  	
;	Alternative C - Deprecated
;	-------------
;	Equals					equ 00000001b
;	isNOTEqualTo			equ 00000010b
;	isLessThan				equ 00000100b
;	isNOTLessThan 			equ 00001000b
;	isGreaterThan			equ 00010000b													
;	isNOTGreaterThan		equ	00100000b

	_IN						equ 01000000b
	_NIN					equ 10000000b

;	FILES
;	=====								  		
	$read 					equ	0000h
	$write	 				equ	0001h
	$readwrite				equ 0002h
	$open					equ 0002h
		$create				equ 0064	;0100octal
		$beginning			equ 0512	;1000octal
		$end				equ 1024	;2000octal
		$lock				equ	2048	;4000octal		
	$close					equ 0003h
	$start					equ 0004h
	$next					equ 0005h
	$delete					equ 0006h

	$filescopy				equ 0007h
	$rename					equ 0008h
	$remove					equ 0009h
	$chdir					equ 000Ah
	$getcwd					equ 000Bh
	$rlock					equ 000Ch
	$runlock				equ 000Dh


;	NUMBERS
;	=======
	$add					EQU 00000001B
	$subtract				EQU 00000010B
	$multiply				EQU 00000100B
	$divide					EQU 00001000B
	$equals					EQU 00010000B
	$random					EQU 00100000B

;	(X)TABLES
;	=========
	$bind					EQU 00000001B
	$sort					EQU 00001000B
	$search					EQU	00010000B

	$rget	 				EQU	00000010B
	$fget					EQU 00000011B
	$rput	 				EQU	00000100B
	$fput					EQU 00000101B
;	XTABLES
	$del					EQU 00100000B
	$load					EQU 01000000B
	$unload					EQU 10000000B
	
;	WORDS
;	=====
	$copy					equ 00000001b
	$pad					equ 00000010b													
	$uppercase 				equ	00000100b							
	$lowercase 				equ	00001000b
	$insert					equ 00010000b
	$find					equ 00100000b
	$replace				equ 01000000b
	$environment 			equ 10000000b
;	-----
;	V2.05
;	-----
	$stringtorecord			equ 10000001b			; be careful with these
	$recordtostring			equ 10000010b			; Must use cmp NOT test

;	WWW
;	===
	$wwwOpen				equ 0000						
	$wwwProcess				equ 0001							
	$wwwClose				equ 0002
;	-----
;	V2.04
;	-----		
	$wwwSendMsg				equ 0003
	$wwwRecvMsg				equ 0004

;	WINDOWS SPECIFIC
;	================
	wc_STD_IN				equ -10		; GetStdHandle
	wc_STD_OUT				equ -11		; GetStdHandle
	wc_STD_ERR				equ -12		; GetStdHandle

;========================================================================				
;	END CONSTANTS
;========================================================================	

