;-----------------------------------------------------------------------
;	IMACROS.ASM are macros used by the system and do not form s
;	part of the language
;   They use lowercase for names and begin with a $ sign
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;	WORDS : ALPHABETIC - Left to Right
		r_Function				TEXTEQU		<R8>
		r_SrcAddress			TEXTEQU		<R9>
		r_SrcStart				TEXTEQU		<R10>
		r_SrcLength				TEXTEQU		<R11>
		r_DstAddress			TEXTEQU	 	<R12>
		r_DstStart				TEXTEQU		<R13>
		;	When it is a Number -> Word 
			r_SrcPicAddress		TEXTEQU		<R10>
			r_SrcPicLength		TEXTEQU		<R11>

;	NUMBERS : NUMERIC - Right to Left
		r_nDstAddress			TEXTEQU		<R9>
		r_nSrcAddress			TEXTEQU		<R12>
		r_nSrcPicAddress		TEXTEQU		<R13>	
		r_nSrcPicLength			TEXTEQU		<R14>
		;	When it is alphabetic -> Number
			r_nSrcStart			TEXTEQU		<R13>	
			r_nSrcLength		TEXTEQU		<R14>

;	FILES
		r_File					TEXTEQU		<R9>
		r_FileFlags				TEXTEQU		<R10>
		r_Record				TEXTEQU		<R10>

;	TABLES
		r_Table					TEXTEQU		<R9>
		r_Record				TEXTEQU 	<R10>
	
;	WWW
	;	r_PortNo				TEXTEQU		<r9d>		; doesn't work if addreassing is 64bit (LARGEADDRESS=YES)
		r_PortNo				TEXTEQU		<r9>
		
		r_ScreenName			TEXTEQU		<r9>
		r_Response				TEXTEQU		<r10>
		r_GetAddress			TEXTEQU		<r11>
		r_PostAddress			TEXTEQU		<r12>

		@NumScale				TEXTEQU <17>
	;V3.05-----------------------------------------------------------
		@NumInfo				TEXTEQU <25>
	;V3.05-----------------------------------------------------------
		@fieldIndicator			TEXTEQU	<9>
		@fieldLength			TEXTEQU	<8> 

;=======================================================================
;	These initial macros provide a way to simulate NASM's CONTEXT support
;	They will allow you to jump forward by defining a label in the macro
;	that will perform the jump, saving it on a stack and then coding the
;	label in the destination macro.
;========================================================================
;	16 Level Stack. Cumbersome but doable
;	-------------------------------------
	label_16 TEXTEQU <>
	label_15 TEXTEQU <>
	label_14 TEXTEQU <>
	label_13 TEXTEQU <>
	label_12 TEXTEQU <>
	label_11 TEXTEQU <>
	label_10 TEXTEQU <>
	label_09 TEXTEQU <>
	label_08 TEXTEQU <>
	label_07 TEXTEQU <>
	label_06 TEXTEQU <>
	label_05 TEXTEQU <>
	label_04 TEXTEQU <>
	label_03 TEXTEQU <>
	label_02 TEXTEQU <>
	label_01 TEXTEQU <>
;	_label	 TEXTEQU <>
	
;	-----------------------
;	MACRO to push the stack
;	-----------------------
$pushCTX MACRO _arg1:REQ

	label_16 TEXTEQU label_15
	label_15 TEXTEQU label_14
	label_14 TEXTEQU label_13
	label_13 TEXTEQU label_12
	label_12 TEXTEQU label_11
	label_11 TEXTEQU label_10
	label_10 TEXTEQU label_09
	label_09 TEXTEQU label_08
	label_08 TEXTEQU label_07
	label_07 TEXTEQU label_06
	label_06 TEXTEQU label_05
	label_05 TEXTEQU label_04
	label_04 TEXTEQU label_03
	label_03 TEXTEQU label_02
	label_02 TEXTEQU label_01

	labelCnt = labelCnt + 1													; Increment the label counter
	label_01 CATSTR <_arg1>,%(labelCnt)										; Append it to <?>

ENDM

;	-----------------------
;	MACRO to pop the stack
;	-----------------------
$popCTX MACRO 
	label_01 TEXTEQU label_02
	label_02 TEXTEQU label_03
	label_03 TEXTEQU label_04
	label_04 TEXTEQU label_05
	label_05 TEXTEQU label_06
	label_06 TEXTEQU label_07
	label_07 TEXTEQU label_08
	label_08 TEXTEQU label_09
	label_09 TEXTEQU label_10
	label_10 TEXTEQU label_11
	label_11 TEXTEQU label_12
	label_12 TEXTEQU label_13
	label_13 TEXTEQU label_14
	label_14 TEXTEQU label_15
	label_15 TEXTEQU label_16	
	label_16 TEXTEQU <>
ENDM

;	--------------------------------------------------
;	Labels are created as a "?" proceded by a label no 
;	--------------------------------------------------
	labelCnt = 0

;	=================================================================
;	Although $createLabel/$jmpToLabel are used for CONTEXT processing
;	they are also used to create any label ie, used in SUB/FUNCTION
;	REMEMBER WHEN THEY ARE CODED THEY MUST BE PRECEEDED BY AN '%'
;	=================================================================
;	---------------------------
;	MACRO to position the label
;	---------------------------
$createLabel MACRO _arg:REQ
_arg:
ENDM

;	--------------------------
;	MACRO to jump to the label
;	_arg1 = jump opcode
;	_arg2 = label name
;	--------------------------
$jmpToLabel MACRO _arg1:REQ, _arg2:REQ 
	_arg1 _arg2
ENDM
		
;=======================================================================
;      		Macros to aid in stack processing
;			less important now but used in
;			$saveRegisters
;				BEGIN.TEST/REPEAT.IF/REPEAT.FOR
;			$restoreRegisters
;				.OR/.AND/WHEN/.WHEN/$whenlist/REPEAT.IF/REPEAT.FOR
;
;			savedRegisters/SX are in COMMON.LIB
;=======================================================================
$saveRegisters MACRO reg1:REQ, reg2:REQ, reg3:REQ, reg4:REQ

			add qword ptr[SX],40
			
			lea rbp,savedRegisters
			add rbp,qword ptr[SX]

			mov qword ptr[rbp-40],reg1
			mov qword ptr[rbp-32],reg2
			mov qword ptr[rbp-24],reg3
			mov qword ptr[rbp-16],reg4
			mov qword ptr[rbp-08],0
				
ENDM

$restoreRegisters MACRO reg1:REQ, reg2:REQ, reg3:REQ, reg4:REQ

			lea rbp,savedRegisters
			add rbp,qword ptr[SX]

			mov reg1,qword ptr[rbp-40]
			mov reg2,qword ptr[rbp-32]
			mov reg3,qword ptr[rbp-24]
			mov reg4,qword ptr[rbp-16]
			
ENDM

;=======================================================================
;      		Code used in FILES.LIB and TABLES.LIB
;=======================================================================
$fromRecord MACRO

	local ?loop, ?X, ?nos, ?9, ?Exit
	
		;	START LOOP -------------------------------------------------						
	?loop:	cmp byte ptr [RSI-@fieldIndicator],00h						; Loop Here - ARE WE DONE
				je ?Exit
				
			cmp byte ptr [RSI-@fieldIndicator],'9'						; If the field is a number then
				je ?nos													;	Do Number

		;---WORDS ****	
			mov rcx,qword ptr [RSI-@fieldLength]						; Grab the length of the field
	?X:		movsb														; move the bytes
			loop ?X														;
	;V3.05 ---------------------------------------------------------------------
		;	add RSI,17													; Next Word
			add RSI,25
	;V3.05 ---------------------------------------------------------------------
			jmp ?loop													; and jump to end of field process
		;	END LOOP for Alpha -----------------------------------------
					
		;---NUMBERS ****	
		;	Convert the binary number to ascii (LEFT to RIGHT)
	?nos:	$pushAll r8,r9,r10,r11,r12,r13,r14,r15,rsi,rdi				; Save everything											
			mov r9,RSI													; Setup source (number)	
			xor r10,r10													; Clear picture override
			xor r11,r11													; Clear picture override
			lea r12,w_Temp												; Using w_Temp
			mov r13,qword ptr[w_One]									; Start at 1
			mov r15,c_TRUE												; Tell _TOALPHA to Set length of Destination
			Call _TOALPHA												; Make the call
			$popAll rdi,rsi,r15,r14,r13,r12,r11,r10,r9,r8				; Restore everything

			PUSH RSI
			lea RSI,w_Temp												; Reset the source to w_Temp
			mov rcx,qword ptr[w_Temp-@fieldLength]						; Grab the length of the field
	?9:		movsb														; move the bytes
			loop ?9									
			POP RSI
			
		;	Jump over stuff
			mov rax,RSI													; Address of Number
			add rax,8													; 	jump over no
			add rax,qword ptr[RSI-@fieldLength]							;	add length of picture
	;V3.05 ---------------------------------------------------------------------
		;	add rax,17													;	add 17 (number)
			add rax,25
	;V3.05 ---------------------------------------------------------------------
			mov RSI,rax													; store the new offset
			jmp ?loop
		;	END LOOP for Number ----------------------------------------

	?Exit:
	
ENDM

$toRecord MACRO

	local ?loop, ?X, ?nos, ?Exit
	
		;	START LOOP -------------------------------------------------
	?loop:	cmp BYTE PTR[RDI-@fieldIndicator],00h						; Loop Here - ARE WE DONE
				je ?Exit
				
			cmp BYTE PTR[RDI-@fieldIndicator],'9'						; If the field is a number then
				je ?nos													;	Do Number

		;---WORDS	
			mov rcx,QWORD PTR[RDI-@fieldLength]							; Grab the length of the field
	?X:		movsb														; move the bytes
			loop ?X						
	;V3.05 ---------------------------------------------------------------------						
		;	add RDI,17													; Next Word
			add RDI,25
	;V3.05 ---------------------------------------------------------------------
			jmp ?loop													; and loop back to get next field
		;	END LOOP for ALPHA -----------------------------------------
							
		;---NUMBERS	
		;	Convert the ascii number to binary (RIGHT to LEFT)		
	?nos:	$pushAll r8,r9,r10,r11,r12,r13,r14,r15,rsi,rdi				; Save everything											
			mov r9,RDI													; Set destination (binary)
			xor r10,r10													; Clear picture override
			xor r11,r11													; Clear picture override
			mov r12,RSI													; Set source (alpha)
			mov r13,QWORD PTR[w_One]									; start at 1
			mov r14,QWORD PTR[r9-8]										; Length (destination length)
			Call _FROMALPHA												; Make the call
			$popAll rdi,rsi,r15,r14,r13,r12,r11,r10,r9,r8				; Restore everything

		;	Jump over stuff
			add RSI,QWORD PTR[RDI-@fieldLength]							; Advance source by picture length
			mov rax,RDI													; Address of Number
			add rax,8													; 	jump over no
			add rax,QWORD PTR[RDI-@fieldLength]							;	add length of picture
	;V3.05 ---------------------------------------------------------------------						
		;	add rax,17													;	add 17 (number)
			add rax,25
	;V3.05 ---------------------------------------------------------------------						
			mov RDI,rax													; store the new offset	
				
			jmp ?loop
		;	END LOOP for Number ----------------------------------------

	?Exit:
	
ENDM

;=======================================================================
;			Replace Symbols
;=======================================================================
$replaceSymbols MACRO _arg:REQ

        IFIDNI <_arg>,<_EQ>
			mov r8,00000001b							; Equals
		ENDIF
		
		IFIDNI <_arg>,<_NEQ>
			mov r8,00000010b							; isNOTEqualTo		
		ENDIF
		
		IFIDNI <_arg>,<_LT>
			mov r8,00000100b							; isLessThan
		ENDIF

		IFIDNI <_arg>,<_NLT>
			mov r8,00001000b							; isNOTLessThan
		ENDIF

		IFIDNI <_arg>,<_GT>
			mov r8,00010000b							; isGreaterThan
		ENDIF

		IFIDNI <_arg>,<_NGT>
			mov r8,00100000b							; isNOTGreaterThan
		ENDIF
	
ENDM

;=======================================================================
;			Push/Pop ALL
;			Used in lots of places
;=======================================================================
$pushAll MACRO regs:VARARG

	FOR reg, <regs>
		push reg
	ENDM
	
ENDM
;-----------------------------------------------------------------------
$popAll MACRO regs:VARARG

	FOR reg, <regs>
		pop reg
	ENDM
	
ENDM

;=======================================================================
;      		Simple copy data
;=======================================================================
$copyBytes MACRO _src:REQ, _dst:REQ, _len:REQ

	local ?loop
	
	; 	Grab the Src Address
		IF (OPATTR (_src)) AND 00010000y 									
			mov RSI,_src												; Register
		ELSE
			lea RSI,_src												; Memory Location
		ENDIF

	; 	Grab the Dst Address
		IF (OPATTR (_dst)) AND 00010000y 									
			mov RDI,_dst												; Register
		ELSE
			LEA RDI,_dst												; Memory Location
		ENDIF
		
			mov rcx,_len												; Grab the length
	?loop:	movsb														; Move the data
			loop ?loop 	

ENDM

;=======================================================================
;      		Copy QWORDS
;			This relies on RSI,RDI and RCX all being setup
;=======================================================================
$copyQwords MACRO
	;
	;	WARNING - Source and Destination must be the same 
	;
	local ?loopq, ?loopb, ?loopEnd
			cld
	?loopq:	cmp rcx,8
				jb ?loopb
			movsq
			sub rcx,8
			jmp ?loopq
			
	?loopb:	cmp rcx,0
			jna ?loopEnd
			movsb
			loop ?loopb
	?loopEnd:		

ENDM

;=======================================================================				
;           Initialise a string
;=======================================================================	
;-----------------------------------------------------------------------
;			No point making a call for this one
;USES:		RAX,RCX,RDX,RSI,RDI
;			$initialise
;				COMMON/STDIO/WORDS
;-----------------------------------------------------------------------
$initialise MACRO _fld:REQ, _char:=< >
	
	local ?num, ?alpha, ?Exit
	
			$pushAll rax,rcx,rsi,rdi

	?num:	cmp byte ptr[_fld-9],'9'
				jne ?alpha
			mov qword ptr[_fld],0
			jmp ?Exit	
				
	?alpha:
			mov  al, "&_char"
		IF (OPATTR (_fld)) AND 00010000y 				;; Register
			mov rdi, _fld
		ELSE
			lea rdi,_fld
		ENDIF
			mov rcx,qword ptr[_fld-8]
			cld
	rep		stosb
		
	?Exit:
			$popAll rdi,rsi,rcx,rax

ENDM

;=======================================================================
;	COMMON code.
;=======================================================================
;=======================================================================
;		Macro to literalStorage sub parameters
;=======================================================================
;-----------------------------------------------------------------------
;			+-------------------+   
;			|  Parameter 4      |
;			+-------------------+   (rsp+24)
;			|  Parameter 3      |
;			+-------------------+   (rsp+16)
;			|  Parameter 2      |
;			+-------------------+   (rsp+8)
;			|  Parameter 1      |
;			+-------------------+   (rsp)
;-----------------------------------------------------------------------
$literalStorage MACRO _args:VARARG

	?count = 0
	?quadword = 0
	IF @SizeStr(<_args>) GT 4
		?quadword = 1
	ENDIF
	IF ?quadword EQ 1
		IFIDNI @SubStr(<_args>,1,5),<QWORD>
			?quadword = 2
		ENDIF
	ENDIF

;   ------------------------
;   for each argumant passed
;   ------------------------
	FOR _arg,<_args>
		local ?alpha,?numeric,?roger																					; Local variable

		?AlphaFlag = 0																												; default to numeric
		?count = ?count + 1																										; Count No Of Parameters

			IFDEF _arg																													; IF already defined then
				LEA  rax,_arg																											; grab the address
				push rax																													; and push it
			ELSE																																; ELSE
				IF ?quadword EQ 2
					push _arg
				ELSE
					;   -----------------------
					;   NUMERIC OR ALPHANUMERIC
					;   -----------------------
;					FORC _alpha, < ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz#.,>	; Scan thru each alphabetic characters
;					%	FORC _val,<_arg>																											; and for each character of the argument passed
;							IFIDNI <_val>,<_alpha>																							; IF it is a letter
;								?AlphaFlag = 1																										; then return true
;								EXITM
;							ENDIF																																; END
;						ENDM																																	; ENDM
;						IF ?AlphaFlag EQ 1																										; IF we have found one
;							EXITM																																; then exit
;						ENDIF																																	; ENDIF
;					ENDM																																		; ENDM

					FirstChar SUBSTR <_arg>,1,1																							; Grab the 1st character
					IFIDN FirstChar,<'>																											; If single quote
						FirstChar TEXTEQU <">																									; set it to double quote
					ENDIF																																		; ENDIF
					IFIDN FirstChar,<">																											; So then if we have a quote
						?AlphaFlag = 1
					ENDIF


					IF ?AlphaFlag EQ 1													; IF we have detected an alpha literal

               	.data                                                      			; IN THE DATA SEGMENT    
		;V3.05------------------------------------------------------------------
										dq 0
		;V3.05------------------------------------------------------------------

			    		                dq 0                                        ; for conformity with insertnumber
			        		            db 'X'                                      ; define it as a string

                strlen = @SizeStr(_arg) - 2                                         ; get the length of the passed argument
										dq strlen									; and define the length 
			                 ?alpha	    db _arg										; create storage for it
			    .code		                                                        ; IN THE CODE SEGMENT
			 		LEA rax,?alpha			 		
			 		push rax
				ELSE
			 	.data                                                      			; IN THE DATA SEGMENT

		;V3.05------------------------------------------------------------------
										dq 0
		;V3.05------------------------------------------------------------------
				    	                dq 0ffffffffffffffffh                       ; Denote it as a created number
					                    db '9'                                      ; define it as a number
					                    dq 26                                       ; largets sized number
			                    ?numeric dq _arg							        ; create storage for it
					                    db '#,###,###,###,###,###,###-'             ; and give it a picture
				.code		                                                        ; IN THE CODE SEGMENT			 
			 		LEA rax,?numeric
			 		push rax
			 	ENDIF																; ENDIF
			ENDIF																	; ENDIF
		ENDIF																		; ENDIF

	ENDM																			; ENDMACRO
  
.code																				; IN THE CODE SEGMENT

;	Because MASM is different from NASM, in this version we need to reverse
;	the order of the pushed items

	IF ?count EQ 4
		$popAll rax,rbx,rcx,rdx
		$pushAll rax,rbx,rcx,rdx
	ENDIF
	IF ?count EQ 3
		$popAll rax,rbx,rcx
		$pushAll rax,rbx,rcx
	ENDIF
	IF ?count EQ 2
		$popAll rax,rbx
		$pushAll rax,rbx
	ENDIF

	exitm %?count

ENDM																				; END MACRO

;-----------------------------------------------------------------------
;	The following code is used for IF/.IF, OR/.OR & AND/AND 
;-----------------------------------------------------------------------
;
;			+-------------------+	  +-------------------+
;			|     				|	  |  	  			  |
;			+-------------------+ r15 +-------------------+	
;			|  r_DstLength		|	  |	 r_DstPicLength	  |
;			+-------------------+ r14 +-------------------+	
;			|  r_DstStart		|	  |	 r_DstPicAddress  |
;			+-------------------+ r13 +-------------------+	 	
;			|  r_DstAddress     |	   	  	
;			+-------------------+ r12 +-------------------+
;			|  r_SrcLength      |	  |  r_SrcPicLength   |
;			+-------------------+ r11 +-------------------+
;			|  r_SrcStart       |	  |  r_SrcPicAddress  |
;			+-------------------+ r10 +-------------------+
;			|  r_SrcAddress     |
;			+-------------------+ r9  
;			|  r_Function       |
;			+-------------------+ r8 
;-----------------------------------------------------------------------
$SetupCompare MACRO _src:REQ, _function:REQ, _dst:REQ

			mov r_Function,_function										; Get compare function

		;   Get DESTINATION parameters
			$pushAll r9,r10,r11
			$SetupField <_dst>												; Grab the Destination field 1st
			mov r12,r9														; and copy to destination registers
			mov r13,r10
			mov r14,r11
			$popAll r11,r10,r9
			
		;   Get SOURCE parameters
			$SetupField <_src>												; Grab the Source fields	
		
ENDM

;-----------------------------------------------------------------------

;			+-------------------+ 	  +-------------------+
;			|  r_SrcLength      |	  |  r_Src
;			+--------------------------------------------
;
;------------------------------------------------------------------------
$SetupField MACRO _arg:REQ
	local ?num, ?Exit

		$NoOfParameters TEXTEQU $literalStorage <_arg>

		pop r9																; address of word/number

			cmp byte ptr [r9-@fieldIndicator],'X'							; If it is not alpha then
				jne ?num													; 	jump to numeric code

;-----------------------------------------------------------------------
;           Code for alphas
;-----------------------------------------------------------------------
		;	Defaults
			lea r10,w_One													; (Default) address of start position	
			mov r11,r9														; (Default) address of No Of Bytes
			sub r11,8

;		IF @NoOfParameters GT 1							
;			pop r10															; address of start position
;			IF @NoOfParameters GT 2										
;				pop r11														; address of No Of Bytes
;			ENDIF
;		ENDIF

		IFIDNI $NoOfParameters,<2>											; If we have found an open brace
			pop r10
		ENDIF
		IFIDNI $NoOfParameters,<3>											; If we have found an open brace
			pop r10
			pop r11
		ENDIF

			mov r10,qword ptr[r10]											; Start position
			mov r11,qword ptr[r11]											; No Of Bytes	

			Call _VALIDATE_SRC
			
			jmp ?Exit	
;-----------------------------------------------------------------------
;			Code for numerics
;-----------------------------------------------------------------------						
	?num:
		;	Defaults
			xor r10,r10														; Zero Override field
			xor r11,r11														; Zero Override field
;		IF @NoOfParameters GT 1												; {I,'####'}													
;			pop r10															; Picture Address
;			mov r11, qword ptr[r10-@fieldLength]							; Picture Length
;		ENDIF		
		IFIDNI $NoOfParameters,<2>											; If we have found an open brace
			pop r10															; Picture Address
			mov r11, qword ptr[r10-@fieldLength]									; Picture Length
		ENDIF
		
	?Exit:

ENDM

;=======================================================================				
;           Calculate the Scale from the No Of Decimal PLaces
;			%1 - Field Address
;			%2 - No Of Places
;			$PlaceToScale
;				NUMBERS -  $PlacesToScale Operand,<qword ptr[fa_dpCount]>
;=======================================================================
;V3.05 should be redundant - If NOT don't forget the -17
;%macro $PlacesToScale 2
;$PlacesToScale MACRO _addr:REQ, _places:REQ
;
;			mov QWORD PTR[_addr-17],1				; Setup the default
;				
;			cmp _places,0							; We have found one (but it could be 123456.) 	
;				je ?Exit							; then exit
;
;			cmp _places,19							; Overflow [Underflow actually]
;				ja ?err			
;
;			mov QWORD PTR[_addr-17],10				; setup default (10) for 1 decimal place
;			dec _places								; Decrement
;			
;		;	so now	Places = 0 and Scale = 10
;			cmp _places,0							; If one decimal place only
;				je ?Exit							;	then exit
;				
;			mov rax,10								; setup for multiplies
;			mov rbx,10								; by 10
;			mov rcx,_places							; Ready Counter
;		;	------------------------------------------------------------	
;	?l:	mul rbx										; Multiply	
;			loop ?l									; and loop
;		;	------------------------------------------------------------
;			mov QWORD PTR[_addr-17],rax				; store the scalling factor
;			jmp ?Exit
;
;	?err:	xor rax,rax
;			lea r14,err02
;			Call _SYSERROR	
;
;	?Exit:
;	
;ENDM
;=======================================================================				
;           Calculate the No Of Decimal Places from the Scale
;			%1 - Scale
; RETURN RCX as No Of Places
;			$ScaleToPlaces
;				NUMBERS -   $ScaleToPlaces @NumScale(Result)
;=======================================================================	
;**V3.05 - This was only ever used in V1.00 and is a very special case
;			It has been moved there. 
;$ScaleToPlaces MACRO _scale:REQ
;
;	local ?l, ?Exit
;			$pushAll rax,rbx,rdx
;			
;			mov rcx,0								; Ready Counter
;			cmp _scale,1							; 1 indicates an integer
;				je ?Exit
;				
;			mov rax,_scale							; Load the Scales
;			cqo
;			mov rbx,10								; by 10
;	?l:	div rbx										; Multiply
;			inc rcx
;			cmp rax,1
;				jne ?l
;				
;	?Exit:
;			$popAll rdx,rbx,rax
;			
;ENDM

;=======================================================================
;	COMMON code.
;=======================================================================

;*********************************** PlacesToScale/ScaleToPLaces
;*********************************** ONLY USED IN NUMBERS.LIB
;*********************************** BETTER TO PUT IT THERE
;=======================================================================
;       	Get position of last non-space in word
;USES:		RAX,RCX			
;RETURNS:	RDI,RCX
;			$EndOfWord
;				COMMON/DECISIONS - always uses registers
;=======================================================================	
$EndOfWord MACRO _reg1:REQ, _reg2:REQ, _reg3:REQ

			mov  al,020h												; set al as space
			mov RDI,_reg1												; get start of source
			add RDI,_reg2												; add the start position
			add RDI,_reg3												; add the No Of Bytes
			sub RDI, 2													; Subtract 2
			mov rcx,_reg3												; Set the counter
			std															; from end to start
	repe	scasb														; and scan
			inc RDI														; cuz scasb has dec it
			inc rcx														; gives the No Of Bytes from beginning (Length of Field)
			
ENDM

;************************ ONLY USED IN FILES
;=======================================================================
;       	Converts c_LF (010b) to 0X0A
;USES:		%1
;RETURNS:	%1
;			$delimiter
;				FILES - $delimiter r13b,'W'    
;=======================================================================	
$delimiter MACRO _ret:REQ, _sys:REQ

; Record Delimiters/CVS for INSERTFILE	
;	c_NULL			equ 00000001b 
;	c_LF			equ 00000010b 
;	c_CSV			equ 00000100b
;	c_Record		equ 00001000b
;	c_Random		equ 00010000b
;	We need this cuz we need to TEST and do stuff like c_CSV+c_LF

	local ?01, ?02, ?03
	
			mov _ret,BYTE PTR [R9-@fileDelimiter]	; Delimiter

	?01:	cmp _ret,1								; c_NULL
				jne ?02
			mov _ret,00h
			jmp ?03	
		
	?02:	cmp _ret,4								; c_LF or c_CSV
				ja ?03

		IFIDN <_sys>,<L>
			mov _ret,0Ah
		ENDIF
		IFIDN <_sys>,<W>
			mov _ret,0Dh
		ENDIF

	?03:
	
ENDM
;***Debug Printing
;	extern _DISPLAY:		PROC
;	extern _VALIDATE_SRC:	PROC
;	extern LF:				BYTE
;	extern I:			QWORD
   debugPrint MACRO _arg:REQ
		$pushAll r8,r9,r10,r11,r12,r13,r14,r15,rax,rbx,rcx,rdx,rsi,rdi
		$SetupField _arg
		Call _DISPLAY
		$SetupField LF
		Call _DISPLAY
		$popAll rdi,rsi,rdx,rcx,rbx,rax,r15,r14,r13,r12,r11,r10,r9,r8
   ENDM
;***Debug Printing

;=======================================================================
;       	Windows Get memory
;			$getmem
;				XTABLES - passed in a register (R11)
;=======================================================================	
$getmem MACRO _reg:REQ

			mov r15,_reg							; R11 may get trashed

			xor rcx,rcx								; Should be zero						
			mov rdx,r15								; Minimum Size
			xor r8,r8								; Maximum Size [0 MEANS IT CAN GROW]
		sub rsp,32
			cld
			Call HeapCreate							; Get a Handle
		add rsp,32
			
			mov rcx,rax								; Use the Handle
			mov rdx,00000004h						; generate an exception if fails
			or  rdx,00000008h						; zero fill
			mov r8,r15								; Size
		sub rsp,32
			cld
			Call HeapAlloc
		add rsp,32
	
		mov QWORD PTR[w_TopOfBSS],rax				; Save the address
		mov QWORD PTR[w_BottomOfBSS],rax			; Calc Bottom 
		add QWORD PTR[w_BottomOfBSS],r15

ENDM

;=======================================================================
;       	Macro to test if two items are zero
;			$And
;				NUMBERS.LIB
;=======================================================================
$And MACRO _reg1:REQ, _reg2:REQ, _value:REQ
	local ?NotEqual
	
			cmp _reg1,_value
				jne ?NotEqual
			cmp _reg2,_value
			
	?NotEqual:
ENDM

;=======================================================================
;       	Macro to return an Array Offset from 1 or more indexes
;=======================================================================

$Arrays_GetIndex MACRO _name:REQ, _args:VARARG

;	YOU RECOGNISED THIS PATTERN WHEN YOU DID IT ON PAPER
;	(3,	2,	3,	4) Indices
;
;	1	1	1	1		1			Always add the last Column	
;	1	1	1	2		2
;	1	1	1	3		3
;	1	1	1	4		4
;
;	1	1	2	1		5			When the column is greater than 1
;	1	1	2	2		6			Multiply all preceeding coumns (working right to left)
;	1	1	2	3		7		    So here:- it (2-1) * 4
;	1	1	2	4		8			
;
;	1	1	3	1		9			When the column is greater than 1
;	1	1	3	2		10			Multiply all preceeding coumns (working right to left)
;	1	1	3	3		11			So here:- (3-1) * 4 
;	1	1	3	4		12
;
;	1	2	1	1		13			When the column is greater than 1
;	1	2	1	2		14			Multiply all preceeding coumns (working right to left)
;	1	2	1	3		15			So here:- (2-1) * 3 * 4
;	1	2	1	4		16
;
;	1	2	2	1		17			When the column is greater than 1
;	1	2	2	2		18			Multiply all preceeding coumns (working right to left)
;	1	2	2	3		19			So here:- (2-1) * 3 * 4
;	1	2	2	4		20			and		  (2-1) * 4
;
;	1	2	3	1		21			When the column is greater than 1
;	1	2	3	2		22			Multiply all preceeding coumns (working right to left)
;	1	2	3	3		23			So here:- (2-1) * 3 * 4
;	1	2	3	4		24			and       (3-1) * 4
;
;	2	1	1	1		25			When the column is greater than 1
;	2	1	1	2		26			Multiply all preceeding coumns (working right to left)
;	2	1	1	3		27			So here:- (2-1) * 2 * 3 * 4
;	2	1	1	4		28
;	
;	2	1	2	1		29			When the column is greater than 1
;	2	1	2	2		30			Multiply all preceeding coumns (working right to left)
;	2	1	2	3		31			So here:- (2-1) * 2 * 3 * 4
;	2	1	2	4		32			and       (2-1) * 4
;
;	Values on the stack
;
;		2
;	+24 -------------------
;		1
;	+16 -------------------
;		2
;	+08 -------------------
;		4
;	+00 -------------------
;

	local ?PreviousColumn,?End
	
	FOR _arg,<_args>														; REPEAT for no of Indexes
		IF (OPATTR (_arg)) AND 00000100y									; if immediate value
			push _arg														; push it
		ELSE																; else
			push QWORD PTR[_arg]											; push  it
		ENDIF																; end
	ENDM																	; end

	?NoOfIndexes CATSTR <_name>,<_Indices>
		LEA rsi,?NoOfIndexes												; Grab the No of address of the Indices
		mov rcx,QWORD PTR[rsi]												; and get the value (No of Indices)
		sub rsi,8															; step back to the last column index
		mov rdi,1															; Initial Indices (cuz we multiply later on)
		pop r9																; passed Index value in r9
		
	?PreviousColumn:
		sub rcx,1															; counting the columns
		cmp rcx,0															; If we are out of columns
			je ?End															; then jump to end

		imul rdi,QWORD PTR[rsi]												; Initial Indice (so we multiply by 1 further on) 
		sub rsi,8															; move to the next (previous) column
		pop r12																; and grab the value
		sub r12,1															; subtract 1 from it
		cmp r12,0															; If it's now zero
			je ?PreviousColumn												; Next left column

		imul r12,rdi														; Multiply by the product of the indices
		add r9,r12															; and add it to the value
		jmp ?PreviousColumn													; Step left to next index
														
	?End:	
	;	returns R9		

ENDM

