;-----------------------------------------------------------------------
;			LMACROS.ASM are macros that form part of the language
;-----------------------------------------------------------------------

;=======================================================================
;      		Macros for basic functions
;=======================================================================

;=======================================================================
;       	Macros to create files for FILES.o
;-----------------------------------------------------------------------
;		FileStatus		+-----------+--------+-------------+----+
;	+---+---+---+---+---|	db      |  dq    | db		   |0x00|
;	| 1	|'9'|Len|Val|Pic+-----------+--------+-------------+----+
;	+---+---+---+---+---| delimiter | Handle | Int[ExtName]|    |
;		AsPer INSERTNO	+-----------+--------+-------------+----+
;				-36		-26			-25		 0
;					c_NONE			equ 00000000b
;					c_NULL			equ 00000001b 
;					c_LF			equ 00000010b 
;					c_CSV			equ 00000100b
;					c_RECORD		equ 00001000b
;					c_RANDOM		equ 00010000b
;					c_DIRECTORY		equ	01000000b
;-----------------------------------------------------------------------
;			INSERTFILE Delimiter,I-Name,'./X-Name'
;-----------------------------------------------------------------------
;=======================================================================
	@fileHandle			TEXTEQU <33>
	@fileDelimiter		TEXTEQU	<34>
	@fileStatus			TEXTEQU	<44>
	@fileSize			TEXTEQU <128>
	@readLength			TEXTEQU <83>
	
	recLen = 0


;=======================================================================
;       	Macros to create storage for WORDS
;			INSERTWORD w_Message,11,'Hello World'
;=======================================================================
	
wAlias MACRO _args:VARARG
		local i

		label1 TEXTEQU <>
		label2 TEXTEQU <>

		i = 1
		FOR _arg,<_args>
			IF i EQ 1

				label1 TEXTEQU <_arg>
			ELSE
				label2 TEXTEQU <_arg>
			ENDIF
			i = i + 1
		ENDM

ENDM

@INSERTWORD MACRO _name:REQ, _length:REQ, _text:VARARG

			dq 0																																; Need to match no size
			dq 0																																; Need to match no size
			db 'X'																															; Define it as a string
			dq _length																													; Define the length of the string

	wAlias _name																														; Check for Alias

	IFNB label2																															; If an Alias
		lab2 CATSTR <label2>,<:>
		%lab2
	ENDIF																																		; ENDIF

%	label1	db _text																												; Create the string

	wAlias _text																														; Use this to split 'roger',00h
	FirstChar SUBSTR <_text>,1,1																						; Grab the 1st character

	IFIDN FirstChar,<'>																											; If single quote
		FirstChar TEXTEQU <">																									; set it to double quote
	ENDIF																																		; ENDIF

	IFIDN FirstChar,<">																											; So then if we have a quote
		nlen SIZESTR label1																										; Get the size of the text
		nlen = _length-nlen+2																									; Calc the no of spaces required
		IF nlen GT 0																													; If its greater than zero
			xlen textequ %nlen																									; get a text version
			db xlen dup(' ')																										; add spaces to fill 
		ENDIF																																	; ENDIF
	ENDIF																																		; ENDIF

		recLen = recLen+_length																								; add to length

ENDM

;=======================================================================
;       	Macros to create storage for NUMBERS
;			INSERTNUMBER	I,0,'##,99,999.99-'
;=======================================================================
@INSERTNUMBER MACRO _name:REQ, _value:REQ, _picture:VARARG

	local _length

.data

	wAlias _name

info CATSTR label1,<_INFO:>																								; Create the overall INFO label
%info

noofdigits CATSTR label1,<_NoOfDigits db 0>																; Create the noofdigits label
%noofdigits

noofplaces CATSTR label1,<_NoOfPlaces db 0>																; Create noofplaces label
%noofplaces
		dw 0 ; -23																														; Some fillers
		dd 0 ; -21 																														; Some fillers

		IFB <_picture>																												; If picture is blank
			scale CATSTR label1,<_Scale dq 1>																		; Create scale label
			%scale
			_length = 26																												; length of 26
		ENDIF

		IFNB <_picture>																												; If picture is blank
			scale CATSTR label1,<_Scale dq 0>																		; Create scale label
			%scale
			_length = @SizeStr(_picture)-2																			; and length of passed picture
		ENDIF

		db '9'																																; Define it as a number
		dq _length																														; and define the length

	IFNB label2																															; If an Alias
		lab2 CATSTR label2,<:>
		%lab2
	ENDIF																																		; ENDIF

%	label1 dq _value

		IFB <_picture>																												; If no picture
			db 26 dup (' ')																											; Allow for dynamic picture
		ELSE
			db _picture																													; the editing picture
		ENDIF
 		recLen = recLen+_length																								; and count length

ENDM

@INSERTFILE MACRO _delimit:REQ, _intName:REQ, _extName:=<>

				;	(V1.01a) Number field for File Size --------------
;	;V3.05----------------------------------------------------------------------
;				dq 0													; 00-153
;	;V3.05----------------------------------------------------------------------
;					dq 1												; 00-145 SCALE
;					db '9'												; 00-137			
;					dq 12												; 00-136
?SIZE CATSTR <_intName>,<_SIZE>
;SIZE 				dq 0												; 00-128 File Size
;					db '999999999999'									; 00-120
%	@INSERTNUMBER ?SIZE,0,'999999999999'
	
				;	(V1.01a) Number field for Read Length --------------
;	;V3.05----------------------------------------------------------------------
;					dq 0												; 00-108
;	;V3.05----------------------------------------------------------------------
;					dq 1												; 00-100 SCALE
;					db '9'												; 00-92				
;					dq 6												; 00-91
?READLENGTH CATSTR <_intName>,<_READLENGTH> 					
;?READLENGTH			dq 0											; 00-83 Read Length
;					db '999999'											; 00-75
%	@INSERTNUMBER ?READLENGTH,0,'999999'

				;	Number field for File Status --------------
;	;V3.05----------------------------------------------------------------------
;					dq 0												; 00-69
;	;V3.05----------------------------------------------------------------------
;					dq 1												; 00-61	 -- New field -SCALE
;					db '9'												; 00-53				
;					dq 2												; 00-52
?STATUS CATSTR <_intName>,<_STATUS>					
;?STATUS				dq 0											; 00-44 File Status
;					db '99'												; 00-36
%	@INSERTNUMBER ?STATUS,0,'99'
				
?DELIMITER CATSTR <_intName>,<_DELIMITER>
?DELIMITER			db _delimit											; 00-34 Delimiter
?HANDLE CATSTR <_intName>,<_HANDLE>
?HANDLE				dq 0 												; 00-33 FileHandle

				;	File Name ---------------------------------			
	;V3.05----------------------------------------------------------------------
					dq 0												; 00-25
	;V3.05----------------------------------------------------------------------
					dq 0												; 00-17
					db 'X'												; 00-09
					dq 255												; 00-08 
				IFB <_extName>
_intName 			db 255 dup(' ')										; 00
				ELSE
_intName			db _extName,00h
					db 255-@SizeStr(_extName)-1 dup(' ')				; and pad it out
				ENDIF
				;	File Name ---------------------------------

	IFIDNI <_delimit>,<c_RECORD>
		?a CATSTR <_intName>,<_R>
		?a:
	ELSEIFIDNI <_delimit>,<c_RANDOM>
		?a CATSTR <_intName>,<_R>
		?a:
	ELSEIFIDNI <_delimit>,<c_INDEXED>
		?a CATSTR <_intName>,<_R>
		?a:
	ELSE
		?a CATSTR <_intName>,<_F>
		?a:
	ENDIF

ENDM

;=======================================================================
;       	Macros for Records
;-----------------------------------------------------------------------
; Record Indicator
;	+---+					RecordNo	 			 			+-----
;	+---+---+---+-----------+----------+-------------+---------+|	     
;	|'R'| 1 |'9'|Length(dq) |Value(dq) |Picture(9b)  + RecLength|NAME
;	|	+---+---+-----------+----------+-------------| 			|
;	+---+				 							 +----------+-----
;	-43 -42 -34 -33			-25	       -17			 -08		0
;-----------------------------------------------------------------------
;=======================================================================
		@recordLength				TEXTEQU <8>
		@recordNo					TEXTEQU <25>

@BEGIN_RECORD MACRO _length:REQ, _name:REQ

					db 'R'									; [00-51] Record indicator
				;	Number field for Record No --------------
;	;V3.05----------------------------------------------------------------------
;					dq 0									; [00-50]
;	;V3.05----------------------------------------------------------------------
;					dq 1									; [00-42] Number Scale 
;					db '9'									; [00-34] Number Indicator
;					dq 9									; [00-33] Picture Length
?NO CATSTR <_name>,<_NO>
;?NO					dq 0									; [00-25] Record Number
;					db '999999999'							; [00-17]
%	@INSERTNUMBER ?NO,0,'999999999'

				;	Number field for Record No --------------
		
				;	LENGTH is a WRITE Only field without a Control Block. 
				;	It can only be used internally.
				;	**** For some stupid reason MASM will screw up if you
				;	use _LENGTH

?LENGTH CATSTR <_name>,<_LEN>			
?LENGTH				dq _length								; [00-08] Record Length

_name:														; [00]	  Record Name   
		recLen = 0

ENDM

@END_RECORD MACRO _name:REQ
				dq 0									; Allow for SCALE in number in TO/FROMRECORD
				db 00h									; Define end of record
?CALCLEN CATSTR <_name>,<_CalcLen>
?CALCLEN		dq recLen								; Calculated Record Length
ENDM


;=======================================================================
;       	Macros to create storage for TABLES
;			INSERTTABLE WorkTable,Record,Dim1*Dim2*Dim3...Dim8
;=======================================================================
;-----------------------------------------------------------------------
; 		TableStatus		Dimension Value	 								Table Indicator									 
;	+---+---+---+---+---+---+---+---+---+---+---+---+---+---------------+---+---------+------+---+---+---+---+---+---+---+---+	     
;	| 1	|'9'|Len|Val|Pic|Idx|Idx|Idx|Idx|Idx|Idx|Idx|Idx|Record Address	|'t'|NoOfBytes| NAME |Idx|Idx|Idx|Idx|Idx|Idx|Idx|Idx|	
;	+---+---+---+---+---+---+---+---+---+---+---+---+---+---------------+---+---------+------+---+---+---+---+---+---+---+---+ 
;	-108-100-99	-91	    -81 -73	-65	-57	-49	-41	-33	-25	-17			   -9	-8		   0	  No Of Bytes +
;															       						 	 8  16  24  32  40  48  56  64  72
;
;		INSERTTABLE WorkTable,A01_Record_Length*Idx*Idx*Idx*Idx*Idx*Idx*Idx*Idx
;-----------------------------------------------------------------------
@INSERTTABLE MACRO _name:REQ,_length:REQ

	;V3.06----------------------------------------------------------------------
		;	UBOUND takes normal numeric data structure
			dq ?									; (-155) Table UBOUND CtrlBlk
			dq ?									; (-147) Table UBOUND (Scale-Always 1)
			db ?									; (-139) Table UBOUND Numeric indicator
			dq ?									; (-138) Table UBOUND length
?UBOUND CATSTR <_name>,<_UBOUND>				
?UBOUND		dq ?									; (-130) Table UBOUND
			db 6 dup(?)								; (-122) Table UBOUND Picture
	;V3.06----------------------------------------------------------------------

		;	Status takes normal numeric data structure
	;V3.05----------------------------------------------------------------------
			dq ?									; (-116) Table Status CtrlBlk
	;V3.05----------------------------------------------------------------------
			dq ?									; (-108) Table Status (Scale-Always 1)
			db ?									; (-100) Table Status Numeric indicator
			dq ?									; (-99)  Table Status length
?STATUS CATSTR <_name>,<_STATUS>				
?STATUS		dq ?									; (-91)  Table Status 
			db 2 dup(?)								; (-83)  Table Status Picture
		;	Dimensions
			dq ?									; Dimension Value 1
			dq ?									; Dimension Value 2
			dq ?									; Dimension Value 3
			dq ?									; Dimension Value 4
			dq ?									; Dimension Value 5
			dq ?									; Dimension Value 6
			dq ?									; Dimension Value 7
			dq ?									; Dimension Value 8
		;	Structure info
			dq ?									; Associate a Record Name (Address)
			db ? 									; Define it as a TABLE (=T)
			dq ?									; Table size
_name		db _length dup(?)						; Create the table
		;	Indexes
			dq ?									; Idx 1
			dq ?									; Idx 2
			dq ?									; Idx 3
			dq ?									; Idx 4
			dq ?									; Idx 5
			dq ?									; Idx 6
			dq ?									; Idx 7
			dq ?									; Idx 8

ENDM

;=======================================================================
;       	Macros to create storage for XTABLES
;			INSERTXTABLE WorkTable,Record,Size
;=======================================================================
;-----------------------------------------------------------------------
; 	UBOUND				 STATUS 				 Table Indicator									 
;	+---+---+---+---+---+---+---+---+---+---+---------------+---+---------+------+	     
;	| 1	|'9'|Len|Val|Pic| 1	|'9'|Len|Val|Pic|Record Address	|'T'|NoOfBytes| NAME |
;	+---+---+---+---+---+---+---+---+---+---+---------------+---+---------+------+
;	-61					-27					-17				-9	-8			0	  
;		INSERTXTABLE WorkTable
;-----------------------------------------------------------------------
@INSERTXTABLE MACRO _name:REQ

		;	UBOUND takes normal numeric data structure
	;V3.05----------------------------------------------------------------------
			dq ?									; (-094)
	;V3.05----------------------------------------------------------------------
			dq ?									; (-086) UBOUND (Scale-Always 1)
			db ?									; (-078) UBOUND Numeric indicator
			dq ?									; (-077) UBOUND length
?UBOUND CATSTR <_name>,<_UBOUND>				
?UBOUND		dq ?									; (-069) UBOUND 
			db 9 dup(?)								; (-061) UBOUND Picture
		;	STATUS takes normal numeric data structure
	;V3.05----------------------------------------------------------------------
			dq ?									; (-052)
	;V3.05----------------------------------------------------------------------
			dq ?									; (-044) STATUS (Scale-Always 1)
			db ?									; (-036) STATUS Numeric indicator
			dq ?									; (-035) STATUS length
?STATUS CATSTR <_name>,<_STATUS>				
?STATUS		dq ?									; (-027) STATUS
			db 2 dup(?)								; (-019) STATUS Picture
		;	Structure info
			dq ?									; (-017) Associate a Record Name (Address)
			db ? 									; (-009) Define it as a TABLE (=T)
			dq ?									; (-008) Table size (AS END ADDRESS)
_name		dq ?									; (-000) Start address of bss

ENDM

;=======================================================================
;       	Macros to create storage for ARRAYS
;			INSERTARRAY WorkTable,NoOf integers (qwords)
;=======================================================================
@INSERTARRAY MACRO _arg1:REQ, _args:VARARG
	local i,_arg1_len
;		-----------------
;		Get size of Array
;		-----------------
		i = 1																; Init i
		FOR _arg,<_args>													; Repeat for No Of Parameters
			i = i * _arg													; i times paramater									
		ENDM																; END
		i = i + 1															; So we can go 1->n rather than 0->(n-1)

;		.data?
		.data
	 	ALIGN 8																; Align stuff
 		_arg1 dq i dup(0)													; Reserve the memory
 		_arg1_len equ $-_arg1												; create a length variable
	
	.data
		$Name textequ <_arg1>												; Save the Array name
		i = 0																; i = 0
		FOR _arg,<_args>													; Repeat for No Of Parameters
			i = i + 1														; increment i
			$No textequ %i													; grab a text version
			$Idx CATSTR <_arg1>,<_>,$No										; Create the Index name
			$Idx dq _arg													; Insert the index value
		ENDM																; END
		$NoOf CATSTR <_arg1>,<_Indices>										; Create the Indices name
		$NoOf dq i															; Insert the Indices value

ENDM

;=======================================================================
;	LANGUAGE KEYWORDS
;=======================================================================
;=======================================================================
;       	INTEGER Routines
;=======================================================================

@INTEGERS_EQ MACRO _receiver:REQ, _sender:REQ
	local i, j

	inc qword ptr[_STOP]
	
	i = @sizestr(_receiver)
	IF i GT 4
		$r SUBSTR <_receiver>,1,5
	ELSE
		$r textequ <>
	ENDIF
	j = @sizestr(_sender)
	IF j GT 4
		$s SUBSTR <_sender>,1,5
	ELSE
		$s textequ <>
	ENDIF


;echo HERE Sender is _sender
;IF (OPATTR (_sender)) AND 00010000y
;	echo IS A REGISTER
;ELSEIF (OPATTR (_sender)) AND 00000100y
;	echo IS A CONSTANT
;ELSEIF (TYPE (_sender) EQ BYTE) OR (TYPE (_sender) EQ SBYTE)
;	echo IS A BYTE
;ELSEIF (SIZE (TYPE (_sender))) EQ 2
;	echo IS A NEAR POINTER
;ELSEIF (SIZE (TYPE (_sender))) EQ 4
;	echo IS A FAR POINTER
;ELSE
;	echo ILLEGAL ARGUMENT
;ENDIF

;atMemory        = 34            ; 00100010
;atImmediate     = 36            ; 00100100
;atLabel         = 37            ; 10100101
;atOffset        = 38            ; 10100110
;atGlobal        = 42            ; 10101010
;atRegLabel      = 43            ; 10101011
;atRegister      = 48            ; 00110000
;atLocal         = 98            ; 01100010

;Result = OPATTR (_sender)
;Res TEXTEQU %Result
;% echo SENDER _sender Res

;Result = OPATTR (_receiver)
;Res TEXTEQU %Result
;% echo RECEIVER _receiver Res
;echo

;	IF (OPATTR (_sender)) AND 00000100y				; immediate value
	IF (OPATTR (_sender)) EQ 36				; immediate value
		mov rax,_sender
		IFIDNI $r,<QWORD>
			mov _receiver,rax
		ELSE
			mov QWORD PTR[_receiver],rax
		ENDIF
	ELSE
		IFIDNI $s,<QWORD>
			PUSH _sender
		ELSE
			push QWORD PTR[_sender]
		ENDIF
		IFIDNI $r,<QWORD>
			pop _receiver
		ELSE
			pop  QWORD PTR[_receiver]
		ENDIF
	ENDIF
						
ENDM

;-----------------------------------------------------------------------
@INTEGERS_ADD MACRO _receiver:REQ, _sender:REQ
	local i, j
	
	inc qword ptr[_STOP]

	i = @sizestr(_receiver)
	IF i GT 4
		$r SUBSTR <_receiver>,1,5
	ELSE
		$r textequ <>
	ENDIF
	j = @sizestr(_sender)
	IF j GT 4
		$s SUBSTR <_sender>,1,5
	ELSE
		$s textequ <>
	ENDIF
	
;	IF (OPATTR (_sender)) AND 00000100y				; immediate value
	IF (OPATTR (_sender)) EQ 36				; immediate value
		mov rax,_sender
		IFIDNI $r,<QWORD>
			add _receiver,rax
		ELSE
			add QWORD PTR[_receiver],rax
		ENDIF
	ELSE
		IFIDNI $s,<QWORD>
			mov rax,_sender
		ELSE
			mov rax,QWORD PTR[_sender]
		ENDIF
		IFIDNI $r,<QWORD>
			add _receiver,rax
		ELSE
			add QWORD PTR[_receiver],rax
		ENDIF
	ENDIF
						
ENDM

;-----------------------------------------------------------------------
@INTEGERS_SUB MACRO _receiver:REQ, _sender:REQ
	local i, j
	
	inc qword ptr[_STOP]

	i = @sizestr(_receiver)
	IF i GT 4
		$r SUBSTR <_receiver>,1,5
	ELSE
		$r textequ <>
	ENDIF
	j = @sizestr(_sender)
	IF j GT 4
		$s SUBSTR <_sender>,1,5
	ELSE
		$s textequ <>
	ENDIF
	
;	IF (OPATTR (_sender)) AND 00000100y				; immediate value
	IF (OPATTR (_sender)) EQ 36				; immediate value
		mov rax,_sender
		IFIDNI $r,<QWORD>
			sub _receiver,rax
		ELSE
			sub QWORD PTR[_receiver],rax
		ENDIF
	ELSE
		IFIDNI $s,<QWORD>
			mov rax,_sender
		ELSE
			mov rax,QWORD PTR[_sender]
		ENDIF
		IFIDNI $r,<QWORD>
			sub _receiver,rax
		ELSE
			sub QWORD PTR[_receiver],rax
		ENDIF
	ENDIF
						
ENDM

;-----------------------------------------------------------------------
@INTEGERS_MUL MACRO _receiver:REQ, _sender:REQ
	local i, j, _cont
	
	inc qword ptr[_STOP]

	i = @sizestr(_receiver)
	IF i GT 4
		$r SUBSTR <_receiver>,1,5
	ELSE
		$r textequ <>
	ENDIF
	j = @sizestr(_sender)
	IF j GT 4
		$s SUBSTR <_sender>,1,5
	ELSE
		$s textequ <>
	ENDIF
	
	IFIDNI $r,<QWORD>
		mov rax,_receiver
	ELSE
		mov rax,QWORD PTR[_receiver]
	ENDIF
	
;	IF (OPATTR (_sender)) AND 00000100y				; immediate value
	IF (OPATTR (_sender)) EQ 36				; immediate value
		mov  rbx,_sender							; Need to move to register incase its a
	ELSE
		IFIDNI $s,<QWORD>
			mov rbx,_sender
		ELSE
			mov rbx,QWORD PTR[_sender]
		ENDIF
	ENDIF

	cqo
	imul rbx          														; do the multiply 
		jno _cont
;	-----------------
;	TOO LARGE
;	-----------------  
	xor rax,rax																; clear rax
	LEA r14,err02															; load the error number
	Call _SYSERROR															; and call syserror

_cont:  
	IFIDNI $r,<QWORD>
		mov _receiver,rax
	ELSE
		mov QWORD PTR[_receiver],rax
	ENDIF
						
ENDM

;-----------------------------------------------------------------------
@INTEGERS_DIV MACRO _receiver:REQ, _sender:REQ, _remainder:VARARG
	local i, j
	
	inc qword ptr[_STOP]

	i = @sizestr(_receiver)
	IF i GT 4
		$r SUBSTR <_receiver>,1,5
	ELSE
		$r textequ <>
	ENDIF
	j = @sizestr(_sender)
	IF j GT 4
		$s SUBSTR <_sender>,1,5
	ELSE
		$s textequ <>
	ENDIF
	
	IFIDNI $r,<QWORD>
		mov rax,_receiver
	ELSE
		mov rax,QWORD PTR[_receiver]
	ENDIF
	
;	IF (OPATTR (_sender)) AND 00000100y				; immediate value
	IF (OPATTR (_sender)) EQ 36				; immediate value
		mov  rbx,_sender							; Need to move to register incase its a
	ELSE
		IFIDNI $s,<QWORD>
			mov rbx,_sender
		ELSE
			mov rbx,QWORD PTR[_sender]
		ENDIF
	ENDIF

	cqo
	idiv rbx          														; do the multiply 

	IFIDNI $r,<QWORD>
		mov _receiver,rax
	ELSE
		mov QWORD PTR[_receiver],rax
	ENDIF
												
ENDM

;-----------------------------------------------------------------------
@INTEGERS_TOGGLE MACRO _receiver:REQ
	local i,_else, _endif

	inc qword ptr[_STOP]

	i = @sizestr(_receiver)
	IF i GT 4
		$r SUBSTR <_receiver>,1,5
	ELSE
		$r textequ <>
	ENDIF
	
	IFIDNI $r,<QWORD>
		mov rax,_receiver
	ELSE
		mov rax,QWORD PTR[_receiver]
	ENDIF

	cmp rax,0
		je _else
	xor rax,rax
	jmp _endif
_else:	
	inc rax
_endif:
	
	IFIDNI $r,<QWORD>
		mov _receiver,rax
	ELSE
		mov QWORD PTR[_receiver],rax
	ENDIF

ENDM
;-----------------------------------------------------------------------
;	Integerss.calc num = num2 + num3 - num4 * num5 / num6
;-----------------------------------------------------------------------
@INTEGERS_CALC MACRO _receiver:REQ, _args:VARARG
	local _cnt,i,_function

	i = @sizestr(_receiver)
	IF i GT 4
		$r SUBSTR <_receiver>,1,5
	ELSE
		$r textequ <>
	ENDIF
	IFIDNI $r,<QWORD>
		i = i - 10 - 1
		$r SUBSTR <_receiver>,11,i
		LEA r15,$r
	ELSE
		LEA r15,_receiver
	ENDIF

	_cnt = 0
	
	FOR arg,<_args>
		_cnt = _cnt + 1
		IFIDNI <arg>,<=>												; set the function
			_function = 1						
		ELSEIFIDNI <arg>,<+>
			_function = 2						
		ELSEIFIDNI <arg>,<->
			_function = 3					
		ELSEIFIDNI <arg>,<*>
			_function = 4						
		ELSEIFIDNI <arg>,</>
			_function = 5						
		ELSE
			IF _function EQ 1
				@INTEGERS_EQ r15,arg								; and make the call
			ELSEIF _function EQ 2
				@INTEGERS_ADD r15,arg								; and make the call
			ELSEIF _function EQ 3
				@INTEGERS_SUB r15,arg								; and make the call
			ELSEIF _function EQ 4
				@INTEGERS_MUL r15,arg								; and make the call
			ELSEIF _function EQ 5
				@INTEGERS_DIV r15,arg								; and make the call
			ENDIF
		ENDIF																
	ENDM

ENDM

;-----------------------------------------------------------------------
@INTEGERS_AND MACRO _receiver:REQ, _sender:REQ
	local i,j

	inc qword ptr[_STOP]

	i = @sizestr(_receiver)
	IF i GT 4
		$r SUBSTR <_receiver>,1,5
	ELSE
		$r textequ <>
	ENDIF
	j = @sizestr(_sender)
	IF j GT 4
		$s SUBSTR <_sender>,1,5
	ELSE
		$s textequ <>
	ENDIF

;	IF (OPATTR (_sender)) AND 00000100y				; immediate value
	IF (OPATTR (_sender)) EQ 36				; immediate value
		mov rbx,_sender
	ELSE
		IFIDNI $s,<QWORD>
			mov rbx,_sender
		ELSE
			mov rbx,QWORD PTR[_sender]
		ENDIF
	ENDIF

	IFIDNI $r,<QWORD>
		mov rax,_receiver
	ELSE
		mov rax,QWORD PTR[_receiver]
	ENDIF

	and rax,rbx

	IFIDNI $r,<QWORD>
		mov _receiver,rax
	ELSE
		mov QWORD PTR[_receiver],rax
	ENDIF
	
ENDM

;-----------------------------------------------------------------------
@INTEGERS_OR MACRO _receiver:REQ, _sender:REQ
	local i,j

	inc qword ptr[_STOP]

	i = @sizestr(_receiver)
	IF i GT 4
		$r SUBSTR <_receiver>,1,5
	ELSE
		$r textequ <>
	ENDIF
	j = @sizestr(_sender)
	IF j GT 4
		$s SUBSTR <_sender>,1,5
	ELSE
		$s textequ <>
	ENDIF

;	IF (OPATTR (_sender)) AND 00000100y				; immediate value
	IF (OPATTR (_sender)) EQ 36				; immediate value
		mov rbx,_sender
	ELSE
		IFIDNI $s,<QWORD>
			mov rbx,_sender
		ELSE
			mov rbx,QWORD PTR[_sender]
		ENDIF
	ENDIF

	IFIDNI $r,<QWORD>
		mov rax,_receiver
	ELSE
		mov rax,QWORD PTR[_receiver]
	ENDIF

	or rax,rbx

	IFIDNI $r,<QWORD>
		mov _receiver,rax
	ELSE
		mov QWORD PTR[_receiver],rax
	ENDIF
						
ENDM

;-----------------------------------------------------------------------
@INTEGERS_XOR MACRO _receiver:REQ, _sender:REQ
	local i,j

	inc qword ptr[_STOP]

	i = @sizestr(_receiver)
	IF i GT 4
		$r SUBSTR <_receiver>,1,5
	ELSE
		$r textequ <>
	ENDIF
	j = @sizestr(_sender)
	IF j GT 4
		$s SUBSTR <_sender>,1,5
	ELSE
		$s textequ <>
	ENDIF

;	IF (OPATTR (_sender)) AND 00000100y				; immediate value
	IF (OPATTR (_sender)) EQ 36				; immediate value
		mov rbx,_sender
	ELSE
		IFIDNI $s,<QWORD>
			mov rbx,_sender
		ELSE
			mov rbx,QWORD PTR[_sender]
		ENDIF
	ENDIF

	IFIDNI $r,<QWORD>
		mov rax,_receiver
	ELSE
		mov rax,QWORD PTR[_receiver]
	ENDIF

	xor rax,rbx

	IFIDNI $r,<QWORD>
		mov _receiver,rax
	ELSE
		mov QWORD PTR[_receiver],rax
	ENDIF
						
ENDM

;=======================================================================
;       	Macros for procedures
;=======================================================================
@SAVING MACRO _args:VARARG
	inc qword ptr[_STOP]

	FOR _arg,<_args>
		push QWORD PTR[_arg]
	ENDM
	
ENDM

@RESTORE MACRO _args:VARARG
	inc qword ptr[_STOP]

	FOR _arg,<_args>
		pop QWORD PTR[_arg]
	ENDM
	
ENDM

@EXIT_LABEL MACRO _arg:REQ
		inc qword ptr[_STOP]

		jmp _arg

ENDM

@BEGIN_RAW MACRO
ENDM
@END_RAW MACRO
ENDM

@BEGIN_SUB MACRO _name:REQ, _dbg:VARARG
		   local x_name, literal
		   local ?1If, ?1Else, ?1EndIf

_name:
	
;	-------------------
;	SIMPLE DEBUG
;	-------------------
;	IFNB <_dbg>
;		.data
;			literal CATSTR <">,<_name>,<">
;			@insertword x_name,30,literal
;		.code
;		push rax
;			@display "Entering Sub:",x_name,LF
;		pop rax
;	ELSE
		inc qword ptr[_STOP]
;	ENDIF

	push QWORD PTR[SX]

ENDM

@EXIT_SUB MACRO _name:REQ
	inc qword ptr[_STOP]
	
	?exit CATSTR <_name>, <_EXIT>
	
%	$jmpToLabel jmp, ?exit
	
ENDM

@END_SUB MACRO _name:REQ, _dbg:VARARG
		 local x_name, literal
		 local ?1If, ?1Else, ?1EndIf

	
	?exit CATSTR <_name>, <_EXIT>
%	$createLabel ?exit

;	-------------------
;	SIMPLE DEBUG
;	-------------------
;	IFNB <_dbg>
;		.data
;			literal CATSTR <">,<_name>,<">
;			@insertword x_name,30,literal
;		.code
;		@display "Exiting Sub:",x_name,LF
;	ELSE
		inc qword ptr[_STOP]
;	ENDIF

	pop QWORD PTR[SX]
	
	ret

ENDM

;=======================================================================
;       	Macros for Boolean Functions
;=======================================================================
@BEGIN_FUNCTION MACRO _name:REQ, _picture:=<>
		   local x_name,literal

	?num CATSTR <d>,<_name>
;	V3.01 - FUNCTIONS
	.data
	%	@insertnumber ?num,0,<_picture>
	.code
;	V3.01 - FUNCTIONS

_name:
	inc qword ptr[_STOP]

	mov QWORD PTR[?num],0
	mov QWORD PTR[RETURN_CODE],c_FALSE
	push QWORD PTR[SX]

;	-------------------
;	SIMPLE DEBUG - removed from function as of V3.01
;	-------------------

ENDM

@EXIT_FUNCTION MACRO _name:REQ
	?exit CATSTR <_name>, <_EXIT>
%	$jmpToLabel jmp, ?exit

	inc qword ptr[_STOP]

ENDM

@END_FUNCTION MACRO _name:REQ
	?exit CATSTR <_name>, <_EXIT>
%	$createLabel ?exit

	inc qword ptr[_STOP]
	
;	-------------------
;	SIMPLE DEBUG - removed from function as of V3.01
;	-------------------

	pop QWORD PTR[SX]
	ret
	
ENDM

;-------------------------------------------------------------------------------
;	V3.01 FUNCTION MACROS
;-------------------------------------------------------------------------------
;-------------------------------------------------------------------------------
;	@USING 
;	Follows the @BEGIN_FUNCTION to create numbers and load them
;	from the stack
;-------------------------------------------------------------------------------
$createField MACRO _arg1:REQ,_arg2:REQ

	.data
		@insertnumber _arg1,0,_arg2
	.code

		mov rax,qword ptr[rsp+idx]

	;	Load the receiving field using _NUMBERS
	;	---------------------------------------
		mov r_Function,$equals												; Using the equals function
		LEA r9,_arg1														; address of destination field
		mov r12,rax															; address of source field
		xor r13,r13															; no override
		xor r14,r14															; no override
		Call _NUMBERS 

		idx = idx - 8														; next parameter
ENDM

@USING MACRO _args:VARARG
	inc qword ptr[_STOP]

	cnt = 0
	FOR _arg,<_args>
		cnt = cnt + 1

	ENDM
	idx = (cnt * 8) + 8
	FOR _arg,<_args>



		$createField _arg
	ENDM

ENDM
;-------------------------------------------------------------------------------
;	@FUNCTION 
;	Pushes the parameters onto the stack 
;	Calls the Function
;	Pops the stack
;	Loads the receiving field from RAX (set in @EXIT_FUNCTION
;	@FUNCTION A,f_POWER,{20,'9.9'},{30,'9.9'}
;-------------------------------------------------------------------------------

	store MACRO _arg1:REQ,_arg2:VARARG										; literal {20,'9.9'} or just integer
	
;		IF (OPATTR (_arg1)) AND 00000100y									; immediate value
		IF (OPATTR (_arg1)) EQ 36									; immediate value
			junk TEXTEQU $literalStorage <_arg1>							; create and push if numeric literal

			IFNB <_arg2>													; if it {20,'9.9'}				
				junk TEXTEQU $literalStorage <_arg2>						; create the picture field
				mov rax,qword PTR[rsp+8]									; Set up the number address
				mov qword PTR[s_NoAddress],rax								; and store it
				pop rax														; Grab the picture address
				mov qword PTR[s_PicAddress],rax								; and store it
				sub rax,8													; back eight
				mov rax,QWORD PTR[rax]										; to get the VALUE (Not Address)
				mov qword PTR[s_PicLength],rax								; and store it
				Call _GETSCALE												; _GETSCALE in NUMBERS.LIB
			ELSE															; ELSE it's an integer
				mov rax,QWORD PTR[rsp]										; so grab the address
				mov QWORD PTR[rax-17],1										; and set the scale to 1
			ENDIF															; END
		ELSE																; ELSE
			lea rax,_arg1													; grab the address
			push rax														; and push it
		ENDIF																; END
		
ENDM

@FUNCTION MACRO _receives:REQ, _name:REQ, _args:VARARG
	local ?num

	inc qword ptr[_STOP]

	?num CATSTR <d>,<_name>													; create a data name

	FOR _arg,<_args>														; for each passed parameter
		store _arg															; create/save storage
	ENDM																	; END

	Call _name																; Call the function

	FOR _arg,<_args>														; for each passed parameter
		pop r15																; reset the stack
	ENDM

	push QWORD PTR[RETURN_CODE]
%	@numbers_eq _receives,?num												; Load the receiving field
	pop QWORD PTR[RETURN_CODE]
	
ENDM

@CALL MACRO _name:REQ, _args:VARARG
	inc qword ptr[_STOP]

	FOR _arg,<_args>														; for each passed parameter
		store _arg															; create/save storage
	ENDM																	; END
	
	Call _name

	FOR _arg,<_args>														; for each passed parameter
		pop r15																; reset the stack
	ENDM

ENDM

;-------------------------------------------------------------------------------
;	V3.01 FUNCTION MACROS
;-------------------------------------------------------------------------------

;=======================================================================
;      		Macro to set terminal cursor position
;			Cursor Col, Row
;=======================================================================
@CURSOR MACRO _row:REQ, _col:REQ
	inc qword ptr[_STOP]
	
;	IF (OPATTR (_row)) AND 00000100y				; immediate value
	IF (OPATTR (_row)) EQ 36				; immediate value
		mov QWORD PTR[Row9],_row
	ELSE
		push QWORD PTR[_row]
		pop  QWORD PTR[Row9]
	ENDIF

;	IF (OPATTR (_col)) AND 00000100y				; immediate value
	IF (OPATTR (_col)) EQ 36				; immediate value
		mov QWORD PTR[Col9],_col
	ELSE
		push QWORD PTR[_col]
		pop  QWORD PTR[Col9]
	ENDIF

		Call _CURSOR														; and make the call

ENDM

;=======================================================================
;      		Macro to read line from stdout
;=======================================================================
@ACCEPTLINE MACRO arg:REQ
	inc qword ptr[_STOP]
										
		lea r_SrcAddress,arg
		call _ACCEPTLINE

ENDM

;
;	Enhanced to include cursor positioning
;
@ACCEPTLINE_AT MACRO _x:REQ, _y:REQ, _field:REQ
	inc qword ptr[_STOP]
				
		@CURSOR _x,_y														; Automated cursor positioning
	
		lea r_SrcAddress,_field
		call _ACCEPTLINE

ENDM

;
;	Enhanced for NON-CANONICAL mode
;	only accepts one item
;		@fieldLength			TEXTEQU	<8> 

@ACCEPT_AT MACRO _x:REQ, _y:REQ, _field:REQ 
	local _num, _alpha, _Exit

	inc qword ptr[_STOP]
	
		@CURSOR _x,_y														; Automated cursor positioning

		mov rax,QWORD PTR[_field-@fieldLength]								; Grab the passed field length
		mov QWORD PTR[w_AcceptAt-@fieldLength],rax							; for w_AcceptAt
		@words_pad _field,w_AcceptAt											; copy input
		lea r_SrcAddress,w_AcceptAt											; setup R9 with address
		Call _ACCEPT_AT														; and Accept

	;	----------------------------------------------
	;	NEWER/NICER way to handle numeric/alpha fields
	; - always accept alpha then convert
	;	----------------------------------------------
		cmp BYTE PTR[_field-@fieldIndicator],'9'							; Are we numeric
			jne _Alpha														; NO - then jump to alpha
	_Num:
		@numbers_eq _field,w_AcceptAt										; 	Convert to numeric
			jmp _Exit														;	and exit

	_Alpha:
		@words_pad w_AcceptAt,_field										; Copy field to passed parameter
		
   _Exit:
ENDM

;=======================================================================
;      		Macro to display text to stdout with LF
;           This is the wrapper for $display so that more than
;			1 field can be displayed at a time
;           %0 is the number of parameters passed
;           %rotate cycles thru the parameters
;=======================================================================
@DISPLAY_LINE MACRO _args:VARARG
	inc qword ptr[_STOP]

	IFB <_args>
		$SetupField LF														; add a LineFeed
		Call _DISPLAY														;	and Display	ENDM
	ELSE
		FOR _arg,<_args>		
	 		IFNB <_arg>
				$SetupField <_arg>											; Standard setup for {Name,1,64}
				Call _DISPLAY												;	and Display
				$SetupField LF												; add a LineFeed
				Call _DISPLAY												;	and Display	ENDM
			ENDIF
		ENDM
	ENDIF
	
ENDM

;=======================================================================
;      		Macro to display text to stdout without LF
;           This is the wrapper for $display so that more than
;			1 field can be displayed at a time
;           %0 is the number of parameters passed (fields to be displayed)
;           %rotate cycles thru the parameters
 
;=======================================================================
@DISPLAY MACRO _args:VARARG
	inc qword ptr[_STOP]

	FOR _arg,<_args>
		$SetupField <_arg>													; Standard setup for {Name,1,64}
		Call _DISPLAY														;	and Display
	ENDM
	
ENDM
;
;	Enhanced to include cursor positioning
;	but only to display one item.
;
@DISPLAY_AT MACRO _x:REQ, _y:REQ, _field:REQ
				
	@CURSOR _x,_y															; Automated cursor positioning
	$SetupField <_field>													; Standard setup for {Name,1,64}
	Call _DISPLAY															; and Display
		
ENDM

;=======================================================================
;       	Macro for WORDS package
;=======================================================================
;-----------------------------------------------------------------------
;			+-------------------+	  +-------------------+
;			| REPLACE value	    |	  |  FIND counter	  |
;			+-------------------+ r15 +-------------------+	
;			|  					|	  |					  |
;			+-------------------+ r14 +-------------------+	
;			|  r_DstStart		|	  |	 				  |
;			+-------------------+ r13 +-------------------+	 	
;			|  r_DstAddress     |	   	  No -> Alpha	
;			+-------------------+ r12 +-------------------+
;			|  r_SrcLength      |	  |  r_SrcPicLength   |
;			+-------------------+ r11 +-------------------+
;			|  r_SrcStart       |	  |  r_SrcPicAddress  |
;			+-------------------+ r10 +-------------------+
;			|  r_SrcAddress     |
;			+-------------------+ r9  
;			|  r_Function       |
;			+-------------------+ r8 
;-----------------------------------------------------------------------

;--------------------------
@WORDS_COPY MACRO _src:REQ, _dst:REQ
	@WORDS $copy,<_src>,<_dst>
ENDM
;--------------------------
@WORDS_PAD MACRO _src:REQ, _dst:VARARG
	IFB <_dst>
		@WORDS $pad,<_src>
	ELSE
		@WORDS $pad,<_src>,<_dst>
	ENDIF
ENDM
;--------------------------
@WORDS_UPPERCASE MACRO _src:REQ, _dst:VARARG
	IFB <_dst>
		@WORDS $uppercase,<_src>
	ELSE
		@WORDS $uppercase,<_src>,<_dst>
	ENDIF
ENDM
;--------------------------
@WORDS_LOWERCASE MACRO _src:REQ, _dst:VARARG
	IFB <_dst>
		@WORDS $lowercase,<_src>
	ELSE
		@WORDS $lowercase,<_src>,<_dst>
	ENDIF
ENDM
;--------------------------------
@WORDS_INSERT MACRO _src:REQ, _dst:REQ
	@WORDS $insert,<_src>,<_dst>
ENDM
;----------------------------
@WORDS_FIND MACRO _src:REQ, _dst:REQ
	@WORDS $find,<_src>,<_dst>
ENDM
;----------------------------
@WORDS_REPLACE MACRO _src:REQ, _dst:REQ
	@WORDS $replace,<_src>,<_dst>
ENDM
;----------------------------
@WORDS_ENVIRONMENT MACRO _src:REQ, _dst:REQ
	@WORDS $environment,<_src>,<_dst>
ENDM;----------------------------
@WORDS_LENGTH MACRO _src:REQ, _dst:REQ
		mov rax,QWORD PTR[_src-@fieldLength]
		mov QWORD PTR[_dst],rax
ENDM
;----------------------------
@WORDS_STRINGTORECORD MACRO _string:REQ, _record:REQ
		@WORDS $stringtorecord,<_string>,_record
ENDM
;----------------------------
@WORDS_RECORDTOSTRING MACRO _record:REQ, _string:REQ
		@WORDS $recordtostring,_record,<_string>
ENDM
;***********************************************************************
@WORDS MACRO _function:REQ, _src:REQ, _dst:VARARG
		local ?Alpha, ?Numeric, ?Others, ?ReplaceFind, ?XpreCall, ?preCall

	inc qword ptr[_STOP]

		mov r_Function,_function													; Load the Function Code

	;	------------------------------------------------------------
	;	V2.05 - words.StringToRecord {w_Description,start},coaRecord
	;	------------------------------------------------------------
		IF _function EQ $stringtorecord
			LEA r10,_dst
			$NoOfParameters TEXTEQU $literalStorage <_src>							; alloctae storage
			pop r12
			IFIDNI $NoOfParameters,<2>										
				pop r13
				mov r13,QWORD PTR[r13]
			ELSE
;V3.09
;				xor r13,r13
				mov r13,1
;V3.09
			ENDIF

	;	------------------------------------------------------------
	;	V2.05 - words.RecordToString coaRecord,{w_Description,start}
	;	------------------------------------------------------------
		ELSEIF _function EQ $recordtostring
			LEA r10,_src
			$NoOfParameters TEXTEQU $literalStorage <_dst>							; alloctae storage
			pop r12
			IFIDNI $NoOfParameters,<2>										
				pop r13
				mov r13,QWORD PTR[r13]
			ELSE
;V3.09
;				xor r13,r13
				mov r13,1
;V3.09
			ENDIF
			
		ELSE
		
	;	-----
	;	V2.05
	;	-----

		IFNB <_dst>															; THIS will be a destination

		;	----------------------------------------	
		;	Get DESTINATION parameters
		;	Allows for nicer code if you do this 1st	
		;	----------------------------------------
			$NoOfParameters TEXTEQU $literalStorage <_dst>					; alloctae storage
			pop r_DstAddress												; Destination address
			LEA r_DstStart,w_One											; (Default) address of start position
			IFIDNI $NoOfParameters,<2>										; Words copy, word1, {word2,5}
				pop r_DstStart												; address of start position
			ENDIF
			IFIDNI $NoOfParameters,<3>										; Words copy, word1, {word2,5,10}
				pop r_DstStart												; address of start position
				add rsp,8													; No of Byes IS DUMPED
			ENDIF
		ENDIF
		
	;	---------------------
	;	Get SOURCE parameters	
	;	---------------------	
		$NoOfParameters TEXTEQU $literalStorage <_src>												; alloctae storage
	;	Numeric to Alpha move
		pop r_SrcAddress													; address of word
		cmp BYTE PTR[r_SrcAddress-@fieldIndicator],'X'						; If it is not numeric then
			je ?Alpha						

	;	====================================================================	
	?Numeric:
	;	Words $copy,w_Num, word0
	;	Words $copy,{w_Num,'99.999},word0
	;	Words $copy,{12345,'##,##9'},word0

		IFIDNI $NoOfParameters,<1>											; If no of parameter is 1 
			xor r_SrcPicAddress,r_SrcPicAddress								;_TOALPHA in _WORDS will sort this out
			xor r_SrcPicLength,r_SrcPicLength								;_TOALPHA in _WORDS will sort this out
		ELSE				
			pop r_SrcPicAddress												; Picture Address
			mov r_SrcPicLength,QWORD PTR[r_SrcPicAddress-@fieldLength]		; Picture Length	
		ENDIF
		mov r15,c_FALSE														; No Need to Resize	
		jmp ?preCall	
;	====================================================================
	?Alpha:
;   		Words copy, word, ....		
			LEA r_SrcStart,w_One											; (Default) address of start position
			mov r_SrcLength,r_SrcAddress									; (Default) address of No Of Bytes
			sub r_SrcLength,8												; its the string length
	
;	Test for exceptions
			test r_Function,$replace										; Test for replace
				jnz ?ReplaceFind											; jump if so
			test r_Function,$find											; Test for find
				jnz ?ReplaceFind											; jump if so	
			jmp ?Others

;	--------------------------------------------------------------------		
	?ReplaceFind:
;			Words replace {'JES','ROG',.,.}
;			Words find {'JES',counter,.,.}
			pop r15															; Get replace value/find counter

	; **NOT SURE IF THESE ARE EVER USED - cuz FIND/REPLACE only uses 2 parameters
		IFIDNI $NoOfParameters,<3>											; 
			pop r_SrcStart													; address of start position
		ENDIF
		IFIDNI $NoOfParameters,<4>											; 
			pop r_SrcStart													; address of start position
			pop r_SrcLength													; address of No Of Bytes
		ENDIF

			jmp ?XpreCall
;	--------------------------------------------------------------------

;	--------------------------------------------------------------------		
	?Others:
		IFIDNI $NoOfParameters,<2>											; Words copy, {word2,5}, word1
			pop r_SrcStart													; address of start position
		ENDIF
		IFIDNI $NoOfParameters,<3>											; Words copy, {word2,5,10}, word1 
			pop r_SrcStart													; address of start position
			pop r_SrcLength													; address of No Of Bytes
		ENDIF
	
;	====================================================================	

	?XpreCall:
		mov r_SrcStart,[r_SrcStart]											; Get source start
		mov r_SrcLength,[r_SrcLength]										; get No Of Bytes

	?preCall:
		IFNB <_dst>															; THIS will be a destination
			mov r_DstStart,[r_DstStart]										; get start position
		ELSE
			mov r_DstAddress,r_SrcAddress									; Copy the source address
			mov r_DstStart,r_SrcStart										; Copy the source start point
		ENDIF	

;	-----
;	V2.05
;	-----		
	ENDIF
	
;-----------------------------------------------------------------------				
;	%%DoCall:	
;-----------------------------------------------------------------------
		call _WORDS

ENDM

;=======================================================================
;       	NUMBERS
;=======================================================================
;-----------------------------------------------------------------------
;				   	R8			R9	R12		 
;			NUMBERS	add,		#1,	#2
;			NUMBERS subtract,	#1,	#2
;			NUMBERS multiply,	#1,	#2
;			NUMBERS divide,		#1,	#2
;			NUMBERS.CALC A,=,10,+,3,+,32.456,-,12.456
;			NUMBERS.RANDOM,		#1
;
;			NUMBERS equals,		#1, NoField
;			NUMBERS equals,		#1,{NoField/Literal,'99.99'}
;			NUMBERS equals,		#1, w_Alpha
;			NUMBERS equals,		#1,{w_Alpha,1,99}
;-----------------------------------------------------------------------
;			 
;			+-------------------+
;			|  				    |
;			+-------------------+ r15 +-------------------+	
;			|  r_nSrcPicLength  | 	  |	 r_nSrcBytes	  |
;			+-------------------+ r14 +-------------------+	
;			|  r_nSrcPicAddress	|	  |	 r_nSrcStart	  |
;			+-------------------+ r13 +-------------------+	 	
;			|  r_nSrcAddress    |	   		
;			+-------------------+ r12 +-------------------+
;			|  				    |	  |  				  |
;			+-------------------+ r11 +-------------------+
;			| 			        |	  |  				  |
;			+-------------------+ r10 +-------------------+
;			|  r_nDstAddress    |
;			+-------------------+ r9  
;			|  r_Function       |
;			+-------------------+ r8 
;
;-----------------------------------------------------------------------
@NUMBERS_EQ MACRO _arg1:REQ, _arg2:REQ
	@NUMBERS $equals,_arg1,<_arg2>
ENDM
@NUMBERS_ADD MACRO _arg1:REQ, _arg2:REQ
	@NUMBERS $add,_arg1,<_arg2>
ENDM
@NUMBERS_SUB MACRO _arg1:REQ, _arg2:REQ
	@NUMBERS $subtract,_arg1, <_arg2>
ENDM
@NUMBERS_MUL MACRO _arg1:REQ, _arg2:REQ
	@NUMBERS $multiply,_arg1,<_arg2>
ENDM
@NUMBERS_DIV MACRO _arg1:REQ, _arg2:REQ
	@NUMBERS $divide,_arg1,<_arg2>
ENDM
@NUMBERS_RANDOM MACRO _arg1:REQ, _arg2:REQ
	@NUMBERS $random,_arg1,_arg2
ENDM

;-----------------------------------------------------------------------
;			Numbers.calc num = num2 + num3 - num4 * num5 / num6
;-----------------------------------------------------------------------
@NUMBERS_CALC MACRO _args:VARARG

	local _cnt,_function
	_cnt = 0

	FOR arg,<_args>
		_cnt = _cnt + 1
		IF _cnt EQ 1
			LEA rax,arg
			mov QWORD PTR[w_SaveAddress],rax								; Save the destination

		ELSE
			IFIDNI <arg>,<=>												; set the function
				mov r8,$equals						
			ELSEIFIDNI <arg>,<+>
				mov r8,$add					
			ELSEIFIDNI <arg>,<->
				mov r8,$subtract						
			ELSEIFIDNI <arg>,<*>
				mov r8,$multiply					
			ELSEIFIDNI <arg>,</>
				mov r8,$divide
			ELSE
				mov r15,QWORD PTR[w_SaveAddress]
				@NUMBERS r8,r15,<arg>										; and make the call
			ENDIF	
		ENDIF
		
	ENDM
		
ENDM


@NUMBERS MACRO _arg1:REQ, _arg2:REQ, _arg3:=<>
	inc qword ptr[_STOP]

	mov r_Function,_arg1												; Get Function

	IFIDNI <_arg1>,<$random>											; Random Numbers are handle in COMMOM.LIB
		$NoOfParameters TEXTEQU $literalStorage <_arg2>					; Byte/Word/Dword/Qword
		pop r9
		LEA r10,_arg3													; so that I do not have to split NUMBERS.LIB
		Call _RANDOM													; into OS Versions and as they use date
																		; functions kinda ok in COMMON
	ELSE
	;	The call to [COMMON.o]No_Assist is necessary because we must detect whether there
	;	is an Alpha or Numeric field passed and as such cannot make a jmp within the rep
	;	preprocessor directive (labels would be duplicated)

;atMemory        = 34            ; 00100010
;atImmediate     = 36            ; 00100100
;atLabel         = 37            ; 10100101
;atOffset        = 38            ; 10100110
;atGlobal        = 42            ; 10101010
;atRegLabel      = 43            ; 10101011
;atRegister      = 48            ; 00110000
;atLocal         = 98            ; 01100010

;		IF (OPATTR (_arg2)) AND 00010000y								; If it's a register
		IF (OPATTR (_arg2)) EQ 48
			mov r_nDstAddress,_arg2										; It has come from _CALC
		ELSE															; ELSE from _ADD/_SUB/_DIV/_MUL
			LEA r_nDstAddress,_arg2										; Get [destination]result field
		ENDIF
	
		IFNB <_arg3>
			$NoOfParameters TEXTEQU $literalStorage <_arg3>			; Byte/Word/Dword/Qword
			mov r15,1												; Init parameter flag
			IFIDNI $NoOfParameters,<2>								; Words copy, word1, {word2,5}
				mov r15,2
			ELSEIFIDNI $NoOfParameters,<3>							; Words copy, word1, {word2,5}
					mov r15,3
			ENDIF
								
			pop r_nSrcAddress										; Grab the source
			xor r13,r13												; Clear the dual use registers
			xor r14,r14
			Call No_Assist											; get assistance to get other 1/2
				
			IFIDNI $NoOfParameters,<2>								; Words copy, word1, {word2,5}
				pop rax												; pop at least 1
			ELSEIFIDNI $NoOfParameters,<3>							; Words copy, word1, {word2,5}
					pop rax
					pop rax											; and pop if 2
			ENDIF
				
			Call _NUMBERS											; Call numbers
		ENDIF												
	ENDIF
		
ENDM

;=======================================================================
;			CONTROL statements
;=======================================================================
;=======================================================================
;       	Macros for IF
;       	COMPARE - Compare 2 items
;			r08 = Request
;				  Equals			equ 00000001b
;				  isNOTEqualTo	    equ 00000010b
;				  isLessThan	    equ 00000100b
;				  isNOTLessThan	    equ 00001000b
;				  isGreaterThan		equ 00010000b													
;				  isNOTGreaterThan	equ	00100000b
;							_IN		equ 01000000b
;							_NIN	equ 10000000b
;			r09 = 1st items address,r11,r12	
;			r13  = 2nd items address,r14
;
;			b_Result = RESULT
;				  1 True
;				  0 False
;=======================================================================
			
 	$CountParms MACRO _args:VARARG
 		local $fname,$tok,$len,$params

 		_NoOfParameters = 0
 		$tok textequ <>
 		
 		FOR _arg,<_args>	
 			_NoOfParameters = _NoOfParameters + 1
 			IF _NoOfParameters EQ 1
 				$fname textequ <_arg>
 			ELSE
 				$tok CATSTR $tok,<_arg>,<,>
 			ENDIF
 		ENDM
 		IF _NoOfParameters GT 1		
 		;	$params SUBSTR $tok,1,@SizeStr($tok)-3		; ???? the @SizeStr function returns a wrong value ???
 			$len sizestr $tok 		
 			$params SUBSTR $tok,1,$len-1									; remove last comma (3 ?)
			push QWORD PTR[RETURN_CODE]		
			
		%	@FUNCTION RETURN_CODE,$fname,<$params>
			push QWORD PTR[RETURN_CODE]
			pop  QWORD PTR[b_Result]
			pop  QWORD PTR[RETURN_CODE]
			_NoOfParameters = 0
		ENDIF

	ENDM

@IF MACRO _arg1:REQ, _arg2:=<>, _arg3:=<>
	inc qword ptr[_STOP]

	IFNB <_arg3>
		_NoOfParameters = 3
	ELSEIFNB <_arg2>
		_NoOfParameters = 2
	ELSE
		_NoOfParameters = 1
	ENDIF

;	-----------------------------------------------------------
;	SAME AS {%PUSH IF} Push a new label on the stack to jump to
;	-----------------------------------------------------------
	$pushCTX ?IF															; and push the stack

;	Replace symbols
	IF _NoOfParameters GT 1													; NOT testing a function
		$replaceSymbols _arg2
	ENDIF		

	IF _NoOfParameters EQ 1													; IF uses a function
		$CountParms _arg1
		IF _NoOfParameters EQ 1												; IF uses a function
			push QWORD PTR[RETURN_CODE]
			Call _arg1														; Call the function
			push QWORD PTR[RETURN_CODE]
			pop  QWORD PTR[b_Result]
			pop  QWORD PTR[RETURN_CODE]
		ENDIF
	ELSE
		IFIDNI <_arg2>,<_IN>												; IF uses an _IN
			mov r8,_EQ														; Setup r8 as equals
			$SetupField <_arg1>												; Setup the 1st field (r9,r10,r11)		
			$orlist _arg3													; Process the list				
		ELSEIFIDNI <_arg2>,<_NIN>											; IF uses an _NIN
			mov r8,_EQ														; Setup r8 as equals 
			$SetupField <_arg1>												; Setup the 1st field (r9,r10,r11)
			$orlist _arg3													; Process the list				
			xor QWORD PTR[b_Result],c_TRUE			
		ELSE	
		%	$SetupCompare <_arg1>,r8,<_arg3>								; Setup the compare
			Call _COMPARE													;	and call it
		ENDIF
	ENDIF
	
	cmp QWORD PTR[b_Result],0
	;	-----------------------------------------------------------------
	;	Jump to label on top of the stack - it may be an ELSE or an ENDIF
	;	-----------------------------------------------------------------
	%	$jmpToLabel je,label_01												; Jump to the label on top of the stack
			
ENDM

;	----------------------------------------------
;	The "_IF" for compound decisions (_or/_and)
;	Same as the IF but without the jump at the end
;	----------------------------------------------
@_IF MACRO _arg1:REQ, _arg2:=<>, _arg3:=<>

	IFNB <_arg3>
		_NoOfParameters = 3
	ELSEIFNB <_arg2>
		_NoOfParameters = 2
	ELSE
		_NoOfParameters = 1
	ENDIF

;	-----------------------------------------------------------
;	SAME AS {%PUSH IF} Push a new label on the stack to jump to
;	-----------------------------------------------------------
	$pushCTX ?IF															; and push the stack
	
;	Replace symbols
	IF _NoOfParameters GT 1													; NOT testing a function
		$replaceSymbols _arg2
	ENDIF		

	IF _NoOfParameters EQ 1													; IF uses a function
		$CountParms _arg1
		IF _NoOfParameters EQ 1												; IF uses a function
			push QWORD PTR[RETURN_CODE]
			Call _arg1														; Call the function
			push QWORD PTR[RETURN_CODE]
			pop  QWORD PTR[b_Result]
			pop  QWORD PTR[RETURN_CODE]
		ENDIF
	ELSE
		IFIDNI <_arg2>,<_IN>												; IF uses an _IN
			mov r8,_EQ														; Setup r8 as equals 
			$SetupField <_arg1>												; Setup the 1st field (r9,r10,r11)
			$orlist _arg3													; Process the list				

		ELSEIFIDNI <_arg2>,<_NIN>											; IF uses an _NIN
			mov r8,_EQ														; Setup r8 as equals 
			$SetupField <_arg1>												; Setup the 1st field (r9,r10,r11)
			$orlist _arg3													; Process the list				
			xor QWORD PTR[b_Result],c_TRUE			
		ELSE
	
		%	$SetupCompare <_arg1>,r8,<_arg3>								; Setup the compare
			Call _COMPARE													;	and call it
		ENDIF
	ENDIF
					
ENDM

;-----------------------------------------------------------------------
;	SEE ALSO $whenlist
;-----------------------------------------------------------------------
;	Although this is an internal routine and strictly speaking would
;	normally be coded in IMACRO.CPY it makes sense to have it here
;	cuz it is only ever referenced from the IF macro.
;	IT is used when the _IN parameter is used in an IF which is
;	refering to a list (Compund OR)[Kinda similar to overloading a macro
;-----------------------------------------------------------------------
$orlist MACRO _args:VARARG
;	IF {w_Name,1,3},_IN,{"ROGER","JESSICA","KRYSTAL","TIFFANI"}
;
	local ?Exit

	FOR _arg,<_args>
		$pushAll r9,r10,r11												; Save the already used registers (SOURCE)
		$SetupField <_arg>												; Grab the Destination field 1st
		mov r12,r9														; and copy to destination registers
		mov r13,r10
		mov r14,r11
		$popAll r11,r10,r9												; Restore the already used registers
		Call _COMPARE													; Do the compare
		cmp QWORD PTR[b_Result],c_TRUE
			je ?Exit													;	exit	
	ENDM

	?Exit:
ENDM

;-----------------------------------------------------------------------
;			_OR
;-----------------------------------------------------------------------	
@_OR MACRO _arg1:REQ, _arg2:=<>, _arg3:=<>
	local ?Exit

	inc qword ptr[_STOP]

	IFNB <_arg3>
		_NoOfParameters = 3
	ELSEIFNB <_arg2>
		_NoOfParameters = 2
	ELSE
		_NoOfParameters = 1
	ENDIF
	
	; Only need one TRUE (so make sure subsequent FALSES don't hide it) 
	;	Store result
	ctx SUBSTR label_01,1,3

	IFIDNI ctx,<?WH>
		LEA rbp,savedRegisters
		add rbp,QWORD PTR[SX]
		push QWORD PTR[rbp-08]
		pop  QWORD PTR[b_Result]	
	ENDIF

		cmp QWORD PTR[b_Result],c_TRUE
			je ?Exit

;	FUNCTION
	IF _NoOfParameters EQ 1													; IF uses a function
		$CountParms _arg1
		IF _NoOfParameters EQ 1													; IF uses a function
			push QWORD PTR[RETURN_CODE]
			Call _arg1															; Call the function
			push QWORD PTR[RETURN_CODE]
			pop  QWORD PTR[b_Result]
			pop  QWORD PTR[RETURN_CODE]
		ENDIF
	ENDIF

	;	WHEN IN/NIN or WHEN = 1	
	IF _NoOfParameters EQ 2
		IFIDNI <_arg1>,<_IN>
			mov r8,_EQ														; Setup r8 as equals 
			$whenlist _arg2													; Process the list				
		ELSEIFIDNI <_arg1>,<_NIN>											; IF uses an _NIN
			mov r8,_EQ														; Setup r8 as equals 
			$whenlist _arg2													; Process the list				
			xor QWORD PTR[b_Result],c_TRUE			
		ELSE
		;	WHEN %1,{%2}													; then it must be =1 (or suchlike)
			$replaceSymbols _arg1
			$SetupCompare 0,r8,<_arg2>										; We are doing a TEST Variable	
			$restoreRegisters r9,r10,r11,rax
			call _COMPARE	
		ENDIF	
	ENDIF
	
	;	STANDARD IF's OR
	IF _NoOfParameters EQ 3
		IFIDNI <_arg2>,<_IN>
			mov r8,_EQ														; Setup r8 as equals 
			$SetupField <_arg1>												; Setup the 1st field (r9,r10,r11)
			$orlist _arg3													; Process the list
		ELSEIFIDNI <_arg2>,<_NIN>											; IF uses an _NIN
			mov r8,_EQ														; Setup r8 as equals 
			$SetupField <_arg1>												; Setup the 1st field (r9,r10,r11)
			$orlist _arg3													; Process the list
			xor QWORD PTR[b_Result],c_TRUE									; and reverse the result
		ELSE
			$replaceSymbols _arg2
		%	$SetupCompare <_arg1>,r8,<_arg3>								; We are doing a TEST Variable	
			call _COMPARE	
		ENDIF	
	ENDIF

	;	Store result
	IFIDNI ctx,<?WH>
		mov rax,QWORD PTR[b_Result]
		LEA rbp,savedRegisters
		add rbp,QWORD PTR[SX]
		mov QWORD PTR[rbp-08],rax
	ENDIF

	?Exit:
ENDM

;-----------------------------------------------------------------------
;			.AND
;-----------------------------------------------------------------------
@_AND MACRO _arg1:REQ, _arg2:=<>, _arg3:=<>
	local ?Exit

	inc qword ptr[_STOP]

	IFNB <_arg3>
		_NoOfParameters = 3
	ELSEIFNB <_arg2>
		_NoOfParameters = 2
	ELSE
		_NoOfParameters = 1
	ENDIF
	
	; Only go ahead if we have a previous TRUE 
	ctx SUBSTR label_01,1,3

	IFIDNI ctx,<?WH>
		LEA rbp,savedRegisters
		add rbp,QWORD PTR[SX]
		push QWORD PTR[rbp-08]
		pop  QWORD PTR[b_Result]	
	ENDIF

		cmp QWORD PTR[b_Result],c_FALSE
			je ?Exit
				
		;	FUNCTION
	IF _NoOfParameters EQ 1													; IF uses a function
		$CountParms _arg1
		IF _NoOfParameters EQ 1													; IF uses a function
			push QWORD PTR[RETURN_CODE]
			Call _arg1															; Call the function
			push QWORD PTR[RETURN_CODE]
			pop  QWORD PTR[b_Result]
			pop  QWORD PTR[RETURN_CODE]
		ENDIF
	ENDIF


	;	WHEN IN or WHEN = 1	
	IF _NoOfParameters EQ 2
		IFIDNI <_arg1>,<_IN>
			mov r8,_EQ														; Setup r8 as equals 
			$whenlist _arg2													; Process the list				
		ELSEIFIDNI <_arg1>,<_NIN>											; IF uses an _NIN
			mov r8,_EQ														; Setup r8 as equals 
			$whenlist _arg2													; Process the list				
			xor QWORD PTR[b_Result],c_TRUE			
		ELSE
		;	WHEN %1,{%2}													; then it must be =1 (or suchlike)
			$replaceSymbols _arg1
			$SetupCompare 0,r8,<_arg2>										; We are doing a TEST Variable	
			$restoreRegisters r9,r10,r11,rax
			call _COMPARE	
		ENDIF	
	ENDIF
		
	;	STANDARD IF's OR
	IF _NoOfParameters EQ 3
		IFIDNI <_arg2>,<_IN>
			mov r8,_EQ														; Setup r8 as equals 
			$SetupField <_arg1>												; Setup the 1st field (r9,r10,r11)
			$orlist _arg3													; Process the list
		ELSEIFIDNI <_arg2>,<_NIN>											; IF uses an _NIN
			mov r8,_EQ														; Setup r8 as equals 
			$SetupField <_arg1>												; Setup the 1st field (r9,r10,r11)
			$orlist _arg3													; Process the list
			xor QWORD PTR[b_Result],c_TRUE									; and reverse the result
		ELSE
			$replaceSymbols _arg2
		%	$SetupCompare <_arg1>,r8,<_arg3>								; We are doing a TEST Variable	
			call _COMPARE	
		ENDIF	
	ENDIF

	;	Store result
	IFIDNI ctx,<?WH>
		mov rax,QWORD PTR[b_Result]
		LEA rbp,savedRegisters
		add rbp,QWORD PTR[SX]
		mov QWORD PTR[rbp-08],rax
	ENDIF

	?Exit:
ENDM

;-----------------------------------------------------------------------
;			.END
;-----------------------------------------------------------------------
@_END MACRO
	inc qword ptr[_STOP]

	ctx SUBSTR label_01,1,3

	IFIDNI ctx,<?IF>
		cmp QWORD PTR[b_Result],c_FALSE
		%	$jmpToLabel je,label_01
	ENDIF

	IFIDNI ctx,<?WH>
		LEA rbp,savedRegisters
		add rbp,QWORD PTR[SX]
		cmp QWORD PTR[rbp-08],c_FALSE
		%	$jmpToLabel je,label_01
	ENDIF

ENDM

;-----------------------------------------------------------------------
;			ELSE
;-----------------------------------------------------------------------
@ELSE MACRO
;	-----------------------------------------------------------
;	Replace the label on the top of the stack and jump to it
;	-----------------------------------------------------------
	_saveLabel TEXTEQU label_01												; save the label on top of the stack
	labelCnt = labelCnt + 1													; Increment the label counter
	label_01 CATSTR <?IE>,%labelCnt											; replace the existing label on top of stack
%	$jmpToLabel jmp,label_01												; now jump to it

	inc qword ptr[_STOP]

;	-----------------------------------
;	CREATE LABEL HERE FOR IF TO JUMP TO 
;	-----------------------------------
% 	$createLabel _saveLabel													; Label for jump to ELSE

ENDM

;-----------------------------------------------------------------------
;			END.IF
;-----------------------------------------------------------------------
@END_IF MACRO
% 	$createLabel label_01													; create the label from the top of the stack
	$popCTX																	; and pop the stack

	inc qword ptr[_STOP]


ENDM

;-----------------------------------------------------------------------
;			BEGIN.TEST
;-----------------------------------------------------------------------
;	BEGIN.TEST %1 where
;		%1 may be:-
;			BEGIN.TEST 'Hello'				a Alphabetic Literal
;			BEGIN.TEST 1					a Numeric Literal
;			BEGIN.TEST w_Alpha				a Word from the Dictionary
;			BEGIN.TEST w_Num				a Number from the Matrix
;			BEGIN.TEST c_TRUE				the system constant c_TRUE
;-----------------------------------------------------------------------
@BEGIN_TEST MACRO _arg:REQ
	inc qword ptr[_STOP]

;  %PUSH TEST
;	-----------------------------------------------------------
;	SAME AS {%PUSH IF} Push a new label on the stack to jump to
;	-----------------------------------------------------------
	$pushCTX ?TS														; and push the stack

	$SetupField <_arg>													; Get 1st parameter			
	$saveRegisters r9,r10,r11,0
			
ENDM

;-----------------------------------------------------------------------
;			WHEN
;-----------------------------------------------------------------------
;	WHEN %1,%2,[%3]
;		WHEN c_TRUE is coded in the BEGIN.TEST keyword
;			%1,%2,%3 take the form of the standard IF keyword
;	WHEN %1,%2
;		%1 = Comparison (=,<,>,!=,!<,!>)
;		%2 = The thing to be compared
;				BEGIN.TEST number
;	`				WHEN = 1
;					WHEN _IN {1,2,3,4,5}
;	WHEN %1
;		WHEN function_name
;-----------------------------------------------------------------------
@WHEN MACRO _arg1:REQ, _arg2:=<>, _arg3:=<>
	inc qword ptr[_STOP]

	
;	-----------------------------------------------------------
;	SAME AS {%PUSH WHEN} Push a new label on the stack to jump to
;	-----------------------------------------------------------
	$pushCTX ?WH														; and push the stack
	
	IFB <_arg2>
		$CountParms _arg1
		IF _NoOfParameters EQ 1													; IF uses a function
			push QWORD PTR[RETURN_CODE]
			Call _arg1															; Call the function
			push QWORD PTR[RETURN_CODE]
			pop  QWORD PTR[b_Result]
			pop  QWORD PTR[RETURN_CODE]
		ENDIF
	ELSE
		IFIDNI <_arg1>,<_IN>
			mov r8,_EQ														; Setup for equals 
			$whenlist _arg2													; Process the list
		ELSE
			IFIDNI <_arg1>,<_NIN>
				mov r8,_EQ													; Setup for equals 
				$whenlist _arg2												; and do when list
				xor QWORD PTR[b_Result],c_TRUE								; and reverse the result
			ELSE
				IFB <_arg3>
					$replaceSymbols _arg1
					$SetupCompare 0,r8,<_arg2>								; We are doing a TEST Variable	
					$restoreRegisters r9,r10,r11,rax
				ELSE
					$replaceSymbols _arg2									; We are doing a TEST TRUE
				%	$SetupCompare <_arg1>,r8,<_arg3>	
				ENDIF
			ENDIF
			call _COMPARE
		ENDIF
	ENDIF

;	Store result
	mov rax,QWORD PTR[b_Result]
	LEA rbp,savedRegisters
	add rbp,QWORD PTR[SX]
	mov QWORD PTR[rbp-08],rax
	
	cmp  QWORD PTR[b_Result],c_FALSE
	
	;	-----------------------------------------------------------------
	;	Jump to label on top of the stack - it may be an ELSE or an ENDIF
	;	-----------------------------------------------------------------
	%	$jmpToLabel je,label_01												; Jump to the label on top of the stack
	
ENDM

@_WHEN MACRO _arg1:REQ, _arg2:=<>, _arg3:=<>
	inc qword ptr[_STOP]


;	-----------------------------------------------------------
;	SAME AS {%PUSH WHEN} Push a new label on the stack to jump to
;	-----------------------------------------------------------
	$pushCTX ?WH														; and push the stack
	
	IFB <_arg2>
		$CountParms _arg1
		IF _NoOfParameters EQ 1													; IF uses a function
			push QWORD PTR[RETURN_CODE]
			Call _arg1															; Call the function
			push QWORD PTR[RETURN_CODE]
			pop  QWORD PTR[b_Result]
			pop  QWORD PTR[RETURN_CODE]
		ENDIF
	ELSE
		IFIDNI <_arg1>,<_IN>
			mov r8,_EQ														; Setup for equals 
			$whenlist _arg2													; Process the list
		ELSEIFIDNI <_arg1>,<_NIN>
			mov r8,_EQ														; Setup for equals 
			$whenlist _arg2													; and do when list
			xor QWORD PTR[b_Result],c_TRUE									; and reverse the result
		ELSE
			IFB <_arg3>
				$replaceSymbols _arg1
				$SetupCompare 0,r8,<_arg2>									; We are doing a TEST Variable	
				$restoreRegisters r9,r10,r11,rax
			ELSE			
				$replaceSymbols _arg2										; We are doing a TEST TRUE
			%	$SetupCompare <_arg1>,r8,<_arg3>
			ENDIF
			call _COMPARE
		ENDIF
	ENDIF

;	Store result
	mov rax,QWORD PTR[b_Result]
	LEA rbp,savedRegisters
	add rbp,QWORD PTR[SX]
	mov QWORD PTR[rbp-08],rax

ENDM

;-----------------------------------------------------------------------
;	SEE ALSO $orlist
;-----------------------------------------------------------------------
;	Although this is an internal routine and strictly speaking would
;	normally be coded in IMACRO.CPY it makes sense to have it here
;	cuz it is only ever referenced from the IF/WHEN macro.
;	IT is used when the _IN parameter is used in an IF which is
;	refering to a list (Compund OR)[Kinda similar to overloading a macro
;-----------------------------------------------------------------------
$whenlist MACRO _args:VARARG
;	WHEN _IN,{"ROGER","JESSICA","KRYSTAL","TIFFANI"}
		
	local ?Exit

	FOR _arg,<_args>
		$SetupField <_arg>												; Grab the Destination field 1st
		mov r12,r9														; and copy to destination registers
		mov r13,r10
		mov r14,r11
		$restoreRegisters r9,r10,r11,rax
		Call _COMPARE													; Do the compare
		cmp QWORD PTR[b_Result],c_TRUE
			je ?Exit													;	exit					
	ENDM

	?Exit:
ENDM

;-----------------------------------------------------------------------
;			OTHERWISE - needed to terminate WHEN's
;-----------------------------------------------------------------------
@WEND MACRO
	inc qword ptr[_STOP]

;	  %$WEND:
;	  %POP

% 	$createLabel label_01													; create the label from the top of the stack
	$popCTX																	; and pop the stack


;	Get result
	LEA rbp,savedRegisters
	add rbp,QWORD PTR[SX]
	
	cmp QWORD PTR[rbp-08],c_TRUE
%	$jmpToLabel je,label_01													; now jump to it
		
ENDM

;-----------------------------------------------------------------------
;			OTHERWISE
;-----------------------------------------------------------------------
@OTHERWISE MACRO
	inc qword ptr[_STOP]

ENDM

;-----------------------------------------------------------------------
;			END.TEST same as END.IF
;-----------------------------------------------------------------------
@END_TEST MACRO	
;	  %$END.TEST:
;	  %POP

% 	$createLabel label_01													; create the label from the top of the stack
	$popCTX																	; and pop the stack

	inc qword ptr[_STOP]

	sub QWORD PTR[SX],40
		
ENDM
	

;=======================================================================
;       	Macros for looping (REPEAT.IF)
;=======================================================================
@REPEAT_WHILE MACRO _arg1:REQ, _arg2:=<>, _arg3:=<>

	IFB <_arg2>
		@REPEAT_IF <_arg1>
	ELSE
		@REPEAT_IF <_arg1>, <_arg2>, <_arg3>
	ENDIF
		
ENDM

@REPEAT_IF MACRO _arg1:REQ, _arg2:=<>, _arg3:=<>
	inc qword ptr[_STOP]

 
	IFNB <_arg3>
		_NoOfParameters = 3
	ELSEIFNB <_arg2>
		_NoOfParameters = 2
	ELSE
		_NoOfParameters = 1
	ENDIF

;	---------------------------------------------------------------
;	SAME AS {%PUSH REPEAT} Push a new label on the stack to jump to
;	---------------------------------------------------------------
	$pushCTX ?REPEAT					; and push the stack (Start Address)
	$pushCTX ?REPEAT					; and push the stack (End Address)

;	Replace symbols

	IF _NoOfParameters GT 1													; NOT testing a function
		$replaceSymbols _arg2
	ENDIF		

;	IF _NoOfParameters GT 1													; NOT testing a function
		$saveRegisters r8,0,0,0
;	ENDIF		

	mov QWORD PTR[exitRepeat],c_FALSE
	
		  ; --> LOOP BEGINS HERE
% 	$createLabel label_02													; create the label for the start address
	cmp QWORD PTR[exitRepeat],c_TRUE
	%	$jmpToLabel je,label_01

	IF _NoOfParameters GT 1
		$restoreRegisters r8,rax,rax,rax
		$SetupCompare <_arg1>,r8,<_arg3>
		Call _COMPARE														; Do the compare
	ELSE
		$CountParms _arg1
		IF _NoOfParameters EQ 1													; IF uses a function
			push QWORD PTR[RETURN_CODE]
			Call _arg1															; Call the function
			push QWORD PTR[RETURN_CODE]
			pop  QWORD PTR[b_Result]
			pop  QWORD PTR[RETURN_CODE]
		ENDIF
	ENDIF		
	
	;	Are we done
		cmp QWORD PTR[b_Result],c_FALSE
	%	$jmpToLabel je,label_01
				
ENDM

;=======================================================================
;       	Macros for looping (REPEAT.FOR)
;=======================================================================
;			+-------------------+	 	
;			|  EndValueAddress  |	   		
;			+-------------------+ r12 (%3)
;			|  				    |	
;			+-------------------+ r11 
;			|  			        |
;			+-------------------+ r10 
;			|  Counter Address  |
;			+-------------------+ r9  (%1)  
;			|  GT/LT	        |
;			+-------------------+ r8 
;-----------------------------------------------------------------------
@REPEAT_FOR MACRO _arg1:REQ, _arg2:REQ, _arg3:REQ, _arg4:=<>
	local ?cont, ?gt, ?lt, ?Exit

	inc qword ptr[_STOP]

	IFNB <_arg4>
		_NoOfParameters = 4
	ELSE
		_NoOfParameters = 3
	ENDIF

;	---------------------------------------------------------------
;	SAME AS {%PUSH REPEAT} Push a new label on the stack to jump to
;	---------------------------------------------------------------
	$pushCTX ?REPEAT					; and push the stack (Start Address)
	$pushCTX ?REPEAT					; and push the stack (End Address)

	$NoOfParameters TEXTEQU $literalStorage <_arg1>							; get the address of the source													
		pop r9
		xor r10,r10
		xor r11,r11
	$NoOfParameters TEXTEQU $literalStorage <_arg3>							; get the address of the destination
		pop r12																
		xor r13,r13
		xor r14,r14
	IF _NoOfParameters EQ 4		
		$NoOfParameters TEXTEQU $literalStorage <_arg4>
		pop r15																; If step is coded then
		mov r15,QWORD PTR[r15]												;	get the VALUE of the step
	ELSE
		mov r15,1
	ENDIF

;	Start value
	$NoOfParameters TEXTEQU $literalStorage <_arg2>							; get the address of the start value
		pop rax																; Set up the counter with the start value
		mov rax,QWORD PTR[rax]
		mov QWORD PTR[r9],rax
					
		  ; Counting up or counting down
			mov r8,_NEQ
			mov rax,QWORD PTR[r9]
			cmp rax,QWORD PTR[r12]
				je ?cont
				jb ?gt
				ja ?lt
	?gt:	mov r8,_GT
			jmp ?cont
	?lt:	mov r8,_LT
			neg r15	

	; 	Setup & save Compare values
	?cont:	
		$saveRegisters r8,r9,r12,r15
		mov QWORD PTR[exitRepeat],c_FALSE
		jmp ?Exit															; go and process

  ; Loop begins here
  % 	$createLabel label_02												; create the label for the start address
		cmp QWORD PTR[exitRepeat],c_TRUE
		%	$jmpToLabel je,label_01
		  
		$restoreRegisters r8,r9,r12,r15								
		xor r10,r10
		xor r11,r11
		xor r13,r13
		xor r14,r14
		add QWORD PTR[r9],r15												; add to the counter			
		Call _COMPARE														; Do the compare

		cmp QWORD PTR[b_Result],c_TRUE
		%	$jmpToLabel je,label_01

	?Exit:	
ENDM

;=======================================================================
;       	Macros for looping (EXIT.REPEAT)
;=======================================================================
@EXIT_REPEAT MACRO
	inc qword ptr[_STOP]
	
	@integers_eq exitRepeat,c_TRUE	
								
ENDM

;=======================================================================
;       	Macros for looping (END.REPEAT)
;=======================================================================
@END_REPEAT MACRO
	
;		jmp %$START.REPEAT													; Within the context stack
	%	$jmpToLabel jmp,label_02

	% 	$createLabel label_01												; create the label for the end address

	inc qword ptr[_STOP]
	
		mov QWORD PTR[exitRepeat],c_FALSE
		sub QWORD PTR[SX],40   												; saveRegisters adds to this
			
	$popCTX																	; End the Context Stack
	$popCTX
	
ENDM

;=======================================================================
;       	Macro for FILES package
;=======================================================================
;-----------------------------------------------------------------------
;			+-------------------+  
;			| Open for | Record | 	  (OPEN) RW+[Beginning/End] | Record No | String,String,String
;			+-------------------+ r10 
;			|  FileName         | 	  I-Name/X-Name
;			+-------------------+ r9  
;			|  Function         | 	  Open/Close/Read/Write
;			+-------------------+ r8  1st Parameter
;-----------------------------------------------------------------------
;		FileStatus		+-----------+--------+-------------+----+
;	+---+---+---+---+---|	db      |  dq    | db		   |0x00|
;	| 1	|'9'|Len|Val|Pic+-----------+--------+-------------+----+
;	+---+---+---+---+---| delimiter | Handle | Int[ExtName]|    |
;		AsPer INSERTNO	+-----------+--------+-------------+----+
;				-19		-9			-8		 0
;					c_NONE			equ 00000000b
;					c_NULL			equ 00000001b 
;					c_LF			equ 00000010b 
;					c_CSV			equ 00000100b
;					c_RECORD		equ 00001000b
;					c_Random		equ 00010000b 
;-----------------------------------------------------------------------
;			INSERTFILE Delimiter,I-Name,'./X-Name'
;					   c_NONE,c_NULL,c_LF,c_CSV,c_RECORD,c_Random
;-----------------------------------------------------------------------
;							  R8	 		R9		R10									
;			OPEN	*	FILES $open,		I_Name, R/W/RW[Beginning/End]/Lock
;			READ	*	FILES $read,  		I_Name, record/{String,1,1},{String,1,1},etc
;			WRITE	*	FILES $write, 		I_Name, record/{String,1,1},{String,1,1},etc
;			DELETE	*	FILES $delete,		I_Name, record,recNo?
;			CLOSE	*	FILES $close, 		I_Name
;			START	*	FILES $start, 		I_Name, record,recNo?
;			NEXT	*	FILES $next,  		I_Name, record
;			COPY	*	FILES $filescopy,	I-from,	I-to
;			RENAME	*	FILES $rename,		X-from,	X-to
;			REMOVE	*	FILES $remove,		X-Name
;			CHDIR	*	FILES $chdir,		X-Name
;			GETCWD	*	FILES $getcwd,		X-Name
;			LOCK	*	FILES $lock,		I_NAME,	record
;			UNLOCK	*	FILES $unlock,		I_NAME,	record
;-----------------------------------------------------------------------

@FILES_OPEN MACRO _name:REQ,_position:=<>

	IFB <_position>
		@FILES $open,_name
	ELSE
		@FILES $open,_name,_position
	ENDIF
	
ENDM
;--------------------------
@FILES_READ MACRO _name:REQ,_record:REQ,_recNo:=<>

	IFB <_recNo>
		@FILES $read,_name,_record
	ELSE
		@FILES $read,_name,_record,_recNo
	ENDIF
	
ENDM
;--------------------------
@FILES_WRITE MACRO _name:REQ,_record:REQ,_recNo:=<>

	IFB <_recNo>	
		@FILES $write,_name,_record
	ELSE
		@FILES $write,_name,_record,_recNo
	ENDIF

ENDM
;--------------------------
@FILES_DELETE MACRO _name:REQ,_record:REQ,_recNo:=<>

	IFB <_recNo>
		@FILES $delete,_name,_record
	ELSE
		@FILES $delete,_name,_record,_recNo
	ENDIF
	
ENDM
;--------------------------
@FILES_CLOSE MACRO _name:REQ
	@FILES $close,_name
ENDM
;--------------------------
@FILES_START MACRO _name:REQ,_record:REQ,_recNo:=<>

	IFB <_recNo>
		@FILES $start,_name,_record
	ELSE
		@FILES $start,_name,_record,_recNo
	ENDIF
	
ENDM
;--------------------------
@FILES_NEXT MACRO _name:REQ,_record:REQ
	@FILES $next,_name,_record
ENDM

;--------------------------
@FILES_LOCK MACRO _name:REQ,_record:REQ,_recNo:=<>

	IFB <_recNo>
		@FILES $rlock,_name,_record
	ELSE
		@FILES $rlock,_name,_record,_recNo
	ENDIF
	
ENDM
;--------------------------
@FILES_UNLOCK MACRO _name:REQ,_record:REQ,_recNo:=<>

	IFB <_recNo>
		@FILES $runlock,_name,_record
	ELSE
		@FILES $runlock,_name,_record,_recNo
	ENDIF
	
ENDM
;--------------------------
@FILES_COPY MACRO _src:REQ,_dst:REQ

	@FILES $filescopy,_src,_dst
	
ENDM
;--------------------------
@FILES_RENAME MACRO _oldName:REQ,_newName:REQ

	@FILES $rename,_oldName,newName
	
ENDM
;--------------------------
@FILES_REMOVE MACRO _name

	@FILES $remove,_name
	
ENDM
;--------------------------
@FILES_CHDIR MACRO _name:REQ

	@FILES $chdir,_name
	
ENDM
;--------------------------
@FILES_GETCWD MACRO _name:REQ

	@FILES $getcwd,_name
	
ENDM

;--------------------------
@FILES MACRO _function:REQ,_name:REQ,_args:VARARG
		local ?IF1, ?EndIf1, ?Exit
		local ?records, ?fields
		local _arg03, _arg04
		
	inc qword ptr[_STOP]

		mov r_Function,_function											; Function
		LEA r_File,_name													; File address

		_ctr = 0
		_arg03	TEXTEQU <>
		_arg04	TEXTEQU <>

		FOR _arg,<_args>
			_ctr = _ctr + 1
			IF _ctr EQ 1
				IFNB <_arg>
					_arg03 TEXTEQU <_arg>
				ENDIF
			ENDIF
			IF _ctr EQ 2
				IFNB <_arg>
					_arg04 TEXTEQU <_arg>
				ENDIF
			ENDIF
		ENDM

	;	----------------------------------
	;	Consolidate the readwrite function
	;	----------------------------------	
		ReadWrite = 0
		IF _function EQ $read
			ReadWrite = 1
		ENDIF
		IF _function EQ $write
			ReadWrite = 1
		ENDIF
		IF _function EQ $start
			ReadWrite = 1
		ENDIF
		IF _function EQ $next
			ReadWrite = 1
		ENDIF

;		----------------------------------------------------
;		COPY
;		----------------------------------------------------
		IF _function EQ $filescopy
			LEA	r10,_arg03													; Outfile name
			Call _FILEIO
		ENDIF
	
;		----------------------------------------------------
;		RENAME
;		----------------------------------------------------
		IF _function EQ $rename
			LEA r10,_arg03													; New Name
			Call _FILEIO
		ENDIF

;		----------------------------------------------------
;		REMOVE
;		----------------------------------------------------
		IF _function EQ $remove
			Call _FILEIO
		ENDIF

;		----------------------------------------------------
;		CHDIR
;		----------------------------------------------------			
		IF _function EQ $chdir
			$NoOfParameters TEXTEQU $literalStorage <_name>					; allocate storage
			pop r9
			Call _FILEIO
		ENDIF

;		----------------------------------------------------
;		GETCWD
;		----------------------------------------------------			
		IF _function EQ $getcwd
			$NoOfParameters TEXTEQU $literalStorage <_name>					; allocate storage
			pop r9															; setup rdi
			Call _FILEIO
		ENDIF

;		----------------------------------------------------
;		OPEN FILE
;		----------------------------------------------------
		IF _function EQ $open
			IFNB _arg03														; If 3 parameters passed
				mov r_FileFlags,_arg03										;	then setup File Flags
			ELSE															; ELSE
				mov r_FileFlags,$beginning									;	default to beginning
			ENDIF
			Call _FILEIO
		ENDIF
	
;		----------------------------------------------------------------
;		CLOSE FILE
;		----------------------------------------------------------------					
		IF _function EQ $close
			Call _FILEIO
		ENDIF

;		----------------------------------------------------
;		DELETE
;		----------------------------------------------------
		IF _function EQ $delete
			LEA	r10,_arg03
			IFNB _arg04		
				$NoOfParameters TEXTEQU $literalStorage <%_arg04>			; allocate storage			
				pop r15
				mov r15,QWORD PTR[r15]
				mov QWORD PTR[r_Record-@recordNo],r15
			ENDIF
			Call _FILEIO
		ENDIF

;		----------------------------------------------------
;		LOCK
;		----------------------------------------------------			
		IF _function EQ $rlock
			LEA	r10,_arg03
			IFNB _arg04
				$NoOfParameters TEXTEQU $literalStorage <%_arg04>			; allocate storage
				pop r15
				mov r15,QWORD PTR[r15]
				mov QWORD PTR[r_Record-@recordNo],r15
			ENDIF
			Call _FILEIO
		ENDIF
		
;		----------------------------------------------------
;		UNLOCK
;		----------------------------------------------------			
		IF _function EQ $runlock
			LEA	r10,_arg03
			IFNB _arg04
				$NoOfParameters TEXTEQU $literalStorage <%_arg04>			; allocate storage
				pop r15
				mov r15,QWORD PTR[r15]
				mov QWORD PTR[r_Record-@recordNo],r15
			ENDIF
			Call _FILEIO
		ENDIF	
	
;		----------------------------------------------------------------
;		DIRECTORY
;		----------------------------------------------------------------
		IF _function EQ $read					
	?IF1:	cmp BYTE PTR[r_File-@fileDelimiter],c_DIRECTORY
				jne ?EndIf1
			LEA r10,_arg03
			call _FILEIO
			jmp ?Exit
	?EndIf1:
		ENDIF

;		----------------------------------------------------
;		RECORDS OR FIELDS
;		----------------------------------------------------	
	IF ReadWrite EQ 1

		if (opattr (@catstr(<_name>,<_R>))) and 00000001y

		;	------------
		;	RECORDS
		;	------------
			IFNB _arg03
				$NoOfParameters TEXTEQU $literalStorage <_arg03>			; allocate storage
				pop r_Record
			ENDIF		

			IFNB _arg04	
				$NoOfParameters TEXTEQU $literalStorage <%_arg04>			; allocate storage
				pop r15
				mov r15,QWORD PTR[r15]
				mov QWORD PTR[r_Record-@recordNo],r15				
			ENDIF

			Call _FILEIO
			jmp  ?Exit

		Else

	;	------------------------------------------------------------
	;	READ/WRITE FIELDS
	;	------------------------------------------------------------		
		;	----
		;	READ
		;	----	
			IF _function EQ $read
				call _FILEIO
				cmp QWORD PTR[r_File-@fileStatus],10						; End of File	
					je ?Exit
			ENDIF

		;	------------------
		;	LOAD/UNLOAD FIELDS
		;	------------------				
			LEA RSI,w_RecordBuffer											; FROM FIELDS-Offset of Record Buffer
			LEA RDI,w_RecordBuffer											; TO FIELDS-Offset of Record Buffer
			LEA r15,_name													; (FileName) To pass to _FIELDS

		;	Loop thru the fields and build w_RecordBuffer
			FOR _arg,<_args>
	 			IFNB <_arg>
	 				$SetupField <_arg>										; Standard setup for {Name,1,64}
	 				Call _FIELDS											;	and Display
	 				mov QWORD PTR[w_SaveAddress],r9							; Need to save the last field for CSV process				
	 			ENDIF
		
	 		ENDM

		;	-----
		;	WRITE
		;	-----
			IF _function EQ $write
				Call _DELIMITER												; Adds the delimeter/Remove comma from CSV
				LEA r_File,_name											; RE-get filename (is crapped on in above code)
				LEA r_Record,w_RecordBuffer									; Offset of Record Buffer
				call _FILEIO	
			ENDIF

		ENDIF
		
	ENDIF
		
	?Exit:
ENDM

;=======================================================================
;       	Macro for TABLES package
;			TABLES bind,WorkTable,A01_Record,Idx,Idx,...
;=======================================================================
;-----------------------------------------------------------------------
; 		TableStatus		Dimension Value	 								Table Indicator									 
;	+---+---+---+---+---+---+---+---+---+---+---+---+---+---------------+---+---------+------+---+---+---+---+---+---+---+---+	     
;	| 1	|'9'|Len|Val|Pic|Idx|Idx|Idx|Idx|Idx|Idx|Idx|Idx|Record Address	|'T'|NoOfBytes| NAME |Idx|Idx|Idx|Idx|Idx|Idx|Idx|Idx|	
;	+---+---+---+---+---+---+---+---+---+---+---+---+---+---------------+---+---------+------+---+---+---+---+---+---+---+---+ 
;	-108-100-99	-91	    -81 -73	-65	-57	-49	-41	-33	-25	-17			   -9	-8		   0	  No Of Bytes +
;															       						 	 8  16  24  32  40  48  56  64  72
;
;		INSERTTABLE WorkTable,A01_Record_Length*Idx*Idx*Idx*Idx*Idx*Idx*Idx*Idx
;-----------------------------------------------------------------------
;				   R8		R9		  R10		 
;			TABLES bind,	WorkTable,A01_Record,Idx1,Idx2,Idx3....Idx8
;			TABLES rget,	WorkTable,Idx1,Idx2,Idx3....Idx8
;			TABLES rput,	WorkTable,Idx1,Idx2,Idx3....Idx8
;			TABLES sort,	WorkTable,Start,End
;			TABLES search,	WorkTable,Start,End,SearchItem,Index
;				   R8		R9		  R10	  R11
;			TABLES fget, 	WorkTable,FieldNo,FieldName,Idx1,Idx2,Idx3....Idx8
;			TABLES fput, 	WorkTable,FieldNo,FieldName,Idx1,Idx2,Idx3....Idx8
;-----------------------------------------------------------------------
@TABLES_BIND MACRO _name:REQ, _record:REQ, _idx1:REQ, _idx2:=<>, _idx3:=<>, _idx4:=<>, \
                                           _idx5:=<>, _idx6:=<>, _idx7:=<>, _idx8:=<>

    IFB <_idx2>
		@TABLES $bind,_name,_record,_idx1
	ELSEIFB <_idx3>
		@TABLES $bind,_name,_record,_idx1,_idx2
	ELSEIFB <_idx4>
		@TABLES $bind,_name,_record,_idx1,_idx2,_idx3
	ELSEIFB <_idx5>
		@TABLES $bind,_name,_record,_idx1,_idx2,_idx3,_idx4
	ELSEIFB <_idx6>
		@TABLES $bind,_name,_record,_idx1,_idx2,_idx3,_idx4,_idx5
	ELSEIFB <_idx7>
		@TABLES $bind,_name,_record,_idx1,_idx2,_idx3,_idx4,_idx5,_idx6
	ELSEIFB <_idx8>
		@TABLES $bind,_name,_record,_idx1,_idx2,_idx3,_idx4,_idx5,_idx6,_idx7
	ELSE
		@TABLES $bind,_name,_record,_idx1,_idx2,_idx3,_idx4,_idx5,_idx6,_idx7,_idx8
	ENDIF

ENDM
;--------------------------
@TABLES_rGET MACRO _name:REQ, _idx1:REQ, _idx2:=<>, _idx3:=<>, _idx4:=<>, \
                              _idx5:=<>, _idx6:=<>, _idx7:=<>, _idx8:=<>

    IFB <_idx2>
		@TABLES $rget,_name,_idx1
	ELSEIFB <_idx3>
		@TABLES $rget,_name,_idx1,_idx2
	ELSEIFB <_idx4>
		@TABLES $rget,_name,_idx1,_idx2,_idx3
	ELSEIFB <_idx5>
		@TABLES $rget,_name,_idx1,_idx2,_idx3,_idx4
	ELSEIFB <_idx6>
		@TABLES $rget,_name,_idx1,_idx2,_idx3,_idx4,_idx5
	ELSEIFB <_idx7>
		@TABLES $rget,_name,_idx1,_idx2,_idx3,_idx4,_idx5,_idx6
	ELSEIFB <_idx8>
		@TABLES $rget,_name,_idx1,_idx2,_idx3,_idx4,_idx5,_idx6,_idx7
	ELSE
		@TABLES $rget,_name,_idx1,_idx2,_idx3,_idx4,_idx5,_idx6,_idx7,_idx8
	ENDIF
				
ENDM
;--------------------------
@TABLES_rPUT MACRO _name:REQ, _idx1:REQ, _idx2:=<>, _idx3:=<>, _idx4:=<>, \
                              _idx5:=<>, _idx6:=<>, _idx7:=<>, _idx8:=<>

;	Macro expansion here to allow for numeric constants

    IFB <_idx2>
		@TABLES $rput,_name,_idx1
	ELSEIFB <_idx3>
		@TABLES $rput,_name,_idx1,_idx2
	ELSEIFB <_idx4>
		@TABLES $rput,_name,_idx1,_idx2,_idx3
	ELSEIFB <_idx5>
		@TABLES $rput,_name,_idx1,_idx2,_idx3,_idx4
	ELSEIFB <_idx6>
		@TABLES $rput,_name,_idx1,_idx2,_idx3,_idx4,_idx5
	ELSEIFB <_idx7>
		@TABLES $rput,_name,_idx1,_idx2,_idx3,_idx4,_idx5,_idx6
	ELSEIFB <_idx8>
		@TABLES $rput,_name,_idx1,_idx2,_idx3,_idx4,_idx5,_idx6,_idx7
	ELSE
		@TABLES $rput,_name,_idx1,_idx2,_idx3,_idx4,_idx5,_idx6,_idx7,_idx8
	ENDIF
				
ENDM
;--------------------------
@TABLES_fGET MACRO _name:REQ, _fieldNo:REQ, _fieldName:REQ, _idx1:REQ, _idx2:=<>, _idx3:=<>, \
						_idx4:=<>, _idx5:=<>, _idx6:=<>, _idx7:=<>, _idx8:=<>

    IFB <_idx2>
		@TABLES $fget,_name,_fieldNo,_fieldName,_idx1
	ELSEIFB <_idx3>
		@TABLES $fget,_name,_fieldNo,_fieldName,_idx1,_idx2
	ELSEIFB <_idx4>
		@TABLES $fget,_name,_fieldNo,_fieldName,_idx1,_idx2,_idx3
	ELSEIFB <_idx5>
		@TABLES $fget,_name,_fieldNo,_fieldName,_idx1,_idx2,_idx3,_idx4
	ELSEIFB <_idx6>
		@TABLES $fget,_name,_fieldNo,_fieldName,_idx1,_idx2,_idx3,_idx4,_idx5
	ELSEIFB <_idx7>
		@TABLES $fget,_name,_fieldNo,_fieldName,_idx1,_idx2,_idx3,_idx4,_idx5,_idx6
	ELSEIFB <_idx8>
		@TABLES $fget,_name,_fieldNo,_fieldName,_idx1,_idx2,_idx3,_idx4,_idx5,_idx6,_idx7
	ELSE
		@TABLES $fget,_name,_fieldNo,_fieldName,_idx1,_idx2,_idx3,_idx4,_idx5,_idx6,_idx7,_idx8
	ENDIF
				
ENDM
;--------------------------
@TABLES_fPUT MACRO _name:REQ, _fieldNo:REQ, _fieldName:REQ, _idx1:REQ, _idx2:=<>, _idx3:=<>, \
						_idx4:=<>, _idx5:=<>, _idx6:=<>, _idx7:=<>, _idx8:=<>

    IFB <_idx2>
		@TABLES $fput,_name,_fieldNo,_fieldName,_idx1
	ELSEIFB <_idx3>
		@TABLES $fput,_name,_fieldNo,_fieldName,_idx1,_idx2
	ELSEIFB <_idx4>
		@TABLES $fput,_name,_fieldNo,_fieldName,_idx1,_idx2,_idx3
	ELSEIFB <_idx5>
		@TABLES $fput,_name,_fieldNo,_fieldName,_idx1,_idx2,_idx3,_idx4
	ELSEIFB <_idx6>
		@TABLES $fput,_name,_fieldNo,_fieldName,_idx1,_idx2,_idx3,_idx4,_idx5
	ELSEIFB <_idx7>
		@TABLES $fput,_name,_fieldNo,_fieldName,_idx1,_idx2,_idx3,_idx4,_idx5,_idx6
	ELSEIFB <_idx8>
		@TABLES $fput,_name,_fieldNo,_fieldName,_idx1,_idx2,_idx3,_idx4,_idx5,_idx6,_idx7
	ELSE
		@TABLES $fput,_name,_fieldNo,_fieldName,_idx1,_idx2,_idx3,_idx4,_idx5,_idx6,_idx7,_idx8
	ENDIF
				
ENDM

;--------------------------
;		TABLES sort,WorkTable,Start,End
@TABLES_SORT MACRO _name:REQ, _start:REQ, _end:REQ
		@TABLES $sort,_name,_start,_end
ENDM
;--------------------------
;		TABLES search,WorkTable,Start,End,SearchItem,Index (returned)
@TABLES_SEARCH MACRO _name:REQ, _start:REQ, _end:REQ, _searchItem:REQ, _idx:REQ 
		@TABLES $search,_name,_start,_end,_searchItem,_idx
ENDM

@TABLES MACRO _function:REQ, _name:REQ, _arg1:REQ, _arg2:=<>, _arg3:=<>, _arg4:=<>, \
			  _arg5:=<>, _arg6:=<>, _arg7:=<>, _arg8:=<>, _arg9:=<>, _arg10:=<>
			  
	inc qword ptr[_STOP]

		  
		;	Function and table address
			mov r_Function,_function										; Function
			LEA r_Table,_name												; Load Table Address

		;	------------------------------------------------------------
		;	Function = BIND	
		;	------------------------------------------------------------
	IF _function EQ $bind
			LEA r_Record,_arg1												; Load Record Address
		;	Setup to store indexes
			mov r11,r_Table
			sub r11,89
			
			FOR _arg,<<_arg2>,<_arg3>,<_arg4>,<_arg5>,<_arg6>,<_arg7>,<_arg8>,<_arg9>> 
				IFNB <_arg>
					add r11,8												;	next slot
					$NoOfParameters TEXTEQU $literalStorage <_arg>			; allocate storage
					pop rax
					mov rax,QWORD PTR[rax]
					mov QWORD PTR[r11],rax 
				ENDIF
		
			ENDM
	
			add r11,8
			mov QWORD PTR[r11],1											; 1 in the first unused slot
			
	ENDIF

		;---------------------------------------------------------------
		;	Function = SORT
		;---------------------------------------------------------------
	IF _function EQ $sort
			$NoOfParameters TEXTEQU $literalStorage <_arg1>					; allocate storage
			pop r10
			mov r10,QWORD PTR[r10]
			$NoOfParameters TEXTEQU $literalStorage <_arg2>					; allocate storage
			pop r11
			mov r11,QWORD PTR[r11]
	ENDIF

		
		;	------------------------------------------------------------
		;	Function = SEARCH	
		;	------------------------------------------------------------
	IF _function EQ $search
			$NoOfParameters TEXTEQU $literalStorage <_arg1>					; Grab the Start of Key
			pop r10
			mov r10,QWORD PTR[r10]
			$NoOfParameters TEXTEQU $literalStorage <_arg2>					; Grab the End Of Key
			pop r11
			mov r11,QWORD PTR[r11]
			$NoOfParameters TEXTEQU $literalStorage <_arg3>					; and grab the key
			pop r12	
			LEA r13,_arg4
	ENDIF

		;---------------------------------------------------------------
		;	Function = rPUT/rGET
		;---------------------------------------------------------------
		;	rPUT and rGET are the same code but cannot find a way to do an OR
		;	for this pre-processor directive (Can probably with MASM but wanted
		;	to keep the code the same
	IF _function EQ $rget

		;	Setup to store indexes
			mov r11,r9
			add r11,QWORD PTR[r9-8]
			xor r12,r12

			FOR _arg,<<_arg1>,<_arg2>,<_arg3>,<_arg4>,<_arg5>,<_arg6>,<_arg7>,<_arg8>> 
				IFNB <_arg>
					add r12,8													;	next slot 
					$NoOfParameters TEXTEQU $literalStorage <_arg>
					pop rax
					mov rax,QWORD PTR[rax]
					mov QWORD PTR[r11+r12],rax
				ENDIF
			ENDM
	ENDIF
	
		;---------------------------------------------------------------
		;	Function = rPUT/rGET
		;---------------------------------------------------------------
	IF _function EQ $rput

		;	Setup to store indexes
			mov r11,r9
			add r11,QWORD PTR[r9-8]
			xor r12,r12

			FOR _arg,<<_arg1>,<_arg2>,<_arg3>,<_arg4>,<_arg5>,<_arg6>,<_arg7>,<_arg8>> 
				IFNB <_arg>
					add r12,8													;	next slot 
					$NoOfParameters TEXTEQU $literalStorage <_arg>
					pop rax
					mov rax,QWORD PTR[rax]
					mov QWORD PTR[r11+r12],rax
				ENDIF
			ENDM
	ENDIF


		;---------------------------------------------------------------
		;	Function = fPUT/fGET
		;---------------------------------------------------------------
		;	fPUT and fGET are the same code but cannot find a way to do an OR
		;	for this pre-processor directive. 
		;	And the same as rPUR/rGET (Can probably with MASM but wanted
		;	to keep the code the same
		;	---------------------------------------------------------------
		;							  R8	R9		  R11	  R12		ControlBlock
		;	Function = fGET : XTABLES fget,	WorkTable,FieldNo,Fieldname, Idx, Idx,   Idx..
		;						 _function,		_name,	_arg1,	  _arg2,_arg3,_arg4,_arg5..
		;	---------------------------------------------------------------
	IF _function EQ $fget

		;	Setup to store indexes
			mov r11,r9
			add r11,QWORD PTR[r9-8]
			xor r12,r12

			FOR _arg,<<_arg3>,<_arg4>,<_arg5>,<_arg6>,<_arg7>,<_arg8>,<_arg9>,<_arg10>> 
				IFNB <_arg>
					add r12,8												;	next slot 
					$NoOfParameters TEXTEQU $literalStorage <_arg>
					pop rax
					mov rax,QWORD PTR[rax]
					mov QWORD PTR[r11+r12],rax
				ENDIF
			ENDM

			$NoOfParameters TEXTEQU $literalStorage <_arg1>					; grab the Field No
			pop r11
			mov r11,QWORD PTR[r11]
			LEA r12,_arg2													; Setup Field Address												

	ENDIF

		;	---------------------------------------------------------------
		;							    R8	R9		      R11	    R12		ControlBlock
		;	Function = rPUT : XTABLES fget,	WorkTable,FieldNo,Fieldname  ,Idx,  Idx,  Idx..
		;						 _function,		_name,	_arg1,	  _arg2,_arg3,_arg4,_arg5..
		;	---------------------------------------------------------------
		;	R13/R14 (Picture Over-ride or qualified alpha)
	IF _function EQ $fput

		;	Setup to store indexes
			mov r11,r9
			add r11,QWORD PTR[r9-8]
			xor r12,r12

			FOR _arg,<<_arg3>,<_arg4>,<_arg5>,<_arg6>,<_arg7>,<_arg8>,<_arg9>,<_arg10>> 
				IFNB <_arg>
					add r12,8												;	next slot 
					$NoOfParameters TEXTEQU $literalStorage <_arg>
					pop rax
					mov rax,QWORD PTR[rax]
					mov QWORD PTR[r11+r12],rax
				ENDIF
			ENDM
			
			$pushAll r9,r10
			$SetupField <_arg2>												; Grab the Destination field 1st
			mov r12,r9
			mov r13,r10
			mov r14,r11	
			$popAll r10,r9

			$NoOfParameters TEXTEQU $literalStorage <_arg1>					; grab the Field No
			pop r11
			mov r11,QWORD PTR[r11]

	ENDIF
	
		Call _TABLES	
	
ENDM

;=======================================================================
;       	Macro for XTABLES package
;=======================================================================
;-----------------------------------------------------------------------
; 	UBOUND				 STATUS 				 			Table Indicator									 
;	+---+---+---+---+---+---+---+---+---+---+---------------+---+---------+------+	     
;	| 1	|'9'|Len|Val|Pic| 1	|'9'|Len|Val|Pic|Record Address	|'T'|NoOfBytes| NAME |
;	+---+---+---+---+---+---+---+---+---+---+---------------+---+---------+------+
;	-61					-27					-17				-9	-8			0	  
;
;-----------------------------------------------------------------------
;				   	R8		R9		  R10		R11,R12			R13
;			XTABLES bind,	WorkTable,Record,	Size
;			XTABLES sort,  	WorkTable,Start,	End
;			XTABLES search,	WorkTable,Start,	End,SearchItem,	Index (Returned)
;			XTABLES load,	WorkTable,File,		IncludeDeletedRecs
;			XTABLES unload,	WorkTable,File,		IncludeDeletedRecs
;			XTABLES rget, 	WorkTable,Idx
;			XTABLES rput, 	WorkTable,Idx
;			XTABLES delete,	WorkTable,Idx,		Initialise
;					R8		R9		  R11	  R12		R10
;			XTABLES fget,	WorkTable,FieldNo,Fieldname,Idx
;			XTABLES fput,	WorkTable,FieldNo,Fieldname,Idx R13/R14 (Picture Over-ride or qualified alpha)
;-----------------------------------------------------------------------
@XTABLES_BIND MACRO _name:REQ, _record:REQ, _size:REQ
		@XTABLES $bind,_name,_record,_size
ENDM
;--------------------------
@XTABLES_SORT MACRO _name:REQ, _start:REQ, _end:REQ
		@XTABLES $sort,_name,_start,_end
ENDM
;--------------------------
;		TABLES $search,WorkTable,Start,End,SearchItem,Index(returned)
@XTABLES_SEARCH MACRO _name:REQ, _start:REQ, _end:REQ, _searchItem:REQ, _index:REQ
		@XTABLES $search,_name,_start,_end,_searchItem,_index
ENDM
;--------------------------
@XTABLES_LOAD MACRO _name:REQ, _file:REQ, _includeDeletedRecs:REQ
		@XTABLES $load,_name,_file,_includeDeletedRecs
endM
;--------------------------
@XTABLES_UNLOAD MACRO _name:REQ, _file:REQ, _includeDeletedRecs:REQ
		@XTABLES $unload,_name,_file,_includeDeletedRecs
ENDM
;--------------------------
@XTABLES_rGET MACRO _name:REQ, _index:REQ
		@XTABLES $rget,_name,_index
ENDM
;--------------------------
@XTABLES_rPUT MACRO _name:REQ, _index:REQ 
		@XTABLES $rput,_name,_index
ENDM
;--------------------------
@XTABLES_DELETE MACRO _name:REQ, _index:REQ, _initialise:REQ
		@XTABLES $del,_name,_index,_initialise
ENDM
;--------------------------
@XTABLES_fGET MACRO _name:REQ, _fieldNo:REQ, _fieldname:REQ, _index
		@XTABLES $fget,_name,_fieldNo,_fieldname,_index
ENDM
;--------------------------
@XTABLES_fPUT MACRO _name:REQ, _fieldNo:REQ, _fieldname:REQ, _index
		@XTABLES $fput,_name,_fieldNo,_fieldname,_index
ENDM

@XTABLES MACRO _function:REQ, _name:REQ, _arg3:REQ, _arg4:=<>, _arg5:=<>, _arg6:=<>
	inc qword ptr[_STOP]

	;	Function and table address
		mov r_Function,_function											; Function
		LEA r_Table,_name													; Load Table Address

		;	------------------------------------------------------------
		;	Function = BIND	
		;	------------------------------------------------------------
	IF _function EQ $bind
			$NoOfParameters TEXTEQU $literalStorage <_arg3>					; Record Address
			pop r10		
			$NoOfParameters TEXTEQU $literalStorage <_arg4>					; Table size
			pop r11
			mov r11,QWORD PTR[r11]
	ENDIF

		;---------------------------------------------------------------
		;	Function = SORT
		;---------------------------------------------------------------
	IF _function EQ $sort
			$NoOfParameters TEXTEQU $literalStorage <_arg3>					; Start position
			pop r10
			mov r10,QWORD PTR[r10]
			$NoOfParameters TEXTEQU $literalStorage <_arg4>					; End Position
			pop r11
			mov r11,QWORD PTR[r11]
	ENDIF

		;	------------------------------------------------------------
		;	Function = SEARCH	
		;	------------------------------------------------------------
	IF _function EQ $search
			$NoOfParameters TEXTEQU $literalStorage <_arg3>					; Grab the Start of Key
			pop r10
			mov r10,QWORD PTR[r10]
			$NoOfParameters TEXTEQU $literalStorage <_arg4>					; Grab the End Of Key
			pop r11
			mov r11,QWORD PTR[r11]
			$NoOfParameters TEXTEQU $literalStorage <_arg5>					; and grab the key address
			pop r12	
			LEA r13,_arg6													; and the Index address
	ENDIF

		;	------------------------------------------------------------
		;	Function = LOAD
		;	------------------------------------------------------------
	IF _function EQ $load
			LEA r10,_arg3													; Filename
			mov r11,_arg4													; Include deleted records (c_TRUE/c_FALSE)
	ENDIF

		;	------------------------------------------------------------
		;	Function = UNLOAD
		;	------------------------------------------------------------
	IF _function EQ $unload
			LEA r10,_arg3													; Filename
			mov r11,_arg4													; Include deleted records (c_TRUE/c_FALSE)
	ENDIF

		;	------------------------------------------------------------
		;	Function = rGET
		;	------------------------------------------------------------
	IF _function EQ $rget
			$NoOfParameters TEXTEQU $literalStorage <_arg3>					; grab the Index
			pop r10
			mov r10,QWORD PTR[r10]
	ENDIF

		;	------------------------------------------------------------
		;	Function = rPUT
		;	------------------------------------------------------------
	IF _function EQ $rput													; Index has been provided														
			$NoOfParameters TEXTEQU $literalStorage <_arg3>
			pop r10
			mov r10,QWORD PTR[r10]
	ENDIF

		;	------------------------------------------------------------
		;	Function = DELETE
		;	------------------------------------------------------------
	IF _function EQ $del
			$NoOfParameters TEXTEQU $literalStorage <_arg3>					; grab the Index
			pop r10
			mov r10,QWORD PTR[r10]
			mov r11,_arg4
	ENDIF

		;	---------------------------------------------------------------
		;							  R8	R9		  R11	  R12		R10
		;	Function = fGET : XTABLES fget,	WorkTable,FieldNo,Fieldname,Idx
		;						 _function,     _name,  _arg3,    _arg4, _arg5, _arg6		
		;	---------------------------------------------------------------
	IF _function EQ $fget
			$NoOfParameters TEXTEQU $literalStorage <_arg5>					; grab the Index
			pop r10
			mov r10,QWORD PTR[r10]
			$NoOfParameters TEXTEQU $literalStorage <_arg3>					; grab the Field No
			pop r11
			mov r11,QWORD PTR[r11]
			LEA r12,_arg4													; Setup Field Address
	ENDIF

		;	---------------------------------------------------------------
		;							  R8	R9		  R11	  R12		R10
		;	Function = rPUT : XTABLES fget,	WorkTable,FieldNo,Fieldname,Idx
		;	---------------------------------------------------------------
		;	R13/R14 (Picture Over-ride or qualified alpha)

	IF _function EQ $fput
			$pushAll r9,r10
			$SetupField <_arg4>												; grab the Field Address
			mov r12,r9
			mov r13,r10
			mov r14,r11	
			$popAll r10,r9
										
			$NoOfParameters TEXTEQU $literalStorage <_arg5>					; grab the Index
			pop r10
			mov r10,QWORD PTR[r10]
			$NoOfParameters TEXTEQU $literalStorage <_arg3>					; grab the Field No
			pop r11
			mov r11,QWORD PTR[r11]
	ENDIF

		
		;	----------------------------------------------------------------
		;	Make the call
		;	----------------------------------------------------------------
			Call _XTABLES	
	
ENDM

;=======================================================================
;       	Macro for ARRAYS package
;======================================================================= 
@Arrays_Get MACRO _arg1:REQ, _arg2:REQ, _arg3:REQ
	inc qword ptr[_STOP]

	$Arrays_GetIndex _arg1,_arg2									; Source	
	LEA rax,_arg1
	mov r15,QWORD PTR[rax+(r9*8)]
	mov QWORD PTR[_arg3],r15										; Destination
	
ENDM
	
@Arrays_Put MACRO _arg1:REQ, _arg2:REQ, _arg3:REQ
	inc qword ptr[_STOP]

	$NoOfParameters TEXTEQU $literalStorage <_arg3>					; Index
	pop r15
	mov r15,[r15]
	$Arrays_GetIndex _arg1,_arg2									; Destination
	LEA rax,_arg1
	mov QWORD PTR[rax+(r9*8)],r15
	
ENDM

;	--------------------------------------------------------------
;	The following Arrays calls handle functions within the Array 
;	itself
;	--------------------------------------------------------------

@Arrays_Swap MACRO _arg1:REQ, _arg2:REQ, _arg3:REQ, _arg4:REQ
	inc qword ptr[_STOP]

	$Arrays_GetIndex _arg1,_arg2									; 1st field
	LEA rax,_arg1
	mov r14,QWORD PTR[rax+(r9*8)]									; save value R14
	push r9															; save index

	$Arrays_GetIndex _arg3,_arg4									; 2nd field
	LEA rax,_arg3	
	mov r15,QWORD PTR[rax+(r9*8)]									; save value R15

	mov QWORD PTR[rax+(r9*8)],r14									; move 1st to 2nd
	pop r9															; get 1st index
	LEA rax,_arg1
	mov QWORD PTR[rax+(r9*8)],r15									; move 2nd to 1st
	
ENDM

;	New integer functions whereby you can pass QWORD[n]
;	---------------------------------------------------

@Arrays_Eq MACRO _arg1:REQ, _arg2:REQ, _arg3:REQ, _arg4:REQ
	inc qword ptr[_STOP]

	$Arrays_GetIndex _arg1,_arg2									; 1st field
	mov r15,r9														; save index

	$Arrays_GetIndex _arg3,_arg4									; 2nd field
	mov r14,r9														; save index
	LEA r9,_arg1
	LEA r10,_arg3
	@Integers_EQ QWORD PTR[r9+(r15*8)],QWORD PTR[r10+(r14*8)]

ENDM 

@Arrays_Add MACRO _arg1:REQ, _arg2:REQ, _arg3:REQ, _arg4:VARARG
	inc qword ptr[_STOP]

	$Arrays_GetIndex _arg1,_arg2									; 1st field
	mov r15,r9														; save index

	IFB <_arg4>
		$NoOfParameters TEXTEQU $literalStorage <_arg3>				; Index
		pop r14														; return the address
		LEA r9,_arg1
		@Integers_ADD QWORD PTR[r9+(r15*8)],QWORD PTR[r14]
	ELSE
		$Arrays_GetIndex _arg3,_arg4								; 2nd field
		mov r14,r9													; save index
		LEA r9,_arg1
		LEA r10,_arg3
		@Integers_ADD QWORD PTR[r9+(r15*8)],QWORD PTR[r10+(r14*8)]
	ENDIF

ENDM

@Arrays_Sub MACRO _arg1:REQ, _arg2:REQ, _arg3:REQ, _arg4:VARARG
	inc qword ptr[_STOP]

	$Arrays_GetIndex _arg1,_arg2									; 1st field
	mov r15,r9														; save index

	IFB <_arg4>
		$NoOfParameters TEXTEQU $literalStorage <_arg3>				; Index
		pop r14														; return the address
		LEA r9,_arg1
		@Integers_SUB QWORD PTR[r9+(r15*8)],QWORD PTR[r14]
	ELSE
		$Arrays_GetIndex _arg3,_arg4								; 2nd field
		mov r14,r9													; save index
		LEA r9,_arg1
		LEA r10,_arg3		
		@Integers_SUB QWORD PTR[r9+(r15*8)],QWORD PTR[r10+(r14*8)]
	ENDIF

ENDM 

@Arrays_Mul  MACRO _arg1:REQ, _arg2:REQ, _arg3:REQ, _arg4:VARARG
	inc qword ptr[_STOP]

	$Arrays_GetIndex _arg1,_arg2									; 1st field
	mov r15,r9														; save index

	IFB <_arg4>
		$NoOfParameters TEXTEQU $literalStorage <_arg3>				; Index
		pop r14														; return the address
		LEA r9,_arg1
		@Integers_MUL QWORD PTR[r9+(r15*8)],QWORD PTR[r14]
	ELSE
		$Arrays_GetIndex _arg3,_arg4								; 2nd field
		mov r14,r9													; save index
		LEA r9,_arg1
		LEA r10,_arg3		
		@Integers_MUL QWORD PTR[r9+(r15*8)],QWORD PTR[r10+(r14*8)]
	ENDIF

ENDM

@Arrays_Div MACRO _arg1:REQ, _arg2:REQ, _arg3:REQ, _arg4:VARARG
	inc qword ptr[_STOP]

	$Arrays_GetIndex _arg1,_arg2									; 1st field
	mov r15,r9														; save index

	IFB <_arg4>
		$NoOfParameters TEXTEQU $literalStorage <_arg3>				; Index
		pop r14														; return the address
		LEA r9,_arg1
		@Integers_DIV QWORD PTR[r9+(r15*8)],QWORD PTR[r14]
	ELSE
		$Arrays_GetIndex _arg3,_arg4								; 2nd field
		mov r14,r9													; save index
		LEA r9,_arg1
		LEA r10,_arg3		
		@Integers_DIV QWORD PTR[r9+(r15*8)],QWORD PTR[r10+(r14*8)]
	ENDIF

ENDM

@Arrays_If MACRO _arg1:REQ, _arg2:REQ, _arg3:REQ, _arg4:REQ, _arg5:VARARG
	inc qword ptr[_STOP]

	$replaceSymbols _arg3											; Evaluator
		
	$Arrays_GetIndex _arg1,_arg2									; 1st field
	mov r15,r9														; save index
	LEA r9,_arg1
	mov rax,QWORD PTR[r9+(r15*8)]									; move in the 1st value

	push RAX														; Store for the Compare
	IFB <_arg5>
		$NoOfParameters TEXTEQU $literalStorage <_arg4>				; Index
		pop r14														; return the address
		mov rbx,QWORD PTR[r14]										; and get the value
	ELSE
		$Arrays_GetIndex _arg4,_arg5								; 2nd field
		mov r14,r9													; save index
		LEA r10,_arg4
		mov rbx,QWORD PTR[r10+(r14*8)]								; move in the 2nd value
	ENDIF
	pop RAX															; Restore for the Compare
	
	@IF _ARRAYCOMPARE												; do the COMPARE (uses RAX/RBX)
	
ENDM
	
;-----------------------------------------------------------------------
;				   R8   R9 	
;			ARRAYS sort,Array
;-----------------------------------------------------------------------
@ARRAYS_SORT MACRO _arg1:REQ
		@ARRAYS $sort,_arg1
ENDM

@ARRAYS MACRO _function:REQ,_arg2:REQ
	inc qword ptr[_STOP]
		
	;	Function and table address
		mov r_Function,_function												; Function
		LEA r_Table,_arg2														; Load Table Address
		mov r10,(SIZE _arg2 / 8 - 1)

		;---------------------------------------------------------------
		;	Function = SORT
		;---------------------------------------------------------------
	IF _function EQ $sort
	ENDIF

		;	----------------------------------------------------------------
		;	Make the call
		;	----------------------------------------------------------------
			Call _ARRAYS	
	
ENDM


;=======================================================================
;       	Macro for DATE routines (COMMON.LIB)
;			GET (String*10)
;			DATE_TO_DAYS (Number,String*10)
;			DAYS_TO_DATE (Number,String*10)
;=======================================================================
;--------------------------
@DATE_SECONDS MACRO _arg:REQ
		@_DATE -1,_arg,0
ENDM
@DATE_GET MACRO _arg1:REQ,_arg2:REQ
		@_DATE 0,_arg1,_arg2
ENDM
@DATE_DATEFROMDAYS MACRO _arg1:REQ,_arg2:REQ
		@_DATE 1,_arg1,_arg2
ENDM
@DATE_DAYSFROMDATE MACRO _arg1:REQ,_arg2:REQ
		@_DATE 2,_arg1,_arg2
ENDM
@DATE_TIMER MACRO _arg1:REQ,_arg2:REQ
		@_DATE 3,_arg1,_arg2
ENDM
;--------------------------
@_DATE MACRO _arg1:REQ,_arg2:REQ,_arg3:=<>
	inc qword ptr[_STOP]
	
	;	Function and table address
		mov r_Function,_arg1												; Function
		$NoOfParameters TEXTEQU $literalStorage <_arg2>
		pop r9
		$NoOfParameters TEXTEQU $literalStorage <_arg3>
		pop r10
		Call _DATE
	
ENDM	

;=======================================================================
;       	Macro for web access (WWW.LIB)
;				R8			R9				R10			R11,		R12		
;			WWW $wwwOpen,	n_PortNo	
;			WWW $wwwProcess,w_ScreenName,	w_Response,	GetAddress,	PostAddress
;			WWW $wwwClose,	n_PortNo (Cosmetic)
;=======================================================================
;--------------------------
@WWW_OPEN MACRO _arg:REQ
		@WWW $wwwOpen,_arg
ENDM
@WWW_PROCESS MACRO _arg1:REQ, _arg2:REQ, _arg3:REQ, _arg4:REQ
		@WWW $wwwProcess,_arg1,_arg2,_arg3,_arg4
ENDM
@WWW_CLOSE MACRO _arg:REQ
		@WWW $wwwClose,_arg
ENDM
@WWW_SENDMSG MACRO _arg1:REQ, _arg2:REQ, _arg3:REQ
		@WWW $wwwSendMsg,_arg1,_arg2,_arg3
ENDM
@WWW_RECVMSG MACRO _arg1:REQ, _arg2:REQ, _arg3:REQ
		@WWW $wwwRecvMsg,_arg1,_arg2,_arg3
ENDM
;--------------------------
@WWW MACRO _function:REQ, _arg2:REQ, _arg3:=<>, _arg4:=<>, _arg5:=<>
	inc qword ptr[_STOP]

	;	Function and table address
			mov r_Function,_function										; Function

	IF _function EQ $wwwOpen
			$NoOfParameters TEXTEQU $literalStorage <_arg2>					; Parameter 2
			pop r9
	ENDIF
	
	IF _function EQ $wwwProcess
			LEA r9,_arg2													; Parameter 2
			LEA r10,_arg3													; Parameter 3
			LEA r11,_arg4													; Parameter 4
			LEA r12,_arg5													; Parameter 5
	ENDIF

	IF _function EQ $wwwClose
			$NoOfParameters TEXTEQU $literalStorage <_arg2>					; Parameter 2
			pop r9
	ENDIF
	
	IF _function EQ $wwwSendMsg
			$NoOfParameters TEXTEQU $literalStorage <_arg2>					; Parameter 2
			pop r9
			$NoOfParameters TEXTEQU $literalStorage <_arg3>					; Parameter 3
			pop r10
			$NoOfParameters TEXTEQU $literalStorage <_arg4>					; Parameter 4
			pop r11
	ENDIF	

	IF _function EQ $wwwRecvMsg
			$NoOfParameters TEXTEQU $literalStorage <_arg2>					; Parameter 2
			pop r9
			$NoOfParameters TEXTEQU $literalStorage <_arg3>					; Parameter 3
			pop r10
			$NoOfParameters TEXTEQU $literalStorage <_arg4>					; Parameter 4
			pop r11
	ENDIF	

			Call _WWW

ENDM

;=======================================================================
;      		Macro to call a program (COMMON.LIB)
;           Passes program path/name in r9
;			Passes R10 to receive read handle
;=======================================================================
@RUN MACRO _arg1:REQ, _arg2:VARARG
	inc qword ptr[_STOP]

		$NoOfParameters TEXTEQU $literalStorage <_arg1>															; Grab the field/literal
		pop r9																; Address in R9

	IFB <_arg2>
		Call _RUN_INTERACTIVE												; Call
	ELSE					
		$NoOfParameters TEXTEQU $literalStorage <_arg1>						; Grab the field/literal
		pop r9																; Address in R9
		LEA r10,_arg2														; To receive Read Handle
		Call _RUN_BATCH														; and Call
	ENDIF

ENDM

;-------------------------------------------------------------------------------
;	WAIT FOR CHILD_PID - No Library call required
;-------------------------------------------------------------------------------
@WAIT MACRO _arg1:REQ
	inc qword ptr[_STOP]

		LEA r9,_arg1
		Call _WAIT

ENDM

;-------------------------------------------------------------------------------
;	TERMINATE - No Library call required
;-------------------------------------------------------------------------------
;@TERMINATE MACRO _arg1:REQ
@TERMINATE MACRO _arg1:=<0>
	inc qword ptr[_STOP]

	mov QWORD PTR[ERROR_CODE],_arg1
	jmp EndInstructions

ENDM
